% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/personalize_operations.R
\name{personalize_create_solution_version}
\alias{personalize_create_solution_version}
\title{Trains or retrains an active solution in a Custom dataset group}
\usage{
personalize_create_solution_version(
  solutionArn,
  trainingMode = NULL,
  tags = NULL
)
}
\arguments{
\item{solutionArn}{[required] The Amazon Resource Name (ARN) of the solution containing the training
configuration information.}

\item{trainingMode}{The scope of training to be performed when creating the solution
version. The \code{FULL} option trains the solution version based on the
entirety of the input solution's training data, while the \code{UPDATE}
option processes only the data that has changed in comparison to the
input solution. Choose \code{UPDATE} when you want to incrementally update
your solution version instead of creating an entirely new one.

The \code{UPDATE} option can only be used when you already have an active
solution version created from the input solution using the \code{FULL} option
and the input solution was trained with the
\href{https://docs.aws.amazon.com/personalize/latest/dg/native-recipe-new-item-USER_PERSONALIZATION.html}{User-Personalization}
recipe or the
\href{https://docs.aws.amazon.com/personalize/latest/dg/native-recipe-hrnn-coldstart.html}{HRNN-Coldstart}
recipe.}

\item{tags}{A list of tags to apply to the solution version.}
}
\description{
Trains or retrains an active solution in a Custom dataset group. A solution is created using the \code{\link[=personalize_create_solution]{create_solution}} operation and must be in the ACTIVE state before calling \code{\link[=personalize_create_solution_version]{create_solution_version}}. A new version of the solution is created every time you call this operation.

See \url{https://paws-r.github.io/docs/personalize/create_solution_version.html} for full documentation.
}
\keyword{internal}
