% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/forecastservice_operations.R
\name{forecastservice_list_explainability_exports}
\alias{forecastservice_list_explainability_exports}
\title{Returns a list of Explainability exports created using the
CreateExplainabilityExport operation}
\usage{
forecastservice_list_explainability_exports(
  NextToken = NULL,
  MaxResults = NULL,
  Filters = NULL
)
}
\arguments{
\item{NextToken}{If the result of the previous request was truncated, the response
includes a NextToken. To retrieve the next set of results, use the token
in the next request. Tokens expire after 24 hours.}

\item{MaxResults}{The number of items to return in the response.}

\item{Filters}{An array of filters. For each filter, provide a condition and a match
statement. The condition is either \code{IS} or \code{IS_NOT}, which specifies
whether to include or exclude resources that match the statement from
the list. The match statement consists of a key and a value.

\strong{Filter properties}
\itemize{
\item \code{Condition} - The condition to apply. Valid values are \code{IS} and
\code{IS_NOT}.
\item \code{Key} - The name of the parameter to filter on. Valid values are
\code{ResourceArn} and \code{Status}.
\item \code{Value} - The value to match.
}}
}
\description{
Returns a list of Explainability exports created using the \code{\link[=forecastservice_create_explainability_export]{create_explainability_export}} operation. This operation returns a summary for each Explainability export. You can filter the list using an array of Filter objects.

See \url{https://paws-r.github.io/docs/forecastservice/list_explainability_exports.html} for full documentation.
}
\keyword{internal}
