% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rekognition_operations.R
\name{rekognition_start_person_tracking}
\alias{rekognition_start_person_tracking}
\title{Starts the asynchronous tracking of a person's path in a stored video}
\usage{
rekognition_start_person_tracking(Video, ClientRequestToken,
  NotificationChannel, JobTag)
}
\arguments{
\item{Video}{[required] The video in which you want to detect people. The video must be stored
in an Amazon S3 bucket.}

\item{ClientRequestToken}{Idempotent token used to identify the start request. If you use the same
token with multiple \code{StartPersonTracking} requests, the same \code{JobId} is
returned. Use \code{ClientRequestToken} to prevent the same job from being
accidently started more than once.}

\item{NotificationChannel}{The Amazon SNS topic ARN you want Amazon Rekognition Video to publish
the completion status of the people detection operation to.}

\item{JobTag}{Unique identifier you specify to identify the job in the completion
status published to the Amazon Simple Notification Service topic.}
}
\description{
Starts the asynchronous tracking of a person's path in a stored video.
}
\details{
Amazon Rekognition Video can track the path of people in a video stored
in an Amazon S3 bucket. Use Video to specify the bucket name and the
filename of the video. \code{StartPersonTracking} returns a job identifier
(\code{JobId}) which you use to get the results of the operation. When label
detection is finished, Amazon Rekognition publishes a completion status
to the Amazon Simple Notification Service topic that you specify in
\code{NotificationChannel}.

To get the results of the person detection operation, first check that
the status value published to the Amazon SNS topic is \code{SUCCEEDED}. If
so, call GetPersonTracking and pass the job identifier (\code{JobId}) from
the initial call to \code{StartPersonTracking}.
}
\section{Request syntax}{
\preformatted{svc$start_person_tracking(
  Video = list(
    S3Object = list(
      Bucket = "string",
      Name = "string",
      Version = "string"
    )
  ),
  ClientRequestToken = "string",
  NotificationChannel = list(
    SNSTopicArn = "string",
    RoleArn = "string"
  ),
  JobTag = "string"
)
}
}

\keyword{internal}
