% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/comprehend_operations.R
\name{comprehend_list_events_detection_jobs}
\alias{comprehend_list_events_detection_jobs}
\title{Gets a list of the events detection jobs that you have submitted}
\usage{
comprehend_list_events_detection_jobs(Filter, NextToken, MaxResults)
}
\arguments{
\item{Filter}{Filters the jobs that are returned. You can filter jobs on their name,
status, or the date and time that they were submitted. You can only set
one filter at a time.}

\item{NextToken}{Identifies the next page of results to return.}

\item{MaxResults}{The maximum number of results to return in each page.}
}
\value{
A list with the following syntax:\preformatted{list(
  EventsDetectionJobPropertiesList = list(
    list(
      JobId = "string",
      JobName = "string",
      JobStatus = "SUBMITTED"|"IN_PROGRESS"|"COMPLETED"|"FAILED"|"STOP_REQUESTED"|"STOPPED",
      Message = "string",
      SubmitTime = as.POSIXct(
        "2015-01-01"
      ),
      EndTime = as.POSIXct(
        "2015-01-01"
      ),
      InputDataConfig = list(
        S3Uri = "string",
        InputFormat = "ONE_DOC_PER_FILE"|"ONE_DOC_PER_LINE"
      ),
      OutputDataConfig = list(
        S3Uri = "string",
        KmsKeyId = "string"
      ),
      LanguageCode = "en"|"es"|"fr"|"de"|"it"|"pt"|"ar"|"hi"|"ja"|"ko"|"zh"|"zh-TW",
      DataAccessRoleArn = "string",
      TargetEventTypes = list(
        "string"
      )
    )
  ),
  NextToken = "string"
)
}
}
\description{
Gets a list of the events detection jobs that you have submitted.
}
\section{Request syntax}{
\preformatted{svc$list_events_detection_jobs(
  Filter = list(
    JobName = "string",
    JobStatus = "SUBMITTED"|"IN_PROGRESS"|"COMPLETED"|"FAILED"|"STOP_REQUESTED"|"STOPPED",
    SubmitTimeBefore = as.POSIXct(
      "2015-01-01"
    ),
    SubmitTimeAfter = as.POSIXct(
      "2015-01-01"
    )
  ),
  NextToken = "string",
  MaxResults = 123
)
}
}

\keyword{internal}
