% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sagemaker_operations.R
\name{sagemaker_list_app_image_configs}
\alias{sagemaker_list_app_image_configs}
\title{Lists the AppImageConfigs in your account and their properties}
\usage{
sagemaker_list_app_image_configs(MaxResults, NextToken, NameContains,
  CreationTimeBefore, CreationTimeAfter, ModifiedTimeBefore,
  ModifiedTimeAfter, SortBy, SortOrder)
}
\arguments{
\item{MaxResults}{The maximum number of AppImageConfigs to return in the response. The
default value is 10.}

\item{NextToken}{If the previous call to \code{ListImages} didn't return the full set of
AppImageConfigs, the call returns a token for getting the next set of
AppImageConfigs.}

\item{NameContains}{A filter that returns only AppImageConfigs whose name contains the
specified string.}

\item{CreationTimeBefore}{A filter that returns only AppImageConfigs created on or before the
specified time.}

\item{CreationTimeAfter}{A filter that returns only AppImageConfigs created on or after the
specified time.}

\item{ModifiedTimeBefore}{A filter that returns only AppImageConfigs modified on or before the
specified time.}

\item{ModifiedTimeAfter}{A filter that returns only AppImageConfigs modified on or after the
specified time.}

\item{SortBy}{The property used to sort results. The default value is \code{CreationTime}.}

\item{SortOrder}{The sort order. The default value is \code{Descending}.}
}
\description{
Lists the AppImageConfigs in your account and their properties. The list
can be filtered by creation time or modified time, and whether the
AppImageConfig name contains a specified string.
}
\section{Request syntax}{
\preformatted{svc$list_app_image_configs(
  MaxResults = 123,
  NextToken = "string",
  NameContains = "string",
  CreationTimeBefore = as.POSIXct(
    "2015-01-01"
  ),
  CreationTimeAfter = as.POSIXct(
    "2015-01-01"
  ),
  ModifiedTimeBefore = as.POSIXct(
    "2015-01-01"
  ),
  ModifiedTimeAfter = as.POSIXct(
    "2015-01-01"
  ),
  SortBy = "CreationTime"|"LastModifiedTime"|"Name",
  SortOrder = "Ascending"|"Descending"
)
}
}

\keyword{internal}
