% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/machinelearning_operations.R
\name{machinelearning_create_data_source_from_rds}
\alias{machinelearning_create_data_source_from_rds}
\title{Creates a DataSource object from an Amazon Relational Database Service
(Amazon RDS)}
\usage{
machinelearning_create_data_source_from_rds(DataSourceId,
  DataSourceName, RDSData, RoleARN, ComputeStatistics)
}
\arguments{
\item{DataSourceId}{[required] A user-supplied ID that uniquely identifies the \code{DataSource}. Typically,
an Amazon Resource Number (ARN) becomes the ID for a \code{DataSource}.}

\item{DataSourceName}{A user-supplied name or description of the \code{DataSource}.}

\item{RDSData}{[required] The data specification of an Amazon RDS \code{DataSource}:
\itemize{
\item DatabaseInformation -
\itemize{
\item \code{DatabaseName} - The name of the Amazon RDS database.
\item \code{InstanceIdentifier } - A unique identifier for the Amazon RDS
database instance.
}
\item DatabaseCredentials - AWS Identity and Access Management (IAM)
credentials that are used to connect to the Amazon RDS database.
\item ResourceRole - A role (DataPipelineDefaultResourceRole) assumed by
an EC2 instance to carry out the copy task from Amazon RDS to Amazon
Simple Storage Service (Amazon S3). For more information, see \href{https://docs.aws.amazon.com/datapipeline/latest/DeveloperGuide/dp-iam-roles.html}{Role templates}
for data pipelines.
\item ServiceRole - A role (DataPipelineDefaultRole) assumed by the AWS
Data Pipeline service to monitor the progress of the copy task from
Amazon RDS to Amazon S3. For more information, see \href{https://docs.aws.amazon.com/datapipeline/latest/DeveloperGuide/dp-iam-roles.html}{Role templates}
for data pipelines.
\item SecurityInfo - The security information to use to access an RDS DB
instance. You need to set up appropriate ingress rules for the
security entity IDs provided to allow access to the Amazon RDS
instance. Specify a [\code{SubnetId}, \code{SecurityGroupIds}] pair for a
VPC-based RDS DB instance.
\item SelectSqlQuery - A query that is used to retrieve the observation
data for the \code{Datasource}.
\item S3StagingLocation - The Amazon S3 location for staging Amazon RDS
data. The data retrieved from Amazon RDS using \code{SelectSqlQuery} is
stored in this location.
\item DataSchemaUri - The Amazon S3 location of the \code{DataSchema}.
\item DataSchema - A JSON string representing the schema. This is not
required if \code{DataSchemaUri} is specified.
\item DataRearrangement - A JSON string that represents the splitting and
rearrangement requirements for the \code{Datasource}.

Sample -
\verb{ "\\\{\\"splitting\\":\\\{\\"percentBegin\\":10,\\"percentEnd\\":60\\\}\\\}"}
}}

\item{RoleARN}{[required] The role that Amazon ML assumes on behalf of the user to create and
activate a data pipeline in the user's account and copy data using the
\code{SelectSqlQuery} query from Amazon RDS to Amazon S3.}

\item{ComputeStatistics}{The compute statistics for a \code{DataSource}. The statistics are generated
from the observation data referenced by a \code{DataSource}. Amazon ML uses
the statistics internally during \code{MLModel} training. This parameter must
be set to \code{true} if the \code{DataSource} needs to be used for \code{MLModel}
training.}
}
\description{
Creates a \code{DataSource} object from an \href{https://aws.amazon.com/rds/}{Amazon Relational Database Service} (Amazon RDS). A \code{DataSource}
references data that can be used to perform \code{CreateMLModel},
\code{CreateEvaluation}, or \code{CreateBatchPrediction} operations.

\code{CreateDataSourceFromRDS} is an asynchronous operation. In response to
\code{CreateDataSourceFromRDS}, Amazon Machine Learning (Amazon ML)
immediately returns and sets the \code{DataSource} status to \code{PENDING}. After
the \code{DataSource} is created and ready for use, Amazon ML sets the
\code{Status} parameter to \code{COMPLETED}. \code{DataSource} in the \code{COMPLETED} or
\code{PENDING} state can be used only to perform \verb{&gt;CreateMLModel}>,
\code{CreateEvaluation}, or \code{CreateBatchPrediction} operations.

If Amazon ML cannot accept the input source, it sets the \code{Status}
parameter to \code{FAILED} and includes an error message in the \code{Message}
attribute of the \code{GetDataSource} operation response.
}
\section{Request syntax}{
\preformatted{svc$create_data_source_from_rds(
  DataSourceId = "string",
  DataSourceName = "string",
  RDSData = list(
    DatabaseInformation = list(
      InstanceIdentifier = "string",
      DatabaseName = "string"
    ),
    SelectSqlQuery = "string",
    DatabaseCredentials = list(
      Username = "string",
      Password = "string"
    ),
    S3StagingLocation = "string",
    DataRearrangement = "string",
    DataSchema = "string",
    DataSchemaUri = "string",
    ResourceRole = "string",
    ServiceRole = "string",
    SubnetId = "string",
    SecurityGroupIds = list(
      "string"
    )
  ),
  RoleARN = "string",
  ComputeStatistics = TRUE|FALSE
)
}
}

\keyword{internal}
