% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/comprehend_operations.R
\name{comprehend_start_pii_entities_detection_job}
\alias{comprehend_start_pii_entities_detection_job}
\title{Starts an asynchronous PII entity detection job for a collection of
documents}
\usage{
comprehend_start_pii_entities_detection_job(InputDataConfig,
  OutputDataConfig, Mode, RedactionConfig, DataAccessRoleArn, JobName,
  LanguageCode, ClientRequestToken)
}
\arguments{
\item{InputDataConfig}{[required] The input properties for a PII entities detection job.}

\item{OutputDataConfig}{[required] Provides conﬁguration parameters for the output of PII entity detection
jobs.}

\item{Mode}{[required] Specifies whether the output provides the locations (offsets) of PII
entities or a file in which PII entities are redacted.}

\item{RedactionConfig}{Provides configuration parameters for PII entity redaction.

This parameter is required if you set the \code{Mode} parameter to
\code{ONLY_REDACTION}. In that case, you must provide a \code{RedactionConfig}
definition that includes the \code{PiiEntityTypes} parameter.}

\item{DataAccessRoleArn}{[required] The Amazon Resource Name (ARN) of the AWS Identity and Access Management
(IAM) role that grants Amazon Comprehend read access to your input data.}

\item{JobName}{The identifier of the job.}

\item{LanguageCode}{[required] The language of the input documents.}

\item{ClientRequestToken}{A unique identifier for the request. If you don't set the client request
token, Amazon Comprehend generates one.}
}
\description{
Starts an asynchronous PII entity detection job for a collection of
documents.
}
\section{Request syntax}{
\preformatted{svc$start_pii_entities_detection_job(
  InputDataConfig = list(
    S3Uri = "string",
    InputFormat = "ONE_DOC_PER_FILE"|"ONE_DOC_PER_LINE"
  ),
  OutputDataConfig = list(
    S3Uri = "string",
    KmsKeyId = "string"
  ),
  Mode = "ONLY_REDACTION"|"ONLY_OFFSETS",
  RedactionConfig = list(
    PiiEntityTypes = list(
      "BANK_ACCOUNT_NUMBER"|"BANK_ROUTING"|"CREDIT_DEBIT_NUMBER"|"CREDIT_DEBIT_CVV"|"CREDIT_DEBIT_EXPIRY"|"PIN"|"EMAIL"|"ADDRESS"|"NAME"|"PHONE"|"SSN"|"DATE_TIME"|"PASSPORT_NUMBER"|"DRIVER_ID"|"URL"|"AGE"|"USERNAME"|"PASSWORD"|"AWS_ACCESS_KEY"|"AWS_SECRET_KEY"|"IP_ADDRESS"|"MAC_ADDRESS"|"ALL"
    ),
    MaskMode = "MASK"|"REPLACE_WITH_PII_ENTITY_TYPE",
    MaskCharacter = "string"
  ),
  DataAccessRoleArn = "string",
  JobName = "string",
  LanguageCode = "en"|"es"|"fr"|"de"|"it"|"pt"|"ar"|"hi"|"ja"|"ko"|"zh"|"zh-TW",
  ClientRequestToken = "string"
)
}
}

\keyword{internal}
