# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include comprehend_service.R
NULL

#' Determines the dominant language of the input text for a batch of
#' documents
#'
#' @description
#' Determines the dominant language of the input text for a batch of
#' documents. For a list of languages that Amazon Comprehend can detect,
#' see [Amazon Comprehend Supported
#' Languages](https://docs.aws.amazon.com/comprehend/latest/dg/how-languages.html).
#'
#' @usage
#' comprehend_batch_detect_dominant_language(TextList)
#'
#' @param TextList &#91;required&#93; A list containing the text of the input documents. The list can contain
#' a maximum of 25 documents. Each document should contain at least 20
#' characters and must contain fewer than 5,000 bytes of UTF-8 encoded
#' characters.
#'
#' @section Request syntax:
#' ```
#' svc$batch_detect_dominant_language(
#'   TextList = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname comprehend_batch_detect_dominant_language
comprehend_batch_detect_dominant_language <- function(TextList) {
  op <- new_operation(
    name = "BatchDetectDominantLanguage",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .comprehend$batch_detect_dominant_language_input(TextList = TextList)
  output <- .comprehend$batch_detect_dominant_language_output()
  config <- get_config()
  svc <- .comprehend$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.comprehend$operations$batch_detect_dominant_language <- comprehend_batch_detect_dominant_language

#' Inspects the text of a batch of documents for named entities and returns
#' information about them
#'
#' @description
#' Inspects the text of a batch of documents for named entities and returns
#' information about them. For more information about named entities, see
#' how-entities
#'
#' @usage
#' comprehend_batch_detect_entities(TextList, LanguageCode)
#'
#' @param TextList &#91;required&#93; A list containing the text of the input documents. The list can contain
#' a maximum of 25 documents. Each document must contain fewer than 5,000
#' bytes of UTF-8 encoded characters.
#' @param LanguageCode &#91;required&#93; The language of the input documents. You can specify any of the primary
#' languages supported by Amazon Comprehend. All documents must be in the
#' same language.
#'
#' @section Request syntax:
#' ```
#' svc$batch_detect_entities(
#'   TextList = list(
#'     "string"
#'   ),
#'   LanguageCode = "en"|"es"|"fr"|"de"|"it"|"pt"|"ar"|"hi"|"ja"|"ko"|"zh"|"zh-TW"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname comprehend_batch_detect_entities
comprehend_batch_detect_entities <- function(TextList, LanguageCode) {
  op <- new_operation(
    name = "BatchDetectEntities",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .comprehend$batch_detect_entities_input(TextList = TextList, LanguageCode = LanguageCode)
  output <- .comprehend$batch_detect_entities_output()
  config <- get_config()
  svc <- .comprehend$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.comprehend$operations$batch_detect_entities <- comprehend_batch_detect_entities

#' Detects the key noun phrases found in a batch of documents
#'
#' @description
#' Detects the key noun phrases found in a batch of documents.
#'
#' @usage
#' comprehend_batch_detect_key_phrases(TextList, LanguageCode)
#'
#' @param TextList &#91;required&#93; A list containing the text of the input documents. The list can contain
#' a maximum of 25 documents. Each document must contain fewer that 5,000
#' bytes of UTF-8 encoded characters.
#' @param LanguageCode &#91;required&#93; The language of the input documents. You can specify any of the primary
#' languages supported by Amazon Comprehend. All documents must be in the
#' same language.
#'
#' @section Request syntax:
#' ```
#' svc$batch_detect_key_phrases(
#'   TextList = list(
#'     "string"
#'   ),
#'   LanguageCode = "en"|"es"|"fr"|"de"|"it"|"pt"|"ar"|"hi"|"ja"|"ko"|"zh"|"zh-TW"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname comprehend_batch_detect_key_phrases
comprehend_batch_detect_key_phrases <- function(TextList, LanguageCode) {
  op <- new_operation(
    name = "BatchDetectKeyPhrases",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .comprehend$batch_detect_key_phrases_input(TextList = TextList, LanguageCode = LanguageCode)
  output <- .comprehend$batch_detect_key_phrases_output()
  config <- get_config()
  svc <- .comprehend$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.comprehend$operations$batch_detect_key_phrases <- comprehend_batch_detect_key_phrases

#' Inspects a batch of documents and returns an inference of the prevailing
#' sentiment, POSITIVE, NEUTRAL, MIXED, or NEGATIVE, in each one
#'
#' @description
#' Inspects a batch of documents and returns an inference of the prevailing
#' sentiment, `POSITIVE`, `NEUTRAL`, `MIXED`, or `NEGATIVE`, in each one.
#'
#' @usage
#' comprehend_batch_detect_sentiment(TextList, LanguageCode)
#'
#' @param TextList &#91;required&#93; A list containing the text of the input documents. The list can contain
#' a maximum of 25 documents. Each document must contain fewer that 5,000
#' bytes of UTF-8 encoded characters.
#' @param LanguageCode &#91;required&#93; The language of the input documents. You can specify any of the primary
#' languages supported by Amazon Comprehend. All documents must be in the
#' same language.
#'
#' @section Request syntax:
#' ```
#' svc$batch_detect_sentiment(
#'   TextList = list(
#'     "string"
#'   ),
#'   LanguageCode = "en"|"es"|"fr"|"de"|"it"|"pt"|"ar"|"hi"|"ja"|"ko"|"zh"|"zh-TW"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname comprehend_batch_detect_sentiment
comprehend_batch_detect_sentiment <- function(TextList, LanguageCode) {
  op <- new_operation(
    name = "BatchDetectSentiment",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .comprehend$batch_detect_sentiment_input(TextList = TextList, LanguageCode = LanguageCode)
  output <- .comprehend$batch_detect_sentiment_output()
  config <- get_config()
  svc <- .comprehend$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.comprehend$operations$batch_detect_sentiment <- comprehend_batch_detect_sentiment

#' Inspects the text of a batch of documents for the syntax and part of
#' speech of the words in the document and returns information about them
#'
#' @description
#' Inspects the text of a batch of documents for the syntax and part of
#' speech of the words in the document and returns information about them.
#' For more information, see how-syntax.
#'
#' @usage
#' comprehend_batch_detect_syntax(TextList, LanguageCode)
#'
#' @param TextList &#91;required&#93; A list containing the text of the input documents. The list can contain
#' a maximum of 25 documents. Each document must contain fewer that 5,000
#' bytes of UTF-8 encoded characters.
#' @param LanguageCode &#91;required&#93; The language of the input documents. You can specify any of the
#' following languages supported by Amazon Comprehend: German ("de"),
#' English ("en"), Spanish ("es"), French ("fr"), Italian ("it"), or
#' Portuguese ("pt"). All documents must be in the same language.
#'
#' @section Request syntax:
#' ```
#' svc$batch_detect_syntax(
#'   TextList = list(
#'     "string"
#'   ),
#'   LanguageCode = "en"|"es"|"fr"|"de"|"it"|"pt"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname comprehend_batch_detect_syntax
comprehend_batch_detect_syntax <- function(TextList, LanguageCode) {
  op <- new_operation(
    name = "BatchDetectSyntax",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .comprehend$batch_detect_syntax_input(TextList = TextList, LanguageCode = LanguageCode)
  output <- .comprehend$batch_detect_syntax_output()
  config <- get_config()
  svc <- .comprehend$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.comprehend$operations$batch_detect_syntax <- comprehend_batch_detect_syntax

#' Creates a new document classification request to analyze a single
#' document in real-time, using a previously created and trained custom
#' model and an endpoint
#'
#' @description
#' Creates a new document classification request to analyze a single
#' document in real-time, using a previously created and trained custom
#' model and an endpoint.
#'
#' @usage
#' comprehend_classify_document(Text, EndpointArn)
#'
#' @param Text &#91;required&#93; The document text to be analyzed.
#' @param EndpointArn &#91;required&#93; The Amazon Resource Number (ARN) of the endpoint.
#'
#' @section Request syntax:
#' ```
#' svc$classify_document(
#'   Text = "string",
#'   EndpointArn = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname comprehend_classify_document
comprehend_classify_document <- function(Text, EndpointArn) {
  op <- new_operation(
    name = "ClassifyDocument",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .comprehend$classify_document_input(Text = Text, EndpointArn = EndpointArn)
  output <- .comprehend$classify_document_output()
  config <- get_config()
  svc <- .comprehend$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.comprehend$operations$classify_document <- comprehend_classify_document

#' Creates a new document classifier that you can use to categorize
#' documents
#'
#' @description
#' Creates a new document classifier that you can use to categorize
#' documents. To create a classifier, you provide a set of training
#' documents that labeled with the categories that you want to use. After
#' the classifier is trained you can use it to categorize a set of labeled
#' documents into the categories. For more information, see
#' how-document-classification.
#'
#' @usage
#' comprehend_create_document_classifier(DocumentClassifierName,
#'   DataAccessRoleArn, Tags, InputDataConfig, OutputDataConfig,
#'   ClientRequestToken, LanguageCode, VolumeKmsKeyId, VpcConfig, Mode)
#'
#' @param DocumentClassifierName &#91;required&#93; The name of the document classifier.
#' @param DataAccessRoleArn &#91;required&#93; The Amazon Resource Name (ARN) of the AWS Identity and Management (IAM)
#' role that grants Amazon Comprehend read access to your input data.
#' @param Tags Tags to be associated with the document classifier being created. A tag
#' is a key-value pair that adds as a metadata to a resource used by Amazon
#' Comprehend. For example, a tag with "Sales" as the key might be added to
#' a resource to indicate its use by the sales department.
#' @param InputDataConfig &#91;required&#93; Specifies the format and location of the input data for the job.
#' @param OutputDataConfig Enables the addition of output results configuration parameters for
#' custom classifier jobs.
#' @param ClientRequestToken A unique identifier for the request. If you don't set the client request
#' token, Amazon Comprehend generates one.
#' @param LanguageCode &#91;required&#93; The language of the input documents. You can specify any of the
#' following languages supported by Amazon Comprehend: German ("de"),
#' English ("en"), Spanish ("es"), French ("fr"), Italian ("it"), or
#' Portuguese ("pt"). All documents must be in the same language.
#' @param VolumeKmsKeyId ID for the AWS Key Management Service (KMS) key that Amazon Comprehend
#' uses to encrypt data on the storage volume attached to the ML compute
#' instance(s) that process the analysis job. The VolumeKmsKeyId can be
#' either of the following formats:
#' 
#' -   KMS Key ID: `"1234abcd-12ab-34cd-56ef-1234567890ab"`
#' 
#' -   Amazon Resource Name (ARN) of a KMS Key:
#'     `"arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"`
#' @param VpcConfig Configuration parameters for an optional private Virtual Private Cloud
#' (VPC) containing the resources you are using for your custom classifier.
#' For more information, see [Amazon
#' VPC](https://docs.aws.amazon.com/vpc/latest/userguide/what-is-amazon-vpc.html).
#' @param Mode Indicates the mode in which the classifier will be trained. The
#' classifier can be trained in multi-class mode, which identifies one and
#' only one class for each document, or multi-label mode, which identifies
#' one or more labels for each document. In multi-label mode, multiple
#' labels for an individual document are separated by a delimiter. The
#' default delimiter between labels is a pipe (|).
#'
#' @section Request syntax:
#' ```
#' svc$create_document_classifier(
#'   DocumentClassifierName = "string",
#'   DataAccessRoleArn = "string",
#'   Tags = list(
#'     list(
#'       Key = "string",
#'       Value = "string"
#'     )
#'   ),
#'   InputDataConfig = list(
#'     DataFormat = "COMPREHEND_CSV"|"AUGMENTED_MANIFEST",
#'     S3Uri = "string",
#'     LabelDelimiter = "string",
#'     AugmentedManifests = list(
#'       list(
#'         S3Uri = "string",
#'         AttributeNames = list(
#'           "string"
#'         )
#'       )
#'     )
#'   ),
#'   OutputDataConfig = list(
#'     S3Uri = "string",
#'     KmsKeyId = "string"
#'   ),
#'   ClientRequestToken = "string",
#'   LanguageCode = "en"|"es"|"fr"|"de"|"it"|"pt"|"ar"|"hi"|"ja"|"ko"|"zh"|"zh-TW",
#'   VolumeKmsKeyId = "string",
#'   VpcConfig = list(
#'     SecurityGroupIds = list(
#'       "string"
#'     ),
#'     Subnets = list(
#'       "string"
#'     )
#'   ),
#'   Mode = "MULTI_CLASS"|"MULTI_LABEL"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname comprehend_create_document_classifier
comprehend_create_document_classifier <- function(DocumentClassifierName, DataAccessRoleArn, Tags = NULL, InputDataConfig, OutputDataConfig = NULL, ClientRequestToken = NULL, LanguageCode, VolumeKmsKeyId = NULL, VpcConfig = NULL, Mode = NULL) {
  op <- new_operation(
    name = "CreateDocumentClassifier",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .comprehend$create_document_classifier_input(DocumentClassifierName = DocumentClassifierName, DataAccessRoleArn = DataAccessRoleArn, Tags = Tags, InputDataConfig = InputDataConfig, OutputDataConfig = OutputDataConfig, ClientRequestToken = ClientRequestToken, LanguageCode = LanguageCode, VolumeKmsKeyId = VolumeKmsKeyId, VpcConfig = VpcConfig, Mode = Mode)
  output <- .comprehend$create_document_classifier_output()
  config <- get_config()
  svc <- .comprehend$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.comprehend$operations$create_document_classifier <- comprehend_create_document_classifier

#' Creates a model-specific endpoint for synchronous inference for a
#' previously trained custom model
#'
#' @description
#' Creates a model-specific endpoint for synchronous inference for a
#' previously trained custom model
#'
#' @usage
#' comprehend_create_endpoint(EndpointName, ModelArn,
#'   DesiredInferenceUnits, ClientRequestToken, Tags)
#'
#' @param EndpointName &#91;required&#93; This is the descriptive suffix that becomes part of the `EndpointArn`
#' used for all subsequent requests to this resource.
#' @param ModelArn &#91;required&#93; The Amazon Resource Number (ARN) of the model to which the endpoint will
#' be attached.
#' @param DesiredInferenceUnits &#91;required&#93; The desired number of inference units to be used by the model using this
#' endpoint. Each inference unit represents of a throughput of 100
#' characters per second.
#' @param ClientRequestToken An idempotency token provided by the customer. If this token matches a
#' previous endpoint creation request, Amazon Comprehend will not return a
#' `ResourceInUseException`.
#' @param Tags Tags associated with the endpoint being created. A tag is a key-value
#' pair that adds metadata to the endpoint. For example, a tag with "Sales"
#' as the key might be added to an endpoint to indicate its use by the
#' sales department.
#'
#' @section Request syntax:
#' ```
#' svc$create_endpoint(
#'   EndpointName = "string",
#'   ModelArn = "string",
#'   DesiredInferenceUnits = 123,
#'   ClientRequestToken = "string",
#'   Tags = list(
#'     list(
#'       Key = "string",
#'       Value = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname comprehend_create_endpoint
comprehend_create_endpoint <- function(EndpointName, ModelArn, DesiredInferenceUnits, ClientRequestToken = NULL, Tags = NULL) {
  op <- new_operation(
    name = "CreateEndpoint",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .comprehend$create_endpoint_input(EndpointName = EndpointName, ModelArn = ModelArn, DesiredInferenceUnits = DesiredInferenceUnits, ClientRequestToken = ClientRequestToken, Tags = Tags)
  output <- .comprehend$create_endpoint_output()
  config <- get_config()
  svc <- .comprehend$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.comprehend$operations$create_endpoint <- comprehend_create_endpoint

#' Creates an entity recognizer using submitted files
#'
#' @description
#' Creates an entity recognizer using submitted files. After your
#' `CreateEntityRecognizer` request is submitted, you can check job status
#' using the API.
#'
#' @usage
#' comprehend_create_entity_recognizer(RecognizerName, DataAccessRoleArn,
#'   Tags, InputDataConfig, ClientRequestToken, LanguageCode, VolumeKmsKeyId,
#'   VpcConfig)
#'
#' @param RecognizerName &#91;required&#93; The name given to the newly created recognizer. Recognizer names can be
#' a maximum of 256 characters. Alphanumeric characters, hyphens (-) and
#' underscores (\\_) are allowed. The name must be unique in the
#' account/region.
#' @param DataAccessRoleArn &#91;required&#93; The Amazon Resource Name (ARN) of the AWS Identity and Management (IAM)
#' role that grants Amazon Comprehend read access to your input data.
#' @param Tags Tags to be associated with the entity recognizer being created. A tag is
#' a key-value pair that adds as a metadata to a resource used by Amazon
#' Comprehend. For example, a tag with "Sales" as the key might be added to
#' a resource to indicate its use by the sales department.
#' @param InputDataConfig &#91;required&#93; Specifies the format and location of the input data. The S3 bucket
#' containing the input data must be located in the same region as the
#' entity recognizer being created.
#' @param ClientRequestToken A unique identifier for the request. If you don't set the client request
#' token, Amazon Comprehend generates one.
#' @param LanguageCode &#91;required&#93; You can specify any of the following languages supported by Amazon
#' Comprehend: English ("en"), Spanish ("es"), French ("fr"), Italian
#' ("it"), German ("de"), or Portuguese ("pt"). All documents must be in
#' the same language.
#' @param VolumeKmsKeyId ID for the AWS Key Management Service (KMS) key that Amazon Comprehend
#' uses to encrypt data on the storage volume attached to the ML compute
#' instance(s) that process the analysis job. The VolumeKmsKeyId can be
#' either of the following formats:
#' 
#' -   KMS Key ID: `"1234abcd-12ab-34cd-56ef-1234567890ab"`
#' 
#' -   Amazon Resource Name (ARN) of a KMS Key:
#'     `"arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"`
#' @param VpcConfig Configuration parameters for an optional private Virtual Private Cloud
#' (VPC) containing the resources you are using for your custom entity
#' recognizer. For more information, see [Amazon
#' VPC](https://docs.aws.amazon.com/vpc/latest/userguide/what-is-amazon-vpc.html).
#'
#' @section Request syntax:
#' ```
#' svc$create_entity_recognizer(
#'   RecognizerName = "string",
#'   DataAccessRoleArn = "string",
#'   Tags = list(
#'     list(
#'       Key = "string",
#'       Value = "string"
#'     )
#'   ),
#'   InputDataConfig = list(
#'     DataFormat = "COMPREHEND_CSV"|"AUGMENTED_MANIFEST",
#'     EntityTypes = list(
#'       list(
#'         Type = "string"
#'       )
#'     ),
#'     Documents = list(
#'       S3Uri = "string"
#'     ),
#'     Annotations = list(
#'       S3Uri = "string"
#'     ),
#'     EntityList = list(
#'       S3Uri = "string"
#'     ),
#'     AugmentedManifests = list(
#'       list(
#'         S3Uri = "string",
#'         AttributeNames = list(
#'           "string"
#'         )
#'       )
#'     )
#'   ),
#'   ClientRequestToken = "string",
#'   LanguageCode = "en"|"es"|"fr"|"de"|"it"|"pt"|"ar"|"hi"|"ja"|"ko"|"zh"|"zh-TW",
#'   VolumeKmsKeyId = "string",
#'   VpcConfig = list(
#'     SecurityGroupIds = list(
#'       "string"
#'     ),
#'     Subnets = list(
#'       "string"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname comprehend_create_entity_recognizer
comprehend_create_entity_recognizer <- function(RecognizerName, DataAccessRoleArn, Tags = NULL, InputDataConfig, ClientRequestToken = NULL, LanguageCode, VolumeKmsKeyId = NULL, VpcConfig = NULL) {
  op <- new_operation(
    name = "CreateEntityRecognizer",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .comprehend$create_entity_recognizer_input(RecognizerName = RecognizerName, DataAccessRoleArn = DataAccessRoleArn, Tags = Tags, InputDataConfig = InputDataConfig, ClientRequestToken = ClientRequestToken, LanguageCode = LanguageCode, VolumeKmsKeyId = VolumeKmsKeyId, VpcConfig = VpcConfig)
  output <- .comprehend$create_entity_recognizer_output()
  config <- get_config()
  svc <- .comprehend$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.comprehend$operations$create_entity_recognizer <- comprehend_create_entity_recognizer

#' Deletes a previously created document classifier Only those classifiers
#' that are in terminated states (IN_ERROR, TRAINED) will be deleted
#'
#' @description
#' Deletes a previously created document classifier
#' 
#' Only those classifiers that are in terminated states (IN\\_ERROR,
#' TRAINED) will be deleted. If an active inference job is using the model,
#' a `ResourceInUseException` will be returned.
#' 
#' This is an asynchronous action that puts the classifier into a DELETING
#' state, and it is then removed by a background job. Once removed, the
#' classifier disappears from your account and is no longer available for
#' use.
#'
#' @usage
#' comprehend_delete_document_classifier(DocumentClassifierArn)
#'
#' @param DocumentClassifierArn &#91;required&#93; The Amazon Resource Name (ARN) that identifies the document classifier.
#'
#' @section Request syntax:
#' ```
#' svc$delete_document_classifier(
#'   DocumentClassifierArn = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname comprehend_delete_document_classifier
comprehend_delete_document_classifier <- function(DocumentClassifierArn) {
  op <- new_operation(
    name = "DeleteDocumentClassifier",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .comprehend$delete_document_classifier_input(DocumentClassifierArn = DocumentClassifierArn)
  output <- .comprehend$delete_document_classifier_output()
  config <- get_config()
  svc <- .comprehend$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.comprehend$operations$delete_document_classifier <- comprehend_delete_document_classifier

#' Deletes a model-specific endpoint for a previously-trained custom model
#'
#' @description
#' Deletes a model-specific endpoint for a previously-trained custom model.
#' All endpoints must be deleted in order for the model to be deleted.
#'
#' @usage
#' comprehend_delete_endpoint(EndpointArn)
#'
#' @param EndpointArn &#91;required&#93; The Amazon Resource Number (ARN) of the endpoint being deleted.
#'
#' @section Request syntax:
#' ```
#' svc$delete_endpoint(
#'   EndpointArn = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname comprehend_delete_endpoint
comprehend_delete_endpoint <- function(EndpointArn) {
  op <- new_operation(
    name = "DeleteEndpoint",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .comprehend$delete_endpoint_input(EndpointArn = EndpointArn)
  output <- .comprehend$delete_endpoint_output()
  config <- get_config()
  svc <- .comprehend$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.comprehend$operations$delete_endpoint <- comprehend_delete_endpoint

#' Deletes an entity recognizer
#'
#' @description
#' Deletes an entity recognizer.
#' 
#' Only those recognizers that are in terminated states (IN\\_ERROR,
#' TRAINED) will be deleted. If an active inference job is using the model,
#' a `ResourceInUseException` will be returned.
#' 
#' This is an asynchronous action that puts the recognizer into a DELETING
#' state, and it is then removed by a background job. Once removed, the
#' recognizer disappears from your account and is no longer available for
#' use.
#'
#' @usage
#' comprehend_delete_entity_recognizer(EntityRecognizerArn)
#'
#' @param EntityRecognizerArn &#91;required&#93; The Amazon Resource Name (ARN) that identifies the entity recognizer.
#'
#' @section Request syntax:
#' ```
#' svc$delete_entity_recognizer(
#'   EntityRecognizerArn = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname comprehend_delete_entity_recognizer
comprehend_delete_entity_recognizer <- function(EntityRecognizerArn) {
  op <- new_operation(
    name = "DeleteEntityRecognizer",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .comprehend$delete_entity_recognizer_input(EntityRecognizerArn = EntityRecognizerArn)
  output <- .comprehend$delete_entity_recognizer_output()
  config <- get_config()
  svc <- .comprehend$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.comprehend$operations$delete_entity_recognizer <- comprehend_delete_entity_recognizer

#' Gets the properties associated with a document classification job
#'
#' @description
#' Gets the properties associated with a document classification job. Use
#' this operation to get the status of a classification job.
#'
#' @usage
#' comprehend_describe_document_classification_job(JobId)
#'
#' @param JobId &#91;required&#93; The identifier that Amazon Comprehend generated for the job. The
#' operation returns this identifier in its response.
#'
#' @section Request syntax:
#' ```
#' svc$describe_document_classification_job(
#'   JobId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname comprehend_describe_document_classification_job
comprehend_describe_document_classification_job <- function(JobId) {
  op <- new_operation(
    name = "DescribeDocumentClassificationJob",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .comprehend$describe_document_classification_job_input(JobId = JobId)
  output <- .comprehend$describe_document_classification_job_output()
  config <- get_config()
  svc <- .comprehend$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.comprehend$operations$describe_document_classification_job <- comprehend_describe_document_classification_job

#' Gets the properties associated with a document classifier
#'
#' @description
#' Gets the properties associated with a document classifier.
#'
#' @usage
#' comprehend_describe_document_classifier(DocumentClassifierArn)
#'
#' @param DocumentClassifierArn &#91;required&#93; The Amazon Resource Name (ARN) that identifies the document classifier.
#' The operation returns this identifier in its response.
#'
#' @section Request syntax:
#' ```
#' svc$describe_document_classifier(
#'   DocumentClassifierArn = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname comprehend_describe_document_classifier
comprehend_describe_document_classifier <- function(DocumentClassifierArn) {
  op <- new_operation(
    name = "DescribeDocumentClassifier",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .comprehend$describe_document_classifier_input(DocumentClassifierArn = DocumentClassifierArn)
  output <- .comprehend$describe_document_classifier_output()
  config <- get_config()
  svc <- .comprehend$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.comprehend$operations$describe_document_classifier <- comprehend_describe_document_classifier

#' Gets the properties associated with a dominant language detection job
#'
#' @description
#' Gets the properties associated with a dominant language detection job.
#' Use this operation to get the status of a detection job.
#'
#' @usage
#' comprehend_describe_dominant_language_detection_job(JobId)
#'
#' @param JobId &#91;required&#93; The identifier that Amazon Comprehend generated for the job. The
#' operation returns this identifier in its response.
#'
#' @section Request syntax:
#' ```
#' svc$describe_dominant_language_detection_job(
#'   JobId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname comprehend_describe_dominant_language_detection_job
comprehend_describe_dominant_language_detection_job <- function(JobId) {
  op <- new_operation(
    name = "DescribeDominantLanguageDetectionJob",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .comprehend$describe_dominant_language_detection_job_input(JobId = JobId)
  output <- .comprehend$describe_dominant_language_detection_job_output()
  config <- get_config()
  svc <- .comprehend$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.comprehend$operations$describe_dominant_language_detection_job <- comprehend_describe_dominant_language_detection_job

#' Gets the properties associated with a specific endpoint
#'
#' @description
#' Gets the properties associated with a specific endpoint. Use this
#' operation to get the status of an endpoint.
#'
#' @usage
#' comprehend_describe_endpoint(EndpointArn)
#'
#' @param EndpointArn &#91;required&#93; The Amazon Resource Number (ARN) of the endpoint being described.
#'
#' @section Request syntax:
#' ```
#' svc$describe_endpoint(
#'   EndpointArn = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname comprehend_describe_endpoint
comprehend_describe_endpoint <- function(EndpointArn) {
  op <- new_operation(
    name = "DescribeEndpoint",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .comprehend$describe_endpoint_input(EndpointArn = EndpointArn)
  output <- .comprehend$describe_endpoint_output()
  config <- get_config()
  svc <- .comprehend$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.comprehend$operations$describe_endpoint <- comprehend_describe_endpoint

#' Gets the properties associated with an entities detection job
#'
#' @description
#' Gets the properties associated with an entities detection job. Use this
#' operation to get the status of a detection job.
#'
#' @usage
#' comprehend_describe_entities_detection_job(JobId)
#'
#' @param JobId &#91;required&#93; The identifier that Amazon Comprehend generated for the job. The
#' operation returns this identifier in its response.
#'
#' @section Request syntax:
#' ```
#' svc$describe_entities_detection_job(
#'   JobId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname comprehend_describe_entities_detection_job
comprehend_describe_entities_detection_job <- function(JobId) {
  op <- new_operation(
    name = "DescribeEntitiesDetectionJob",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .comprehend$describe_entities_detection_job_input(JobId = JobId)
  output <- .comprehend$describe_entities_detection_job_output()
  config <- get_config()
  svc <- .comprehend$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.comprehend$operations$describe_entities_detection_job <- comprehend_describe_entities_detection_job

#' Provides details about an entity recognizer including status, S3 buckets
#' containing training data, recognizer metadata, metrics, and so on
#'
#' @description
#' Provides details about an entity recognizer including status, S3 buckets
#' containing training data, recognizer metadata, metrics, and so on.
#'
#' @usage
#' comprehend_describe_entity_recognizer(EntityRecognizerArn)
#'
#' @param EntityRecognizerArn &#91;required&#93; The Amazon Resource Name (ARN) that identifies the entity recognizer.
#'
#' @section Request syntax:
#' ```
#' svc$describe_entity_recognizer(
#'   EntityRecognizerArn = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname comprehend_describe_entity_recognizer
comprehend_describe_entity_recognizer <- function(EntityRecognizerArn) {
  op <- new_operation(
    name = "DescribeEntityRecognizer",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .comprehend$describe_entity_recognizer_input(EntityRecognizerArn = EntityRecognizerArn)
  output <- .comprehend$describe_entity_recognizer_output()
  config <- get_config()
  svc <- .comprehend$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.comprehend$operations$describe_entity_recognizer <- comprehend_describe_entity_recognizer

#' Gets the status and details of an events detection job
#'
#' @description
#' Gets the status and details of an events detection job.
#'
#' @usage
#' comprehend_describe_events_detection_job(JobId)
#'
#' @param JobId &#91;required&#93; The identifier of the events detection job.
#'
#' @section Request syntax:
#' ```
#' svc$describe_events_detection_job(
#'   JobId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname comprehend_describe_events_detection_job
comprehend_describe_events_detection_job <- function(JobId) {
  op <- new_operation(
    name = "DescribeEventsDetectionJob",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .comprehend$describe_events_detection_job_input(JobId = JobId)
  output <- .comprehend$describe_events_detection_job_output()
  config <- get_config()
  svc <- .comprehend$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.comprehend$operations$describe_events_detection_job <- comprehend_describe_events_detection_job

#' Gets the properties associated with a key phrases detection job
#'
#' @description
#' Gets the properties associated with a key phrases detection job. Use
#' this operation to get the status of a detection job.
#'
#' @usage
#' comprehend_describe_key_phrases_detection_job(JobId)
#'
#' @param JobId &#91;required&#93; The identifier that Amazon Comprehend generated for the job. The
#' operation returns this identifier in its response.
#'
#' @section Request syntax:
#' ```
#' svc$describe_key_phrases_detection_job(
#'   JobId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname comprehend_describe_key_phrases_detection_job
comprehend_describe_key_phrases_detection_job <- function(JobId) {
  op <- new_operation(
    name = "DescribeKeyPhrasesDetectionJob",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .comprehend$describe_key_phrases_detection_job_input(JobId = JobId)
  output <- .comprehend$describe_key_phrases_detection_job_output()
  config <- get_config()
  svc <- .comprehend$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.comprehend$operations$describe_key_phrases_detection_job <- comprehend_describe_key_phrases_detection_job

#' Gets the properties associated with a PII entities detection job
#'
#' @description
#' Gets the properties associated with a PII entities detection job. For
#' example, you can use this operation to get the job status.
#'
#' @usage
#' comprehend_describe_pii_entities_detection_job(JobId)
#'
#' @param JobId &#91;required&#93; The identifier that Amazon Comprehend generated for the job. The
#' operation returns this identifier in its response.
#'
#' @section Request syntax:
#' ```
#' svc$describe_pii_entities_detection_job(
#'   JobId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname comprehend_describe_pii_entities_detection_job
comprehend_describe_pii_entities_detection_job <- function(JobId) {
  op <- new_operation(
    name = "DescribePiiEntitiesDetectionJob",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .comprehend$describe_pii_entities_detection_job_input(JobId = JobId)
  output <- .comprehend$describe_pii_entities_detection_job_output()
  config <- get_config()
  svc <- .comprehend$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.comprehend$operations$describe_pii_entities_detection_job <- comprehend_describe_pii_entities_detection_job

#' Gets the properties associated with a sentiment detection job
#'
#' @description
#' Gets the properties associated with a sentiment detection job. Use this
#' operation to get the status of a detection job.
#'
#' @usage
#' comprehend_describe_sentiment_detection_job(JobId)
#'
#' @param JobId &#91;required&#93; The identifier that Amazon Comprehend generated for the job. The
#' operation returns this identifier in its response.
#'
#' @section Request syntax:
#' ```
#' svc$describe_sentiment_detection_job(
#'   JobId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname comprehend_describe_sentiment_detection_job
comprehend_describe_sentiment_detection_job <- function(JobId) {
  op <- new_operation(
    name = "DescribeSentimentDetectionJob",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .comprehend$describe_sentiment_detection_job_input(JobId = JobId)
  output <- .comprehend$describe_sentiment_detection_job_output()
  config <- get_config()
  svc <- .comprehend$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.comprehend$operations$describe_sentiment_detection_job <- comprehend_describe_sentiment_detection_job

#' Gets the properties associated with a topic detection job
#'
#' @description
#' Gets the properties associated with a topic detection job. Use this
#' operation to get the status of a detection job.
#'
#' @usage
#' comprehend_describe_topics_detection_job(JobId)
#'
#' @param JobId &#91;required&#93; The identifier assigned by the user to the detection job.
#'
#' @section Request syntax:
#' ```
#' svc$describe_topics_detection_job(
#'   JobId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname comprehend_describe_topics_detection_job
comprehend_describe_topics_detection_job <- function(JobId) {
  op <- new_operation(
    name = "DescribeTopicsDetectionJob",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .comprehend$describe_topics_detection_job_input(JobId = JobId)
  output <- .comprehend$describe_topics_detection_job_output()
  config <- get_config()
  svc <- .comprehend$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.comprehend$operations$describe_topics_detection_job <- comprehend_describe_topics_detection_job

#' Determines the dominant language of the input text
#'
#' @description
#' Determines the dominant language of the input text. For a list of
#' languages that Amazon Comprehend can detect, see [Amazon Comprehend
#' Supported
#' Languages](https://docs.aws.amazon.com/comprehend/latest/dg/how-languages.html).
#'
#' @usage
#' comprehend_detect_dominant_language(Text)
#'
#' @param Text &#91;required&#93; A UTF-8 text string. Each string should contain at least 20 characters
#' and must contain fewer that 5,000 bytes of UTF-8 encoded characters.
#'
#' @section Request syntax:
#' ```
#' svc$detect_dominant_language(
#'   Text = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname comprehend_detect_dominant_language
comprehend_detect_dominant_language <- function(Text) {
  op <- new_operation(
    name = "DetectDominantLanguage",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .comprehend$detect_dominant_language_input(Text = Text)
  output <- .comprehend$detect_dominant_language_output()
  config <- get_config()
  svc <- .comprehend$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.comprehend$operations$detect_dominant_language <- comprehend_detect_dominant_language

#' Inspects text for named entities, and returns information about them
#'
#' @description
#' Inspects text for named entities, and returns information about them.
#' For more information, about named entities, see how-entities.
#'
#' @usage
#' comprehend_detect_entities(Text, LanguageCode, EndpointArn)
#'
#' @param Text &#91;required&#93; A UTF-8 text string. Each string must contain fewer that 5,000 bytes of
#' UTF-8 encoded characters.
#' @param LanguageCode The language of the input documents. You can specify any of the primary
#' languages supported by Amazon Comprehend. All documents must be in the
#' same language.
#' 
#' If your request includes the endpoint for a custom entity recognition
#' model, Amazon Comprehend uses the language of your custom model, and it
#' ignores any language code that you specify here.
#' @param EndpointArn The Amazon Resource Name of an endpoint that is associated with a custom
#' entity recognition model. Provide an endpoint if you want to detect
#' entities by using your own custom model instead of the default model
#' that is used by Amazon Comprehend.
#' 
#' If you specify an endpoint, Amazon Comprehend uses the language of your
#' custom model, and it ignores any language code that you provide in your
#' request.
#'
#' @section Request syntax:
#' ```
#' svc$detect_entities(
#'   Text = "string",
#'   LanguageCode = "en"|"es"|"fr"|"de"|"it"|"pt"|"ar"|"hi"|"ja"|"ko"|"zh"|"zh-TW",
#'   EndpointArn = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname comprehend_detect_entities
comprehend_detect_entities <- function(Text, LanguageCode = NULL, EndpointArn = NULL) {
  op <- new_operation(
    name = "DetectEntities",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .comprehend$detect_entities_input(Text = Text, LanguageCode = LanguageCode, EndpointArn = EndpointArn)
  output <- .comprehend$detect_entities_output()
  config <- get_config()
  svc <- .comprehend$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.comprehend$operations$detect_entities <- comprehend_detect_entities

#' Detects the key noun phrases found in the text
#'
#' @description
#' Detects the key noun phrases found in the text.
#'
#' @usage
#' comprehend_detect_key_phrases(Text, LanguageCode)
#'
#' @param Text &#91;required&#93; A UTF-8 text string. Each string must contain fewer that 5,000 bytes of
#' UTF-8 encoded characters.
#' @param LanguageCode &#91;required&#93; The language of the input documents. You can specify any of the primary
#' languages supported by Amazon Comprehend. All documents must be in the
#' same language.
#'
#' @section Request syntax:
#' ```
#' svc$detect_key_phrases(
#'   Text = "string",
#'   LanguageCode = "en"|"es"|"fr"|"de"|"it"|"pt"|"ar"|"hi"|"ja"|"ko"|"zh"|"zh-TW"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname comprehend_detect_key_phrases
comprehend_detect_key_phrases <- function(Text, LanguageCode) {
  op <- new_operation(
    name = "DetectKeyPhrases",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .comprehend$detect_key_phrases_input(Text = Text, LanguageCode = LanguageCode)
  output <- .comprehend$detect_key_phrases_output()
  config <- get_config()
  svc <- .comprehend$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.comprehend$operations$detect_key_phrases <- comprehend_detect_key_phrases

#' Inspects the input text for entities that contain personally
#' identifiable information (PII) and returns information about them
#'
#' @description
#' Inspects the input text for entities that contain personally
#' identifiable information (PII) and returns information about them.
#'
#' @usage
#' comprehend_detect_pii_entities(Text, LanguageCode)
#'
#' @param Text &#91;required&#93; A UTF-8 text string. Each string must contain fewer that 5,000 bytes of
#' UTF-8 encoded characters.
#' @param LanguageCode &#91;required&#93; The language of the input documents.
#'
#' @section Request syntax:
#' ```
#' svc$detect_pii_entities(
#'   Text = "string",
#'   LanguageCode = "en"|"es"|"fr"|"de"|"it"|"pt"|"ar"|"hi"|"ja"|"ko"|"zh"|"zh-TW"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname comprehend_detect_pii_entities
comprehend_detect_pii_entities <- function(Text, LanguageCode) {
  op <- new_operation(
    name = "DetectPiiEntities",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .comprehend$detect_pii_entities_input(Text = Text, LanguageCode = LanguageCode)
  output <- .comprehend$detect_pii_entities_output()
  config <- get_config()
  svc <- .comprehend$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.comprehend$operations$detect_pii_entities <- comprehend_detect_pii_entities

#' Inspects text and returns an inference of the prevailing sentiment
#' (POSITIVE, NEUTRAL, MIXED, or NEGATIVE)
#'
#' @description
#' Inspects text and returns an inference of the prevailing sentiment
#' (`POSITIVE`, `NEUTRAL`, `MIXED`, or `NEGATIVE`).
#'
#' @usage
#' comprehend_detect_sentiment(Text, LanguageCode)
#'
#' @param Text &#91;required&#93; A UTF-8 text string. Each string must contain fewer that 5,000 bytes of
#' UTF-8 encoded characters.
#' @param LanguageCode &#91;required&#93; The language of the input documents. You can specify any of the primary
#' languages supported by Amazon Comprehend. All documents must be in the
#' same language.
#'
#' @section Request syntax:
#' ```
#' svc$detect_sentiment(
#'   Text = "string",
#'   LanguageCode = "en"|"es"|"fr"|"de"|"it"|"pt"|"ar"|"hi"|"ja"|"ko"|"zh"|"zh-TW"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname comprehend_detect_sentiment
comprehend_detect_sentiment <- function(Text, LanguageCode) {
  op <- new_operation(
    name = "DetectSentiment",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .comprehend$detect_sentiment_input(Text = Text, LanguageCode = LanguageCode)
  output <- .comprehend$detect_sentiment_output()
  config <- get_config()
  svc <- .comprehend$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.comprehend$operations$detect_sentiment <- comprehend_detect_sentiment

#' Inspects text for syntax and the part of speech of words in the document
#'
#' @description
#' Inspects text for syntax and the part of speech of words in the
#' document. For more information, how-syntax.
#'
#' @usage
#' comprehend_detect_syntax(Text, LanguageCode)
#'
#' @param Text &#91;required&#93; A UTF-8 string. Each string must contain fewer that 5,000 bytes of UTF
#' encoded characters.
#' @param LanguageCode &#91;required&#93; The language code of the input documents. You can specify any of the
#' following languages supported by Amazon Comprehend: German ("de"),
#' English ("en"), Spanish ("es"), French ("fr"), Italian ("it"), or
#' Portuguese ("pt").
#'
#' @section Request syntax:
#' ```
#' svc$detect_syntax(
#'   Text = "string",
#'   LanguageCode = "en"|"es"|"fr"|"de"|"it"|"pt"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname comprehend_detect_syntax
comprehend_detect_syntax <- function(Text, LanguageCode) {
  op <- new_operation(
    name = "DetectSyntax",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .comprehend$detect_syntax_input(Text = Text, LanguageCode = LanguageCode)
  output <- .comprehend$detect_syntax_output()
  config <- get_config()
  svc <- .comprehend$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.comprehend$operations$detect_syntax <- comprehend_detect_syntax

#' Gets a list of the documentation classification jobs that you have
#' submitted
#'
#' @description
#' Gets a list of the documentation classification jobs that you have
#' submitted.
#'
#' @usage
#' comprehend_list_document_classification_jobs(Filter, NextToken,
#'   MaxResults)
#'
#' @param Filter Filters the jobs that are returned. You can filter jobs on their names,
#' status, or the date and time that they were submitted. You can only set
#' one filter at a time.
#' @param NextToken Identifies the next page of results to return.
#' @param MaxResults The maximum number of results to return in each page. The default is
#' 100.
#'
#' @section Request syntax:
#' ```
#' svc$list_document_classification_jobs(
#'   Filter = list(
#'     JobName = "string",
#'     JobStatus = "SUBMITTED"|"IN_PROGRESS"|"COMPLETED"|"FAILED"|"STOP_REQUESTED"|"STOPPED",
#'     SubmitTimeBefore = as.POSIXct(
#'       "2015-01-01"
#'     ),
#'     SubmitTimeAfter = as.POSIXct(
#'       "2015-01-01"
#'     )
#'   ),
#'   NextToken = "string",
#'   MaxResults = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname comprehend_list_document_classification_jobs
comprehend_list_document_classification_jobs <- function(Filter = NULL, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListDocumentClassificationJobs",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .comprehend$list_document_classification_jobs_input(Filter = Filter, NextToken = NextToken, MaxResults = MaxResults)
  output <- .comprehend$list_document_classification_jobs_output()
  config <- get_config()
  svc <- .comprehend$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.comprehend$operations$list_document_classification_jobs <- comprehend_list_document_classification_jobs

#' Gets a list of the document classifiers that you have created
#'
#' @description
#' Gets a list of the document classifiers that you have created.
#'
#' @usage
#' comprehend_list_document_classifiers(Filter, NextToken, MaxResults)
#'
#' @param Filter Filters the jobs that are returned. You can filter jobs on their name,
#' status, or the date and time that they were submitted. You can only set
#' one filter at a time.
#' @param NextToken Identifies the next page of results to return.
#' @param MaxResults The maximum number of results to return in each page. The default is
#' 100.
#'
#' @section Request syntax:
#' ```
#' svc$list_document_classifiers(
#'   Filter = list(
#'     Status = "SUBMITTED"|"TRAINING"|"DELETING"|"STOP_REQUESTED"|"STOPPED"|"IN_ERROR"|"TRAINED",
#'     SubmitTimeBefore = as.POSIXct(
#'       "2015-01-01"
#'     ),
#'     SubmitTimeAfter = as.POSIXct(
#'       "2015-01-01"
#'     )
#'   ),
#'   NextToken = "string",
#'   MaxResults = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname comprehend_list_document_classifiers
comprehend_list_document_classifiers <- function(Filter = NULL, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListDocumentClassifiers",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .comprehend$list_document_classifiers_input(Filter = Filter, NextToken = NextToken, MaxResults = MaxResults)
  output <- .comprehend$list_document_classifiers_output()
  config <- get_config()
  svc <- .comprehend$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.comprehend$operations$list_document_classifiers <- comprehend_list_document_classifiers

#' Gets a list of the dominant language detection jobs that you have
#' submitted
#'
#' @description
#' Gets a list of the dominant language detection jobs that you have
#' submitted.
#'
#' @usage
#' comprehend_list_dominant_language_detection_jobs(Filter, NextToken,
#'   MaxResults)
#'
#' @param Filter Filters that jobs that are returned. You can filter jobs on their name,
#' status, or the date and time that they were submitted. You can only set
#' one filter at a time.
#' @param NextToken Identifies the next page of results to return.
#' @param MaxResults The maximum number of results to return in each page. The default is
#' 100.
#'
#' @section Request syntax:
#' ```
#' svc$list_dominant_language_detection_jobs(
#'   Filter = list(
#'     JobName = "string",
#'     JobStatus = "SUBMITTED"|"IN_PROGRESS"|"COMPLETED"|"FAILED"|"STOP_REQUESTED"|"STOPPED",
#'     SubmitTimeBefore = as.POSIXct(
#'       "2015-01-01"
#'     ),
#'     SubmitTimeAfter = as.POSIXct(
#'       "2015-01-01"
#'     )
#'   ),
#'   NextToken = "string",
#'   MaxResults = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname comprehend_list_dominant_language_detection_jobs
comprehend_list_dominant_language_detection_jobs <- function(Filter = NULL, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListDominantLanguageDetectionJobs",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .comprehend$list_dominant_language_detection_jobs_input(Filter = Filter, NextToken = NextToken, MaxResults = MaxResults)
  output <- .comprehend$list_dominant_language_detection_jobs_output()
  config <- get_config()
  svc <- .comprehend$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.comprehend$operations$list_dominant_language_detection_jobs <- comprehend_list_dominant_language_detection_jobs

#' Gets a list of all existing endpoints that you've created
#'
#' @description
#' Gets a list of all existing endpoints that you've created.
#'
#' @usage
#' comprehend_list_endpoints(Filter, NextToken, MaxResults)
#'
#' @param Filter Filters the endpoints that are returned. You can filter endpoints on
#' their name, model, status, or the date and time that they were created.
#' You can only set one filter at a time.
#' @param NextToken Identifies the next page of results to return.
#' @param MaxResults The maximum number of results to return in each page. The default is
#' 100.
#'
#' @section Request syntax:
#' ```
#' svc$list_endpoints(
#'   Filter = list(
#'     ModelArn = "string",
#'     Status = "CREATING"|"DELETING"|"FAILED"|"IN_SERVICE"|"UPDATING",
#'     CreationTimeBefore = as.POSIXct(
#'       "2015-01-01"
#'     ),
#'     CreationTimeAfter = as.POSIXct(
#'       "2015-01-01"
#'     )
#'   ),
#'   NextToken = "string",
#'   MaxResults = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname comprehend_list_endpoints
comprehend_list_endpoints <- function(Filter = NULL, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListEndpoints",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .comprehend$list_endpoints_input(Filter = Filter, NextToken = NextToken, MaxResults = MaxResults)
  output <- .comprehend$list_endpoints_output()
  config <- get_config()
  svc <- .comprehend$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.comprehend$operations$list_endpoints <- comprehend_list_endpoints

#' Gets a list of the entity detection jobs that you have submitted
#'
#' @description
#' Gets a list of the entity detection jobs that you have submitted.
#'
#' @usage
#' comprehend_list_entities_detection_jobs(Filter, NextToken, MaxResults)
#'
#' @param Filter Filters the jobs that are returned. You can filter jobs on their name,
#' status, or the date and time that they were submitted. You can only set
#' one filter at a time.
#' @param NextToken Identifies the next page of results to return.
#' @param MaxResults The maximum number of results to return in each page. The default is
#' 100.
#'
#' @section Request syntax:
#' ```
#' svc$list_entities_detection_jobs(
#'   Filter = list(
#'     JobName = "string",
#'     JobStatus = "SUBMITTED"|"IN_PROGRESS"|"COMPLETED"|"FAILED"|"STOP_REQUESTED"|"STOPPED",
#'     SubmitTimeBefore = as.POSIXct(
#'       "2015-01-01"
#'     ),
#'     SubmitTimeAfter = as.POSIXct(
#'       "2015-01-01"
#'     )
#'   ),
#'   NextToken = "string",
#'   MaxResults = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname comprehend_list_entities_detection_jobs
comprehend_list_entities_detection_jobs <- function(Filter = NULL, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListEntitiesDetectionJobs",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .comprehend$list_entities_detection_jobs_input(Filter = Filter, NextToken = NextToken, MaxResults = MaxResults)
  output <- .comprehend$list_entities_detection_jobs_output()
  config <- get_config()
  svc <- .comprehend$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.comprehend$operations$list_entities_detection_jobs <- comprehend_list_entities_detection_jobs

#' Gets a list of the properties of all entity recognizers that you
#' created, including recognizers currently in training
#'
#' @description
#' Gets a list of the properties of all entity recognizers that you
#' created, including recognizers currently in training. Allows you to
#' filter the list of recognizers based on criteria such as status and
#' submission time. This call returns up to 500 entity recognizers in the
#' list, with a default number of 100 recognizers in the list.
#' 
#' The results of this list are not in any particular order. Please get the
#' list and sort locally if needed.
#'
#' @usage
#' comprehend_list_entity_recognizers(Filter, NextToken, MaxResults)
#'
#' @param Filter Filters the list of entities returned. You can filter on `Status`,
#' `SubmitTimeBefore`, or `SubmitTimeAfter`. You can only set one filter at
#' a time.
#' @param NextToken Identifies the next page of results to return.
#' @param MaxResults The maximum number of results to return on each page. The default is
#' 100.
#'
#' @section Request syntax:
#' ```
#' svc$list_entity_recognizers(
#'   Filter = list(
#'     Status = "SUBMITTED"|"TRAINING"|"DELETING"|"STOP_REQUESTED"|"STOPPED"|"IN_ERROR"|"TRAINED",
#'     SubmitTimeBefore = as.POSIXct(
#'       "2015-01-01"
#'     ),
#'     SubmitTimeAfter = as.POSIXct(
#'       "2015-01-01"
#'     )
#'   ),
#'   NextToken = "string",
#'   MaxResults = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname comprehend_list_entity_recognizers
comprehend_list_entity_recognizers <- function(Filter = NULL, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListEntityRecognizers",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .comprehend$list_entity_recognizers_input(Filter = Filter, NextToken = NextToken, MaxResults = MaxResults)
  output <- .comprehend$list_entity_recognizers_output()
  config <- get_config()
  svc <- .comprehend$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.comprehend$operations$list_entity_recognizers <- comprehend_list_entity_recognizers

#' Gets a list of the events detection jobs that you have submitted
#'
#' @description
#' Gets a list of the events detection jobs that you have submitted.
#'
#' @usage
#' comprehend_list_events_detection_jobs(Filter, NextToken, MaxResults)
#'
#' @param Filter Filters the jobs that are returned. You can filter jobs on their name,
#' status, or the date and time that they were submitted. You can only set
#' one filter at a time.
#' @param NextToken Identifies the next page of results to return.
#' @param MaxResults The maximum number of results to return in each page.
#'
#' @section Request syntax:
#' ```
#' svc$list_events_detection_jobs(
#'   Filter = list(
#'     JobName = "string",
#'     JobStatus = "SUBMITTED"|"IN_PROGRESS"|"COMPLETED"|"FAILED"|"STOP_REQUESTED"|"STOPPED",
#'     SubmitTimeBefore = as.POSIXct(
#'       "2015-01-01"
#'     ),
#'     SubmitTimeAfter = as.POSIXct(
#'       "2015-01-01"
#'     )
#'   ),
#'   NextToken = "string",
#'   MaxResults = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname comprehend_list_events_detection_jobs
comprehend_list_events_detection_jobs <- function(Filter = NULL, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListEventsDetectionJobs",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .comprehend$list_events_detection_jobs_input(Filter = Filter, NextToken = NextToken, MaxResults = MaxResults)
  output <- .comprehend$list_events_detection_jobs_output()
  config <- get_config()
  svc <- .comprehend$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.comprehend$operations$list_events_detection_jobs <- comprehend_list_events_detection_jobs

#' Get a list of key phrase detection jobs that you have submitted
#'
#' @description
#' Get a list of key phrase detection jobs that you have submitted.
#'
#' @usage
#' comprehend_list_key_phrases_detection_jobs(Filter, NextToken,
#'   MaxResults)
#'
#' @param Filter Filters the jobs that are returned. You can filter jobs on their name,
#' status, or the date and time that they were submitted. You can only set
#' one filter at a time.
#' @param NextToken Identifies the next page of results to return.
#' @param MaxResults The maximum number of results to return in each page. The default is
#' 100.
#'
#' @section Request syntax:
#' ```
#' svc$list_key_phrases_detection_jobs(
#'   Filter = list(
#'     JobName = "string",
#'     JobStatus = "SUBMITTED"|"IN_PROGRESS"|"COMPLETED"|"FAILED"|"STOP_REQUESTED"|"STOPPED",
#'     SubmitTimeBefore = as.POSIXct(
#'       "2015-01-01"
#'     ),
#'     SubmitTimeAfter = as.POSIXct(
#'       "2015-01-01"
#'     )
#'   ),
#'   NextToken = "string",
#'   MaxResults = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname comprehend_list_key_phrases_detection_jobs
comprehend_list_key_phrases_detection_jobs <- function(Filter = NULL, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListKeyPhrasesDetectionJobs",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .comprehend$list_key_phrases_detection_jobs_input(Filter = Filter, NextToken = NextToken, MaxResults = MaxResults)
  output <- .comprehend$list_key_phrases_detection_jobs_output()
  config <- get_config()
  svc <- .comprehend$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.comprehend$operations$list_key_phrases_detection_jobs <- comprehend_list_key_phrases_detection_jobs

#' Gets a list of the PII entity detection jobs that you have submitted
#'
#' @description
#' Gets a list of the PII entity detection jobs that you have submitted.
#'
#' @usage
#' comprehend_list_pii_entities_detection_jobs(Filter, NextToken,
#'   MaxResults)
#'
#' @param Filter Filters the jobs that are returned. You can filter jobs on their name,
#' status, or the date and time that they were submitted. You can only set
#' one filter at a time.
#' @param NextToken Identifies the next page of results to return.
#' @param MaxResults The maximum number of results to return in each page.
#'
#' @section Request syntax:
#' ```
#' svc$list_pii_entities_detection_jobs(
#'   Filter = list(
#'     JobName = "string",
#'     JobStatus = "SUBMITTED"|"IN_PROGRESS"|"COMPLETED"|"FAILED"|"STOP_REQUESTED"|"STOPPED",
#'     SubmitTimeBefore = as.POSIXct(
#'       "2015-01-01"
#'     ),
#'     SubmitTimeAfter = as.POSIXct(
#'       "2015-01-01"
#'     )
#'   ),
#'   NextToken = "string",
#'   MaxResults = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname comprehend_list_pii_entities_detection_jobs
comprehend_list_pii_entities_detection_jobs <- function(Filter = NULL, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListPiiEntitiesDetectionJobs",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .comprehend$list_pii_entities_detection_jobs_input(Filter = Filter, NextToken = NextToken, MaxResults = MaxResults)
  output <- .comprehend$list_pii_entities_detection_jobs_output()
  config <- get_config()
  svc <- .comprehend$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.comprehend$operations$list_pii_entities_detection_jobs <- comprehend_list_pii_entities_detection_jobs

#' Gets a list of sentiment detection jobs that you have submitted
#'
#' @description
#' Gets a list of sentiment detection jobs that you have submitted.
#'
#' @usage
#' comprehend_list_sentiment_detection_jobs(Filter, NextToken, MaxResults)
#'
#' @param Filter Filters the jobs that are returned. You can filter jobs on their name,
#' status, or the date and time that they were submitted. You can only set
#' one filter at a time.
#' @param NextToken Identifies the next page of results to return.
#' @param MaxResults The maximum number of results to return in each page. The default is
#' 100.
#'
#' @section Request syntax:
#' ```
#' svc$list_sentiment_detection_jobs(
#'   Filter = list(
#'     JobName = "string",
#'     JobStatus = "SUBMITTED"|"IN_PROGRESS"|"COMPLETED"|"FAILED"|"STOP_REQUESTED"|"STOPPED",
#'     SubmitTimeBefore = as.POSIXct(
#'       "2015-01-01"
#'     ),
#'     SubmitTimeAfter = as.POSIXct(
#'       "2015-01-01"
#'     )
#'   ),
#'   NextToken = "string",
#'   MaxResults = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname comprehend_list_sentiment_detection_jobs
comprehend_list_sentiment_detection_jobs <- function(Filter = NULL, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListSentimentDetectionJobs",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .comprehend$list_sentiment_detection_jobs_input(Filter = Filter, NextToken = NextToken, MaxResults = MaxResults)
  output <- .comprehend$list_sentiment_detection_jobs_output()
  config <- get_config()
  svc <- .comprehend$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.comprehend$operations$list_sentiment_detection_jobs <- comprehend_list_sentiment_detection_jobs

#' Lists all tags associated with a given Amazon Comprehend resource
#'
#' @description
#' Lists all tags associated with a given Amazon Comprehend resource.
#'
#' @usage
#' comprehend_list_tags_for_resource(ResourceArn)
#'
#' @param ResourceArn &#91;required&#93; The Amazon Resource Name (ARN) of the given Amazon Comprehend resource
#' you are querying.
#'
#' @section Request syntax:
#' ```
#' svc$list_tags_for_resource(
#'   ResourceArn = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname comprehend_list_tags_for_resource
comprehend_list_tags_for_resource <- function(ResourceArn) {
  op <- new_operation(
    name = "ListTagsForResource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .comprehend$list_tags_for_resource_input(ResourceArn = ResourceArn)
  output <- .comprehend$list_tags_for_resource_output()
  config <- get_config()
  svc <- .comprehend$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.comprehend$operations$list_tags_for_resource <- comprehend_list_tags_for_resource

#' Gets a list of the topic detection jobs that you have submitted
#'
#' @description
#' Gets a list of the topic detection jobs that you have submitted.
#'
#' @usage
#' comprehend_list_topics_detection_jobs(Filter, NextToken, MaxResults)
#'
#' @param Filter Filters the jobs that are returned. Jobs can be filtered on their name,
#' status, or the date and time that they were submitted. You can set only
#' one filter at a time.
#' @param NextToken Identifies the next page of results to return.
#' @param MaxResults The maximum number of results to return in each page. The default is
#' 100.
#'
#' @section Request syntax:
#' ```
#' svc$list_topics_detection_jobs(
#'   Filter = list(
#'     JobName = "string",
#'     JobStatus = "SUBMITTED"|"IN_PROGRESS"|"COMPLETED"|"FAILED"|"STOP_REQUESTED"|"STOPPED",
#'     SubmitTimeBefore = as.POSIXct(
#'       "2015-01-01"
#'     ),
#'     SubmitTimeAfter = as.POSIXct(
#'       "2015-01-01"
#'     )
#'   ),
#'   NextToken = "string",
#'   MaxResults = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname comprehend_list_topics_detection_jobs
comprehend_list_topics_detection_jobs <- function(Filter = NULL, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListTopicsDetectionJobs",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .comprehend$list_topics_detection_jobs_input(Filter = Filter, NextToken = NextToken, MaxResults = MaxResults)
  output <- .comprehend$list_topics_detection_jobs_output()
  config <- get_config()
  svc <- .comprehend$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.comprehend$operations$list_topics_detection_jobs <- comprehend_list_topics_detection_jobs

#' Starts an asynchronous document classification job
#'
#' @description
#' Starts an asynchronous document classification job. Use the operation to
#' track the progress of the job.
#'
#' @usage
#' comprehend_start_document_classification_job(JobName,
#'   DocumentClassifierArn, InputDataConfig, OutputDataConfig,
#'   DataAccessRoleArn, ClientRequestToken, VolumeKmsKeyId, VpcConfig)
#'
#' @param JobName The identifier of the job.
#' @param DocumentClassifierArn &#91;required&#93; The Amazon Resource Name (ARN) of the document classifier to use to
#' process the job.
#' @param InputDataConfig &#91;required&#93; Specifies the format and location of the input data for the job.
#' @param OutputDataConfig &#91;required&#93; Specifies where to send the output files.
#' @param DataAccessRoleArn &#91;required&#93; The Amazon Resource Name (ARN) of the AWS Identity and Access Management
#' (IAM) role that grants Amazon Comprehend read access to your input data.
#' @param ClientRequestToken A unique identifier for the request. If you do not set the client
#' request token, Amazon Comprehend generates one.
#' @param VolumeKmsKeyId ID for the AWS Key Management Service (KMS) key that Amazon Comprehend
#' uses to encrypt data on the storage volume attached to the ML compute
#' instance(s) that process the analysis job. The VolumeKmsKeyId can be
#' either of the following formats:
#' 
#' -   KMS Key ID: `"1234abcd-12ab-34cd-56ef-1234567890ab"`
#' 
#' -   Amazon Resource Name (ARN) of a KMS Key:
#'     `"arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"`
#' @param VpcConfig Configuration parameters for an optional private Virtual Private Cloud
#' (VPC) containing the resources you are using for your document
#' classification job. For more information, see [Amazon
#' VPC](https://docs.aws.amazon.com/vpc/latest/userguide/what-is-amazon-vpc.html).
#'
#' @section Request syntax:
#' ```
#' svc$start_document_classification_job(
#'   JobName = "string",
#'   DocumentClassifierArn = "string",
#'   InputDataConfig = list(
#'     S3Uri = "string",
#'     InputFormat = "ONE_DOC_PER_FILE"|"ONE_DOC_PER_LINE"
#'   ),
#'   OutputDataConfig = list(
#'     S3Uri = "string",
#'     KmsKeyId = "string"
#'   ),
#'   DataAccessRoleArn = "string",
#'   ClientRequestToken = "string",
#'   VolumeKmsKeyId = "string",
#'   VpcConfig = list(
#'     SecurityGroupIds = list(
#'       "string"
#'     ),
#'     Subnets = list(
#'       "string"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname comprehend_start_document_classification_job
comprehend_start_document_classification_job <- function(JobName = NULL, DocumentClassifierArn, InputDataConfig, OutputDataConfig, DataAccessRoleArn, ClientRequestToken = NULL, VolumeKmsKeyId = NULL, VpcConfig = NULL) {
  op <- new_operation(
    name = "StartDocumentClassificationJob",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .comprehend$start_document_classification_job_input(JobName = JobName, DocumentClassifierArn = DocumentClassifierArn, InputDataConfig = InputDataConfig, OutputDataConfig = OutputDataConfig, DataAccessRoleArn = DataAccessRoleArn, ClientRequestToken = ClientRequestToken, VolumeKmsKeyId = VolumeKmsKeyId, VpcConfig = VpcConfig)
  output <- .comprehend$start_document_classification_job_output()
  config <- get_config()
  svc <- .comprehend$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.comprehend$operations$start_document_classification_job <- comprehend_start_document_classification_job

#' Starts an asynchronous dominant language detection job for a collection
#' of documents
#'
#' @description
#' Starts an asynchronous dominant language detection job for a collection
#' of documents. Use the operation to track the status of a job.
#'
#' @usage
#' comprehend_start_dominant_language_detection_job(InputDataConfig,
#'   OutputDataConfig, DataAccessRoleArn, JobName, ClientRequestToken,
#'   VolumeKmsKeyId, VpcConfig)
#'
#' @param InputDataConfig &#91;required&#93; Specifies the format and location of the input data for the job.
#' @param OutputDataConfig &#91;required&#93; Specifies where to send the output files.
#' @param DataAccessRoleArn &#91;required&#93; The Amazon Resource Name (ARN) of the AWS Identity and Access Management
#' (IAM) role that grants Amazon Comprehend read access to your input data.
#' For more information, see
#' <https://docs.aws.amazon.com/comprehend/latest/dg/access-control-managing-permissions.html#auth-role-permissions>.
#' @param JobName An identifier for the job.
#' @param ClientRequestToken A unique identifier for the request. If you do not set the client
#' request token, Amazon Comprehend generates one.
#' @param VolumeKmsKeyId ID for the AWS Key Management Service (KMS) key that Amazon Comprehend
#' uses to encrypt data on the storage volume attached to the ML compute
#' instance(s) that process the analysis job. The VolumeKmsKeyId can be
#' either of the following formats:
#' 
#' -   KMS Key ID: `"1234abcd-12ab-34cd-56ef-1234567890ab"`
#' 
#' -   Amazon Resource Name (ARN) of a KMS Key:
#'     `"arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"`
#' @param VpcConfig Configuration parameters for an optional private Virtual Private Cloud
#' (VPC) containing the resources you are using for your dominant language
#' detection job. For more information, see [Amazon
#' VPC](https://docs.aws.amazon.com/vpc/latest/userguide/what-is-amazon-vpc.html).
#'
#' @section Request syntax:
#' ```
#' svc$start_dominant_language_detection_job(
#'   InputDataConfig = list(
#'     S3Uri = "string",
#'     InputFormat = "ONE_DOC_PER_FILE"|"ONE_DOC_PER_LINE"
#'   ),
#'   OutputDataConfig = list(
#'     S3Uri = "string",
#'     KmsKeyId = "string"
#'   ),
#'   DataAccessRoleArn = "string",
#'   JobName = "string",
#'   ClientRequestToken = "string",
#'   VolumeKmsKeyId = "string",
#'   VpcConfig = list(
#'     SecurityGroupIds = list(
#'       "string"
#'     ),
#'     Subnets = list(
#'       "string"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname comprehend_start_dominant_language_detection_job
comprehend_start_dominant_language_detection_job <- function(InputDataConfig, OutputDataConfig, DataAccessRoleArn, JobName = NULL, ClientRequestToken = NULL, VolumeKmsKeyId = NULL, VpcConfig = NULL) {
  op <- new_operation(
    name = "StartDominantLanguageDetectionJob",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .comprehend$start_dominant_language_detection_job_input(InputDataConfig = InputDataConfig, OutputDataConfig = OutputDataConfig, DataAccessRoleArn = DataAccessRoleArn, JobName = JobName, ClientRequestToken = ClientRequestToken, VolumeKmsKeyId = VolumeKmsKeyId, VpcConfig = VpcConfig)
  output <- .comprehend$start_dominant_language_detection_job_output()
  config <- get_config()
  svc <- .comprehend$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.comprehend$operations$start_dominant_language_detection_job <- comprehend_start_dominant_language_detection_job

#' Starts an asynchronous entity detection job for a collection of
#' documents
#'
#' @description
#' Starts an asynchronous entity detection job for a collection of
#' documents. Use the operation to track the status of a job.
#' 
#' This API can be used for either standard entity detection or custom
#' entity recognition. In order to be used for custom entity recognition,
#' the optional `EntityRecognizerArn` must be used in order to provide
#' access to the recognizer being used to detect the custom entity.
#'
#' @usage
#' comprehend_start_entities_detection_job(InputDataConfig,
#'   OutputDataConfig, DataAccessRoleArn, JobName, EntityRecognizerArn,
#'   LanguageCode, ClientRequestToken, VolumeKmsKeyId, VpcConfig)
#'
#' @param InputDataConfig &#91;required&#93; Specifies the format and location of the input data for the job.
#' @param OutputDataConfig &#91;required&#93; Specifies where to send the output files.
#' @param DataAccessRoleArn &#91;required&#93; The Amazon Resource Name (ARN) of the AWS Identity and Access Management
#' (IAM) role that grants Amazon Comprehend read access to your input data.
#' For more information, see
#' <https://docs.aws.amazon.com/comprehend/latest/dg/access-control-managing-permissions.html#auth-role-permissions>.
#' @param JobName The identifier of the job.
#' @param EntityRecognizerArn The Amazon Resource Name (ARN) that identifies the specific entity
#' recognizer to be used by the `StartEntitiesDetectionJob`. This ARN is
#' optional and is only used for a custom entity recognition job.
#' @param LanguageCode &#91;required&#93; The language of the input documents. All documents must be in the same
#' language. You can specify any of the languages supported by Amazon
#' Comprehend. If custom entities recognition is used, this parameter is
#' ignored and the language used for training the model is used instead.
#' @param ClientRequestToken A unique identifier for the request. If you don't set the client request
#' token, Amazon Comprehend generates one.
#' @param VolumeKmsKeyId ID for the AWS Key Management Service (KMS) key that Amazon Comprehend
#' uses to encrypt data on the storage volume attached to the ML compute
#' instance(s) that process the analysis job. The VolumeKmsKeyId can be
#' either of the following formats:
#' 
#' -   KMS Key ID: `"1234abcd-12ab-34cd-56ef-1234567890ab"`
#' 
#' -   Amazon Resource Name (ARN) of a KMS Key:
#'     `"arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"`
#' @param VpcConfig Configuration parameters for an optional private Virtual Private Cloud
#' (VPC) containing the resources you are using for your entity detection
#' job. For more information, see [Amazon
#' VPC](https://docs.aws.amazon.com/vpc/latest/userguide/what-is-amazon-vpc.html).
#'
#' @section Request syntax:
#' ```
#' svc$start_entities_detection_job(
#'   InputDataConfig = list(
#'     S3Uri = "string",
#'     InputFormat = "ONE_DOC_PER_FILE"|"ONE_DOC_PER_LINE"
#'   ),
#'   OutputDataConfig = list(
#'     S3Uri = "string",
#'     KmsKeyId = "string"
#'   ),
#'   DataAccessRoleArn = "string",
#'   JobName = "string",
#'   EntityRecognizerArn = "string",
#'   LanguageCode = "en"|"es"|"fr"|"de"|"it"|"pt"|"ar"|"hi"|"ja"|"ko"|"zh"|"zh-TW",
#'   ClientRequestToken = "string",
#'   VolumeKmsKeyId = "string",
#'   VpcConfig = list(
#'     SecurityGroupIds = list(
#'       "string"
#'     ),
#'     Subnets = list(
#'       "string"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname comprehend_start_entities_detection_job
comprehend_start_entities_detection_job <- function(InputDataConfig, OutputDataConfig, DataAccessRoleArn, JobName = NULL, EntityRecognizerArn = NULL, LanguageCode, ClientRequestToken = NULL, VolumeKmsKeyId = NULL, VpcConfig = NULL) {
  op <- new_operation(
    name = "StartEntitiesDetectionJob",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .comprehend$start_entities_detection_job_input(InputDataConfig = InputDataConfig, OutputDataConfig = OutputDataConfig, DataAccessRoleArn = DataAccessRoleArn, JobName = JobName, EntityRecognizerArn = EntityRecognizerArn, LanguageCode = LanguageCode, ClientRequestToken = ClientRequestToken, VolumeKmsKeyId = VolumeKmsKeyId, VpcConfig = VpcConfig)
  output <- .comprehend$start_entities_detection_job_output()
  config <- get_config()
  svc <- .comprehend$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.comprehend$operations$start_entities_detection_job <- comprehend_start_entities_detection_job

#' Starts an asynchronous event detection job for a collection of documents
#'
#' @description
#' Starts an asynchronous event detection job for a collection of
#' documents.
#'
#' @usage
#' comprehend_start_events_detection_job(InputDataConfig, OutputDataConfig,
#'   DataAccessRoleArn, JobName, LanguageCode, ClientRequestToken,
#'   TargetEventTypes)
#'
#' @param InputDataConfig &#91;required&#93; Specifies the format and location of the input data for the job.
#' @param OutputDataConfig &#91;required&#93; Specifies where to send the output files.
#' @param DataAccessRoleArn &#91;required&#93; The Amazon Resource Name (ARN) of the AWS Identity and Access Management
#' (IAM) role that grants Amazon Comprehend read access to your input data.
#' @param JobName The identifier of the events detection job.
#' @param LanguageCode &#91;required&#93; The language code of the input documents.
#' @param ClientRequestToken An unique identifier for the request. If you don't set the client
#' request token, Amazon Comprehend generates one.
#' @param TargetEventTypes &#91;required&#93; The types of events to detect in the input documents.
#'
#' @section Request syntax:
#' ```
#' svc$start_events_detection_job(
#'   InputDataConfig = list(
#'     S3Uri = "string",
#'     InputFormat = "ONE_DOC_PER_FILE"|"ONE_DOC_PER_LINE"
#'   ),
#'   OutputDataConfig = list(
#'     S3Uri = "string",
#'     KmsKeyId = "string"
#'   ),
#'   DataAccessRoleArn = "string",
#'   JobName = "string",
#'   LanguageCode = "en"|"es"|"fr"|"de"|"it"|"pt"|"ar"|"hi"|"ja"|"ko"|"zh"|"zh-TW",
#'   ClientRequestToken = "string",
#'   TargetEventTypes = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname comprehend_start_events_detection_job
comprehend_start_events_detection_job <- function(InputDataConfig, OutputDataConfig, DataAccessRoleArn, JobName = NULL, LanguageCode, ClientRequestToken = NULL, TargetEventTypes) {
  op <- new_operation(
    name = "StartEventsDetectionJob",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .comprehend$start_events_detection_job_input(InputDataConfig = InputDataConfig, OutputDataConfig = OutputDataConfig, DataAccessRoleArn = DataAccessRoleArn, JobName = JobName, LanguageCode = LanguageCode, ClientRequestToken = ClientRequestToken, TargetEventTypes = TargetEventTypes)
  output <- .comprehend$start_events_detection_job_output()
  config <- get_config()
  svc <- .comprehend$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.comprehend$operations$start_events_detection_job <- comprehend_start_events_detection_job

#' Starts an asynchronous key phrase detection job for a collection of
#' documents
#'
#' @description
#' Starts an asynchronous key phrase detection job for a collection of
#' documents. Use the operation to track the status of a job.
#'
#' @usage
#' comprehend_start_key_phrases_detection_job(InputDataConfig,
#'   OutputDataConfig, DataAccessRoleArn, JobName, LanguageCode,
#'   ClientRequestToken, VolumeKmsKeyId, VpcConfig)
#'
#' @param InputDataConfig &#91;required&#93; Specifies the format and location of the input data for the job.
#' @param OutputDataConfig &#91;required&#93; Specifies where to send the output files.
#' @param DataAccessRoleArn &#91;required&#93; The Amazon Resource Name (ARN) of the AWS Identity and Access Management
#' (IAM) role that grants Amazon Comprehend read access to your input data.
#' For more information, see
#' <https://docs.aws.amazon.com/comprehend/latest/dg/access-control-managing-permissions.html#auth-role-permissions>.
#' @param JobName The identifier of the job.
#' @param LanguageCode &#91;required&#93; The language of the input documents. You can specify any of the primary
#' languages supported by Amazon Comprehend. All documents must be in the
#' same language.
#' @param ClientRequestToken A unique identifier for the request. If you don't set the client request
#' token, Amazon Comprehend generates one.
#' @param VolumeKmsKeyId ID for the AWS Key Management Service (KMS) key that Amazon Comprehend
#' uses to encrypt data on the storage volume attached to the ML compute
#' instance(s) that process the analysis job. The VolumeKmsKeyId can be
#' either of the following formats:
#' 
#' -   KMS Key ID: `"1234abcd-12ab-34cd-56ef-1234567890ab"`
#' 
#' -   Amazon Resource Name (ARN) of a KMS Key:
#'     `"arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"`
#' @param VpcConfig Configuration parameters for an optional private Virtual Private Cloud
#' (VPC) containing the resources you are using for your key phrases
#' detection job. For more information, see [Amazon
#' VPC](https://docs.aws.amazon.com/vpc/latest/userguide/what-is-amazon-vpc.html).
#'
#' @section Request syntax:
#' ```
#' svc$start_key_phrases_detection_job(
#'   InputDataConfig = list(
#'     S3Uri = "string",
#'     InputFormat = "ONE_DOC_PER_FILE"|"ONE_DOC_PER_LINE"
#'   ),
#'   OutputDataConfig = list(
#'     S3Uri = "string",
#'     KmsKeyId = "string"
#'   ),
#'   DataAccessRoleArn = "string",
#'   JobName = "string",
#'   LanguageCode = "en"|"es"|"fr"|"de"|"it"|"pt"|"ar"|"hi"|"ja"|"ko"|"zh"|"zh-TW",
#'   ClientRequestToken = "string",
#'   VolumeKmsKeyId = "string",
#'   VpcConfig = list(
#'     SecurityGroupIds = list(
#'       "string"
#'     ),
#'     Subnets = list(
#'       "string"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname comprehend_start_key_phrases_detection_job
comprehend_start_key_phrases_detection_job <- function(InputDataConfig, OutputDataConfig, DataAccessRoleArn, JobName = NULL, LanguageCode, ClientRequestToken = NULL, VolumeKmsKeyId = NULL, VpcConfig = NULL) {
  op <- new_operation(
    name = "StartKeyPhrasesDetectionJob",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .comprehend$start_key_phrases_detection_job_input(InputDataConfig = InputDataConfig, OutputDataConfig = OutputDataConfig, DataAccessRoleArn = DataAccessRoleArn, JobName = JobName, LanguageCode = LanguageCode, ClientRequestToken = ClientRequestToken, VolumeKmsKeyId = VolumeKmsKeyId, VpcConfig = VpcConfig)
  output <- .comprehend$start_key_phrases_detection_job_output()
  config <- get_config()
  svc <- .comprehend$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.comprehend$operations$start_key_phrases_detection_job <- comprehend_start_key_phrases_detection_job

#' Starts an asynchronous PII entity detection job for a collection of
#' documents
#'
#' @description
#' Starts an asynchronous PII entity detection job for a collection of
#' documents.
#'
#' @usage
#' comprehend_start_pii_entities_detection_job(InputDataConfig,
#'   OutputDataConfig, Mode, RedactionConfig, DataAccessRoleArn, JobName,
#'   LanguageCode, ClientRequestToken)
#'
#' @param InputDataConfig &#91;required&#93; The input properties for a PII entities detection job.
#' @param OutputDataConfig &#91;required&#93; Provides conﬁguration parameters for the output of PII entity detection
#' jobs.
#' @param Mode &#91;required&#93; Specifies whether the output provides the locations (offsets) of PII
#' entities or a file in which PII entities are redacted.
#' @param RedactionConfig Provides configuration parameters for PII entity redaction.
#' 
#' This parameter is required if you set the `Mode` parameter to
#' `ONLY_REDACTION`. In that case, you must provide a `RedactionConfig`
#' definition that includes the `PiiEntityTypes` parameter.
#' @param DataAccessRoleArn &#91;required&#93; The Amazon Resource Name (ARN) of the AWS Identity and Access Management
#' (IAM) role that grants Amazon Comprehend read access to your input data.
#' @param JobName The identifier of the job.
#' @param LanguageCode &#91;required&#93; The language of the input documents.
#' @param ClientRequestToken A unique identifier for the request. If you don't set the client request
#' token, Amazon Comprehend generates one.
#'
#' @section Request syntax:
#' ```
#' svc$start_pii_entities_detection_job(
#'   InputDataConfig = list(
#'     S3Uri = "string",
#'     InputFormat = "ONE_DOC_PER_FILE"|"ONE_DOC_PER_LINE"
#'   ),
#'   OutputDataConfig = list(
#'     S3Uri = "string",
#'     KmsKeyId = "string"
#'   ),
#'   Mode = "ONLY_REDACTION"|"ONLY_OFFSETS",
#'   RedactionConfig = list(
#'     PiiEntityTypes = list(
#'       "BANK_ACCOUNT_NUMBER"|"BANK_ROUTING"|"CREDIT_DEBIT_NUMBER"|"CREDIT_DEBIT_CVV"|"CREDIT_DEBIT_EXPIRY"|"PIN"|"EMAIL"|"ADDRESS"|"NAME"|"PHONE"|"SSN"|"DATE_TIME"|"PASSPORT_NUMBER"|"DRIVER_ID"|"URL"|"AGE"|"USERNAME"|"PASSWORD"|"AWS_ACCESS_KEY"|"AWS_SECRET_KEY"|"IP_ADDRESS"|"MAC_ADDRESS"|"ALL"
#'     ),
#'     MaskMode = "MASK"|"REPLACE_WITH_PII_ENTITY_TYPE",
#'     MaskCharacter = "string"
#'   ),
#'   DataAccessRoleArn = "string",
#'   JobName = "string",
#'   LanguageCode = "en"|"es"|"fr"|"de"|"it"|"pt"|"ar"|"hi"|"ja"|"ko"|"zh"|"zh-TW",
#'   ClientRequestToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname comprehend_start_pii_entities_detection_job
comprehend_start_pii_entities_detection_job <- function(InputDataConfig, OutputDataConfig, Mode, RedactionConfig = NULL, DataAccessRoleArn, JobName = NULL, LanguageCode, ClientRequestToken = NULL) {
  op <- new_operation(
    name = "StartPiiEntitiesDetectionJob",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .comprehend$start_pii_entities_detection_job_input(InputDataConfig = InputDataConfig, OutputDataConfig = OutputDataConfig, Mode = Mode, RedactionConfig = RedactionConfig, DataAccessRoleArn = DataAccessRoleArn, JobName = JobName, LanguageCode = LanguageCode, ClientRequestToken = ClientRequestToken)
  output <- .comprehend$start_pii_entities_detection_job_output()
  config <- get_config()
  svc <- .comprehend$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.comprehend$operations$start_pii_entities_detection_job <- comprehend_start_pii_entities_detection_job

#' Starts an asynchronous sentiment detection job for a collection of
#' documents
#'
#' @description
#' Starts an asynchronous sentiment detection job for a collection of
#' documents. use the operation to track the status of a job.
#'
#' @usage
#' comprehend_start_sentiment_detection_job(InputDataConfig,
#'   OutputDataConfig, DataAccessRoleArn, JobName, LanguageCode,
#'   ClientRequestToken, VolumeKmsKeyId, VpcConfig)
#'
#' @param InputDataConfig &#91;required&#93; Specifies the format and location of the input data for the job.
#' @param OutputDataConfig &#91;required&#93; Specifies where to send the output files.
#' @param DataAccessRoleArn &#91;required&#93; The Amazon Resource Name (ARN) of the AWS Identity and Access Management
#' (IAM) role that grants Amazon Comprehend read access to your input data.
#' For more information, see
#' <https://docs.aws.amazon.com/comprehend/latest/dg/access-control-managing-permissions.html#auth-role-permissions>.
#' @param JobName The identifier of the job.
#' @param LanguageCode &#91;required&#93; The language of the input documents. You can specify any of the primary
#' languages supported by Amazon Comprehend. All documents must be in the
#' same language.
#' @param ClientRequestToken A unique identifier for the request. If you don't set the client request
#' token, Amazon Comprehend generates one.
#' @param VolumeKmsKeyId ID for the AWS Key Management Service (KMS) key that Amazon Comprehend
#' uses to encrypt data on the storage volume attached to the ML compute
#' instance(s) that process the analysis job. The VolumeKmsKeyId can be
#' either of the following formats:
#' 
#' -   KMS Key ID: `"1234abcd-12ab-34cd-56ef-1234567890ab"`
#' 
#' -   Amazon Resource Name (ARN) of a KMS Key:
#'     `"arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"`
#' @param VpcConfig Configuration parameters for an optional private Virtual Private Cloud
#' (VPC) containing the resources you are using for your sentiment
#' detection job. For more information, see [Amazon
#' VPC](https://docs.aws.amazon.com/vpc/latest/userguide/what-is-amazon-vpc.html).
#'
#' @section Request syntax:
#' ```
#' svc$start_sentiment_detection_job(
#'   InputDataConfig = list(
#'     S3Uri = "string",
#'     InputFormat = "ONE_DOC_PER_FILE"|"ONE_DOC_PER_LINE"
#'   ),
#'   OutputDataConfig = list(
#'     S3Uri = "string",
#'     KmsKeyId = "string"
#'   ),
#'   DataAccessRoleArn = "string",
#'   JobName = "string",
#'   LanguageCode = "en"|"es"|"fr"|"de"|"it"|"pt"|"ar"|"hi"|"ja"|"ko"|"zh"|"zh-TW",
#'   ClientRequestToken = "string",
#'   VolumeKmsKeyId = "string",
#'   VpcConfig = list(
#'     SecurityGroupIds = list(
#'       "string"
#'     ),
#'     Subnets = list(
#'       "string"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname comprehend_start_sentiment_detection_job
comprehend_start_sentiment_detection_job <- function(InputDataConfig, OutputDataConfig, DataAccessRoleArn, JobName = NULL, LanguageCode, ClientRequestToken = NULL, VolumeKmsKeyId = NULL, VpcConfig = NULL) {
  op <- new_operation(
    name = "StartSentimentDetectionJob",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .comprehend$start_sentiment_detection_job_input(InputDataConfig = InputDataConfig, OutputDataConfig = OutputDataConfig, DataAccessRoleArn = DataAccessRoleArn, JobName = JobName, LanguageCode = LanguageCode, ClientRequestToken = ClientRequestToken, VolumeKmsKeyId = VolumeKmsKeyId, VpcConfig = VpcConfig)
  output <- .comprehend$start_sentiment_detection_job_output()
  config <- get_config()
  svc <- .comprehend$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.comprehend$operations$start_sentiment_detection_job <- comprehend_start_sentiment_detection_job

#' Starts an asynchronous topic detection job
#'
#' @description
#' Starts an asynchronous topic detection job. Use the
#' `DescribeTopicDetectionJob` operation to track the status of a job.
#'
#' @usage
#' comprehend_start_topics_detection_job(InputDataConfig, OutputDataConfig,
#'   DataAccessRoleArn, JobName, NumberOfTopics, ClientRequestToken,
#'   VolumeKmsKeyId, VpcConfig)
#'
#' @param InputDataConfig &#91;required&#93; Specifies the format and location of the input data for the job.
#' @param OutputDataConfig &#91;required&#93; Specifies where to send the output files. The output is a compressed
#' archive with two files, `topic-terms.csv` that lists the terms
#' associated with each topic, and `doc-topics.csv` that lists the
#' documents associated with each topic
#' @param DataAccessRoleArn &#91;required&#93; The Amazon Resource Name (ARN) of the AWS Identity and Access Management
#' (IAM) role that grants Amazon Comprehend read access to your input data.
#' For more information, see
#' <https://docs.aws.amazon.com/comprehend/latest/dg/access-control-managing-permissions.html#auth-role-permissions>.
#' @param JobName The identifier of the job.
#' @param NumberOfTopics The number of topics to detect.
#' @param ClientRequestToken A unique identifier for the request. If you do not set the client
#' request token, Amazon Comprehend generates one.
#' @param VolumeKmsKeyId ID for the AWS Key Management Service (KMS) key that Amazon Comprehend
#' uses to encrypt data on the storage volume attached to the ML compute
#' instance(s) that process the analysis job. The VolumeKmsKeyId can be
#' either of the following formats:
#' 
#' -   KMS Key ID: `"1234abcd-12ab-34cd-56ef-1234567890ab"`
#' 
#' -   Amazon Resource Name (ARN) of a KMS Key:
#'     `"arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"`
#' @param VpcConfig Configuration parameters for an optional private Virtual Private Cloud
#' (VPC) containing the resources you are using for your topic detection
#' job. For more information, see [Amazon
#' VPC](https://docs.aws.amazon.com/vpc/latest/userguide/what-is-amazon-vpc.html).
#'
#' @section Request syntax:
#' ```
#' svc$start_topics_detection_job(
#'   InputDataConfig = list(
#'     S3Uri = "string",
#'     InputFormat = "ONE_DOC_PER_FILE"|"ONE_DOC_PER_LINE"
#'   ),
#'   OutputDataConfig = list(
#'     S3Uri = "string",
#'     KmsKeyId = "string"
#'   ),
#'   DataAccessRoleArn = "string",
#'   JobName = "string",
#'   NumberOfTopics = 123,
#'   ClientRequestToken = "string",
#'   VolumeKmsKeyId = "string",
#'   VpcConfig = list(
#'     SecurityGroupIds = list(
#'       "string"
#'     ),
#'     Subnets = list(
#'       "string"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname comprehend_start_topics_detection_job
comprehend_start_topics_detection_job <- function(InputDataConfig, OutputDataConfig, DataAccessRoleArn, JobName = NULL, NumberOfTopics = NULL, ClientRequestToken = NULL, VolumeKmsKeyId = NULL, VpcConfig = NULL) {
  op <- new_operation(
    name = "StartTopicsDetectionJob",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .comprehend$start_topics_detection_job_input(InputDataConfig = InputDataConfig, OutputDataConfig = OutputDataConfig, DataAccessRoleArn = DataAccessRoleArn, JobName = JobName, NumberOfTopics = NumberOfTopics, ClientRequestToken = ClientRequestToken, VolumeKmsKeyId = VolumeKmsKeyId, VpcConfig = VpcConfig)
  output <- .comprehend$start_topics_detection_job_output()
  config <- get_config()
  svc <- .comprehend$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.comprehend$operations$start_topics_detection_job <- comprehend_start_topics_detection_job

#' Stops a dominant language detection job in progress
#'
#' @description
#' Stops a dominant language detection job in progress.
#' 
#' If the job state is `IN_PROGRESS` the job is marked for termination and
#' put into the `STOP_REQUESTED` state. If the job completes before it can
#' be stopped, it is put into the `COMPLETED` state; otherwise the job is
#' stopped and put into the `STOPPED` state.
#' 
#' If the job is in the `COMPLETED` or `FAILED` state when you call the
#' `StopDominantLanguageDetectionJob` operation, the operation returns a
#' 400 Internal Request Exception.
#' 
#' When a job is stopped, any documents already processed are written to
#' the output location.
#'
#' @usage
#' comprehend_stop_dominant_language_detection_job(JobId)
#'
#' @param JobId &#91;required&#93; The identifier of the dominant language detection job to stop.
#'
#' @section Request syntax:
#' ```
#' svc$stop_dominant_language_detection_job(
#'   JobId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname comprehend_stop_dominant_language_detection_job
comprehend_stop_dominant_language_detection_job <- function(JobId) {
  op <- new_operation(
    name = "StopDominantLanguageDetectionJob",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .comprehend$stop_dominant_language_detection_job_input(JobId = JobId)
  output <- .comprehend$stop_dominant_language_detection_job_output()
  config <- get_config()
  svc <- .comprehend$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.comprehend$operations$stop_dominant_language_detection_job <- comprehend_stop_dominant_language_detection_job

#' Stops an entities detection job in progress
#'
#' @description
#' Stops an entities detection job in progress.
#' 
#' If the job state is `IN_PROGRESS` the job is marked for termination and
#' put into the `STOP_REQUESTED` state. If the job completes before it can
#' be stopped, it is put into the `COMPLETED` state; otherwise the job is
#' stopped and put into the `STOPPED` state.
#' 
#' If the job is in the `COMPLETED` or `FAILED` state when you call the
#' `StopDominantLanguageDetectionJob` operation, the operation returns a
#' 400 Internal Request Exception.
#' 
#' When a job is stopped, any documents already processed are written to
#' the output location.
#'
#' @usage
#' comprehend_stop_entities_detection_job(JobId)
#'
#' @param JobId &#91;required&#93; The identifier of the entities detection job to stop.
#'
#' @section Request syntax:
#' ```
#' svc$stop_entities_detection_job(
#'   JobId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname comprehend_stop_entities_detection_job
comprehend_stop_entities_detection_job <- function(JobId) {
  op <- new_operation(
    name = "StopEntitiesDetectionJob",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .comprehend$stop_entities_detection_job_input(JobId = JobId)
  output <- .comprehend$stop_entities_detection_job_output()
  config <- get_config()
  svc <- .comprehend$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.comprehend$operations$stop_entities_detection_job <- comprehend_stop_entities_detection_job

#' Stops an events detection job in progress
#'
#' @description
#' Stops an events detection job in progress.
#'
#' @usage
#' comprehend_stop_events_detection_job(JobId)
#'
#' @param JobId &#91;required&#93; The identifier of the events detection job to stop.
#'
#' @section Request syntax:
#' ```
#' svc$stop_events_detection_job(
#'   JobId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname comprehend_stop_events_detection_job
comprehend_stop_events_detection_job <- function(JobId) {
  op <- new_operation(
    name = "StopEventsDetectionJob",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .comprehend$stop_events_detection_job_input(JobId = JobId)
  output <- .comprehend$stop_events_detection_job_output()
  config <- get_config()
  svc <- .comprehend$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.comprehend$operations$stop_events_detection_job <- comprehend_stop_events_detection_job

#' Stops a key phrases detection job in progress
#'
#' @description
#' Stops a key phrases detection job in progress.
#' 
#' If the job state is `IN_PROGRESS` the job is marked for termination and
#' put into the `STOP_REQUESTED` state. If the job completes before it can
#' be stopped, it is put into the `COMPLETED` state; otherwise the job is
#' stopped and put into the `STOPPED` state.
#' 
#' If the job is in the `COMPLETED` or `FAILED` state when you call the
#' `StopDominantLanguageDetectionJob` operation, the operation returns a
#' 400 Internal Request Exception.
#' 
#' When a job is stopped, any documents already processed are written to
#' the output location.
#'
#' @usage
#' comprehend_stop_key_phrases_detection_job(JobId)
#'
#' @param JobId &#91;required&#93; The identifier of the key phrases detection job to stop.
#'
#' @section Request syntax:
#' ```
#' svc$stop_key_phrases_detection_job(
#'   JobId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname comprehend_stop_key_phrases_detection_job
comprehend_stop_key_phrases_detection_job <- function(JobId) {
  op <- new_operation(
    name = "StopKeyPhrasesDetectionJob",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .comprehend$stop_key_phrases_detection_job_input(JobId = JobId)
  output <- .comprehend$stop_key_phrases_detection_job_output()
  config <- get_config()
  svc <- .comprehend$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.comprehend$operations$stop_key_phrases_detection_job <- comprehend_stop_key_phrases_detection_job

#' Stops a PII entities detection job in progress
#'
#' @description
#' Stops a PII entities detection job in progress.
#'
#' @usage
#' comprehend_stop_pii_entities_detection_job(JobId)
#'
#' @param JobId &#91;required&#93; The identifier of the PII entities detection job to stop.
#'
#' @section Request syntax:
#' ```
#' svc$stop_pii_entities_detection_job(
#'   JobId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname comprehend_stop_pii_entities_detection_job
comprehend_stop_pii_entities_detection_job <- function(JobId) {
  op <- new_operation(
    name = "StopPiiEntitiesDetectionJob",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .comprehend$stop_pii_entities_detection_job_input(JobId = JobId)
  output <- .comprehend$stop_pii_entities_detection_job_output()
  config <- get_config()
  svc <- .comprehend$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.comprehend$operations$stop_pii_entities_detection_job <- comprehend_stop_pii_entities_detection_job

#' Stops a sentiment detection job in progress
#'
#' @description
#' Stops a sentiment detection job in progress.
#' 
#' If the job state is `IN_PROGRESS` the job is marked for termination and
#' put into the `STOP_REQUESTED` state. If the job completes before it can
#' be stopped, it is put into the `COMPLETED` state; otherwise the job is
#' be stopped and put into the `STOPPED` state.
#' 
#' If the job is in the `COMPLETED` or `FAILED` state when you call the
#' `StopDominantLanguageDetectionJob` operation, the operation returns a
#' 400 Internal Request Exception.
#' 
#' When a job is stopped, any documents already processed are written to
#' the output location.
#'
#' @usage
#' comprehend_stop_sentiment_detection_job(JobId)
#'
#' @param JobId &#91;required&#93; The identifier of the sentiment detection job to stop.
#'
#' @section Request syntax:
#' ```
#' svc$stop_sentiment_detection_job(
#'   JobId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname comprehend_stop_sentiment_detection_job
comprehend_stop_sentiment_detection_job <- function(JobId) {
  op <- new_operation(
    name = "StopSentimentDetectionJob",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .comprehend$stop_sentiment_detection_job_input(JobId = JobId)
  output <- .comprehend$stop_sentiment_detection_job_output()
  config <- get_config()
  svc <- .comprehend$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.comprehend$operations$stop_sentiment_detection_job <- comprehend_stop_sentiment_detection_job

#' Stops a document classifier training job while in progress
#'
#' @description
#' Stops a document classifier training job while in progress.
#' 
#' If the training job state is `TRAINING`, the job is marked for
#' termination and put into the `STOP_REQUESTED` state. If the training job
#' completes before it can be stopped, it is put into the `TRAINED`;
#' otherwise the training job is stopped and put into the `STOPPED` state
#' and the service sends back an HTTP 200 response with an empty HTTP body.
#'
#' @usage
#' comprehend_stop_training_document_classifier(DocumentClassifierArn)
#'
#' @param DocumentClassifierArn &#91;required&#93; The Amazon Resource Name (ARN) that identifies the document classifier
#' currently being trained.
#'
#' @section Request syntax:
#' ```
#' svc$stop_training_document_classifier(
#'   DocumentClassifierArn = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname comprehend_stop_training_document_classifier
comprehend_stop_training_document_classifier <- function(DocumentClassifierArn) {
  op <- new_operation(
    name = "StopTrainingDocumentClassifier",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .comprehend$stop_training_document_classifier_input(DocumentClassifierArn = DocumentClassifierArn)
  output <- .comprehend$stop_training_document_classifier_output()
  config <- get_config()
  svc <- .comprehend$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.comprehend$operations$stop_training_document_classifier <- comprehend_stop_training_document_classifier

#' Stops an entity recognizer training job while in progress
#'
#' @description
#' Stops an entity recognizer training job while in progress.
#' 
#' If the training job state is `TRAINING`, the job is marked for
#' termination and put into the `STOP_REQUESTED` state. If the training job
#' completes before it can be stopped, it is put into the `TRAINED`;
#' otherwise the training job is stopped and putted into the `STOPPED`
#' state and the service sends back an HTTP 200 response with an empty HTTP
#' body.
#'
#' @usage
#' comprehend_stop_training_entity_recognizer(EntityRecognizerArn)
#'
#' @param EntityRecognizerArn &#91;required&#93; The Amazon Resource Name (ARN) that identifies the entity recognizer
#' currently being trained.
#'
#' @section Request syntax:
#' ```
#' svc$stop_training_entity_recognizer(
#'   EntityRecognizerArn = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname comprehend_stop_training_entity_recognizer
comprehend_stop_training_entity_recognizer <- function(EntityRecognizerArn) {
  op <- new_operation(
    name = "StopTrainingEntityRecognizer",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .comprehend$stop_training_entity_recognizer_input(EntityRecognizerArn = EntityRecognizerArn)
  output <- .comprehend$stop_training_entity_recognizer_output()
  config <- get_config()
  svc <- .comprehend$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.comprehend$operations$stop_training_entity_recognizer <- comprehend_stop_training_entity_recognizer

#' Associates a specific tag with an Amazon Comprehend resource
#'
#' @description
#' Associates a specific tag with an Amazon Comprehend resource. A tag is a
#' key-value pair that adds as a metadata to a resource used by Amazon
#' Comprehend. For example, a tag with "Sales" as the key might be added to
#' a resource to indicate its use by the sales department.
#'
#' @usage
#' comprehend_tag_resource(ResourceArn, Tags)
#'
#' @param ResourceArn &#91;required&#93; The Amazon Resource Name (ARN) of the given Amazon Comprehend resource
#' to which you want to associate the tags.
#' @param Tags &#91;required&#93; Tags being associated with a specific Amazon Comprehend resource. There
#' can be a maximum of 50 tags (both existing and pending) associated with
#' a specific resource.
#'
#' @section Request syntax:
#' ```
#' svc$tag_resource(
#'   ResourceArn = "string",
#'   Tags = list(
#'     list(
#'       Key = "string",
#'       Value = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname comprehend_tag_resource
comprehend_tag_resource <- function(ResourceArn, Tags) {
  op <- new_operation(
    name = "TagResource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .comprehend$tag_resource_input(ResourceArn = ResourceArn, Tags = Tags)
  output <- .comprehend$tag_resource_output()
  config <- get_config()
  svc <- .comprehend$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.comprehend$operations$tag_resource <- comprehend_tag_resource

#' Removes a specific tag associated with an Amazon Comprehend resource
#'
#' @description
#' Removes a specific tag associated with an Amazon Comprehend resource.
#'
#' @usage
#' comprehend_untag_resource(ResourceArn, TagKeys)
#'
#' @param ResourceArn &#91;required&#93; The Amazon Resource Name (ARN) of the given Amazon Comprehend resource
#' from which you want to remove the tags.
#' @param TagKeys &#91;required&#93; The initial part of a key-value pair that forms a tag being removed from
#' a given resource. For example, a tag with "Sales" as the key might be
#' added to a resource to indicate its use by the sales department. Keys
#' must be unique and cannot be duplicated for a particular resource.
#'
#' @section Request syntax:
#' ```
#' svc$untag_resource(
#'   ResourceArn = "string",
#'   TagKeys = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname comprehend_untag_resource
comprehend_untag_resource <- function(ResourceArn, TagKeys) {
  op <- new_operation(
    name = "UntagResource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .comprehend$untag_resource_input(ResourceArn = ResourceArn, TagKeys = TagKeys)
  output <- .comprehend$untag_resource_output()
  config <- get_config()
  svc <- .comprehend$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.comprehend$operations$untag_resource <- comprehend_untag_resource

#' Updates information about the specified endpoint
#'
#' @description
#' Updates information about the specified endpoint.
#'
#' @usage
#' comprehend_update_endpoint(EndpointArn, DesiredInferenceUnits)
#'
#' @param EndpointArn &#91;required&#93; The Amazon Resource Number (ARN) of the endpoint being updated.
#' @param DesiredInferenceUnits &#91;required&#93; The desired number of inference units to be used by the model using this
#' endpoint. Each inference unit represents of a throughput of 100
#' characters per second.
#'
#' @section Request syntax:
#' ```
#' svc$update_endpoint(
#'   EndpointArn = "string",
#'   DesiredInferenceUnits = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname comprehend_update_endpoint
comprehend_update_endpoint <- function(EndpointArn, DesiredInferenceUnits) {
  op <- new_operation(
    name = "UpdateEndpoint",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .comprehend$update_endpoint_input(EndpointArn = EndpointArn, DesiredInferenceUnits = DesiredInferenceUnits)
  output <- .comprehend$update_endpoint_output()
  config <- get_config()
  svc <- .comprehend$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.comprehend$operations$update_endpoint <- comprehend_update_endpoint
