% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nimblestudio_operations.R
\name{nimblestudio_create_streaming_session}
\alias{nimblestudio_create_streaming_session}
\title{Creates a streaming session in a studio}
\usage{
nimblestudio_create_streaming_session(
  clientToken = NULL,
  ec2InstanceType = NULL,
  launchProfileId,
  ownedBy = NULL,
  streamingImageId = NULL,
  studioId,
  tags = NULL
)
}
\arguments{
\item{clientToken}{Unique, case-sensitive identifier that you provide to ensure the
idempotency of the request. If you don’t specify a client token, the
Amazon Web Services SDK automatically generates a client token and uses
it for the request to ensure idempotency.}

\item{ec2InstanceType}{The EC2 Instance type used for the streaming session.}

\item{launchProfileId}{[required] The ID of the launch profile used to control access from the streaming
session.}

\item{ownedBy}{The user ID of the user that owns the streaming session. The user that
owns the session will be logging into the session and interacting with
the virtual workstation.}

\item{streamingImageId}{The ID of the streaming image.}

\item{studioId}{[required] The studio ID.}

\item{tags}{A collection of labels, in the form of key-value pairs, that apply to
this resource.}
}
\description{
Creates a streaming session in a studio.

See \url{https://www.paws-r-sdk.com/docs/nimblestudio_create_streaming_session/} for full documentation.
}
\keyword{internal}
