% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/appstream_operations.R
\name{appstream_update_app_block_builder}
\alias{appstream_update_app_block_builder}
\title{Updates an app block builder}
\usage{
appstream_update_app_block_builder(
  Name,
  Description = NULL,
  DisplayName = NULL,
  Platform = NULL,
  InstanceType = NULL,
  VpcConfig = NULL,
  EnableDefaultInternetAccess = NULL,
  IamRoleArn = NULL,
  AccessEndpoints = NULL,
  AttributesToDelete = NULL
)
}
\arguments{
\item{Name}{[required] The unique name for the app block builder.}

\item{Description}{The description of the app block builder.}

\item{DisplayName}{The display name of the app block builder.}

\item{Platform}{The platform of the app block builder.

\code{WINDOWS_SERVER_2019} is the only valid value.}

\item{InstanceType}{The instance type to use when launching the app block builder. The
following instance types are available:
\itemize{
\item stream.standard.small
\item stream.standard.medium
\item stream.standard.large
\item stream.standard.xlarge
\item stream.standard.2xlarge
}}

\item{VpcConfig}{The VPC configuration for the app block builder.

App block builders require that you specify at least two subnets in
different availability zones.}

\item{EnableDefaultInternetAccess}{Enables or disables default internet access for the app block builder.}

\item{IamRoleArn}{The Amazon Resource Name (ARN) of the IAM role to apply to the app block
builder. To assume a role, the app block builder calls the AWS Security
Token Service (STS) \code{AssumeRole} API operation and passes the ARN of the
role to use. The operation creates a new session with temporary
credentials. AppStream 2.0 retrieves the temporary credentials and
creates the \strong{appstream_machine_role} credential profile on the
instance.

For more information, see \href{https://docs.aws.amazon.com/appstream2/latest/developerguide/using-iam-roles-to-grant-permissions-to-applications-scripts-streaming-instances.html}{Using an IAM Role to Grant Permissions to Applications and Scripts Running on AppStream 2.0 Streaming Instances}
in the \emph{Amazon AppStream 2.0 Administration Guide}.}

\item{AccessEndpoints}{The list of interface VPC endpoint (interface endpoint) objects.
Administrators can connect to the app block builder only through the
specified endpoints.}

\item{AttributesToDelete}{The attributes to delete from the app block builder.}
}
\description{
Updates an app block builder.

See \url{https://www.paws-r-sdk.com/docs/appstream_update_app_block_builder/} for full documentation.
}
\keyword{internal}
