# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include worklink_service.R
NULL

#' Specifies a domain to be associated to Amazon WorkLink
#'
#' @description
#' Specifies a domain to be associated to Amazon WorkLink.
#'
#' See [https://www.paws-r-sdk.com/docs/worklink_associate_domain/](https://www.paws-r-sdk.com/docs/worklink_associate_domain/) for full documentation.
#'
#' @param FleetArn &#91;required&#93; The Amazon Resource Name (ARN) of the fleet.
#' @param DomainName &#91;required&#93; The fully qualified domain name (FQDN).
#' @param DisplayName The name to display.
#' @param AcmCertificateArn &#91;required&#93; The ARN of an issued ACM certificate that is valid for the domain being
#' associated.
#'
#' @keywords internal
#'
#' @rdname worklink_associate_domain
worklink_associate_domain <- function(FleetArn, DomainName, DisplayName = NULL, AcmCertificateArn) {
  op <- new_operation(
    name = "AssociateDomain",
    http_method = "POST",
    http_path = "/associateDomain",
    host_prefix = "",
    paginator = list()
  )
  input <- .worklink$associate_domain_input(FleetArn = FleetArn, DomainName = DomainName, DisplayName = DisplayName, AcmCertificateArn = AcmCertificateArn)
  output <- .worklink$associate_domain_output()
  config <- get_config()
  svc <- .worklink$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.worklink$operations$associate_domain <- worklink_associate_domain

#' Associates a website authorization provider with a specified fleet
#'
#' @description
#' Associates a website authorization provider with a specified fleet. This is used to authorize users against associated websites in the company network.
#'
#' See [https://www.paws-r-sdk.com/docs/worklink_associate_website_authorization_provider/](https://www.paws-r-sdk.com/docs/worklink_associate_website_authorization_provider/) for full documentation.
#'
#' @param FleetArn &#91;required&#93; The ARN of the fleet.
#' @param AuthorizationProviderType &#91;required&#93; The authorization provider type.
#' @param DomainName The domain name of the authorization provider. This applies only to
#' SAML-based authorization providers.
#'
#' @keywords internal
#'
#' @rdname worklink_associate_website_authorization_provider
worklink_associate_website_authorization_provider <- function(FleetArn, AuthorizationProviderType, DomainName = NULL) {
  op <- new_operation(
    name = "AssociateWebsiteAuthorizationProvider",
    http_method = "POST",
    http_path = "/associateWebsiteAuthorizationProvider",
    host_prefix = "",
    paginator = list()
  )
  input <- .worklink$associate_website_authorization_provider_input(FleetArn = FleetArn, AuthorizationProviderType = AuthorizationProviderType, DomainName = DomainName)
  output <- .worklink$associate_website_authorization_provider_output()
  config <- get_config()
  svc <- .worklink$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.worklink$operations$associate_website_authorization_provider <- worklink_associate_website_authorization_provider

#' Imports the root certificate of a certificate authority (CA) used to
#' obtain TLS certificates used by associated websites within the company
#' network
#'
#' @description
#' Imports the root certificate of a certificate authority (CA) used to obtain TLS certificates used by associated websites within the company network.
#'
#' See [https://www.paws-r-sdk.com/docs/worklink_associate_website_certificate_authority/](https://www.paws-r-sdk.com/docs/worklink_associate_website_certificate_authority/) for full documentation.
#'
#' @param FleetArn &#91;required&#93; The ARN of the fleet.
#' @param Certificate &#91;required&#93; The root certificate of the CA.
#' @param DisplayName The certificate name to display.
#'
#' @keywords internal
#'
#' @rdname worklink_associate_website_certificate_authority
worklink_associate_website_certificate_authority <- function(FleetArn, Certificate, DisplayName = NULL) {
  op <- new_operation(
    name = "AssociateWebsiteCertificateAuthority",
    http_method = "POST",
    http_path = "/associateWebsiteCertificateAuthority",
    host_prefix = "",
    paginator = list()
  )
  input <- .worklink$associate_website_certificate_authority_input(FleetArn = FleetArn, Certificate = Certificate, DisplayName = DisplayName)
  output <- .worklink$associate_website_certificate_authority_output()
  config <- get_config()
  svc <- .worklink$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.worklink$operations$associate_website_certificate_authority <- worklink_associate_website_certificate_authority

#' Creates a fleet
#'
#' @description
#' Creates a fleet. A fleet consists of resources and the configuration that delivers associated websites to authorized users who download and set up the Amazon WorkLink app.
#'
#' See [https://www.paws-r-sdk.com/docs/worklink_create_fleet/](https://www.paws-r-sdk.com/docs/worklink_create_fleet/) for full documentation.
#'
#' @param FleetName &#91;required&#93; A unique name for the fleet.
#' @param DisplayName The fleet name to display.
#' @param OptimizeForEndUserLocation The option to optimize for better performance by routing traffic through
#' the closest AWS Region to users, which may be outside of your home
#' Region.
#' @param Tags The tags to add to the resource. A tag is a key-value pair.
#'
#' @keywords internal
#'
#' @rdname worklink_create_fleet
worklink_create_fleet <- function(FleetName, DisplayName = NULL, OptimizeForEndUserLocation = NULL, Tags = NULL) {
  op <- new_operation(
    name = "CreateFleet",
    http_method = "POST",
    http_path = "/createFleet",
    host_prefix = "",
    paginator = list()
  )
  input <- .worklink$create_fleet_input(FleetName = FleetName, DisplayName = DisplayName, OptimizeForEndUserLocation = OptimizeForEndUserLocation, Tags = Tags)
  output <- .worklink$create_fleet_output()
  config <- get_config()
  svc <- .worklink$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.worklink$operations$create_fleet <- worklink_create_fleet

#' Deletes a fleet
#'
#' @description
#' Deletes a fleet. Prevents users from accessing previously associated websites.
#'
#' See [https://www.paws-r-sdk.com/docs/worklink_delete_fleet/](https://www.paws-r-sdk.com/docs/worklink_delete_fleet/) for full documentation.
#'
#' @param FleetArn &#91;required&#93; The ARN of the fleet.
#'
#' @keywords internal
#'
#' @rdname worklink_delete_fleet
worklink_delete_fleet <- function(FleetArn) {
  op <- new_operation(
    name = "DeleteFleet",
    http_method = "POST",
    http_path = "/deleteFleet",
    host_prefix = "",
    paginator = list()
  )
  input <- .worklink$delete_fleet_input(FleetArn = FleetArn)
  output <- .worklink$delete_fleet_output()
  config <- get_config()
  svc <- .worklink$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.worklink$operations$delete_fleet <- worklink_delete_fleet

#' Describes the configuration for delivering audit streams to the customer
#' account
#'
#' @description
#' Describes the configuration for delivering audit streams to the customer account.
#'
#' See [https://www.paws-r-sdk.com/docs/worklink_describe_audit_stream_configuration/](https://www.paws-r-sdk.com/docs/worklink_describe_audit_stream_configuration/) for full documentation.
#'
#' @param FleetArn &#91;required&#93; The ARN of the fleet.
#'
#' @keywords internal
#'
#' @rdname worklink_describe_audit_stream_configuration
worklink_describe_audit_stream_configuration <- function(FleetArn) {
  op <- new_operation(
    name = "DescribeAuditStreamConfiguration",
    http_method = "POST",
    http_path = "/describeAuditStreamConfiguration",
    host_prefix = "",
    paginator = list()
  )
  input <- .worklink$describe_audit_stream_configuration_input(FleetArn = FleetArn)
  output <- .worklink$describe_audit_stream_configuration_output()
  config <- get_config()
  svc <- .worklink$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.worklink$operations$describe_audit_stream_configuration <- worklink_describe_audit_stream_configuration

#' Describes the networking configuration to access the internal websites
#' associated with the specified fleet
#'
#' @description
#' Describes the networking configuration to access the internal websites associated with the specified fleet.
#'
#' See [https://www.paws-r-sdk.com/docs/worklink_describe_company_network_configuration/](https://www.paws-r-sdk.com/docs/worklink_describe_company_network_configuration/) for full documentation.
#'
#' @param FleetArn &#91;required&#93; The ARN of the fleet.
#'
#' @keywords internal
#'
#' @rdname worklink_describe_company_network_configuration
worklink_describe_company_network_configuration <- function(FleetArn) {
  op <- new_operation(
    name = "DescribeCompanyNetworkConfiguration",
    http_method = "POST",
    http_path = "/describeCompanyNetworkConfiguration",
    host_prefix = "",
    paginator = list()
  )
  input <- .worklink$describe_company_network_configuration_input(FleetArn = FleetArn)
  output <- .worklink$describe_company_network_configuration_output()
  config <- get_config()
  svc <- .worklink$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.worklink$operations$describe_company_network_configuration <- worklink_describe_company_network_configuration

#' Provides information about a user's device
#'
#' @description
#' Provides information about a user's device.
#'
#' See [https://www.paws-r-sdk.com/docs/worklink_describe_device/](https://www.paws-r-sdk.com/docs/worklink_describe_device/) for full documentation.
#'
#' @param FleetArn &#91;required&#93; The ARN of the fleet.
#' @param DeviceId &#91;required&#93; A unique identifier for a registered user's device.
#'
#' @keywords internal
#'
#' @rdname worklink_describe_device
worklink_describe_device <- function(FleetArn, DeviceId) {
  op <- new_operation(
    name = "DescribeDevice",
    http_method = "POST",
    http_path = "/describeDevice",
    host_prefix = "",
    paginator = list()
  )
  input <- .worklink$describe_device_input(FleetArn = FleetArn, DeviceId = DeviceId)
  output <- .worklink$describe_device_output()
  config <- get_config()
  svc <- .worklink$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.worklink$operations$describe_device <- worklink_describe_device

#' Describes the device policy configuration for the specified fleet
#'
#' @description
#' Describes the device policy configuration for the specified fleet.
#'
#' See [https://www.paws-r-sdk.com/docs/worklink_describe_device_policy_configuration/](https://www.paws-r-sdk.com/docs/worklink_describe_device_policy_configuration/) for full documentation.
#'
#' @param FleetArn &#91;required&#93; The ARN of the fleet.
#'
#' @keywords internal
#'
#' @rdname worklink_describe_device_policy_configuration
worklink_describe_device_policy_configuration <- function(FleetArn) {
  op <- new_operation(
    name = "DescribeDevicePolicyConfiguration",
    http_method = "POST",
    http_path = "/describeDevicePolicyConfiguration",
    host_prefix = "",
    paginator = list()
  )
  input <- .worklink$describe_device_policy_configuration_input(FleetArn = FleetArn)
  output <- .worklink$describe_device_policy_configuration_output()
  config <- get_config()
  svc <- .worklink$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.worklink$operations$describe_device_policy_configuration <- worklink_describe_device_policy_configuration

#' Provides information about the domain
#'
#' @description
#' Provides information about the domain.
#'
#' See [https://www.paws-r-sdk.com/docs/worklink_describe_domain/](https://www.paws-r-sdk.com/docs/worklink_describe_domain/) for full documentation.
#'
#' @param FleetArn &#91;required&#93; The ARN of the fleet.
#' @param DomainName &#91;required&#93; The name of the domain.
#'
#' @keywords internal
#'
#' @rdname worklink_describe_domain
worklink_describe_domain <- function(FleetArn, DomainName) {
  op <- new_operation(
    name = "DescribeDomain",
    http_method = "POST",
    http_path = "/describeDomain",
    host_prefix = "",
    paginator = list()
  )
  input <- .worklink$describe_domain_input(FleetArn = FleetArn, DomainName = DomainName)
  output <- .worklink$describe_domain_output()
  config <- get_config()
  svc <- .worklink$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.worklink$operations$describe_domain <- worklink_describe_domain

#' Provides basic information for the specified fleet, excluding identity
#' provider, networking, and device configuration details
#'
#' @description
#' Provides basic information for the specified fleet, excluding identity provider, networking, and device configuration details.
#'
#' See [https://www.paws-r-sdk.com/docs/worklink_describe_fleet_metadata/](https://www.paws-r-sdk.com/docs/worklink_describe_fleet_metadata/) for full documentation.
#'
#' @param FleetArn &#91;required&#93; The Amazon Resource Name (ARN) of the fleet.
#'
#' @keywords internal
#'
#' @rdname worklink_describe_fleet_metadata
worklink_describe_fleet_metadata <- function(FleetArn) {
  op <- new_operation(
    name = "DescribeFleetMetadata",
    http_method = "POST",
    http_path = "/describeFleetMetadata",
    host_prefix = "",
    paginator = list()
  )
  input <- .worklink$describe_fleet_metadata_input(FleetArn = FleetArn)
  output <- .worklink$describe_fleet_metadata_output()
  config <- get_config()
  svc <- .worklink$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.worklink$operations$describe_fleet_metadata <- worklink_describe_fleet_metadata

#' Describes the identity provider configuration of the specified fleet
#'
#' @description
#' Describes the identity provider configuration of the specified fleet.
#'
#' See [https://www.paws-r-sdk.com/docs/worklink_describe_identity_provider_configuration/](https://www.paws-r-sdk.com/docs/worklink_describe_identity_provider_configuration/) for full documentation.
#'
#' @param FleetArn &#91;required&#93; The ARN of the fleet.
#'
#' @keywords internal
#'
#' @rdname worklink_describe_identity_provider_configuration
worklink_describe_identity_provider_configuration <- function(FleetArn) {
  op <- new_operation(
    name = "DescribeIdentityProviderConfiguration",
    http_method = "POST",
    http_path = "/describeIdentityProviderConfiguration",
    host_prefix = "",
    paginator = list()
  )
  input <- .worklink$describe_identity_provider_configuration_input(FleetArn = FleetArn)
  output <- .worklink$describe_identity_provider_configuration_output()
  config <- get_config()
  svc <- .worklink$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.worklink$operations$describe_identity_provider_configuration <- worklink_describe_identity_provider_configuration

#' Provides information about the certificate authority
#'
#' @description
#' Provides information about the certificate authority.
#'
#' See [https://www.paws-r-sdk.com/docs/worklink_describe_website_certificate_authority/](https://www.paws-r-sdk.com/docs/worklink_describe_website_certificate_authority/) for full documentation.
#'
#' @param FleetArn &#91;required&#93; The ARN of the fleet.
#' @param WebsiteCaId &#91;required&#93; A unique identifier for the certificate authority.
#'
#' @keywords internal
#'
#' @rdname worklink_describe_website_certificate_authority
worklink_describe_website_certificate_authority <- function(FleetArn, WebsiteCaId) {
  op <- new_operation(
    name = "DescribeWebsiteCertificateAuthority",
    http_method = "POST",
    http_path = "/describeWebsiteCertificateAuthority",
    host_prefix = "",
    paginator = list()
  )
  input <- .worklink$describe_website_certificate_authority_input(FleetArn = FleetArn, WebsiteCaId = WebsiteCaId)
  output <- .worklink$describe_website_certificate_authority_output()
  config <- get_config()
  svc <- .worklink$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.worklink$operations$describe_website_certificate_authority <- worklink_describe_website_certificate_authority

#' Disassociates a domain from Amazon WorkLink
#'
#' @description
#' Disassociates a domain from Amazon WorkLink. End users lose the ability to access the domain with Amazon WorkLink.
#'
#' See [https://www.paws-r-sdk.com/docs/worklink_disassociate_domain/](https://www.paws-r-sdk.com/docs/worklink_disassociate_domain/) for full documentation.
#'
#' @param FleetArn &#91;required&#93; The ARN of the fleet.
#' @param DomainName &#91;required&#93; The name of the domain.
#'
#' @keywords internal
#'
#' @rdname worklink_disassociate_domain
worklink_disassociate_domain <- function(FleetArn, DomainName) {
  op <- new_operation(
    name = "DisassociateDomain",
    http_method = "POST",
    http_path = "/disassociateDomain",
    host_prefix = "",
    paginator = list()
  )
  input <- .worklink$disassociate_domain_input(FleetArn = FleetArn, DomainName = DomainName)
  output <- .worklink$disassociate_domain_output()
  config <- get_config()
  svc <- .worklink$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.worklink$operations$disassociate_domain <- worklink_disassociate_domain

#' Disassociates a website authorization provider from a specified fleet
#'
#' @description
#' Disassociates a website authorization provider from a specified fleet. After the disassociation, users can't load any associated websites that require this authorization provider.
#'
#' See [https://www.paws-r-sdk.com/docs/worklink_disassociate_website_authorization_provider/](https://www.paws-r-sdk.com/docs/worklink_disassociate_website_authorization_provider/) for full documentation.
#'
#' @param FleetArn &#91;required&#93; The ARN of the fleet.
#' @param AuthorizationProviderId &#91;required&#93; A unique identifier for the authorization provider.
#'
#' @keywords internal
#'
#' @rdname worklink_disassociate_website_authorization_provider
worklink_disassociate_website_authorization_provider <- function(FleetArn, AuthorizationProviderId) {
  op <- new_operation(
    name = "DisassociateWebsiteAuthorizationProvider",
    http_method = "POST",
    http_path = "/disassociateWebsiteAuthorizationProvider",
    host_prefix = "",
    paginator = list()
  )
  input <- .worklink$disassociate_website_authorization_provider_input(FleetArn = FleetArn, AuthorizationProviderId = AuthorizationProviderId)
  output <- .worklink$disassociate_website_authorization_provider_output()
  config <- get_config()
  svc <- .worklink$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.worklink$operations$disassociate_website_authorization_provider <- worklink_disassociate_website_authorization_provider

#' Removes a certificate authority (CA)
#'
#' @description
#' Removes a certificate authority (CA).
#'
#' See [https://www.paws-r-sdk.com/docs/worklink_disassociate_website_certificate_authority/](https://www.paws-r-sdk.com/docs/worklink_disassociate_website_certificate_authority/) for full documentation.
#'
#' @param FleetArn &#91;required&#93; The ARN of the fleet.
#' @param WebsiteCaId &#91;required&#93; A unique identifier for the CA.
#'
#' @keywords internal
#'
#' @rdname worklink_disassociate_website_certificate_authority
worklink_disassociate_website_certificate_authority <- function(FleetArn, WebsiteCaId) {
  op <- new_operation(
    name = "DisassociateWebsiteCertificateAuthority",
    http_method = "POST",
    http_path = "/disassociateWebsiteCertificateAuthority",
    host_prefix = "",
    paginator = list()
  )
  input <- .worklink$disassociate_website_certificate_authority_input(FleetArn = FleetArn, WebsiteCaId = WebsiteCaId)
  output <- .worklink$disassociate_website_certificate_authority_output()
  config <- get_config()
  svc <- .worklink$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.worklink$operations$disassociate_website_certificate_authority <- worklink_disassociate_website_certificate_authority

#' Retrieves a list of devices registered with the specified fleet
#'
#' @description
#' Retrieves a list of devices registered with the specified fleet.
#'
#' See [https://www.paws-r-sdk.com/docs/worklink_list_devices/](https://www.paws-r-sdk.com/docs/worklink_list_devices/) for full documentation.
#'
#' @param FleetArn &#91;required&#93; The ARN of the fleet.
#' @param NextToken The pagination token used to retrieve the next page of results for this
#' operation. If this value is null, it retrieves the first page.
#' @param MaxResults The maximum number of results to be included in the next page.
#'
#' @keywords internal
#'
#' @rdname worklink_list_devices
worklink_list_devices <- function(FleetArn, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListDevices",
    http_method = "POST",
    http_path = "/listDevices",
    host_prefix = "",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults")
  )
  input <- .worklink$list_devices_input(FleetArn = FleetArn, NextToken = NextToken, MaxResults = MaxResults)
  output <- .worklink$list_devices_output()
  config <- get_config()
  svc <- .worklink$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.worklink$operations$list_devices <- worklink_list_devices

#' Retrieves a list of domains associated to a specified fleet
#'
#' @description
#' Retrieves a list of domains associated to a specified fleet.
#'
#' See [https://www.paws-r-sdk.com/docs/worklink_list_domains/](https://www.paws-r-sdk.com/docs/worklink_list_domains/) for full documentation.
#'
#' @param FleetArn &#91;required&#93; The ARN of the fleet.
#' @param NextToken The pagination token used to retrieve the next page of results for this
#' operation. If this value is null, it retrieves the first page.
#' @param MaxResults The maximum number of results to be included in the next page.
#'
#' @keywords internal
#'
#' @rdname worklink_list_domains
worklink_list_domains <- function(FleetArn, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListDomains",
    http_method = "POST",
    http_path = "/listDomains",
    host_prefix = "",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults")
  )
  input <- .worklink$list_domains_input(FleetArn = FleetArn, NextToken = NextToken, MaxResults = MaxResults)
  output <- .worklink$list_domains_output()
  config <- get_config()
  svc <- .worklink$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.worklink$operations$list_domains <- worklink_list_domains

#' Retrieves a list of fleets for the current account and Region
#'
#' @description
#' Retrieves a list of fleets for the current account and Region.
#'
#' See [https://www.paws-r-sdk.com/docs/worklink_list_fleets/](https://www.paws-r-sdk.com/docs/worklink_list_fleets/) for full documentation.
#'
#' @param NextToken The pagination token used to retrieve the next page of results for this
#' operation. If this value is null, it retrieves the first page.
#' @param MaxResults The maximum number of results to be included in the next page.
#'
#' @keywords internal
#'
#' @rdname worklink_list_fleets
worklink_list_fleets <- function(NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListFleets",
    http_method = "POST",
    http_path = "/listFleets",
    host_prefix = "",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults")
  )
  input <- .worklink$list_fleets_input(NextToken = NextToken, MaxResults = MaxResults)
  output <- .worklink$list_fleets_output()
  config <- get_config()
  svc <- .worklink$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.worklink$operations$list_fleets <- worklink_list_fleets

#' Retrieves a list of tags for the specified resource
#'
#' @description
#' Retrieves a list of tags for the specified resource.
#'
#' See [https://www.paws-r-sdk.com/docs/worklink_list_tags_for_resource/](https://www.paws-r-sdk.com/docs/worklink_list_tags_for_resource/) for full documentation.
#'
#' @param ResourceArn &#91;required&#93; The Amazon Resource Name (ARN) of the fleet.
#'
#' @keywords internal
#'
#' @rdname worklink_list_tags_for_resource
worklink_list_tags_for_resource <- function(ResourceArn) {
  op <- new_operation(
    name = "ListTagsForResource",
    http_method = "GET",
    http_path = "/tags/{ResourceArn}",
    host_prefix = "",
    paginator = list()
  )
  input <- .worklink$list_tags_for_resource_input(ResourceArn = ResourceArn)
  output <- .worklink$list_tags_for_resource_output()
  config <- get_config()
  svc <- .worklink$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.worklink$operations$list_tags_for_resource <- worklink_list_tags_for_resource

#' Retrieves a list of website authorization providers associated with a
#' specified fleet
#'
#' @description
#' Retrieves a list of website authorization providers associated with a specified fleet.
#'
#' See [https://www.paws-r-sdk.com/docs/worklink_list_website_authorization_providers/](https://www.paws-r-sdk.com/docs/worklink_list_website_authorization_providers/) for full documentation.
#'
#' @param FleetArn &#91;required&#93; The ARN of the fleet.
#' @param NextToken The pagination token to use to retrieve the next page of results for
#' this operation. If this value is null, it retrieves the first page.
#' @param MaxResults The maximum number of results to be included in the next page.
#'
#' @keywords internal
#'
#' @rdname worklink_list_website_authorization_providers
worklink_list_website_authorization_providers <- function(FleetArn, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListWebsiteAuthorizationProviders",
    http_method = "POST",
    http_path = "/listWebsiteAuthorizationProviders",
    host_prefix = "",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults")
  )
  input <- .worklink$list_website_authorization_providers_input(FleetArn = FleetArn, NextToken = NextToken, MaxResults = MaxResults)
  output <- .worklink$list_website_authorization_providers_output()
  config <- get_config()
  svc <- .worklink$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.worklink$operations$list_website_authorization_providers <- worklink_list_website_authorization_providers

#' Retrieves a list of certificate authorities added for the current
#' account and Region
#'
#' @description
#' Retrieves a list of certificate authorities added for the current account and Region.
#'
#' See [https://www.paws-r-sdk.com/docs/worklink_list_website_certificate_authorities/](https://www.paws-r-sdk.com/docs/worklink_list_website_certificate_authorities/) for full documentation.
#'
#' @param FleetArn &#91;required&#93; The ARN of the fleet.
#' @param MaxResults The maximum number of results to be included in the next page.
#' @param NextToken The pagination token used to retrieve the next page of results for this
#' operation. If this value is null, it retrieves the first page.
#'
#' @keywords internal
#'
#' @rdname worklink_list_website_certificate_authorities
worklink_list_website_certificate_authorities <- function(FleetArn, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListWebsiteCertificateAuthorities",
    http_method = "POST",
    http_path = "/listWebsiteCertificateAuthorities",
    host_prefix = "",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults")
  )
  input <- .worklink$list_website_certificate_authorities_input(FleetArn = FleetArn, MaxResults = MaxResults, NextToken = NextToken)
  output <- .worklink$list_website_certificate_authorities_output()
  config <- get_config()
  svc <- .worklink$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.worklink$operations$list_website_certificate_authorities <- worklink_list_website_certificate_authorities

#' Moves a domain to ACTIVE status if it was in the INACTIVE status
#'
#' @description
#' Moves a domain to ACTIVE status if it was in the INACTIVE status.
#'
#' See [https://www.paws-r-sdk.com/docs/worklink_restore_domain_access/](https://www.paws-r-sdk.com/docs/worklink_restore_domain_access/) for full documentation.
#'
#' @param FleetArn &#91;required&#93; The ARN of the fleet.
#' @param DomainName &#91;required&#93; The name of the domain.
#'
#' @keywords internal
#'
#' @rdname worklink_restore_domain_access
worklink_restore_domain_access <- function(FleetArn, DomainName) {
  op <- new_operation(
    name = "RestoreDomainAccess",
    http_method = "POST",
    http_path = "/restoreDomainAccess",
    host_prefix = "",
    paginator = list()
  )
  input <- .worklink$restore_domain_access_input(FleetArn = FleetArn, DomainName = DomainName)
  output <- .worklink$restore_domain_access_output()
  config <- get_config()
  svc <- .worklink$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.worklink$operations$restore_domain_access <- worklink_restore_domain_access

#' Moves a domain to INACTIVE status if it was in the ACTIVE status
#'
#' @description
#' Moves a domain to INACTIVE status if it was in the ACTIVE status.
#'
#' See [https://www.paws-r-sdk.com/docs/worklink_revoke_domain_access/](https://www.paws-r-sdk.com/docs/worklink_revoke_domain_access/) for full documentation.
#'
#' @param FleetArn &#91;required&#93; The ARN of the fleet.
#' @param DomainName &#91;required&#93; The name of the domain.
#'
#' @keywords internal
#'
#' @rdname worklink_revoke_domain_access
worklink_revoke_domain_access <- function(FleetArn, DomainName) {
  op <- new_operation(
    name = "RevokeDomainAccess",
    http_method = "POST",
    http_path = "/revokeDomainAccess",
    host_prefix = "",
    paginator = list()
  )
  input <- .worklink$revoke_domain_access_input(FleetArn = FleetArn, DomainName = DomainName)
  output <- .worklink$revoke_domain_access_output()
  config <- get_config()
  svc <- .worklink$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.worklink$operations$revoke_domain_access <- worklink_revoke_domain_access

#' Signs the user out from all of their devices
#'
#' @description
#' Signs the user out from all of their devices. The user can sign in again if they have valid credentials.
#'
#' See [https://www.paws-r-sdk.com/docs/worklink_sign_out_user/](https://www.paws-r-sdk.com/docs/worklink_sign_out_user/) for full documentation.
#'
#' @param FleetArn &#91;required&#93; The ARN of the fleet.
#' @param Username &#91;required&#93; The name of the user.
#'
#' @keywords internal
#'
#' @rdname worklink_sign_out_user
worklink_sign_out_user <- function(FleetArn, Username) {
  op <- new_operation(
    name = "SignOutUser",
    http_method = "POST",
    http_path = "/signOutUser",
    host_prefix = "",
    paginator = list()
  )
  input <- .worklink$sign_out_user_input(FleetArn = FleetArn, Username = Username)
  output <- .worklink$sign_out_user_output()
  config <- get_config()
  svc <- .worklink$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.worklink$operations$sign_out_user <- worklink_sign_out_user

#' Adds or overwrites one or more tags for the specified resource, such as
#' a fleet
#'
#' @description
#' Adds or overwrites one or more tags for the specified resource, such as a fleet. Each tag consists of a key and an optional value. If a resource already has a tag with the same key, this operation updates its value.
#'
#' See [https://www.paws-r-sdk.com/docs/worklink_tag_resource/](https://www.paws-r-sdk.com/docs/worklink_tag_resource/) for full documentation.
#'
#' @param ResourceArn &#91;required&#93; The Amazon Resource Name (ARN) of the fleet.
#' @param Tags &#91;required&#93; The tags to add to the resource. A tag is a key-value pair.
#'
#' @keywords internal
#'
#' @rdname worklink_tag_resource
worklink_tag_resource <- function(ResourceArn, Tags) {
  op <- new_operation(
    name = "TagResource",
    http_method = "POST",
    http_path = "/tags/{ResourceArn}",
    host_prefix = "",
    paginator = list()
  )
  input <- .worklink$tag_resource_input(ResourceArn = ResourceArn, Tags = Tags)
  output <- .worklink$tag_resource_output()
  config <- get_config()
  svc <- .worklink$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.worklink$operations$tag_resource <- worklink_tag_resource

#' Removes one or more tags from the specified resource
#'
#' @description
#' Removes one or more tags from the specified resource.
#'
#' See [https://www.paws-r-sdk.com/docs/worklink_untag_resource/](https://www.paws-r-sdk.com/docs/worklink_untag_resource/) for full documentation.
#'
#' @param ResourceArn &#91;required&#93; The Amazon Resource Name (ARN) of the fleet.
#' @param TagKeys &#91;required&#93; The list of tag keys to remove from the resource.
#'
#' @keywords internal
#'
#' @rdname worklink_untag_resource
worklink_untag_resource <- function(ResourceArn, TagKeys) {
  op <- new_operation(
    name = "UntagResource",
    http_method = "DELETE",
    http_path = "/tags/{ResourceArn}",
    host_prefix = "",
    paginator = list()
  )
  input <- .worklink$untag_resource_input(ResourceArn = ResourceArn, TagKeys = TagKeys)
  output <- .worklink$untag_resource_output()
  config <- get_config()
  svc <- .worklink$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.worklink$operations$untag_resource <- worklink_untag_resource

#' Updates the audit stream configuration for the fleet
#'
#' @description
#' Updates the audit stream configuration for the fleet.
#'
#' See [https://www.paws-r-sdk.com/docs/worklink_update_audit_stream_configuration/](https://www.paws-r-sdk.com/docs/worklink_update_audit_stream_configuration/) for full documentation.
#'
#' @param FleetArn &#91;required&#93; The ARN of the fleet.
#' @param AuditStreamArn The ARN of the Amazon Kinesis data stream that receives the audit
#' events.
#'
#' @keywords internal
#'
#' @rdname worklink_update_audit_stream_configuration
worklink_update_audit_stream_configuration <- function(FleetArn, AuditStreamArn = NULL) {
  op <- new_operation(
    name = "UpdateAuditStreamConfiguration",
    http_method = "POST",
    http_path = "/updateAuditStreamConfiguration",
    host_prefix = "",
    paginator = list()
  )
  input <- .worklink$update_audit_stream_configuration_input(FleetArn = FleetArn, AuditStreamArn = AuditStreamArn)
  output <- .worklink$update_audit_stream_configuration_output()
  config <- get_config()
  svc <- .worklink$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.worklink$operations$update_audit_stream_configuration <- worklink_update_audit_stream_configuration

#' Updates the company network configuration for the fleet
#'
#' @description
#' Updates the company network configuration for the fleet.
#'
#' See [https://www.paws-r-sdk.com/docs/worklink_update_company_network_configuration/](https://www.paws-r-sdk.com/docs/worklink_update_company_network_configuration/) for full documentation.
#'
#' @param FleetArn &#91;required&#93; The ARN of the fleet.
#' @param VpcId &#91;required&#93; The VPC with connectivity to associated websites.
#' @param SubnetIds &#91;required&#93; The subnets used for X-ENI connections from Amazon WorkLink rendering
#' containers.
#' @param SecurityGroupIds &#91;required&#93; The security groups associated with access to the provided subnets.
#'
#' @keywords internal
#'
#' @rdname worklink_update_company_network_configuration
worklink_update_company_network_configuration <- function(FleetArn, VpcId, SubnetIds, SecurityGroupIds) {
  op <- new_operation(
    name = "UpdateCompanyNetworkConfiguration",
    http_method = "POST",
    http_path = "/updateCompanyNetworkConfiguration",
    host_prefix = "",
    paginator = list()
  )
  input <- .worklink$update_company_network_configuration_input(FleetArn = FleetArn, VpcId = VpcId, SubnetIds = SubnetIds, SecurityGroupIds = SecurityGroupIds)
  output <- .worklink$update_company_network_configuration_output()
  config <- get_config()
  svc <- .worklink$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.worklink$operations$update_company_network_configuration <- worklink_update_company_network_configuration

#' Updates the device policy configuration for the fleet
#'
#' @description
#' Updates the device policy configuration for the fleet.
#'
#' See [https://www.paws-r-sdk.com/docs/worklink_update_device_policy_configuration/](https://www.paws-r-sdk.com/docs/worklink_update_device_policy_configuration/) for full documentation.
#'
#' @param FleetArn &#91;required&#93; The ARN of the fleet.
#' @param DeviceCaCertificate The certificate chain, including intermediate certificates and the root
#' certificate authority certificate used to issue device certificates.
#'
#' @keywords internal
#'
#' @rdname worklink_update_device_policy_configuration
worklink_update_device_policy_configuration <- function(FleetArn, DeviceCaCertificate = NULL) {
  op <- new_operation(
    name = "UpdateDevicePolicyConfiguration",
    http_method = "POST",
    http_path = "/updateDevicePolicyConfiguration",
    host_prefix = "",
    paginator = list()
  )
  input <- .worklink$update_device_policy_configuration_input(FleetArn = FleetArn, DeviceCaCertificate = DeviceCaCertificate)
  output <- .worklink$update_device_policy_configuration_output()
  config <- get_config()
  svc <- .worklink$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.worklink$operations$update_device_policy_configuration <- worklink_update_device_policy_configuration

#' Updates domain metadata, such as DisplayName
#'
#' @description
#' Updates domain metadata, such as DisplayName.
#'
#' See [https://www.paws-r-sdk.com/docs/worklink_update_domain_metadata/](https://www.paws-r-sdk.com/docs/worklink_update_domain_metadata/) for full documentation.
#'
#' @param FleetArn &#91;required&#93; The ARN of the fleet.
#' @param DomainName &#91;required&#93; The name of the domain.
#' @param DisplayName The name to display.
#'
#' @keywords internal
#'
#' @rdname worklink_update_domain_metadata
worklink_update_domain_metadata <- function(FleetArn, DomainName, DisplayName = NULL) {
  op <- new_operation(
    name = "UpdateDomainMetadata",
    http_method = "POST",
    http_path = "/updateDomainMetadata",
    host_prefix = "",
    paginator = list()
  )
  input <- .worklink$update_domain_metadata_input(FleetArn = FleetArn, DomainName = DomainName, DisplayName = DisplayName)
  output <- .worklink$update_domain_metadata_output()
  config <- get_config()
  svc <- .worklink$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.worklink$operations$update_domain_metadata <- worklink_update_domain_metadata

#' Updates fleet metadata, such as DisplayName
#'
#' @description
#' Updates fleet metadata, such as DisplayName.
#'
#' See [https://www.paws-r-sdk.com/docs/worklink_update_fleet_metadata/](https://www.paws-r-sdk.com/docs/worklink_update_fleet_metadata/) for full documentation.
#'
#' @param FleetArn &#91;required&#93; The ARN of the fleet.
#' @param DisplayName The fleet name to display. The existing DisplayName is unset if null is
#' passed.
#' @param OptimizeForEndUserLocation The option to optimize for better performance by routing traffic through
#' the closest AWS Region to users, which may be outside of your home
#' Region.
#'
#' @keywords internal
#'
#' @rdname worklink_update_fleet_metadata
worklink_update_fleet_metadata <- function(FleetArn, DisplayName = NULL, OptimizeForEndUserLocation = NULL) {
  op <- new_operation(
    name = "UpdateFleetMetadata",
    http_method = "POST",
    http_path = "/UpdateFleetMetadata",
    host_prefix = "",
    paginator = list()
  )
  input <- .worklink$update_fleet_metadata_input(FleetArn = FleetArn, DisplayName = DisplayName, OptimizeForEndUserLocation = OptimizeForEndUserLocation)
  output <- .worklink$update_fleet_metadata_output()
  config <- get_config()
  svc <- .worklink$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.worklink$operations$update_fleet_metadata <- worklink_update_fleet_metadata

#' Updates the identity provider configuration for the fleet
#'
#' @description
#' Updates the identity provider configuration for the fleet.
#'
#' See [https://www.paws-r-sdk.com/docs/worklink_update_identity_provider_configuration/](https://www.paws-r-sdk.com/docs/worklink_update_identity_provider_configuration/) for full documentation.
#'
#' @param FleetArn &#91;required&#93; The ARN of the fleet.
#' @param IdentityProviderType &#91;required&#93; The type of identity provider.
#' @param IdentityProviderSamlMetadata The SAML metadata document provided by the customer’s identity provider.
#' The existing IdentityProviderSamlMetadata is unset if null is passed.
#'
#' @keywords internal
#'
#' @rdname worklink_update_identity_provider_configuration
worklink_update_identity_provider_configuration <- function(FleetArn, IdentityProviderType, IdentityProviderSamlMetadata = NULL) {
  op <- new_operation(
    name = "UpdateIdentityProviderConfiguration",
    http_method = "POST",
    http_path = "/updateIdentityProviderConfiguration",
    host_prefix = "",
    paginator = list()
  )
  input <- .worklink$update_identity_provider_configuration_input(FleetArn = FleetArn, IdentityProviderType = IdentityProviderType, IdentityProviderSamlMetadata = IdentityProviderSamlMetadata)
  output <- .worklink$update_identity_provider_configuration_output()
  config <- get_config()
  svc <- .worklink$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.worklink$operations$update_identity_provider_configuration <- worklink_update_identity_provider_configuration
