% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/workspaces_operations.R
\name{workspaces_modify_saml_properties}
\alias{workspaces_modify_saml_properties}
\title{Modifies multiple properties related to SAML 2}
\usage{
workspaces_modify_saml_properties(
  ResourceId,
  SamlProperties = NULL,
  PropertiesToDelete = NULL
)
}
\arguments{
\item{ResourceId}{[required] The directory identifier for which you want to configure SAML
properties.}

\item{SamlProperties}{The properties for configuring SAML 2.0 authentication.}

\item{PropertiesToDelete}{The SAML properties to delete as part of your request.

Specify one of the following options:
\itemize{
\item \code{SAML_PROPERTIES_USER_ACCESS_URL} to delete the user access URL.
\item \code{SAML_PROPERTIES_RELAY_STATE_PARAMETER_NAME} to delete the relay
state parameter name.
}}
}
\description{
Modifies multiple properties related to SAML 2.0 authentication, including the enablement status, user access URL, and relay state parameter name that are used for configuring federation with an SAML 2.0 identity provider.

See \url{https://www.paws-r-sdk.com/docs/workspaces_modify_saml_properties/} for full documentation.
}
\keyword{internal}
