% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/workmail_operations.R
\name{workmail_put_mailbox_permissions}
\alias{workmail_put_mailbox_permissions}
\title{Sets permissions for a user, group, or resource}
\usage{
workmail_put_mailbox_permissions(
  OrganizationId,
  EntityId,
  GranteeId,
  PermissionValues
)
}
\arguments{
\item{OrganizationId}{[required] The identifier of the organization under which the user, group, or
resource exists.}

\item{EntityId}{[required] The identifier of the user, group, or resource for which to update
mailbox permissions.}

\item{GranteeId}{[required] The identifier of the user, group, or resource to which to grant the
permissions.}

\item{PermissionValues}{[required] The permissions granted to the grantee. SEND_AS allows the grantee to
send email as the owner of the mailbox (the grantee is not mentioned on
these emails). SEND_ON_BEHALF allows the grantee to send email on behalf
of the owner of the mailbox (the grantee is not mentioned as the
physical sender of these emails). FULL_ACCESS allows the grantee full
access to the mailbox, irrespective of other folder-level permissions
set on the mailbox.}
}
\description{
Sets permissions for a user, group, or resource. This replaces any pre-existing permissions.

See \url{https://www.paws-r-sdk.com/docs/workmail_put_mailbox_permissions/} for full documentation.
}
\keyword{internal}
