% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xray_operations.R
\name{xray_start_trace_retrieval}
\alias{xray_start_trace_retrieval}
\title{Initiates a trace retrieval process using the specified time range and
for the give trace IDs on Transaction Search generated by the CloudWatch
log group}
\usage{
xray_start_trace_retrieval(TraceIds, StartTime, EndTime)
}
\arguments{
\item{TraceIds}{[required] Specify the trace IDs of the traces to be retrieved.}

\item{StartTime}{[required] The start of the time range to retrieve traces. The range is inclusive,
so the specified start time is included in the query. Specified as epoch
time, the number of seconds since January 1, 1970, 00:00:00 UTC.}

\item{EndTime}{[required] The end of the time range to retrieve traces. The range is inclusive, so
the specified end time is included in the query. Specified as epoch
time, the number of seconds since January 1, 1970, 00:00:00 UTC.}
}
\description{
Initiates a trace retrieval process using the specified time range and for the give trace IDs on Transaction Search generated by the CloudWatch log group. For more information, see \href{https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-Transaction-Search.html}{Transaction Search}.

See \url{https://www.paws-r-sdk.com/docs/xray_start_trace_retrieval/} for full documentation.
}
\keyword{internal}
