% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/devopsguru_operations.R
\name{devopsguru_get_resource_collection}
\alias{devopsguru_get_resource_collection}
\title{Returns lists Amazon Web Services resources that are of the specified
resource collection type}
\usage{
devopsguru_get_resource_collection(ResourceCollectionType, NextToken = NULL)
}
\arguments{
\item{ResourceCollectionType}{[required] The type of Amazon Web Services resource collections to return. The one
valid value is \code{CLOUD_FORMATION} for Amazon Web Services CloudFormation
stacks.}

\item{NextToken}{The pagination token to use to retrieve the next page of results for
this operation. If this value is null, it retrieves the first page.}
}
\description{
Returns lists Amazon Web Services resources that are of the specified resource collection type. The two types of Amazon Web Services resource collections supported are Amazon Web Services CloudFormation stacks and Amazon Web Services resources that contain the same Amazon Web Services tag. DevOps Guru can be configured to analyze the Amazon Web Services resources that are defined in the stacks or that are tagged using the same tag \emph{key}. You can specify up to 500 Amazon Web Services CloudFormation stacks.

See \url{https://www.paws-r-sdk.com/docs/devopsguru_get_resource_collection/} for full documentation.
}
\keyword{internal}
