% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/codegurusecurity_operations.R
\name{codegurusecurity_list_findings_metrics}
\alias{codegurusecurity_list_findings_metrics}
\title{Returns metrics about all findings in an account within a specified time
range}
\usage{
codegurusecurity_list_findings_metrics(
  endDate,
  maxResults = NULL,
  nextToken = NULL,
  startDate
)
}
\arguments{
\item{endDate}{[required] The end date of the interval which you want to retrieve metrics from.}

\item{maxResults}{The maximum number of results to return in the response. Use this
parameter when paginating results. If additional results exist beyond
the number you specify, the \code{nextToken} element is returned in the
response. Use \code{nextToken} in a subsequent request to retrieve additional
results.}

\item{nextToken}{A token to use for paginating results that are returned in the response.
Set the value of this parameter to null for the first request. For
subsequent calls, use the \code{nextToken} value returned from the previous
request to continue listing results after the first page.}

\item{startDate}{[required] The start date of the interval which you want to retrieve metrics from.}
}
\description{
Returns metrics about all findings in an account within a specified time range.

See \url{https://www.paws-r-sdk.com/docs/codegurusecurity_list_findings_metrics/} for full documentation.
}
\keyword{internal}
