% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/codeartifact_operations.R
\name{codeartifact_dispose_package_versions}
\alias{codeartifact_dispose_package_versions}
\title{Deletes the assets in package versions and sets the package versions'
status to Disposed}
\usage{
codeartifact_dispose_package_versions(
  domain,
  domainOwner = NULL,
  repository,
  format,
  namespace = NULL,
  package,
  versions,
  versionRevisions = NULL,
  expectedStatus = NULL
)
}
\arguments{
\item{domain}{[required] The name of the domain that contains the repository you want to dispose.}

\item{domainOwner}{The 12-digit account number of the Amazon Web Services account that owns
the domain. It does not include dashes or spaces.}

\item{repository}{[required] The name of the repository that contains the package versions you want
to dispose.}

\item{format}{[required] A format that specifies the type of package versions you want to
dispose.}

\item{namespace}{The namespace of the package versions to be disposed. The package
version component that specifies its namespace depends on its type. For
example:
\itemize{
\item The namespace of a Maven package version is its \code{groupId}.
\item The namespace of an npm package version is its \code{scope}.
\item Python and NuGet package versions do not contain a corresponding
component, package versions of those formats do not have a
namespace.
\item The namespace of a generic package is its \code{namespace}.
}}

\item{package}{[required] The name of the package with the versions you want to dispose.}

\item{versions}{[required] The versions of the package you want to dispose.}

\item{versionRevisions}{The revisions of the package versions you want to dispose.}

\item{expectedStatus}{The expected status of the package version to dispose.}
}
\description{
Deletes the assets in package versions and sets the package versions' status to \code{Disposed}. A disposed package version cannot be restored in your repository because its assets are deleted.

See \url{https://www.paws-r-sdk.com/docs/codeartifact_dispose_package_versions/} for full documentation.
}
\keyword{internal}
