# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include codedeploy_service.R
NULL

#' Adds tags to on-premises instances
#'
#' @description
#' Adds tags to on-premises instances.
#'
#' See [https://www.paws-r-sdk.com/docs/codedeploy_add_tags_to_on_premises_instances/](https://www.paws-r-sdk.com/docs/codedeploy_add_tags_to_on_premises_instances/) for full documentation.
#'
#' @param tags &#91;required&#93; The tag key-value pairs to add to the on-premises instances.
#' 
#' Keys and values are both required. Keys cannot be null or empty strings.
#' Value-only tags are not allowed.
#' @param instanceNames &#91;required&#93; The names of the on-premises instances to which to add tags.
#'
#' @keywords internal
#'
#' @rdname codedeploy_add_tags_to_on_premises_instances
codedeploy_add_tags_to_on_premises_instances <- function(tags, instanceNames) {
  op <- new_operation(
    name = "AddTagsToOnPremisesInstances",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codedeploy$add_tags_to_on_premises_instances_input(tags = tags, instanceNames = instanceNames)
  output <- .codedeploy$add_tags_to_on_premises_instances_output()
  config <- get_config()
  svc <- .codedeploy$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codedeploy$operations$add_tags_to_on_premises_instances <- codedeploy_add_tags_to_on_premises_instances

#' Gets information about one or more application revisions
#'
#' @description
#' Gets information about one or more application revisions. The maximum number of application revisions that can be returned is 25.
#'
#' See [https://www.paws-r-sdk.com/docs/codedeploy_batch_get_application_revisions/](https://www.paws-r-sdk.com/docs/codedeploy_batch_get_application_revisions/) for full documentation.
#'
#' @param applicationName &#91;required&#93; The name of an CodeDeploy application about which to get revision
#' information.
#' @param revisions &#91;required&#93; An array of `RevisionLocation` objects that specify information to get
#' about the application revisions, including type and location. The
#' maximum number of `RevisionLocation` objects you can specify is 25.
#'
#' @keywords internal
#'
#' @rdname codedeploy_batch_get_application_revisions
codedeploy_batch_get_application_revisions <- function(applicationName, revisions) {
  op <- new_operation(
    name = "BatchGetApplicationRevisions",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codedeploy$batch_get_application_revisions_input(applicationName = applicationName, revisions = revisions)
  output <- .codedeploy$batch_get_application_revisions_output()
  config <- get_config()
  svc <- .codedeploy$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codedeploy$operations$batch_get_application_revisions <- codedeploy_batch_get_application_revisions

#' Gets information about one or more applications
#'
#' @description
#' Gets information about one or more applications. The maximum number of applications that can be returned is 100.
#'
#' See [https://www.paws-r-sdk.com/docs/codedeploy_batch_get_applications/](https://www.paws-r-sdk.com/docs/codedeploy_batch_get_applications/) for full documentation.
#'
#' @param applicationNames &#91;required&#93; A list of application names separated by spaces. The maximum number of
#' application names you can specify is 100.
#'
#' @keywords internal
#'
#' @rdname codedeploy_batch_get_applications
codedeploy_batch_get_applications <- function(applicationNames) {
  op <- new_operation(
    name = "BatchGetApplications",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codedeploy$batch_get_applications_input(applicationNames = applicationNames)
  output <- .codedeploy$batch_get_applications_output()
  config <- get_config()
  svc <- .codedeploy$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codedeploy$operations$batch_get_applications <- codedeploy_batch_get_applications

#' Gets information about one or more deployment groups
#'
#' @description
#' Gets information about one or more deployment groups.
#'
#' See [https://www.paws-r-sdk.com/docs/codedeploy_batch_get_deployment_groups/](https://www.paws-r-sdk.com/docs/codedeploy_batch_get_deployment_groups/) for full documentation.
#'
#' @param applicationName &#91;required&#93; The name of an CodeDeploy application associated with the applicable
#' user or Amazon Web Services account.
#' @param deploymentGroupNames &#91;required&#93; The names of the deployment groups.
#'
#' @keywords internal
#'
#' @rdname codedeploy_batch_get_deployment_groups
codedeploy_batch_get_deployment_groups <- function(applicationName, deploymentGroupNames) {
  op <- new_operation(
    name = "BatchGetDeploymentGroups",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codedeploy$batch_get_deployment_groups_input(applicationName = applicationName, deploymentGroupNames = deploymentGroupNames)
  output <- .codedeploy$batch_get_deployment_groups_output()
  config <- get_config()
  svc <- .codedeploy$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codedeploy$operations$batch_get_deployment_groups <- codedeploy_batch_get_deployment_groups

#' This method works, but is deprecated
#'
#' @description
#' This method works, but is deprecated. Use [`batch_get_deployment_targets`][codedeploy_batch_get_deployment_targets] instead.
#'
#' See [https://www.paws-r-sdk.com/docs/codedeploy_batch_get_deployment_instances/](https://www.paws-r-sdk.com/docs/codedeploy_batch_get_deployment_instances/) for full documentation.
#'
#' @param deploymentId &#91;required&#93; The unique ID of a deployment.
#' @param instanceIds &#91;required&#93; The unique IDs of instances used in the deployment. The maximum number
#' of instance IDs you can specify is 25.
#'
#' @keywords internal
#'
#' @rdname codedeploy_batch_get_deployment_instances
codedeploy_batch_get_deployment_instances <- function(deploymentId, instanceIds) {
  op <- new_operation(
    name = "BatchGetDeploymentInstances",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codedeploy$batch_get_deployment_instances_input(deploymentId = deploymentId, instanceIds = instanceIds)
  output <- .codedeploy$batch_get_deployment_instances_output()
  config <- get_config()
  svc <- .codedeploy$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codedeploy$operations$batch_get_deployment_instances <- codedeploy_batch_get_deployment_instances

#' Returns an array of one or more targets associated with a deployment
#'
#' @description
#' Returns an array of one or more targets associated with a deployment. This method works with all compute types and should be used instead of the deprecated [`batch_get_deployment_instances`][codedeploy_batch_get_deployment_instances]. The maximum number of targets that can be returned is 25.
#'
#' See [https://www.paws-r-sdk.com/docs/codedeploy_batch_get_deployment_targets/](https://www.paws-r-sdk.com/docs/codedeploy_batch_get_deployment_targets/) for full documentation.
#'
#' @param deploymentId &#91;required&#93; The unique ID of a deployment.
#' @param targetIds &#91;required&#93; The unique IDs of the deployment targets. The compute platform of the
#' deployment determines the type of the targets and their formats. The
#' maximum number of deployment target IDs you can specify is 25.
#' 
#' -   For deployments that use the EC2/On-premises compute platform, the
#'     target IDs are Amazon EC2 or on-premises instances IDs, and their
#'     target type is `instanceTarget`.
#' 
#' -   For deployments that use the Lambda compute platform, the target IDs
#'     are the names of Lambda functions, and their target type is
#'     `instanceTarget`.
#' 
#' -   For deployments that use the Amazon ECS compute platform, the target
#'     IDs are pairs of Amazon ECS clusters and services specified using
#'     the format `<clustername>:<servicename>`. Their target type is
#'     `ecsTarget`.
#' 
#' -   For deployments that are deployed with CloudFormation, the target
#'     IDs are CloudFormation stack IDs. Their target type is
#'     `cloudFormationTarget`.
#'
#' @keywords internal
#'
#' @rdname codedeploy_batch_get_deployment_targets
codedeploy_batch_get_deployment_targets <- function(deploymentId, targetIds) {
  op <- new_operation(
    name = "BatchGetDeploymentTargets",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codedeploy$batch_get_deployment_targets_input(deploymentId = deploymentId, targetIds = targetIds)
  output <- .codedeploy$batch_get_deployment_targets_output()
  config <- get_config()
  svc <- .codedeploy$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codedeploy$operations$batch_get_deployment_targets <- codedeploy_batch_get_deployment_targets

#' Gets information about one or more deployments
#'
#' @description
#' Gets information about one or more deployments. The maximum number of deployments that can be returned is 25.
#'
#' See [https://www.paws-r-sdk.com/docs/codedeploy_batch_get_deployments/](https://www.paws-r-sdk.com/docs/codedeploy_batch_get_deployments/) for full documentation.
#'
#' @param deploymentIds &#91;required&#93; A list of deployment IDs, separated by spaces. The maximum number of
#' deployment IDs you can specify is 25.
#'
#' @keywords internal
#'
#' @rdname codedeploy_batch_get_deployments
codedeploy_batch_get_deployments <- function(deploymentIds) {
  op <- new_operation(
    name = "BatchGetDeployments",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codedeploy$batch_get_deployments_input(deploymentIds = deploymentIds)
  output <- .codedeploy$batch_get_deployments_output()
  config <- get_config()
  svc <- .codedeploy$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codedeploy$operations$batch_get_deployments <- codedeploy_batch_get_deployments

#' Gets information about one or more on-premises instances
#'
#' @description
#' Gets information about one or more on-premises instances. The maximum number of on-premises instances that can be returned is 25.
#'
#' See [https://www.paws-r-sdk.com/docs/codedeploy_batch_get_on_premises_instances/](https://www.paws-r-sdk.com/docs/codedeploy_batch_get_on_premises_instances/) for full documentation.
#'
#' @param instanceNames &#91;required&#93; The names of the on-premises instances about which to get information.
#' The maximum number of instance names you can specify is 25.
#'
#' @keywords internal
#'
#' @rdname codedeploy_batch_get_on_premises_instances
codedeploy_batch_get_on_premises_instances <- function(instanceNames) {
  op <- new_operation(
    name = "BatchGetOnPremisesInstances",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codedeploy$batch_get_on_premises_instances_input(instanceNames = instanceNames)
  output <- .codedeploy$batch_get_on_premises_instances_output()
  config <- get_config()
  svc <- .codedeploy$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codedeploy$operations$batch_get_on_premises_instances <- codedeploy_batch_get_on_premises_instances

#' For a blue/green deployment, starts the process of rerouting traffic
#' from instances in the original environment to instances in the
#' replacement environment without waiting for a specified wait time to
#' elapse
#'
#' @description
#' For a blue/green deployment, starts the process of rerouting traffic from instances in the original environment to instances in the replacement environment without waiting for a specified wait time to elapse. (Traffic rerouting, which is achieved by registering instances in the replacement environment with the load balancer, can start as soon as all instances have a status of Ready.)
#'
#' See [https://www.paws-r-sdk.com/docs/codedeploy_continue_deployment/](https://www.paws-r-sdk.com/docs/codedeploy_continue_deployment/) for full documentation.
#'
#' @param deploymentId The unique ID of a blue/green deployment for which you want to start
#' rerouting traffic to the replacement environment.
#' @param deploymentWaitType The status of the deployment's waiting period. `READY_WAIT` indicates
#' that the deployment is ready to start shifting traffic.
#' `TERMINATION_WAIT` indicates that the traffic is shifted, but the
#' original target is not terminated.
#'
#' @keywords internal
#'
#' @rdname codedeploy_continue_deployment
codedeploy_continue_deployment <- function(deploymentId = NULL, deploymentWaitType = NULL) {
  op <- new_operation(
    name = "ContinueDeployment",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codedeploy$continue_deployment_input(deploymentId = deploymentId, deploymentWaitType = deploymentWaitType)
  output <- .codedeploy$continue_deployment_output()
  config <- get_config()
  svc <- .codedeploy$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codedeploy$operations$continue_deployment <- codedeploy_continue_deployment

#' Creates an application
#'
#' @description
#' Creates an application.
#'
#' See [https://www.paws-r-sdk.com/docs/codedeploy_create_application/](https://www.paws-r-sdk.com/docs/codedeploy_create_application/) for full documentation.
#'
#' @param applicationName &#91;required&#93; The name of the application. This name must be unique with the
#' applicable user or Amazon Web Services account.
#' @param computePlatform The destination platform type for the deployment (`Lambda`, `Server`, or
#' `ECS`).
#' @param tags The metadata that you apply to CodeDeploy applications to help you
#' organize and categorize them. Each tag consists of a key and an optional
#' value, both of which you define.
#'
#' @keywords internal
#'
#' @rdname codedeploy_create_application
codedeploy_create_application <- function(applicationName, computePlatform = NULL, tags = NULL) {
  op <- new_operation(
    name = "CreateApplication",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codedeploy$create_application_input(applicationName = applicationName, computePlatform = computePlatform, tags = tags)
  output <- .codedeploy$create_application_output()
  config <- get_config()
  svc <- .codedeploy$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codedeploy$operations$create_application <- codedeploy_create_application

#' Deploys an application revision through the specified deployment group
#'
#' @description
#' Deploys an application revision through the specified deployment group.
#'
#' See [https://www.paws-r-sdk.com/docs/codedeploy_create_deployment/](https://www.paws-r-sdk.com/docs/codedeploy_create_deployment/) for full documentation.
#'
#' @param applicationName &#91;required&#93; The name of an CodeDeploy application associated with the user or Amazon
#' Web Services account.
#' @param deploymentGroupName The name of the deployment group.
#' @param revision The type and location of the revision to deploy.
#' @param deploymentConfigName The name of a deployment configuration associated with the user or
#' Amazon Web Services account.
#' 
#' If not specified, the value configured in the deployment group is used
#' as the default. If the deployment group does not have a deployment
#' configuration associated with it, `CodeDeployDefault`.`OneAtATime` is
#' used by default.
#' @param description A comment about the deployment.
#' @param ignoreApplicationStopFailures If true, then if an `ApplicationStop`, `BeforeBlockTraffic`, or
#' `AfterBlockTraffic` deployment lifecycle event to an instance fails,
#' then the deployment continues to the next deployment lifecycle event.
#' For example, if `ApplicationStop` fails, the deployment continues with
#' `DownloadBundle`. If `BeforeBlockTraffic` fails, the deployment
#' continues with `BlockTraffic`. If `AfterBlockTraffic` fails, the
#' deployment continues with `ApplicationStop`.
#' 
#' If false or not specified, then if a lifecycle event fails during a
#' deployment to an instance, that deployment fails. If deployment to that
#' instance is part of an overall deployment and the number of healthy
#' hosts is not less than the minimum number of healthy hosts, then a
#' deployment to the next instance is attempted.
#' 
#' During a deployment, the CodeDeploy agent runs the scripts specified for
#' `ApplicationStop`, `BeforeBlockTraffic`, and `AfterBlockTraffic` in the
#' AppSpec file from the previous successful deployment. (All other scripts
#' are run from the AppSpec file in the current deployment.) If one of
#' these scripts contains an error and does not run successfully, the
#' deployment can fail.
#' 
#' If the cause of the failure is a script from the last successful
#' deployment that will never run successfully, create a new deployment and
#' use `ignoreApplicationStopFailures` to specify that the
#' `ApplicationStop`, `BeforeBlockTraffic`, and `AfterBlockTraffic`
#' failures should be ignored.
#' @param targetInstances Information about the instances that belong to the replacement
#' environment in a blue/green deployment.
#' @param autoRollbackConfiguration Configuration information for an automatic rollback that is added when a
#' deployment is created.
#' @param updateOutdatedInstancesOnly Indicates whether to deploy to all instances or only to instances that
#' are not running the latest application revision.
#' @param fileExistsBehavior Information about how CodeDeploy handles files that already exist in a
#' deployment target location but weren't part of the previous successful
#' deployment.
#' 
#' The `fileExistsBehavior` parameter takes any of the following values:
#' 
#' -   DISALLOW: The deployment fails. This is also the default behavior if
#'     no option is specified.
#' 
#' -   OVERWRITE: The version of the file from the application revision
#'     currently being deployed replaces the version already on the
#'     instance.
#' 
#' -   RETAIN: The version of the file already on the instance is kept and
#'     used as part of the new deployment.
#' @param overrideAlarmConfiguration Allows you to specify information about alarms associated with a
#' deployment. The alarm configuration that you specify here will override
#' the alarm configuration at the deployment group level. Consider
#' overriding the alarm configuration if you have set up alarms at the
#' deployment group level that are causing deployment failures. In this
#' case, you would call [`create_deployment`][codedeploy_create_deployment]
#' to create a new deployment that uses a previous application revision
#' that is known to work, and set its alarm configuration to turn off alarm
#' polling. Turning off alarm polling ensures that the new deployment
#' proceeds without being blocked by the alarm that was generated by the
#' previous, failed, deployment.
#' 
#' If you specify an `overrideAlarmConfiguration`, you need the
#' [`update_deployment_group`][codedeploy_update_deployment_group] IAM
#' permission when calling
#' [`create_deployment`][codedeploy_create_deployment].
#'
#' @keywords internal
#'
#' @rdname codedeploy_create_deployment
codedeploy_create_deployment <- function(applicationName, deploymentGroupName = NULL, revision = NULL, deploymentConfigName = NULL, description = NULL, ignoreApplicationStopFailures = NULL, targetInstances = NULL, autoRollbackConfiguration = NULL, updateOutdatedInstancesOnly = NULL, fileExistsBehavior = NULL, overrideAlarmConfiguration = NULL) {
  op <- new_operation(
    name = "CreateDeployment",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codedeploy$create_deployment_input(applicationName = applicationName, deploymentGroupName = deploymentGroupName, revision = revision, deploymentConfigName = deploymentConfigName, description = description, ignoreApplicationStopFailures = ignoreApplicationStopFailures, targetInstances = targetInstances, autoRollbackConfiguration = autoRollbackConfiguration, updateOutdatedInstancesOnly = updateOutdatedInstancesOnly, fileExistsBehavior = fileExistsBehavior, overrideAlarmConfiguration = overrideAlarmConfiguration)
  output <- .codedeploy$create_deployment_output()
  config <- get_config()
  svc <- .codedeploy$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codedeploy$operations$create_deployment <- codedeploy_create_deployment

#' Creates a deployment configuration
#'
#' @description
#' Creates a deployment configuration.
#'
#' See [https://www.paws-r-sdk.com/docs/codedeploy_create_deployment_config/](https://www.paws-r-sdk.com/docs/codedeploy_create_deployment_config/) for full documentation.
#'
#' @param deploymentConfigName &#91;required&#93; The name of the deployment configuration to create.
#' @param minimumHealthyHosts The minimum number of healthy instances that should be available at any
#' time during the deployment. There are two parameters expected in the
#' input: type and value.
#' 
#' The type parameter takes either of the following values:
#' 
#' -   HOST_COUNT: The value parameter represents the minimum number of
#'     healthy instances as an absolute value.
#' 
#' -   FLEET_PERCENT: The value parameter represents the minimum number of
#'     healthy instances as a percentage of the total number of instances
#'     in the deployment. If you specify FLEET_PERCENT, at the start of the
#'     deployment, CodeDeploy converts the percentage to the equivalent
#'     number of instances and rounds up fractional instances.
#' 
#' The value parameter takes an integer.
#' 
#' For example, to set a minimum of 95% healthy instance, specify a type of
#' FLEET_PERCENT and a value of 95.
#' @param trafficRoutingConfig The configuration that specifies how the deployment traffic is routed.
#' @param computePlatform The destination platform type for the deployment (`Lambda`, `Server`, or
#' `ECS`).
#' @param zonalConfig Configure the `ZonalConfig` object if you want CodeDeploy to deploy your
#' application to one [Availability
#' Zone](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-regions-availability-zones.html#concepts-availability-zones)
#' at a time, within an Amazon Web Services Region.
#' 
#' For more information about the zonal configuration feature, see [zonal
#' configuration](https://docs.aws.amazon.com/codedeploy/latest/userguide/deployment-configurations-create.html#zonal-config)
#' in the *CodeDeploy User Guide*.
#'
#' @keywords internal
#'
#' @rdname codedeploy_create_deployment_config
codedeploy_create_deployment_config <- function(deploymentConfigName, minimumHealthyHosts = NULL, trafficRoutingConfig = NULL, computePlatform = NULL, zonalConfig = NULL) {
  op <- new_operation(
    name = "CreateDeploymentConfig",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codedeploy$create_deployment_config_input(deploymentConfigName = deploymentConfigName, minimumHealthyHosts = minimumHealthyHosts, trafficRoutingConfig = trafficRoutingConfig, computePlatform = computePlatform, zonalConfig = zonalConfig)
  output <- .codedeploy$create_deployment_config_output()
  config <- get_config()
  svc <- .codedeploy$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codedeploy$operations$create_deployment_config <- codedeploy_create_deployment_config

#' Creates a deployment group to which application revisions are deployed
#'
#' @description
#' Creates a deployment group to which application revisions are deployed.
#'
#' See [https://www.paws-r-sdk.com/docs/codedeploy_create_deployment_group/](https://www.paws-r-sdk.com/docs/codedeploy_create_deployment_group/) for full documentation.
#'
#' @param applicationName &#91;required&#93; The name of an CodeDeploy application associated with the user or Amazon
#' Web Services account.
#' @param deploymentGroupName &#91;required&#93; The name of a new deployment group for the specified application.
#' @param deploymentConfigName If specified, the deployment configuration name can be either one of the
#' predefined configurations provided with CodeDeploy or a custom
#' deployment configuration that you create by calling the create
#' deployment configuration operation.
#' 
#' `CodeDeployDefault.OneAtATime` is the default deployment configuration.
#' It is used if a configuration isn't specified for the deployment or
#' deployment group.
#' 
#' For more information about the predefined deployment configurations in
#' CodeDeploy, see [Working with Deployment Configurations in
#' CodeDeploy](https://docs.aws.amazon.com/codedeploy/latest/userguide/deployment-configurations.html)
#' in the *CodeDeploy User Guide*.
#' @param ec2TagFilters The Amazon EC2 tags on which to filter. The deployment group includes
#' Amazon EC2 instances with any of the specified tags. Cannot be used in
#' the same call as ec2TagSet.
#' @param onPremisesInstanceTagFilters The on-premises instance tags on which to filter. The deployment group
#' includes on-premises instances with any of the specified tags. Cannot be
#' used in the same call as `OnPremisesTagSet`.
#' @param autoScalingGroups A list of associated Amazon EC2 Auto Scaling groups.
#' @param serviceRoleArn &#91;required&#93; A service role Amazon Resource Name (ARN) that allows CodeDeploy to act
#' on the user's behalf when interacting with Amazon Web Services services.
#' @param triggerConfigurations Information about triggers to create when the deployment group is
#' created. For examples, see [Create a Trigger for an CodeDeploy
#' Event](https://docs.aws.amazon.com/codedeploy/latest/userguide/monitoring-sns-event-notifications-create-trigger.html)
#' in the *CodeDeploy User Guide*.
#' @param alarmConfiguration Information to add about Amazon CloudWatch alarms when the deployment
#' group is created.
#' @param autoRollbackConfiguration Configuration information for an automatic rollback that is added when a
#' deployment group is created.
#' @param outdatedInstancesStrategy Indicates what happens when new Amazon EC2 instances are launched
#' mid-deployment and do not receive the deployed application revision.
#' 
#' If this option is set to `UPDATE` or is unspecified, CodeDeploy
#' initiates one or more 'auto-update outdated instances' deployments to
#' apply the deployed application revision to the new Amazon EC2 instances.
#' 
#' If this option is set to `IGNORE`, CodeDeploy does not initiate a
#' deployment to update the new Amazon EC2 instances. This may result in
#' instances having different revisions.
#' @param deploymentStyle Information about the type of deployment, in-place or blue/green, that
#' you want to run and whether to route deployment traffic behind a load
#' balancer.
#' @param blueGreenDeploymentConfiguration Information about blue/green deployment options for a deployment group.
#' @param loadBalancerInfo Information about the load balancer used in a deployment.
#' @param ec2TagSet Information about groups of tags applied to Amazon EC2 instances. The
#' deployment group includes only Amazon EC2 instances identified by all
#' the tag groups. Cannot be used in the same call as `ec2TagFilters`.
#' @param ecsServices The target Amazon ECS services in the deployment group. This applies
#' only to deployment groups that use the Amazon ECS compute platform. A
#' target Amazon ECS service is specified as an Amazon ECS cluster and
#' service name pair using the format `<clustername>:<servicename>`.
#' @param onPremisesTagSet Information about groups of tags applied to on-premises instances. The
#' deployment group includes only on-premises instances identified by all
#' of the tag groups. Cannot be used in the same call as
#' `onPremisesInstanceTagFilters`.
#' @param tags The metadata that you apply to CodeDeploy deployment groups to help you
#' organize and categorize them. Each tag consists of a key and an optional
#' value, both of which you define.
#' @param terminationHookEnabled This parameter only applies if you are using CodeDeploy with Amazon EC2
#' Auto Scaling. For more information, see [Integrating CodeDeploy with
#' Amazon EC2 Auto
#' Scaling](https://docs.aws.amazon.com/codedeploy/latest/userguide/integrations-aws-auto-scaling.html)
#' in the *CodeDeploy User Guide*.
#' 
#' Set `terminationHookEnabled` to `true` to have CodeDeploy install a
#' termination hook into your Auto Scaling group when you create a
#' deployment group. When this hook is installed, CodeDeploy will perform
#' termination deployments.
#' 
#' For information about termination deployments, see [Enabling termination
#' deployments during Auto Scaling scale-in
#' events](https://docs.aws.amazon.com/codedeploy/latest/userguide/integrations-aws-auto-scaling.html#integrations-aws-auto-scaling-behaviors-hook-enable)
#' in the *CodeDeploy User Guide*.
#' 
#' For more information about Auto Scaling scale-in events, see the [Scale
#' in](https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-lifecycle.html#as-lifecycle-scale-in)
#' topic in the *Amazon EC2 Auto Scaling User Guide*.
#'
#' @keywords internal
#'
#' @rdname codedeploy_create_deployment_group
codedeploy_create_deployment_group <- function(applicationName, deploymentGroupName, deploymentConfigName = NULL, ec2TagFilters = NULL, onPremisesInstanceTagFilters = NULL, autoScalingGroups = NULL, serviceRoleArn, triggerConfigurations = NULL, alarmConfiguration = NULL, autoRollbackConfiguration = NULL, outdatedInstancesStrategy = NULL, deploymentStyle = NULL, blueGreenDeploymentConfiguration = NULL, loadBalancerInfo = NULL, ec2TagSet = NULL, ecsServices = NULL, onPremisesTagSet = NULL, tags = NULL, terminationHookEnabled = NULL) {
  op <- new_operation(
    name = "CreateDeploymentGroup",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codedeploy$create_deployment_group_input(applicationName = applicationName, deploymentGroupName = deploymentGroupName, deploymentConfigName = deploymentConfigName, ec2TagFilters = ec2TagFilters, onPremisesInstanceTagFilters = onPremisesInstanceTagFilters, autoScalingGroups = autoScalingGroups, serviceRoleArn = serviceRoleArn, triggerConfigurations = triggerConfigurations, alarmConfiguration = alarmConfiguration, autoRollbackConfiguration = autoRollbackConfiguration, outdatedInstancesStrategy = outdatedInstancesStrategy, deploymentStyle = deploymentStyle, blueGreenDeploymentConfiguration = blueGreenDeploymentConfiguration, loadBalancerInfo = loadBalancerInfo, ec2TagSet = ec2TagSet, ecsServices = ecsServices, onPremisesTagSet = onPremisesTagSet, tags = tags, terminationHookEnabled = terminationHookEnabled)
  output <- .codedeploy$create_deployment_group_output()
  config <- get_config()
  svc <- .codedeploy$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codedeploy$operations$create_deployment_group <- codedeploy_create_deployment_group

#' Deletes an application
#'
#' @description
#' Deletes an application.
#'
#' See [https://www.paws-r-sdk.com/docs/codedeploy_delete_application/](https://www.paws-r-sdk.com/docs/codedeploy_delete_application/) for full documentation.
#'
#' @param applicationName &#91;required&#93; The name of an CodeDeploy application associated with the user or Amazon
#' Web Services account.
#'
#' @keywords internal
#'
#' @rdname codedeploy_delete_application
codedeploy_delete_application <- function(applicationName) {
  op <- new_operation(
    name = "DeleteApplication",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codedeploy$delete_application_input(applicationName = applicationName)
  output <- .codedeploy$delete_application_output()
  config <- get_config()
  svc <- .codedeploy$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codedeploy$operations$delete_application <- codedeploy_delete_application

#' Deletes a deployment configuration
#'
#' @description
#' Deletes a deployment configuration.
#'
#' See [https://www.paws-r-sdk.com/docs/codedeploy_delete_deployment_config/](https://www.paws-r-sdk.com/docs/codedeploy_delete_deployment_config/) for full documentation.
#'
#' @param deploymentConfigName &#91;required&#93; The name of a deployment configuration associated with the user or
#' Amazon Web Services account.
#'
#' @keywords internal
#'
#' @rdname codedeploy_delete_deployment_config
codedeploy_delete_deployment_config <- function(deploymentConfigName) {
  op <- new_operation(
    name = "DeleteDeploymentConfig",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codedeploy$delete_deployment_config_input(deploymentConfigName = deploymentConfigName)
  output <- .codedeploy$delete_deployment_config_output()
  config <- get_config()
  svc <- .codedeploy$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codedeploy$operations$delete_deployment_config <- codedeploy_delete_deployment_config

#' Deletes a deployment group
#'
#' @description
#' Deletes a deployment group.
#'
#' See [https://www.paws-r-sdk.com/docs/codedeploy_delete_deployment_group/](https://www.paws-r-sdk.com/docs/codedeploy_delete_deployment_group/) for full documentation.
#'
#' @param applicationName &#91;required&#93; The name of an CodeDeploy application associated with the user or Amazon
#' Web Services account.
#' @param deploymentGroupName &#91;required&#93; The name of a deployment group for the specified application.
#'
#' @keywords internal
#'
#' @rdname codedeploy_delete_deployment_group
codedeploy_delete_deployment_group <- function(applicationName, deploymentGroupName) {
  op <- new_operation(
    name = "DeleteDeploymentGroup",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codedeploy$delete_deployment_group_input(applicationName = applicationName, deploymentGroupName = deploymentGroupName)
  output <- .codedeploy$delete_deployment_group_output()
  config <- get_config()
  svc <- .codedeploy$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codedeploy$operations$delete_deployment_group <- codedeploy_delete_deployment_group

#' Deletes a GitHub account connection
#'
#' @description
#' Deletes a GitHub account connection.
#'
#' See [https://www.paws-r-sdk.com/docs/codedeploy_delete_git_hub_account_token/](https://www.paws-r-sdk.com/docs/codedeploy_delete_git_hub_account_token/) for full documentation.
#'
#' @param tokenName The name of the GitHub account connection to delete.
#'
#' @keywords internal
#'
#' @rdname codedeploy_delete_git_hub_account_token
codedeploy_delete_git_hub_account_token <- function(tokenName = NULL) {
  op <- new_operation(
    name = "DeleteGitHubAccountToken",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codedeploy$delete_git_hub_account_token_input(tokenName = tokenName)
  output <- .codedeploy$delete_git_hub_account_token_output()
  config <- get_config()
  svc <- .codedeploy$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codedeploy$operations$delete_git_hub_account_token <- codedeploy_delete_git_hub_account_token

#' Deletes resources linked to an external ID
#'
#' @description
#' Deletes resources linked to an external ID. This action only applies if you have configured blue/green deployments through CloudFormation.
#'
#' See [https://www.paws-r-sdk.com/docs/codedeploy_delete_resources_by_external_id/](https://www.paws-r-sdk.com/docs/codedeploy_delete_resources_by_external_id/) for full documentation.
#'
#' @param externalId The unique ID of an external resource (for example, a CloudFormation
#' stack ID) that is linked to one or more CodeDeploy resources.
#'
#' @keywords internal
#'
#' @rdname codedeploy_delete_resources_by_external_id
codedeploy_delete_resources_by_external_id <- function(externalId = NULL) {
  op <- new_operation(
    name = "DeleteResourcesByExternalId",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codedeploy$delete_resources_by_external_id_input(externalId = externalId)
  output <- .codedeploy$delete_resources_by_external_id_output()
  config <- get_config()
  svc <- .codedeploy$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codedeploy$operations$delete_resources_by_external_id <- codedeploy_delete_resources_by_external_id

#' Deregisters an on-premises instance
#'
#' @description
#' Deregisters an on-premises instance.
#'
#' See [https://www.paws-r-sdk.com/docs/codedeploy_deregister_on_premises_instance/](https://www.paws-r-sdk.com/docs/codedeploy_deregister_on_premises_instance/) for full documentation.
#'
#' @param instanceName &#91;required&#93; The name of the on-premises instance to deregister.
#'
#' @keywords internal
#'
#' @rdname codedeploy_deregister_on_premises_instance
codedeploy_deregister_on_premises_instance <- function(instanceName) {
  op <- new_operation(
    name = "DeregisterOnPremisesInstance",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codedeploy$deregister_on_premises_instance_input(instanceName = instanceName)
  output <- .codedeploy$deregister_on_premises_instance_output()
  config <- get_config()
  svc <- .codedeploy$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codedeploy$operations$deregister_on_premises_instance <- codedeploy_deregister_on_premises_instance

#' Gets information about an application
#'
#' @description
#' Gets information about an application.
#'
#' See [https://www.paws-r-sdk.com/docs/codedeploy_get_application/](https://www.paws-r-sdk.com/docs/codedeploy_get_application/) for full documentation.
#'
#' @param applicationName &#91;required&#93; The name of an CodeDeploy application associated with the user or Amazon
#' Web Services account.
#'
#' @keywords internal
#'
#' @rdname codedeploy_get_application
codedeploy_get_application <- function(applicationName) {
  op <- new_operation(
    name = "GetApplication",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codedeploy$get_application_input(applicationName = applicationName)
  output <- .codedeploy$get_application_output()
  config <- get_config()
  svc <- .codedeploy$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codedeploy$operations$get_application <- codedeploy_get_application

#' Gets information about an application revision
#'
#' @description
#' Gets information about an application revision.
#'
#' See [https://www.paws-r-sdk.com/docs/codedeploy_get_application_revision/](https://www.paws-r-sdk.com/docs/codedeploy_get_application_revision/) for full documentation.
#'
#' @param applicationName &#91;required&#93; The name of the application that corresponds to the revision.
#' @param revision &#91;required&#93; Information about the application revision to get, including type and
#' location.
#'
#' @keywords internal
#'
#' @rdname codedeploy_get_application_revision
codedeploy_get_application_revision <- function(applicationName, revision) {
  op <- new_operation(
    name = "GetApplicationRevision",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codedeploy$get_application_revision_input(applicationName = applicationName, revision = revision)
  output <- .codedeploy$get_application_revision_output()
  config <- get_config()
  svc <- .codedeploy$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codedeploy$operations$get_application_revision <- codedeploy_get_application_revision

#' Gets information about a deployment
#'
#' @description
#' Gets information about a deployment.
#'
#' See [https://www.paws-r-sdk.com/docs/codedeploy_get_deployment/](https://www.paws-r-sdk.com/docs/codedeploy_get_deployment/) for full documentation.
#'
#' @param deploymentId &#91;required&#93; The unique ID of a deployment associated with the user or Amazon Web
#' Services account.
#'
#' @keywords internal
#'
#' @rdname codedeploy_get_deployment
codedeploy_get_deployment <- function(deploymentId) {
  op <- new_operation(
    name = "GetDeployment",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codedeploy$get_deployment_input(deploymentId = deploymentId)
  output <- .codedeploy$get_deployment_output()
  config <- get_config()
  svc <- .codedeploy$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codedeploy$operations$get_deployment <- codedeploy_get_deployment

#' Gets information about a deployment configuration
#'
#' @description
#' Gets information about a deployment configuration.
#'
#' See [https://www.paws-r-sdk.com/docs/codedeploy_get_deployment_config/](https://www.paws-r-sdk.com/docs/codedeploy_get_deployment_config/) for full documentation.
#'
#' @param deploymentConfigName &#91;required&#93; The name of a deployment configuration associated with the user or
#' Amazon Web Services account.
#'
#' @keywords internal
#'
#' @rdname codedeploy_get_deployment_config
codedeploy_get_deployment_config <- function(deploymentConfigName) {
  op <- new_operation(
    name = "GetDeploymentConfig",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codedeploy$get_deployment_config_input(deploymentConfigName = deploymentConfigName)
  output <- .codedeploy$get_deployment_config_output()
  config <- get_config()
  svc <- .codedeploy$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codedeploy$operations$get_deployment_config <- codedeploy_get_deployment_config

#' Gets information about a deployment group
#'
#' @description
#' Gets information about a deployment group.
#'
#' See [https://www.paws-r-sdk.com/docs/codedeploy_get_deployment_group/](https://www.paws-r-sdk.com/docs/codedeploy_get_deployment_group/) for full documentation.
#'
#' @param applicationName &#91;required&#93; The name of an CodeDeploy application associated with the user or Amazon
#' Web Services account.
#' @param deploymentGroupName &#91;required&#93; The name of a deployment group for the specified application.
#'
#' @keywords internal
#'
#' @rdname codedeploy_get_deployment_group
codedeploy_get_deployment_group <- function(applicationName, deploymentGroupName) {
  op <- new_operation(
    name = "GetDeploymentGroup",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codedeploy$get_deployment_group_input(applicationName = applicationName, deploymentGroupName = deploymentGroupName)
  output <- .codedeploy$get_deployment_group_output()
  config <- get_config()
  svc <- .codedeploy$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codedeploy$operations$get_deployment_group <- codedeploy_get_deployment_group

#' Gets information about an instance as part of a deployment
#'
#' @description
#' Gets information about an instance as part of a deployment.
#'
#' See [https://www.paws-r-sdk.com/docs/codedeploy_get_deployment_instance/](https://www.paws-r-sdk.com/docs/codedeploy_get_deployment_instance/) for full documentation.
#'
#' @param deploymentId &#91;required&#93; The unique ID of a deployment.
#' @param instanceId &#91;required&#93; The unique ID of an instance in the deployment group.
#'
#' @keywords internal
#'
#' @rdname codedeploy_get_deployment_instance
codedeploy_get_deployment_instance <- function(deploymentId, instanceId) {
  op <- new_operation(
    name = "GetDeploymentInstance",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codedeploy$get_deployment_instance_input(deploymentId = deploymentId, instanceId = instanceId)
  output <- .codedeploy$get_deployment_instance_output()
  config <- get_config()
  svc <- .codedeploy$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codedeploy$operations$get_deployment_instance <- codedeploy_get_deployment_instance

#' Returns information about a deployment target
#'
#' @description
#' Returns information about a deployment target.
#'
#' See [https://www.paws-r-sdk.com/docs/codedeploy_get_deployment_target/](https://www.paws-r-sdk.com/docs/codedeploy_get_deployment_target/) for full documentation.
#'
#' @param deploymentId &#91;required&#93; The unique ID of a deployment.
#' @param targetId &#91;required&#93; The unique ID of a deployment target.
#'
#' @keywords internal
#'
#' @rdname codedeploy_get_deployment_target
codedeploy_get_deployment_target <- function(deploymentId, targetId) {
  op <- new_operation(
    name = "GetDeploymentTarget",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codedeploy$get_deployment_target_input(deploymentId = deploymentId, targetId = targetId)
  output <- .codedeploy$get_deployment_target_output()
  config <- get_config()
  svc <- .codedeploy$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codedeploy$operations$get_deployment_target <- codedeploy_get_deployment_target

#' Gets information about an on-premises instance
#'
#' @description
#' Gets information about an on-premises instance.
#'
#' See [https://www.paws-r-sdk.com/docs/codedeploy_get_on_premises_instance/](https://www.paws-r-sdk.com/docs/codedeploy_get_on_premises_instance/) for full documentation.
#'
#' @param instanceName &#91;required&#93; The name of the on-premises instance about which to get information.
#'
#' @keywords internal
#'
#' @rdname codedeploy_get_on_premises_instance
codedeploy_get_on_premises_instance <- function(instanceName) {
  op <- new_operation(
    name = "GetOnPremisesInstance",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codedeploy$get_on_premises_instance_input(instanceName = instanceName)
  output <- .codedeploy$get_on_premises_instance_output()
  config <- get_config()
  svc <- .codedeploy$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codedeploy$operations$get_on_premises_instance <- codedeploy_get_on_premises_instance

#' Lists information about revisions for an application
#'
#' @description
#' Lists information about revisions for an application.
#'
#' See [https://www.paws-r-sdk.com/docs/codedeploy_list_application_revisions/](https://www.paws-r-sdk.com/docs/codedeploy_list_application_revisions/) for full documentation.
#'
#' @param applicationName &#91;required&#93; The name of an CodeDeploy application associated with the user or Amazon
#' Web Services account.
#' @param sortBy The column name to use to sort the list results:
#' 
#' -   `registerTime`: Sort by the time the revisions were registered with
#'     CodeDeploy.
#' 
#' -   `firstUsedTime`: Sort by the time the revisions were first used in a
#'     deployment.
#' 
#' -   `lastUsedTime`: Sort by the time the revisions were last used in a
#'     deployment.
#' 
#' If not specified or set to null, the results are returned in an
#' arbitrary order.
#' @param sortOrder The order in which to sort the list results:
#' 
#' -   `ascending`: ascending order.
#' 
#' -   `descending`: descending order.
#' 
#' If not specified, the results are sorted in ascending order.
#' 
#' If set to null, the results are sorted in an arbitrary order.
#' @param s3Bucket An Amazon S3 bucket name to limit the search for revisions.
#' 
#' If set to null, all of the user's buckets are searched.
#' @param s3KeyPrefix A key prefix for the set of Amazon S3 objects to limit the search for
#' revisions.
#' @param deployed Whether to list revisions based on whether the revision is the target
#' revision of a deployment group:
#' 
#' -   `include`: List revisions that are target revisions of a deployment
#'     group.
#' 
#' -   `exclude`: Do not list revisions that are target revisions of a
#'     deployment group.
#' 
#' -   `ignore`: List all revisions.
#' @param nextToken An identifier returned from the previous
#' [`list_application_revisions`][codedeploy_list_application_revisions]
#' call. It can be used to return the next set of applications in the list.
#'
#' @keywords internal
#'
#' @rdname codedeploy_list_application_revisions
codedeploy_list_application_revisions <- function(applicationName, sortBy = NULL, sortOrder = NULL, s3Bucket = NULL, s3KeyPrefix = NULL, deployed = NULL, nextToken = NULL) {
  op <- new_operation(
    name = "ListApplicationRevisions",
    http_method = "POST",
    http_path = "/",
    paginator = list(input_token = "nextToken", output_token = "nextToken", result_key = "revisions")
  )
  input <- .codedeploy$list_application_revisions_input(applicationName = applicationName, sortBy = sortBy, sortOrder = sortOrder, s3Bucket = s3Bucket, s3KeyPrefix = s3KeyPrefix, deployed = deployed, nextToken = nextToken)
  output <- .codedeploy$list_application_revisions_output()
  config <- get_config()
  svc <- .codedeploy$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codedeploy$operations$list_application_revisions <- codedeploy_list_application_revisions

#' Lists the applications registered with the user or Amazon Web Services
#' account
#'
#' @description
#' Lists the applications registered with the user or Amazon Web Services account.
#'
#' See [https://www.paws-r-sdk.com/docs/codedeploy_list_applications/](https://www.paws-r-sdk.com/docs/codedeploy_list_applications/) for full documentation.
#'
#' @param nextToken An identifier returned from the previous list applications call. It can
#' be used to return the next set of applications in the list.
#'
#' @keywords internal
#'
#' @rdname codedeploy_list_applications
codedeploy_list_applications <- function(nextToken = NULL) {
  op <- new_operation(
    name = "ListApplications",
    http_method = "POST",
    http_path = "/",
    paginator = list(input_token = "nextToken", output_token = "nextToken", result_key = "applications")
  )
  input <- .codedeploy$list_applications_input(nextToken = nextToken)
  output <- .codedeploy$list_applications_output()
  config <- get_config()
  svc <- .codedeploy$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codedeploy$operations$list_applications <- codedeploy_list_applications

#' Lists the deployment configurations with the user or Amazon Web Services
#' account
#'
#' @description
#' Lists the deployment configurations with the user or Amazon Web Services account.
#'
#' See [https://www.paws-r-sdk.com/docs/codedeploy_list_deployment_configs/](https://www.paws-r-sdk.com/docs/codedeploy_list_deployment_configs/) for full documentation.
#'
#' @param nextToken An identifier returned from the previous
#' [`list_deployment_configs`][codedeploy_list_deployment_configs] call. It
#' can be used to return the next set of deployment configurations in the
#' list.
#'
#' @keywords internal
#'
#' @rdname codedeploy_list_deployment_configs
codedeploy_list_deployment_configs <- function(nextToken = NULL) {
  op <- new_operation(
    name = "ListDeploymentConfigs",
    http_method = "POST",
    http_path = "/",
    paginator = list(input_token = "nextToken", output_token = "nextToken", result_key = "deploymentConfigsList")
  )
  input <- .codedeploy$list_deployment_configs_input(nextToken = nextToken)
  output <- .codedeploy$list_deployment_configs_output()
  config <- get_config()
  svc <- .codedeploy$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codedeploy$operations$list_deployment_configs <- codedeploy_list_deployment_configs

#' Lists the deployment groups for an application registered with the
#' Amazon Web Services user or Amazon Web Services account
#'
#' @description
#' Lists the deployment groups for an application registered with the Amazon Web Services user or Amazon Web Services account.
#'
#' See [https://www.paws-r-sdk.com/docs/codedeploy_list_deployment_groups/](https://www.paws-r-sdk.com/docs/codedeploy_list_deployment_groups/) for full documentation.
#'
#' @param applicationName &#91;required&#93; The name of an CodeDeploy application associated with the user or Amazon
#' Web Services account.
#' @param nextToken An identifier returned from the previous list deployment groups call. It
#' can be used to return the next set of deployment groups in the list.
#'
#' @keywords internal
#'
#' @rdname codedeploy_list_deployment_groups
codedeploy_list_deployment_groups <- function(applicationName, nextToken = NULL) {
  op <- new_operation(
    name = "ListDeploymentGroups",
    http_method = "POST",
    http_path = "/",
    paginator = list(input_token = "nextToken", output_token = "nextToken", result_key = "deploymentGroups")
  )
  input <- .codedeploy$list_deployment_groups_input(applicationName = applicationName, nextToken = nextToken)
  output <- .codedeploy$list_deployment_groups_output()
  config <- get_config()
  svc <- .codedeploy$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codedeploy$operations$list_deployment_groups <- codedeploy_list_deployment_groups

#' The newer BatchGetDeploymentTargets should be used instead because it
#' works with all compute types
#'
#' @description
#' The newer [`batch_get_deployment_targets`][codedeploy_batch_get_deployment_targets] should be used instead because it works with all compute types. [`list_deployment_instances`][codedeploy_list_deployment_instances] throws an exception if it is used with a compute platform other than EC2/On-premises or Lambda.
#'
#' See [https://www.paws-r-sdk.com/docs/codedeploy_list_deployment_instances/](https://www.paws-r-sdk.com/docs/codedeploy_list_deployment_instances/) for full documentation.
#'
#' @param deploymentId &#91;required&#93; The unique ID of a deployment.
#' @param nextToken An identifier returned from the previous list deployment instances call.
#' It can be used to return the next set of deployment instances in the
#' list.
#' @param instanceStatusFilter A subset of instances to list by status:
#' 
#' -   `Pending`: Include those instances with pending deployments.
#' 
#' -   `InProgress`: Include those instances where deployments are still in
#'     progress.
#' 
#' -   `Succeeded`: Include those instances with successful deployments.
#' 
#' -   `Failed`: Include those instances with failed deployments.
#' 
#' -   `Skipped`: Include those instances with skipped deployments.
#' 
#' -   `Unknown`: Include those instances with deployments in an unknown
#'     state.
#' @param instanceTypeFilter The set of instances in a blue/green deployment, either those in the
#' original environment ("BLUE") or those in the replacement environment
#' ("GREEN"), for which you want to view instance information.
#'
#' @keywords internal
#'
#' @rdname codedeploy_list_deployment_instances
codedeploy_list_deployment_instances <- function(deploymentId, nextToken = NULL, instanceStatusFilter = NULL, instanceTypeFilter = NULL) {
  op <- new_operation(
    name = "ListDeploymentInstances",
    http_method = "POST",
    http_path = "/",
    paginator = list(input_token = "nextToken", output_token = "nextToken", result_key = "instancesList")
  )
  input <- .codedeploy$list_deployment_instances_input(deploymentId = deploymentId, nextToken = nextToken, instanceStatusFilter = instanceStatusFilter, instanceTypeFilter = instanceTypeFilter)
  output <- .codedeploy$list_deployment_instances_output()
  config <- get_config()
  svc <- .codedeploy$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codedeploy$operations$list_deployment_instances <- codedeploy_list_deployment_instances

#' Returns an array of target IDs that are associated a deployment
#'
#' @description
#' Returns an array of target IDs that are associated a deployment.
#'
#' See [https://www.paws-r-sdk.com/docs/codedeploy_list_deployment_targets/](https://www.paws-r-sdk.com/docs/codedeploy_list_deployment_targets/) for full documentation.
#'
#' @param deploymentId &#91;required&#93; The unique ID of a deployment.
#' @param nextToken A token identifier returned from the previous
#' [`list_deployment_targets`][codedeploy_list_deployment_targets] call. It
#' can be used to return the next set of deployment targets in the list.
#' @param targetFilters A key used to filter the returned targets. The two valid values are:
#' 
#' -   `TargetStatus` - A `TargetStatus` filter string can be `Failed`,
#'     `InProgress`, `Pending`, `Ready`, `Skipped`, `Succeeded`, or
#'     `Unknown`.
#' 
#' -   `ServerInstanceLabel` - A `ServerInstanceLabel` filter string can be
#'     `Blue` or `Green`.
#'
#' @keywords internal
#'
#' @rdname codedeploy_list_deployment_targets
codedeploy_list_deployment_targets <- function(deploymentId, nextToken = NULL, targetFilters = NULL) {
  op <- new_operation(
    name = "ListDeploymentTargets",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codedeploy$list_deployment_targets_input(deploymentId = deploymentId, nextToken = nextToken, targetFilters = targetFilters)
  output <- .codedeploy$list_deployment_targets_output()
  config <- get_config()
  svc <- .codedeploy$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codedeploy$operations$list_deployment_targets <- codedeploy_list_deployment_targets

#' Lists the deployments in a deployment group for an application
#' registered with the user or Amazon Web Services account
#'
#' @description
#' Lists the deployments in a deployment group for an application registered with the user or Amazon Web Services account.
#'
#' See [https://www.paws-r-sdk.com/docs/codedeploy_list_deployments/](https://www.paws-r-sdk.com/docs/codedeploy_list_deployments/) for full documentation.
#'
#' @param applicationName The name of an CodeDeploy application associated with the user or Amazon
#' Web Services account.
#' 
#' If `applicationName` is specified, then `deploymentGroupName` must be
#' specified. If it is not specified, then `deploymentGroupName` must not
#' be specified.
#' @param deploymentGroupName The name of a deployment group for the specified application.
#' 
#' If `deploymentGroupName` is specified, then `applicationName` must be
#' specified. If it is not specified, then `applicationName` must not be
#' specified.
#' @param externalId The unique ID of an external resource for returning deployments linked
#' to the external resource.
#' @param includeOnlyStatuses A subset of deployments to list by status:
#' 
#' -   `Created`: Include created deployments in the resulting list.
#' 
#' -   `Queued`: Include queued deployments in the resulting list.
#' 
#' -   `In Progress`: Include in-progress deployments in the resulting
#'     list.
#' 
#' -   `Succeeded`: Include successful deployments in the resulting list.
#' 
#' -   `Failed`: Include failed deployments in the resulting list.
#' 
#' -   `Stopped`: Include stopped deployments in the resulting list.
#' @param createTimeRange A time range (start and end) for returning a subset of the list of
#' deployments.
#' @param nextToken An identifier returned from the previous list deployments call. It can
#' be used to return the next set of deployments in the list.
#'
#' @keywords internal
#'
#' @rdname codedeploy_list_deployments
codedeploy_list_deployments <- function(applicationName = NULL, deploymentGroupName = NULL, externalId = NULL, includeOnlyStatuses = NULL, createTimeRange = NULL, nextToken = NULL) {
  op <- new_operation(
    name = "ListDeployments",
    http_method = "POST",
    http_path = "/",
    paginator = list(input_token = "nextToken", output_token = "nextToken", result_key = "deployments")
  )
  input <- .codedeploy$list_deployments_input(applicationName = applicationName, deploymentGroupName = deploymentGroupName, externalId = externalId, includeOnlyStatuses = includeOnlyStatuses, createTimeRange = createTimeRange, nextToken = nextToken)
  output <- .codedeploy$list_deployments_output()
  config <- get_config()
  svc <- .codedeploy$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codedeploy$operations$list_deployments <- codedeploy_list_deployments

#' Lists the names of stored connections to GitHub accounts
#'
#' @description
#' Lists the names of stored connections to GitHub accounts.
#'
#' See [https://www.paws-r-sdk.com/docs/codedeploy_list_git_hub_account_token_names/](https://www.paws-r-sdk.com/docs/codedeploy_list_git_hub_account_token_names/) for full documentation.
#'
#' @param nextToken An identifier returned from the previous
#' [`list_git_hub_account_token_names`][codedeploy_list_git_hub_account_token_names]
#' call. It can be used to return the next set of names in the list.
#'
#' @keywords internal
#'
#' @rdname codedeploy_list_git_hub_account_token_names
codedeploy_list_git_hub_account_token_names <- function(nextToken = NULL) {
  op <- new_operation(
    name = "ListGitHubAccountTokenNames",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codedeploy$list_git_hub_account_token_names_input(nextToken = nextToken)
  output <- .codedeploy$list_git_hub_account_token_names_output()
  config <- get_config()
  svc <- .codedeploy$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codedeploy$operations$list_git_hub_account_token_names <- codedeploy_list_git_hub_account_token_names

#' Gets a list of names for one or more on-premises instances
#'
#' @description
#' Gets a list of names for one or more on-premises instances.
#'
#' See [https://www.paws-r-sdk.com/docs/codedeploy_list_on_premises_instances/](https://www.paws-r-sdk.com/docs/codedeploy_list_on_premises_instances/) for full documentation.
#'
#' @param registrationStatus The registration status of the on-premises instances:
#' 
#' -   `Deregistered`: Include deregistered on-premises instances in the
#'     resulting list.
#' 
#' -   `Registered`: Include registered on-premises instances in the
#'     resulting list.
#' @param tagFilters The on-premises instance tags that are used to restrict the on-premises
#' instance names returned.
#' @param nextToken An identifier returned from the previous list on-premises instances
#' call. It can be used to return the next set of on-premises instances in
#' the list.
#'
#' @keywords internal
#'
#' @rdname codedeploy_list_on_premises_instances
codedeploy_list_on_premises_instances <- function(registrationStatus = NULL, tagFilters = NULL, nextToken = NULL) {
  op <- new_operation(
    name = "ListOnPremisesInstances",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codedeploy$list_on_premises_instances_input(registrationStatus = registrationStatus, tagFilters = tagFilters, nextToken = nextToken)
  output <- .codedeploy$list_on_premises_instances_output()
  config <- get_config()
  svc <- .codedeploy$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codedeploy$operations$list_on_premises_instances <- codedeploy_list_on_premises_instances

#' Returns a list of tags for the resource identified by a specified Amazon
#' Resource Name (ARN)
#'
#' @description
#' Returns a list of tags for the resource identified by a specified Amazon Resource Name (ARN). Tags are used to organize and categorize your CodeDeploy resources.
#'
#' See [https://www.paws-r-sdk.com/docs/codedeploy_list_tags_for_resource/](https://www.paws-r-sdk.com/docs/codedeploy_list_tags_for_resource/) for full documentation.
#'
#' @param ResourceArn &#91;required&#93; The ARN of a CodeDeploy resource.
#' [`list_tags_for_resource`][codedeploy_list_tags_for_resource] returns
#' all the tags associated with the resource that is identified by the
#' `ResourceArn`.
#' @param NextToken An identifier returned from the previous
#' [`list_tags_for_resource`][codedeploy_list_tags_for_resource] call. It
#' can be used to return the next set of applications in the list.
#'
#' @keywords internal
#'
#' @rdname codedeploy_list_tags_for_resource
codedeploy_list_tags_for_resource <- function(ResourceArn, NextToken = NULL) {
  op <- new_operation(
    name = "ListTagsForResource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codedeploy$list_tags_for_resource_input(ResourceArn = ResourceArn, NextToken = NextToken)
  output <- .codedeploy$list_tags_for_resource_output()
  config <- get_config()
  svc <- .codedeploy$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codedeploy$operations$list_tags_for_resource <- codedeploy_list_tags_for_resource

#' Sets the result of a Lambda validation function
#'
#' @description
#' Sets the result of a Lambda validation function. The function validates lifecycle hooks during a deployment that uses the Lambda or Amazon ECS compute platform. For Lambda deployments, the available lifecycle hooks are `BeforeAllowTraffic` and `AfterAllowTraffic`. For Amazon ECS deployments, the available lifecycle hooks are `BeforeInstall`, `AfterInstall`, `AfterAllowTestTraffic`, `BeforeAllowTraffic`, and `AfterAllowTraffic`. Lambda validation functions return `Succeeded` or `Failed`. For more information, see [AppSpec 'hooks' Section for an Lambda Deployment](https://docs.aws.amazon.com/codedeploy/latest/userguide/reference-appspec-file-structure-hooks.html#appspec-hooks-lambda) and [AppSpec 'hooks' Section for an Amazon ECS Deployment](https://docs.aws.amazon.com/codedeploy/latest/userguide/reference-appspec-file-structure-hooks.html#appspec-hooks-ecs).
#'
#' See [https://www.paws-r-sdk.com/docs/codedeploy_put_lifecycle_event_hook_execution_status/](https://www.paws-r-sdk.com/docs/codedeploy_put_lifecycle_event_hook_execution_status/) for full documentation.
#'
#' @param deploymentId The unique ID of a deployment. Pass this ID to a Lambda function that
#' validates a deployment lifecycle event.
#' @param lifecycleEventHookExecutionId The execution ID of a deployment's lifecycle hook. A deployment
#' lifecycle hook is specified in the `hooks` section of the AppSpec file.
#' @param status The result of a Lambda function that validates a deployment lifecycle
#' event. The values listed in **Valid Values** are valid for lifecycle
#' statuses in general; however, only `Succeeded` and `Failed` can be
#' passed successfully in your API call.
#'
#' @keywords internal
#'
#' @rdname codedeploy_put_lifecycle_event_hook_execution_status
codedeploy_put_lifecycle_event_hook_execution_status <- function(deploymentId = NULL, lifecycleEventHookExecutionId = NULL, status = NULL) {
  op <- new_operation(
    name = "PutLifecycleEventHookExecutionStatus",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codedeploy$put_lifecycle_event_hook_execution_status_input(deploymentId = deploymentId, lifecycleEventHookExecutionId = lifecycleEventHookExecutionId, status = status)
  output <- .codedeploy$put_lifecycle_event_hook_execution_status_output()
  config <- get_config()
  svc <- .codedeploy$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codedeploy$operations$put_lifecycle_event_hook_execution_status <- codedeploy_put_lifecycle_event_hook_execution_status

#' Registers with CodeDeploy a revision for the specified application
#'
#' @description
#' Registers with CodeDeploy a revision for the specified application.
#'
#' See [https://www.paws-r-sdk.com/docs/codedeploy_register_application_revision/](https://www.paws-r-sdk.com/docs/codedeploy_register_application_revision/) for full documentation.
#'
#' @param applicationName &#91;required&#93; The name of an CodeDeploy application associated with the user or Amazon
#' Web Services account.
#' @param description A comment about the revision.
#' @param revision &#91;required&#93; Information about the application revision to register, including type
#' and location.
#'
#' @keywords internal
#'
#' @rdname codedeploy_register_application_revision
codedeploy_register_application_revision <- function(applicationName, description = NULL, revision) {
  op <- new_operation(
    name = "RegisterApplicationRevision",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codedeploy$register_application_revision_input(applicationName = applicationName, description = description, revision = revision)
  output <- .codedeploy$register_application_revision_output()
  config <- get_config()
  svc <- .codedeploy$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codedeploy$operations$register_application_revision <- codedeploy_register_application_revision

#' Registers an on-premises instance
#'
#' @description
#' Registers an on-premises instance.
#'
#' See [https://www.paws-r-sdk.com/docs/codedeploy_register_on_premises_instance/](https://www.paws-r-sdk.com/docs/codedeploy_register_on_premises_instance/) for full documentation.
#'
#' @param instanceName &#91;required&#93; The name of the on-premises instance to register.
#' @param iamSessionArn The ARN of the IAM session to associate with the on-premises instance.
#' @param iamUserArn The ARN of the user to associate with the on-premises instance.
#'
#' @keywords internal
#'
#' @rdname codedeploy_register_on_premises_instance
codedeploy_register_on_premises_instance <- function(instanceName, iamSessionArn = NULL, iamUserArn = NULL) {
  op <- new_operation(
    name = "RegisterOnPremisesInstance",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codedeploy$register_on_premises_instance_input(instanceName = instanceName, iamSessionArn = iamSessionArn, iamUserArn = iamUserArn)
  output <- .codedeploy$register_on_premises_instance_output()
  config <- get_config()
  svc <- .codedeploy$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codedeploy$operations$register_on_premises_instance <- codedeploy_register_on_premises_instance

#' Removes one or more tags from one or more on-premises instances
#'
#' @description
#' Removes one or more tags from one or more on-premises instances.
#'
#' See [https://www.paws-r-sdk.com/docs/codedeploy_remove_tags_from_on_premises_instances/](https://www.paws-r-sdk.com/docs/codedeploy_remove_tags_from_on_premises_instances/) for full documentation.
#'
#' @param tags &#91;required&#93; The tag key-value pairs to remove from the on-premises instances.
#' @param instanceNames &#91;required&#93; The names of the on-premises instances from which to remove tags.
#'
#' @keywords internal
#'
#' @rdname codedeploy_remove_tags_from_on_premises_instances
codedeploy_remove_tags_from_on_premises_instances <- function(tags, instanceNames) {
  op <- new_operation(
    name = "RemoveTagsFromOnPremisesInstances",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codedeploy$remove_tags_from_on_premises_instances_input(tags = tags, instanceNames = instanceNames)
  output <- .codedeploy$remove_tags_from_on_premises_instances_output()
  config <- get_config()
  svc <- .codedeploy$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codedeploy$operations$remove_tags_from_on_premises_instances <- codedeploy_remove_tags_from_on_premises_instances

#' In a blue/green deployment, overrides any specified wait time and starts
#' terminating instances immediately after the traffic routing is complete
#'
#' @description
#' In a blue/green deployment, overrides any specified wait time and starts terminating instances immediately after the traffic routing is complete.
#'
#' See [https://www.paws-r-sdk.com/docs/codedeploy_skip_wait_time_for_instance_termination/](https://www.paws-r-sdk.com/docs/codedeploy_skip_wait_time_for_instance_termination/) for full documentation.
#'
#' @param deploymentId The unique ID of a blue/green deployment for which you want to skip the
#' instance termination wait time.
#'
#' @keywords internal
#'
#' @rdname codedeploy_skip_wait_time_for_instance_termination
codedeploy_skip_wait_time_for_instance_termination <- function(deploymentId = NULL) {
  op <- new_operation(
    name = "SkipWaitTimeForInstanceTermination",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codedeploy$skip_wait_time_for_instance_termination_input(deploymentId = deploymentId)
  output <- .codedeploy$skip_wait_time_for_instance_termination_output()
  config <- get_config()
  svc <- .codedeploy$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codedeploy$operations$skip_wait_time_for_instance_termination <- codedeploy_skip_wait_time_for_instance_termination

#' Attempts to stop an ongoing deployment
#'
#' @description
#' Attempts to stop an ongoing deployment.
#'
#' See [https://www.paws-r-sdk.com/docs/codedeploy_stop_deployment/](https://www.paws-r-sdk.com/docs/codedeploy_stop_deployment/) for full documentation.
#'
#' @param deploymentId &#91;required&#93; The unique ID of a deployment.
#' @param autoRollbackEnabled Indicates, when a deployment is stopped, whether instances that have
#' been updated should be rolled back to the previous version of the
#' application revision.
#'
#' @keywords internal
#'
#' @rdname codedeploy_stop_deployment
codedeploy_stop_deployment <- function(deploymentId, autoRollbackEnabled = NULL) {
  op <- new_operation(
    name = "StopDeployment",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codedeploy$stop_deployment_input(deploymentId = deploymentId, autoRollbackEnabled = autoRollbackEnabled)
  output <- .codedeploy$stop_deployment_output()
  config <- get_config()
  svc <- .codedeploy$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codedeploy$operations$stop_deployment <- codedeploy_stop_deployment

#' Associates the list of tags in the input Tags parameter with the
#' resource identified by the ResourceArn input parameter
#'
#' @description
#' Associates the list of tags in the input `Tags` parameter with the resource identified by the `ResourceArn` input parameter.
#'
#' See [https://www.paws-r-sdk.com/docs/codedeploy_tag_resource/](https://www.paws-r-sdk.com/docs/codedeploy_tag_resource/) for full documentation.
#'
#' @param ResourceArn &#91;required&#93; The ARN of a resource, such as a CodeDeploy application or deployment
#' group.
#' @param Tags &#91;required&#93; A list of tags that [`tag_resource`][codedeploy_tag_resource] associates
#' with a resource. The resource is identified by the `ResourceArn` input
#' parameter.
#'
#' @keywords internal
#'
#' @rdname codedeploy_tag_resource
codedeploy_tag_resource <- function(ResourceArn, Tags) {
  op <- new_operation(
    name = "TagResource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codedeploy$tag_resource_input(ResourceArn = ResourceArn, Tags = Tags)
  output <- .codedeploy$tag_resource_output()
  config <- get_config()
  svc <- .codedeploy$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codedeploy$operations$tag_resource <- codedeploy_tag_resource

#' Disassociates a resource from a list of tags
#'
#' @description
#' Disassociates a resource from a list of tags. The resource is identified by the `ResourceArn` input parameter. The tags are identified by the list of keys in the `TagKeys` input parameter.
#'
#' See [https://www.paws-r-sdk.com/docs/codedeploy_untag_resource/](https://www.paws-r-sdk.com/docs/codedeploy_untag_resource/) for full documentation.
#'
#' @param ResourceArn &#91;required&#93; The Amazon Resource Name (ARN) that specifies from which resource to
#' disassociate the tags with the keys in the `TagKeys` input parameter.
#' @param TagKeys &#91;required&#93; A list of keys of `Tag` objects. The `Tag` objects identified by the
#' keys are disassociated from the resource specified by the `ResourceArn`
#' input parameter.
#'
#' @keywords internal
#'
#' @rdname codedeploy_untag_resource
codedeploy_untag_resource <- function(ResourceArn, TagKeys) {
  op <- new_operation(
    name = "UntagResource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codedeploy$untag_resource_input(ResourceArn = ResourceArn, TagKeys = TagKeys)
  output <- .codedeploy$untag_resource_output()
  config <- get_config()
  svc <- .codedeploy$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codedeploy$operations$untag_resource <- codedeploy_untag_resource

#' Changes the name of an application
#'
#' @description
#' Changes the name of an application.
#'
#' See [https://www.paws-r-sdk.com/docs/codedeploy_update_application/](https://www.paws-r-sdk.com/docs/codedeploy_update_application/) for full documentation.
#'
#' @param applicationName The current name of the application you want to change.
#' @param newApplicationName The new name to give the application.
#'
#' @keywords internal
#'
#' @rdname codedeploy_update_application
codedeploy_update_application <- function(applicationName = NULL, newApplicationName = NULL) {
  op <- new_operation(
    name = "UpdateApplication",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codedeploy$update_application_input(applicationName = applicationName, newApplicationName = newApplicationName)
  output <- .codedeploy$update_application_output()
  config <- get_config()
  svc <- .codedeploy$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codedeploy$operations$update_application <- codedeploy_update_application

#' Changes information about a deployment group
#'
#' @description
#' Changes information about a deployment group.
#'
#' See [https://www.paws-r-sdk.com/docs/codedeploy_update_deployment_group/](https://www.paws-r-sdk.com/docs/codedeploy_update_deployment_group/) for full documentation.
#'
#' @param applicationName &#91;required&#93; The application name that corresponds to the deployment group to update.
#' @param currentDeploymentGroupName &#91;required&#93; The current name of the deployment group.
#' @param newDeploymentGroupName The new name of the deployment group, if you want to change it.
#' @param deploymentConfigName The replacement deployment configuration name to use, if you want to
#' change it.
#' @param ec2TagFilters The replacement set of Amazon EC2 tags on which to filter, if you want
#' to change them. To keep the existing tags, enter their names. To remove
#' tags, do not enter any tag names.
#' @param onPremisesInstanceTagFilters The replacement set of on-premises instance tags on which to filter, if
#' you want to change them. To keep the existing tags, enter their names.
#' To remove tags, do not enter any tag names.
#' @param autoScalingGroups The replacement list of Auto Scaling groups to be included in the
#' deployment group, if you want to change them.
#' 
#' -   To keep the Auto Scaling groups, enter their names or do not specify
#'     this parameter.
#' 
#' -   To remove Auto Scaling groups, specify a non-null empty list of Auto
#'     Scaling group names to detach all CodeDeploy-managed Auto Scaling
#'     lifecycle hooks. For examples, see [Amazon EC2 instances in an
#'     Amazon EC2 Auto Scaling group fail to launch and receive the error
#'     "Heartbeat
#'     Timeout"](https://docs.aws.amazon.com/codedeploy/latest/userguide/troubleshooting-auto-scaling.html#troubleshooting-auto-scaling-heartbeat)
#'     in the *CodeDeploy User Guide*.
#' @param serviceRoleArn A replacement ARN for the service role, if you want to change it.
#' @param triggerConfigurations Information about triggers to change when the deployment group is
#' updated. For examples, see [Edit a Trigger in a CodeDeploy Deployment
#' Group](https://docs.aws.amazon.com/codedeploy/latest/userguide/monitoring-sns-event-notifications-edit-trigger.html)
#' in the *CodeDeploy User Guide*.
#' @param alarmConfiguration Information to add or change about Amazon CloudWatch alarms when the
#' deployment group is updated.
#' @param autoRollbackConfiguration Information for an automatic rollback configuration that is added or
#' changed when a deployment group is updated.
#' @param outdatedInstancesStrategy Indicates what happens when new Amazon EC2 instances are launched
#' mid-deployment and do not receive the deployed application revision.
#' 
#' If this option is set to `UPDATE` or is unspecified, CodeDeploy
#' initiates one or more 'auto-update outdated instances' deployments to
#' apply the deployed application revision to the new Amazon EC2 instances.
#' 
#' If this option is set to `IGNORE`, CodeDeploy does not initiate a
#' deployment to update the new Amazon EC2 instances. This may result in
#' instances having different revisions.
#' @param deploymentStyle Information about the type of deployment, either in-place or blue/green,
#' you want to run and whether to route deployment traffic behind a load
#' balancer.
#' @param blueGreenDeploymentConfiguration Information about blue/green deployment options for a deployment group.
#' @param loadBalancerInfo Information about the load balancer used in a deployment.
#' @param ec2TagSet Information about groups of tags applied to on-premises instances. The
#' deployment group includes only Amazon EC2 instances identified by all
#' the tag groups.
#' @param ecsServices The target Amazon ECS services in the deployment group. This applies
#' only to deployment groups that use the Amazon ECS compute platform. A
#' target Amazon ECS service is specified as an Amazon ECS cluster and
#' service name pair using the format `<clustername>:<servicename>`.
#' @param onPremisesTagSet Information about an on-premises instance tag set. The deployment group
#' includes only on-premises instances identified by all the tag groups.
#' @param terminationHookEnabled This parameter only applies if you are using CodeDeploy with Amazon EC2
#' Auto Scaling. For more information, see [Integrating CodeDeploy with
#' Amazon EC2 Auto
#' Scaling](https://docs.aws.amazon.com/codedeploy/latest/userguide/integrations-aws-auto-scaling.html)
#' in the *CodeDeploy User Guide*.
#' 
#' Set `terminationHookEnabled` to `true` to have CodeDeploy install a
#' termination hook into your Auto Scaling group when you update a
#' deployment group. When this hook is installed, CodeDeploy will perform
#' termination deployments.
#' 
#' For information about termination deployments, see [Enabling termination
#' deployments during Auto Scaling scale-in
#' events](https://docs.aws.amazon.com/codedeploy/latest/userguide/integrations-aws-auto-scaling.html#integrations-aws-auto-scaling-behaviors-hook-enable)
#' in the *CodeDeploy User Guide*.
#' 
#' For more information about Auto Scaling scale-in events, see the [Scale
#' in](https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-lifecycle.html#as-lifecycle-scale-in)
#' topic in the *Amazon EC2 Auto Scaling User Guide*.
#'
#' @keywords internal
#'
#' @rdname codedeploy_update_deployment_group
codedeploy_update_deployment_group <- function(applicationName, currentDeploymentGroupName, newDeploymentGroupName = NULL, deploymentConfigName = NULL, ec2TagFilters = NULL, onPremisesInstanceTagFilters = NULL, autoScalingGroups = NULL, serviceRoleArn = NULL, triggerConfigurations = NULL, alarmConfiguration = NULL, autoRollbackConfiguration = NULL, outdatedInstancesStrategy = NULL, deploymentStyle = NULL, blueGreenDeploymentConfiguration = NULL, loadBalancerInfo = NULL, ec2TagSet = NULL, ecsServices = NULL, onPremisesTagSet = NULL, terminationHookEnabled = NULL) {
  op <- new_operation(
    name = "UpdateDeploymentGroup",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codedeploy$update_deployment_group_input(applicationName = applicationName, currentDeploymentGroupName = currentDeploymentGroupName, newDeploymentGroupName = newDeploymentGroupName, deploymentConfigName = deploymentConfigName, ec2TagFilters = ec2TagFilters, onPremisesInstanceTagFilters = onPremisesInstanceTagFilters, autoScalingGroups = autoScalingGroups, serviceRoleArn = serviceRoleArn, triggerConfigurations = triggerConfigurations, alarmConfiguration = alarmConfiguration, autoRollbackConfiguration = autoRollbackConfiguration, outdatedInstancesStrategy = outdatedInstancesStrategy, deploymentStyle = deploymentStyle, blueGreenDeploymentConfiguration = blueGreenDeploymentConfiguration, loadBalancerInfo = loadBalancerInfo, ec2TagSet = ec2TagSet, ecsServices = ecsServices, onPremisesTagSet = onPremisesTagSet, terminationHookEnabled = terminationHookEnabled)
  output <- .codedeploy$update_deployment_group_output()
  config <- get_config()
  svc <- .codedeploy$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codedeploy$operations$update_deployment_group <- codedeploy_update_deployment_group
