% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xray_operations.R
\name{xray_put_resource_policy}
\alias{xray_put_resource_policy}
\title{Sets the resource policy to grant one or more Amazon Web Services
services and accounts permissions to access X-Ray}
\usage{
xray_put_resource_policy(
  PolicyName,
  PolicyDocument,
  PolicyRevisionId = NULL,
  BypassPolicyLockoutCheck = NULL
)
}
\arguments{
\item{PolicyName}{[required] The name of the resource policy. Must be unique within a specific Amazon
Web Services account.}

\item{PolicyDocument}{[required] The resource policy document, which can be up to 5kb in size.}

\item{PolicyRevisionId}{Specifies a specific policy revision, to ensure an atomic create
operation. By default the resource policy is created if it does not
exist, or updated with an incremented revision id. The revision id is
unique to each policy in the account.

If the policy revision id does not match the latest revision id, the
operation will fail with an \code{InvalidPolicyRevisionIdException}
exception. You can also provide a \code{PolicyRevisionId} of 0. In this case,
the operation will fail with an \code{InvalidPolicyRevisionIdException}
exception if a resource policy with the same name already exists.}

\item{BypassPolicyLockoutCheck}{A flag to indicate whether to bypass the resource policy lockout safety
check.

Setting this value to true increases the risk that the policy becomes
unmanageable. Do not set this value to true indiscriminately.

Use this parameter only when you include a policy in the request and you
intend to prevent the principal that is making the request from making a
subsequent \code{\link[=xray_put_resource_policy]{put_resource_policy}} request.

The default value is false.}
}
\description{
Sets the resource policy to grant one or more Amazon Web Services services and accounts permissions to access X-Ray. Each resource policy will be associated with a specific Amazon Web Services account. Each Amazon Web Services account can have a maximum of 5 resource policies, and each policy name must be unique within that account. The maximum size of each resource policy is 5KB.

See \url{https://www.paws-r-sdk.com/docs/xray_put_resource_policy/} for full documentation.
}
\keyword{internal}
