# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include wellarchitected_service.R
NULL

#' Associate a lens to a workload
#'
#' @description
#' Associate a lens to a workload.
#'
#' See [https://www.paws-r-sdk.com/docs/wellarchitected_associate_lenses/](https://www.paws-r-sdk.com/docs/wellarchitected_associate_lenses/) for full documentation.
#'
#' @param WorkloadId &#91;required&#93; 
#' @param LensAliases &#91;required&#93; 
#'
#' @keywords internal
#'
#' @rdname wellarchitected_associate_lenses
wellarchitected_associate_lenses <- function(WorkloadId, LensAliases) {
  op <- new_operation(
    name = "AssociateLenses",
    http_method = "PATCH",
    http_path = "/workloads/{WorkloadId}/associateLenses",
    paginator = list()
  )
  input <- .wellarchitected$associate_lenses_input(WorkloadId = WorkloadId, LensAliases = LensAliases)
  output <- .wellarchitected$associate_lenses_output()
  config <- get_config()
  svc <- .wellarchitected$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.wellarchitected$operations$associate_lenses <- wellarchitected_associate_lenses

#' Associate a profile with a workload
#'
#' @description
#' Associate a profile with a workload.
#'
#' See [https://www.paws-r-sdk.com/docs/wellarchitected_associate_profiles/](https://www.paws-r-sdk.com/docs/wellarchitected_associate_profiles/) for full documentation.
#'
#' @param WorkloadId &#91;required&#93; 
#' @param ProfileArns &#91;required&#93; The list of profile ARNs to associate with the workload.
#'
#' @keywords internal
#'
#' @rdname wellarchitected_associate_profiles
wellarchitected_associate_profiles <- function(WorkloadId, ProfileArns) {
  op <- new_operation(
    name = "AssociateProfiles",
    http_method = "PATCH",
    http_path = "/workloads/{WorkloadId}/associateProfiles",
    paginator = list()
  )
  input <- .wellarchitected$associate_profiles_input(WorkloadId = WorkloadId, ProfileArns = ProfileArns)
  output <- .wellarchitected$associate_profiles_output()
  config <- get_config()
  svc <- .wellarchitected$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.wellarchitected$operations$associate_profiles <- wellarchitected_associate_profiles

#' Create a lens share
#'
#' @description
#' Create a lens share.
#'
#' See [https://www.paws-r-sdk.com/docs/wellarchitected_create_lens_share/](https://www.paws-r-sdk.com/docs/wellarchitected_create_lens_share/) for full documentation.
#'
#' @param LensAlias &#91;required&#93; 
#' @param SharedWith &#91;required&#93; 
#' @param ClientRequestToken &#91;required&#93; 
#'
#' @keywords internal
#'
#' @rdname wellarchitected_create_lens_share
wellarchitected_create_lens_share <- function(LensAlias, SharedWith, ClientRequestToken) {
  op <- new_operation(
    name = "CreateLensShare",
    http_method = "POST",
    http_path = "/lenses/{LensAlias}/shares",
    paginator = list()
  )
  input <- .wellarchitected$create_lens_share_input(LensAlias = LensAlias, SharedWith = SharedWith, ClientRequestToken = ClientRequestToken)
  output <- .wellarchitected$create_lens_share_output()
  config <- get_config()
  svc <- .wellarchitected$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.wellarchitected$operations$create_lens_share <- wellarchitected_create_lens_share

#' Create a new lens version
#'
#' @description
#' Create a new lens version.
#'
#' See [https://www.paws-r-sdk.com/docs/wellarchitected_create_lens_version/](https://www.paws-r-sdk.com/docs/wellarchitected_create_lens_version/) for full documentation.
#'
#' @param LensAlias &#91;required&#93; 
#' @param LensVersion &#91;required&#93; The version of the lens being created.
#' @param IsMajorVersion Set to true if this new major lens version.
#' @param ClientRequestToken &#91;required&#93; 
#'
#' @keywords internal
#'
#' @rdname wellarchitected_create_lens_version
wellarchitected_create_lens_version <- function(LensAlias, LensVersion, IsMajorVersion = NULL, ClientRequestToken) {
  op <- new_operation(
    name = "CreateLensVersion",
    http_method = "POST",
    http_path = "/lenses/{LensAlias}/versions",
    paginator = list()
  )
  input <- .wellarchitected$create_lens_version_input(LensAlias = LensAlias, LensVersion = LensVersion, IsMajorVersion = IsMajorVersion, ClientRequestToken = ClientRequestToken)
  output <- .wellarchitected$create_lens_version_output()
  config <- get_config()
  svc <- .wellarchitected$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.wellarchitected$operations$create_lens_version <- wellarchitected_create_lens_version

#' Create a milestone for an existing workload
#'
#' @description
#' Create a milestone for an existing workload.
#'
#' See [https://www.paws-r-sdk.com/docs/wellarchitected_create_milestone/](https://www.paws-r-sdk.com/docs/wellarchitected_create_milestone/) for full documentation.
#'
#' @param WorkloadId &#91;required&#93; 
#' @param MilestoneName &#91;required&#93; 
#' @param ClientRequestToken &#91;required&#93; 
#'
#' @keywords internal
#'
#' @rdname wellarchitected_create_milestone
wellarchitected_create_milestone <- function(WorkloadId, MilestoneName, ClientRequestToken) {
  op <- new_operation(
    name = "CreateMilestone",
    http_method = "POST",
    http_path = "/workloads/{WorkloadId}/milestones",
    paginator = list()
  )
  input <- .wellarchitected$create_milestone_input(WorkloadId = WorkloadId, MilestoneName = MilestoneName, ClientRequestToken = ClientRequestToken)
  output <- .wellarchitected$create_milestone_output()
  config <- get_config()
  svc <- .wellarchitected$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.wellarchitected$operations$create_milestone <- wellarchitected_create_milestone

#' Create a profile
#'
#' @description
#' Create a profile.
#'
#' See [https://www.paws-r-sdk.com/docs/wellarchitected_create_profile/](https://www.paws-r-sdk.com/docs/wellarchitected_create_profile/) for full documentation.
#'
#' @param ProfileName &#91;required&#93; Name of the profile.
#' @param ProfileDescription &#91;required&#93; The profile description.
#' @param ProfileQuestions &#91;required&#93; The profile questions.
#' @param ClientRequestToken &#91;required&#93; 
#' @param Tags The tags assigned to the profile.
#'
#' @keywords internal
#'
#' @rdname wellarchitected_create_profile
wellarchitected_create_profile <- function(ProfileName, ProfileDescription, ProfileQuestions, ClientRequestToken, Tags = NULL) {
  op <- new_operation(
    name = "CreateProfile",
    http_method = "POST",
    http_path = "/profiles",
    paginator = list()
  )
  input <- .wellarchitected$create_profile_input(ProfileName = ProfileName, ProfileDescription = ProfileDescription, ProfileQuestions = ProfileQuestions, ClientRequestToken = ClientRequestToken, Tags = Tags)
  output <- .wellarchitected$create_profile_output()
  config <- get_config()
  svc <- .wellarchitected$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.wellarchitected$operations$create_profile <- wellarchitected_create_profile

#' Create a profile share
#'
#' @description
#' Create a profile share.
#'
#' See [https://www.paws-r-sdk.com/docs/wellarchitected_create_profile_share/](https://www.paws-r-sdk.com/docs/wellarchitected_create_profile_share/) for full documentation.
#'
#' @param ProfileArn &#91;required&#93; The profile ARN.
#' @param SharedWith &#91;required&#93; 
#' @param ClientRequestToken &#91;required&#93; 
#'
#' @keywords internal
#'
#' @rdname wellarchitected_create_profile_share
wellarchitected_create_profile_share <- function(ProfileArn, SharedWith, ClientRequestToken) {
  op <- new_operation(
    name = "CreateProfileShare",
    http_method = "POST",
    http_path = "/profiles/{ProfileArn}/shares",
    paginator = list()
  )
  input <- .wellarchitected$create_profile_share_input(ProfileArn = ProfileArn, SharedWith = SharedWith, ClientRequestToken = ClientRequestToken)
  output <- .wellarchitected$create_profile_share_output()
  config <- get_config()
  svc <- .wellarchitected$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.wellarchitected$operations$create_profile_share <- wellarchitected_create_profile_share

#' Create a new workload
#'
#' @description
#' Create a new workload.
#'
#' See [https://www.paws-r-sdk.com/docs/wellarchitected_create_workload/](https://www.paws-r-sdk.com/docs/wellarchitected_create_workload/) for full documentation.
#'
#' @param WorkloadName &#91;required&#93; 
#' @param Description &#91;required&#93; 
#' @param Environment &#91;required&#93; 
#' @param AccountIds 
#' @param AwsRegions 
#' @param NonAwsRegions 
#' @param PillarPriorities 
#' @param ArchitecturalDesign 
#' @param ReviewOwner 
#' @param IndustryType 
#' @param Industry 
#' @param Lenses &#91;required&#93; 
#' @param Notes 
#' @param ClientRequestToken &#91;required&#93; 
#' @param Tags The tags to be associated with the workload.
#' @param DiscoveryConfig Well-Architected discovery configuration settings associated to the
#' workload.
#' @param Applications List of AppRegistry application ARNs associated to the workload.
#' @param ProfileArns The list of profile ARNs associated with the workload.
#'
#' @keywords internal
#'
#' @rdname wellarchitected_create_workload
wellarchitected_create_workload <- function(WorkloadName, Description, Environment, AccountIds = NULL, AwsRegions = NULL, NonAwsRegions = NULL, PillarPriorities = NULL, ArchitecturalDesign = NULL, ReviewOwner = NULL, IndustryType = NULL, Industry = NULL, Lenses, Notes = NULL, ClientRequestToken, Tags = NULL, DiscoveryConfig = NULL, Applications = NULL, ProfileArns = NULL) {
  op <- new_operation(
    name = "CreateWorkload",
    http_method = "POST",
    http_path = "/workloads",
    paginator = list()
  )
  input <- .wellarchitected$create_workload_input(WorkloadName = WorkloadName, Description = Description, Environment = Environment, AccountIds = AccountIds, AwsRegions = AwsRegions, NonAwsRegions = NonAwsRegions, PillarPriorities = PillarPriorities, ArchitecturalDesign = ArchitecturalDesign, ReviewOwner = ReviewOwner, IndustryType = IndustryType, Industry = Industry, Lenses = Lenses, Notes = Notes, ClientRequestToken = ClientRequestToken, Tags = Tags, DiscoveryConfig = DiscoveryConfig, Applications = Applications, ProfileArns = ProfileArns)
  output <- .wellarchitected$create_workload_output()
  config <- get_config()
  svc <- .wellarchitected$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.wellarchitected$operations$create_workload <- wellarchitected_create_workload

#' Create a workload share
#'
#' @description
#' Create a workload share.
#'
#' See [https://www.paws-r-sdk.com/docs/wellarchitected_create_workload_share/](https://www.paws-r-sdk.com/docs/wellarchitected_create_workload_share/) for full documentation.
#'
#' @param WorkloadId &#91;required&#93; 
#' @param SharedWith &#91;required&#93; 
#' @param PermissionType &#91;required&#93; 
#' @param ClientRequestToken &#91;required&#93; 
#'
#' @keywords internal
#'
#' @rdname wellarchitected_create_workload_share
wellarchitected_create_workload_share <- function(WorkloadId, SharedWith, PermissionType, ClientRequestToken) {
  op <- new_operation(
    name = "CreateWorkloadShare",
    http_method = "POST",
    http_path = "/workloads/{WorkloadId}/shares",
    paginator = list()
  )
  input <- .wellarchitected$create_workload_share_input(WorkloadId = WorkloadId, SharedWith = SharedWith, PermissionType = PermissionType, ClientRequestToken = ClientRequestToken)
  output <- .wellarchitected$create_workload_share_output()
  config <- get_config()
  svc <- .wellarchitected$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.wellarchitected$operations$create_workload_share <- wellarchitected_create_workload_share

#' Delete an existing lens
#'
#' @description
#' Delete an existing lens.
#'
#' See [https://www.paws-r-sdk.com/docs/wellarchitected_delete_lens/](https://www.paws-r-sdk.com/docs/wellarchitected_delete_lens/) for full documentation.
#'
#' @param LensAlias &#91;required&#93; 
#' @param ClientRequestToken &#91;required&#93; 
#' @param LensStatus &#91;required&#93; The status of the lens to be deleted.
#'
#' @keywords internal
#'
#' @rdname wellarchitected_delete_lens
wellarchitected_delete_lens <- function(LensAlias, ClientRequestToken, LensStatus) {
  op <- new_operation(
    name = "DeleteLens",
    http_method = "DELETE",
    http_path = "/lenses/{LensAlias}",
    paginator = list()
  )
  input <- .wellarchitected$delete_lens_input(LensAlias = LensAlias, ClientRequestToken = ClientRequestToken, LensStatus = LensStatus)
  output <- .wellarchitected$delete_lens_output()
  config <- get_config()
  svc <- .wellarchitected$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.wellarchitected$operations$delete_lens <- wellarchitected_delete_lens

#' Delete a lens share
#'
#' @description
#' Delete a lens share.
#'
#' See [https://www.paws-r-sdk.com/docs/wellarchitected_delete_lens_share/](https://www.paws-r-sdk.com/docs/wellarchitected_delete_lens_share/) for full documentation.
#'
#' @param ShareId &#91;required&#93; 
#' @param LensAlias &#91;required&#93; 
#' @param ClientRequestToken &#91;required&#93; 
#'
#' @keywords internal
#'
#' @rdname wellarchitected_delete_lens_share
wellarchitected_delete_lens_share <- function(ShareId, LensAlias, ClientRequestToken) {
  op <- new_operation(
    name = "DeleteLensShare",
    http_method = "DELETE",
    http_path = "/lenses/{LensAlias}/shares/{ShareId}",
    paginator = list()
  )
  input <- .wellarchitected$delete_lens_share_input(ShareId = ShareId, LensAlias = LensAlias, ClientRequestToken = ClientRequestToken)
  output <- .wellarchitected$delete_lens_share_output()
  config <- get_config()
  svc <- .wellarchitected$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.wellarchitected$operations$delete_lens_share <- wellarchitected_delete_lens_share

#' Delete a profile
#'
#' @description
#' Delete a profile.
#'
#' See [https://www.paws-r-sdk.com/docs/wellarchitected_delete_profile/](https://www.paws-r-sdk.com/docs/wellarchitected_delete_profile/) for full documentation.
#'
#' @param ProfileArn &#91;required&#93; The profile ARN.
#' @param ClientRequestToken &#91;required&#93; 
#'
#' @keywords internal
#'
#' @rdname wellarchitected_delete_profile
wellarchitected_delete_profile <- function(ProfileArn, ClientRequestToken) {
  op <- new_operation(
    name = "DeleteProfile",
    http_method = "DELETE",
    http_path = "/profiles/{ProfileArn}",
    paginator = list()
  )
  input <- .wellarchitected$delete_profile_input(ProfileArn = ProfileArn, ClientRequestToken = ClientRequestToken)
  output <- .wellarchitected$delete_profile_output()
  config <- get_config()
  svc <- .wellarchitected$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.wellarchitected$operations$delete_profile <- wellarchitected_delete_profile

#' Delete a profile share
#'
#' @description
#' Delete a profile share.
#'
#' See [https://www.paws-r-sdk.com/docs/wellarchitected_delete_profile_share/](https://www.paws-r-sdk.com/docs/wellarchitected_delete_profile_share/) for full documentation.
#'
#' @param ShareId &#91;required&#93; 
#' @param ProfileArn &#91;required&#93; The profile ARN.
#' @param ClientRequestToken &#91;required&#93; 
#'
#' @keywords internal
#'
#' @rdname wellarchitected_delete_profile_share
wellarchitected_delete_profile_share <- function(ShareId, ProfileArn, ClientRequestToken) {
  op <- new_operation(
    name = "DeleteProfileShare",
    http_method = "DELETE",
    http_path = "/profiles/{ProfileArn}/shares/{ShareId}",
    paginator = list()
  )
  input <- .wellarchitected$delete_profile_share_input(ShareId = ShareId, ProfileArn = ProfileArn, ClientRequestToken = ClientRequestToken)
  output <- .wellarchitected$delete_profile_share_output()
  config <- get_config()
  svc <- .wellarchitected$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.wellarchitected$operations$delete_profile_share <- wellarchitected_delete_profile_share

#' Delete an existing workload
#'
#' @description
#' Delete an existing workload.
#'
#' See [https://www.paws-r-sdk.com/docs/wellarchitected_delete_workload/](https://www.paws-r-sdk.com/docs/wellarchitected_delete_workload/) for full documentation.
#'
#' @param WorkloadId &#91;required&#93; 
#' @param ClientRequestToken &#91;required&#93; 
#'
#' @keywords internal
#'
#' @rdname wellarchitected_delete_workload
wellarchitected_delete_workload <- function(WorkloadId, ClientRequestToken) {
  op <- new_operation(
    name = "DeleteWorkload",
    http_method = "DELETE",
    http_path = "/workloads/{WorkloadId}",
    paginator = list()
  )
  input <- .wellarchitected$delete_workload_input(WorkloadId = WorkloadId, ClientRequestToken = ClientRequestToken)
  output <- .wellarchitected$delete_workload_output()
  config <- get_config()
  svc <- .wellarchitected$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.wellarchitected$operations$delete_workload <- wellarchitected_delete_workload

#' Delete a workload share
#'
#' @description
#' Delete a workload share.
#'
#' See [https://www.paws-r-sdk.com/docs/wellarchitected_delete_workload_share/](https://www.paws-r-sdk.com/docs/wellarchitected_delete_workload_share/) for full documentation.
#'
#' @param ShareId &#91;required&#93; 
#' @param WorkloadId &#91;required&#93; 
#' @param ClientRequestToken &#91;required&#93; 
#'
#' @keywords internal
#'
#' @rdname wellarchitected_delete_workload_share
wellarchitected_delete_workload_share <- function(ShareId, WorkloadId, ClientRequestToken) {
  op <- new_operation(
    name = "DeleteWorkloadShare",
    http_method = "DELETE",
    http_path = "/workloads/{WorkloadId}/shares/{ShareId}",
    paginator = list()
  )
  input <- .wellarchitected$delete_workload_share_input(ShareId = ShareId, WorkloadId = WorkloadId, ClientRequestToken = ClientRequestToken)
  output <- .wellarchitected$delete_workload_share_output()
  config <- get_config()
  svc <- .wellarchitected$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.wellarchitected$operations$delete_workload_share <- wellarchitected_delete_workload_share

#' Disassociate a lens from a workload
#'
#' @description
#' Disassociate a lens from a workload.
#'
#' See [https://www.paws-r-sdk.com/docs/wellarchitected_disassociate_lenses/](https://www.paws-r-sdk.com/docs/wellarchitected_disassociate_lenses/) for full documentation.
#'
#' @param WorkloadId &#91;required&#93; 
#' @param LensAliases &#91;required&#93; 
#'
#' @keywords internal
#'
#' @rdname wellarchitected_disassociate_lenses
wellarchitected_disassociate_lenses <- function(WorkloadId, LensAliases) {
  op <- new_operation(
    name = "DisassociateLenses",
    http_method = "PATCH",
    http_path = "/workloads/{WorkloadId}/disassociateLenses",
    paginator = list()
  )
  input <- .wellarchitected$disassociate_lenses_input(WorkloadId = WorkloadId, LensAliases = LensAliases)
  output <- .wellarchitected$disassociate_lenses_output()
  config <- get_config()
  svc <- .wellarchitected$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.wellarchitected$operations$disassociate_lenses <- wellarchitected_disassociate_lenses

#' Disassociate a profile from a workload
#'
#' @description
#' Disassociate a profile from a workload.
#'
#' See [https://www.paws-r-sdk.com/docs/wellarchitected_disassociate_profiles/](https://www.paws-r-sdk.com/docs/wellarchitected_disassociate_profiles/) for full documentation.
#'
#' @param WorkloadId &#91;required&#93; 
#' @param ProfileArns &#91;required&#93; The list of profile ARNs to disassociate from the workload.
#'
#' @keywords internal
#'
#' @rdname wellarchitected_disassociate_profiles
wellarchitected_disassociate_profiles <- function(WorkloadId, ProfileArns) {
  op <- new_operation(
    name = "DisassociateProfiles",
    http_method = "PATCH",
    http_path = "/workloads/{WorkloadId}/disassociateProfiles",
    paginator = list()
  )
  input <- .wellarchitected$disassociate_profiles_input(WorkloadId = WorkloadId, ProfileArns = ProfileArns)
  output <- .wellarchitected$disassociate_profiles_output()
  config <- get_config()
  svc <- .wellarchitected$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.wellarchitected$operations$disassociate_profiles <- wellarchitected_disassociate_profiles

#' Export an existing lens
#'
#' @description
#' Export an existing lens.
#'
#' See [https://www.paws-r-sdk.com/docs/wellarchitected_export_lens/](https://www.paws-r-sdk.com/docs/wellarchitected_export_lens/) for full documentation.
#'
#' @param LensAlias &#91;required&#93; 
#' @param LensVersion The lens version to be exported.
#'
#' @keywords internal
#'
#' @rdname wellarchitected_export_lens
wellarchitected_export_lens <- function(LensAlias, LensVersion = NULL) {
  op <- new_operation(
    name = "ExportLens",
    http_method = "GET",
    http_path = "/lenses/{LensAlias}/export",
    paginator = list()
  )
  input <- .wellarchitected$export_lens_input(LensAlias = LensAlias, LensVersion = LensVersion)
  output <- .wellarchitected$export_lens_output()
  config <- get_config()
  svc <- .wellarchitected$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.wellarchitected$operations$export_lens <- wellarchitected_export_lens

#' Get the answer to a specific question in a workload review
#'
#' @description
#' Get the answer to a specific question in a workload review.
#'
#' See [https://www.paws-r-sdk.com/docs/wellarchitected_get_answer/](https://www.paws-r-sdk.com/docs/wellarchitected_get_answer/) for full documentation.
#'
#' @param WorkloadId &#91;required&#93; 
#' @param LensAlias &#91;required&#93; 
#' @param QuestionId &#91;required&#93; 
#' @param MilestoneNumber 
#'
#' @keywords internal
#'
#' @rdname wellarchitected_get_answer
wellarchitected_get_answer <- function(WorkloadId, LensAlias, QuestionId, MilestoneNumber = NULL) {
  op <- new_operation(
    name = "GetAnswer",
    http_method = "GET",
    http_path = "/workloads/{WorkloadId}/lensReviews/{LensAlias}/answers/{QuestionId}",
    paginator = list()
  )
  input <- .wellarchitected$get_answer_input(WorkloadId = WorkloadId, LensAlias = LensAlias, QuestionId = QuestionId, MilestoneNumber = MilestoneNumber)
  output <- .wellarchitected$get_answer_output()
  config <- get_config()
  svc <- .wellarchitected$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.wellarchitected$operations$get_answer <- wellarchitected_get_answer

#' Get a consolidated report of your workloads
#'
#' @description
#' Get a consolidated report of your workloads.
#'
#' See [https://www.paws-r-sdk.com/docs/wellarchitected_get_consolidated_report/](https://www.paws-r-sdk.com/docs/wellarchitected_get_consolidated_report/) for full documentation.
#'
#' @param Format &#91;required&#93; The format of the consolidated report.
#' 
#' For `PDF`, `Base64String` is returned. For `JSON`, `Metrics` is
#' returned.
#' @param IncludeSharedResources Set to `true` to have shared resources included in the report.
#' @param NextToken 
#' @param MaxResults The maximum number of results to return for this request.
#'
#' @keywords internal
#'
#' @rdname wellarchitected_get_consolidated_report
wellarchitected_get_consolidated_report <- function(Format, IncludeSharedResources = NULL, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "GetConsolidatedReport",
    http_method = "GET",
    http_path = "/consolidatedReport",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults")
  )
  input <- .wellarchitected$get_consolidated_report_input(Format = Format, IncludeSharedResources = IncludeSharedResources, NextToken = NextToken, MaxResults = MaxResults)
  output <- .wellarchitected$get_consolidated_report_output()
  config <- get_config()
  svc <- .wellarchitected$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.wellarchitected$operations$get_consolidated_report <- wellarchitected_get_consolidated_report

#' Get an existing lens
#'
#' @description
#' Get an existing lens.
#'
#' See [https://www.paws-r-sdk.com/docs/wellarchitected_get_lens/](https://www.paws-r-sdk.com/docs/wellarchitected_get_lens/) for full documentation.
#'
#' @param LensAlias &#91;required&#93; 
#' @param LensVersion The lens version to be retrieved.
#'
#' @keywords internal
#'
#' @rdname wellarchitected_get_lens
wellarchitected_get_lens <- function(LensAlias, LensVersion = NULL) {
  op <- new_operation(
    name = "GetLens",
    http_method = "GET",
    http_path = "/lenses/{LensAlias}",
    paginator = list()
  )
  input <- .wellarchitected$get_lens_input(LensAlias = LensAlias, LensVersion = LensVersion)
  output <- .wellarchitected$get_lens_output()
  config <- get_config()
  svc <- .wellarchitected$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.wellarchitected$operations$get_lens <- wellarchitected_get_lens

#' Get lens review
#'
#' @description
#' Get lens review.
#'
#' See [https://www.paws-r-sdk.com/docs/wellarchitected_get_lens_review/](https://www.paws-r-sdk.com/docs/wellarchitected_get_lens_review/) for full documentation.
#'
#' @param WorkloadId &#91;required&#93; 
#' @param LensAlias &#91;required&#93; 
#' @param MilestoneNumber 
#'
#' @keywords internal
#'
#' @rdname wellarchitected_get_lens_review
wellarchitected_get_lens_review <- function(WorkloadId, LensAlias, MilestoneNumber = NULL) {
  op <- new_operation(
    name = "GetLensReview",
    http_method = "GET",
    http_path = "/workloads/{WorkloadId}/lensReviews/{LensAlias}",
    paginator = list()
  )
  input <- .wellarchitected$get_lens_review_input(WorkloadId = WorkloadId, LensAlias = LensAlias, MilestoneNumber = MilestoneNumber)
  output <- .wellarchitected$get_lens_review_output()
  config <- get_config()
  svc <- .wellarchitected$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.wellarchitected$operations$get_lens_review <- wellarchitected_get_lens_review

#' Get lens review report
#'
#' @description
#' Get lens review report.
#'
#' See [https://www.paws-r-sdk.com/docs/wellarchitected_get_lens_review_report/](https://www.paws-r-sdk.com/docs/wellarchitected_get_lens_review_report/) for full documentation.
#'
#' @param WorkloadId &#91;required&#93; 
#' @param LensAlias &#91;required&#93; 
#' @param MilestoneNumber 
#'
#' @keywords internal
#'
#' @rdname wellarchitected_get_lens_review_report
wellarchitected_get_lens_review_report <- function(WorkloadId, LensAlias, MilestoneNumber = NULL) {
  op <- new_operation(
    name = "GetLensReviewReport",
    http_method = "GET",
    http_path = "/workloads/{WorkloadId}/lensReviews/{LensAlias}/report",
    paginator = list()
  )
  input <- .wellarchitected$get_lens_review_report_input(WorkloadId = WorkloadId, LensAlias = LensAlias, MilestoneNumber = MilestoneNumber)
  output <- .wellarchitected$get_lens_review_report_output()
  config <- get_config()
  svc <- .wellarchitected$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.wellarchitected$operations$get_lens_review_report <- wellarchitected_get_lens_review_report

#' Get lens version differences
#'
#' @description
#' Get lens version differences.
#'
#' See [https://www.paws-r-sdk.com/docs/wellarchitected_get_lens_version_difference/](https://www.paws-r-sdk.com/docs/wellarchitected_get_lens_version_difference/) for full documentation.
#'
#' @param LensAlias &#91;required&#93; 
#' @param BaseLensVersion The base version of the lens.
#' @param TargetLensVersion The lens version to target a difference for.
#'
#' @keywords internal
#'
#' @rdname wellarchitected_get_lens_version_difference
wellarchitected_get_lens_version_difference <- function(LensAlias, BaseLensVersion = NULL, TargetLensVersion = NULL) {
  op <- new_operation(
    name = "GetLensVersionDifference",
    http_method = "GET",
    http_path = "/lenses/{LensAlias}/versionDifference",
    paginator = list()
  )
  input <- .wellarchitected$get_lens_version_difference_input(LensAlias = LensAlias, BaseLensVersion = BaseLensVersion, TargetLensVersion = TargetLensVersion)
  output <- .wellarchitected$get_lens_version_difference_output()
  config <- get_config()
  svc <- .wellarchitected$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.wellarchitected$operations$get_lens_version_difference <- wellarchitected_get_lens_version_difference

#' Get a milestone for an existing workload
#'
#' @description
#' Get a milestone for an existing workload.
#'
#' See [https://www.paws-r-sdk.com/docs/wellarchitected_get_milestone/](https://www.paws-r-sdk.com/docs/wellarchitected_get_milestone/) for full documentation.
#'
#' @param WorkloadId &#91;required&#93; 
#' @param MilestoneNumber &#91;required&#93; 
#'
#' @keywords internal
#'
#' @rdname wellarchitected_get_milestone
wellarchitected_get_milestone <- function(WorkloadId, MilestoneNumber) {
  op <- new_operation(
    name = "GetMilestone",
    http_method = "GET",
    http_path = "/workloads/{WorkloadId}/milestones/{MilestoneNumber}",
    paginator = list()
  )
  input <- .wellarchitected$get_milestone_input(WorkloadId = WorkloadId, MilestoneNumber = MilestoneNumber)
  output <- .wellarchitected$get_milestone_output()
  config <- get_config()
  svc <- .wellarchitected$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.wellarchitected$operations$get_milestone <- wellarchitected_get_milestone

#' Get profile information
#'
#' @description
#' Get profile information.
#'
#' See [https://www.paws-r-sdk.com/docs/wellarchitected_get_profile/](https://www.paws-r-sdk.com/docs/wellarchitected_get_profile/) for full documentation.
#'
#' @param ProfileArn &#91;required&#93; The profile ARN.
#' @param ProfileVersion The profile version.
#'
#' @keywords internal
#'
#' @rdname wellarchitected_get_profile
wellarchitected_get_profile <- function(ProfileArn, ProfileVersion = NULL) {
  op <- new_operation(
    name = "GetProfile",
    http_method = "GET",
    http_path = "/profiles/{ProfileArn}",
    paginator = list()
  )
  input <- .wellarchitected$get_profile_input(ProfileArn = ProfileArn, ProfileVersion = ProfileVersion)
  output <- .wellarchitected$get_profile_output()
  config <- get_config()
  svc <- .wellarchitected$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.wellarchitected$operations$get_profile <- wellarchitected_get_profile

#' Get profile template
#'
#' @description
#' Get profile template.
#'
#' See [https://www.paws-r-sdk.com/docs/wellarchitected_get_profile_template/](https://www.paws-r-sdk.com/docs/wellarchitected_get_profile_template/) for full documentation.
#'
#' @keywords internal
#'
#' @rdname wellarchitected_get_profile_template
wellarchitected_get_profile_template <- function() {
  op <- new_operation(
    name = "GetProfileTemplate",
    http_method = "GET",
    http_path = "/profileTemplate",
    paginator = list()
  )
  input <- .wellarchitected$get_profile_template_input()
  output <- .wellarchitected$get_profile_template_output()
  config <- get_config()
  svc <- .wellarchitected$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.wellarchitected$operations$get_profile_template <- wellarchitected_get_profile_template

#' Get an existing workload
#'
#' @description
#' Get an existing workload.
#'
#' See [https://www.paws-r-sdk.com/docs/wellarchitected_get_workload/](https://www.paws-r-sdk.com/docs/wellarchitected_get_workload/) for full documentation.
#'
#' @param WorkloadId &#91;required&#93; 
#'
#' @keywords internal
#'
#' @rdname wellarchitected_get_workload
wellarchitected_get_workload <- function(WorkloadId) {
  op <- new_operation(
    name = "GetWorkload",
    http_method = "GET",
    http_path = "/workloads/{WorkloadId}",
    paginator = list()
  )
  input <- .wellarchitected$get_workload_input(WorkloadId = WorkloadId)
  output <- .wellarchitected$get_workload_output()
  config <- get_config()
  svc <- .wellarchitected$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.wellarchitected$operations$get_workload <- wellarchitected_get_workload

#' Import a new custom lens or update an existing custom lens
#'
#' @description
#' Import a new custom lens or update an existing custom lens.
#'
#' See [https://www.paws-r-sdk.com/docs/wellarchitected_import_lens/](https://www.paws-r-sdk.com/docs/wellarchitected_import_lens/) for full documentation.
#'
#' @param LensAlias 
#' @param JSONString &#91;required&#93; The JSON representation of a lens.
#' @param ClientRequestToken &#91;required&#93; 
#' @param Tags Tags to associate to a lens.
#'
#' @keywords internal
#'
#' @rdname wellarchitected_import_lens
wellarchitected_import_lens <- function(LensAlias = NULL, JSONString, ClientRequestToken, Tags = NULL) {
  op <- new_operation(
    name = "ImportLens",
    http_method = "PUT",
    http_path = "/importLens",
    paginator = list()
  )
  input <- .wellarchitected$import_lens_input(LensAlias = LensAlias, JSONString = JSONString, ClientRequestToken = ClientRequestToken, Tags = Tags)
  output <- .wellarchitected$import_lens_output()
  config <- get_config()
  svc <- .wellarchitected$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.wellarchitected$operations$import_lens <- wellarchitected_import_lens

#' List of answers for a particular workload and lens
#'
#' @description
#' List of answers for a particular workload and lens.
#'
#' See [https://www.paws-r-sdk.com/docs/wellarchitected_list_answers/](https://www.paws-r-sdk.com/docs/wellarchitected_list_answers/) for full documentation.
#'
#' @param WorkloadId &#91;required&#93; 
#' @param LensAlias &#91;required&#93; 
#' @param PillarId 
#' @param MilestoneNumber 
#' @param NextToken 
#' @param MaxResults The maximum number of results to return for this request.
#' @param QuestionPriority The priority of the question.
#'
#' @keywords internal
#'
#' @rdname wellarchitected_list_answers
wellarchitected_list_answers <- function(WorkloadId, LensAlias, PillarId = NULL, MilestoneNumber = NULL, NextToken = NULL, MaxResults = NULL, QuestionPriority = NULL) {
  op <- new_operation(
    name = "ListAnswers",
    http_method = "GET",
    http_path = "/workloads/{WorkloadId}/lensReviews/{LensAlias}/answers",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults")
  )
  input <- .wellarchitected$list_answers_input(WorkloadId = WorkloadId, LensAlias = LensAlias, PillarId = PillarId, MilestoneNumber = MilestoneNumber, NextToken = NextToken, MaxResults = MaxResults, QuestionPriority = QuestionPriority)
  output <- .wellarchitected$list_answers_output()
  config <- get_config()
  svc <- .wellarchitected$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.wellarchitected$operations$list_answers <- wellarchitected_list_answers

#' List of Trusted Advisor check details by account related to the workload
#'
#' @description
#' List of Trusted Advisor check details by account related to the workload.
#'
#' See [https://www.paws-r-sdk.com/docs/wellarchitected_list_check_details/](https://www.paws-r-sdk.com/docs/wellarchitected_list_check_details/) for full documentation.
#'
#' @param WorkloadId &#91;required&#93; 
#' @param NextToken 
#' @param MaxResults 
#' @param LensArn &#91;required&#93; Well-Architected Lens ARN.
#' @param PillarId &#91;required&#93; 
#' @param QuestionId &#91;required&#93; 
#' @param ChoiceId &#91;required&#93; 
#'
#' @keywords internal
#'
#' @rdname wellarchitected_list_check_details
wellarchitected_list_check_details <- function(WorkloadId, NextToken = NULL, MaxResults = NULL, LensArn, PillarId, QuestionId, ChoiceId) {
  op <- new_operation(
    name = "ListCheckDetails",
    http_method = "POST",
    http_path = "/workloads/{WorkloadId}/checks",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults")
  )
  input <- .wellarchitected$list_check_details_input(WorkloadId = WorkloadId, NextToken = NextToken, MaxResults = MaxResults, LensArn = LensArn, PillarId = PillarId, QuestionId = QuestionId, ChoiceId = ChoiceId)
  output <- .wellarchitected$list_check_details_output()
  config <- get_config()
  svc <- .wellarchitected$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.wellarchitected$operations$list_check_details <- wellarchitected_list_check_details

#' List of Trusted Advisor checks summarized for all accounts related to
#' the workload
#'
#' @description
#' List of Trusted Advisor checks summarized for all accounts related to the workload.
#'
#' See [https://www.paws-r-sdk.com/docs/wellarchitected_list_check_summaries/](https://www.paws-r-sdk.com/docs/wellarchitected_list_check_summaries/) for full documentation.
#'
#' @param WorkloadId &#91;required&#93; 
#' @param NextToken 
#' @param MaxResults 
#' @param LensArn &#91;required&#93; Well-Architected Lens ARN.
#' @param PillarId &#91;required&#93; 
#' @param QuestionId &#91;required&#93; 
#' @param ChoiceId &#91;required&#93; 
#'
#' @keywords internal
#'
#' @rdname wellarchitected_list_check_summaries
wellarchitected_list_check_summaries <- function(WorkloadId, NextToken = NULL, MaxResults = NULL, LensArn, PillarId, QuestionId, ChoiceId) {
  op <- new_operation(
    name = "ListCheckSummaries",
    http_method = "POST",
    http_path = "/workloads/{WorkloadId}/checkSummaries",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults")
  )
  input <- .wellarchitected$list_check_summaries_input(WorkloadId = WorkloadId, NextToken = NextToken, MaxResults = MaxResults, LensArn = LensArn, PillarId = PillarId, QuestionId = QuestionId, ChoiceId = ChoiceId)
  output <- .wellarchitected$list_check_summaries_output()
  config <- get_config()
  svc <- .wellarchitected$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.wellarchitected$operations$list_check_summaries <- wellarchitected_list_check_summaries

#' List lens review improvements
#'
#' @description
#' List lens review improvements.
#'
#' See [https://www.paws-r-sdk.com/docs/wellarchitected_list_lens_review_improvements/](https://www.paws-r-sdk.com/docs/wellarchitected_list_lens_review_improvements/) for full documentation.
#'
#' @param WorkloadId &#91;required&#93; 
#' @param LensAlias &#91;required&#93; 
#' @param PillarId 
#' @param MilestoneNumber 
#' @param NextToken 
#' @param MaxResults The maximum number of results to return for this request.
#' @param QuestionPriority The priority of the question.
#'
#' @keywords internal
#'
#' @rdname wellarchitected_list_lens_review_improvements
wellarchitected_list_lens_review_improvements <- function(WorkloadId, LensAlias, PillarId = NULL, MilestoneNumber = NULL, NextToken = NULL, MaxResults = NULL, QuestionPriority = NULL) {
  op <- new_operation(
    name = "ListLensReviewImprovements",
    http_method = "GET",
    http_path = "/workloads/{WorkloadId}/lensReviews/{LensAlias}/improvements",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults")
  )
  input <- .wellarchitected$list_lens_review_improvements_input(WorkloadId = WorkloadId, LensAlias = LensAlias, PillarId = PillarId, MilestoneNumber = MilestoneNumber, NextToken = NextToken, MaxResults = MaxResults, QuestionPriority = QuestionPriority)
  output <- .wellarchitected$list_lens_review_improvements_output()
  config <- get_config()
  svc <- .wellarchitected$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.wellarchitected$operations$list_lens_review_improvements <- wellarchitected_list_lens_review_improvements

#' List lens reviews for a particular workload
#'
#' @description
#' List lens reviews for a particular workload.
#'
#' See [https://www.paws-r-sdk.com/docs/wellarchitected_list_lens_reviews/](https://www.paws-r-sdk.com/docs/wellarchitected_list_lens_reviews/) for full documentation.
#'
#' @param WorkloadId &#91;required&#93; 
#' @param MilestoneNumber 
#' @param NextToken 
#' @param MaxResults 
#'
#' @keywords internal
#'
#' @rdname wellarchitected_list_lens_reviews
wellarchitected_list_lens_reviews <- function(WorkloadId, MilestoneNumber = NULL, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListLensReviews",
    http_method = "GET",
    http_path = "/workloads/{WorkloadId}/lensReviews",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults")
  )
  input <- .wellarchitected$list_lens_reviews_input(WorkloadId = WorkloadId, MilestoneNumber = MilestoneNumber, NextToken = NextToken, MaxResults = MaxResults)
  output <- .wellarchitected$list_lens_reviews_output()
  config <- get_config()
  svc <- .wellarchitected$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.wellarchitected$operations$list_lens_reviews <- wellarchitected_list_lens_reviews

#' List the lens shares associated with the lens
#'
#' @description
#' List the lens shares associated with the lens.
#'
#' See [https://www.paws-r-sdk.com/docs/wellarchitected_list_lens_shares/](https://www.paws-r-sdk.com/docs/wellarchitected_list_lens_shares/) for full documentation.
#'
#' @param LensAlias &#91;required&#93; 
#' @param SharedWithPrefix The Amazon Web Services account ID, IAM role, organization ID, or
#' organizational unit (OU) ID with which the lens is shared.
#' @param NextToken 
#' @param MaxResults The maximum number of results to return for this request.
#' @param Status 
#'
#' @keywords internal
#'
#' @rdname wellarchitected_list_lens_shares
wellarchitected_list_lens_shares <- function(LensAlias, SharedWithPrefix = NULL, NextToken = NULL, MaxResults = NULL, Status = NULL) {
  op <- new_operation(
    name = "ListLensShares",
    http_method = "GET",
    http_path = "/lenses/{LensAlias}/shares",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults")
  )
  input <- .wellarchitected$list_lens_shares_input(LensAlias = LensAlias, SharedWithPrefix = SharedWithPrefix, NextToken = NextToken, MaxResults = MaxResults, Status = Status)
  output <- .wellarchitected$list_lens_shares_output()
  config <- get_config()
  svc <- .wellarchitected$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.wellarchitected$operations$list_lens_shares <- wellarchitected_list_lens_shares

#' List the available lenses
#'
#' @description
#' List the available lenses.
#'
#' See [https://www.paws-r-sdk.com/docs/wellarchitected_list_lenses/](https://www.paws-r-sdk.com/docs/wellarchitected_list_lenses/) for full documentation.
#'
#' @param NextToken 
#' @param MaxResults 
#' @param LensType The type of lenses to be returned.
#' @param LensStatus The status of lenses to be returned.
#' @param LensName 
#'
#' @keywords internal
#'
#' @rdname wellarchitected_list_lenses
wellarchitected_list_lenses <- function(NextToken = NULL, MaxResults = NULL, LensType = NULL, LensStatus = NULL, LensName = NULL) {
  op <- new_operation(
    name = "ListLenses",
    http_method = "GET",
    http_path = "/lenses",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults")
  )
  input <- .wellarchitected$list_lenses_input(NextToken = NextToken, MaxResults = MaxResults, LensType = LensType, LensStatus = LensStatus, LensName = LensName)
  output <- .wellarchitected$list_lenses_output()
  config <- get_config()
  svc <- .wellarchitected$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.wellarchitected$operations$list_lenses <- wellarchitected_list_lenses

#' List all milestones for an existing workload
#'
#' @description
#' List all milestones for an existing workload.
#'
#' See [https://www.paws-r-sdk.com/docs/wellarchitected_list_milestones/](https://www.paws-r-sdk.com/docs/wellarchitected_list_milestones/) for full documentation.
#'
#' @param WorkloadId &#91;required&#93; 
#' @param NextToken 
#' @param MaxResults 
#'
#' @keywords internal
#'
#' @rdname wellarchitected_list_milestones
wellarchitected_list_milestones <- function(WorkloadId, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListMilestones",
    http_method = "POST",
    http_path = "/workloads/{WorkloadId}/milestonesSummaries",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults")
  )
  input <- .wellarchitected$list_milestones_input(WorkloadId = WorkloadId, NextToken = NextToken, MaxResults = MaxResults)
  output <- .wellarchitected$list_milestones_output()
  config <- get_config()
  svc <- .wellarchitected$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.wellarchitected$operations$list_milestones <- wellarchitected_list_milestones

#' List lens notifications
#'
#' @description
#' List lens notifications.
#'
#' See [https://www.paws-r-sdk.com/docs/wellarchitected_list_notifications/](https://www.paws-r-sdk.com/docs/wellarchitected_list_notifications/) for full documentation.
#'
#' @param WorkloadId 
#' @param NextToken 
#' @param MaxResults The maximum number of results to return for this request.
#'
#' @keywords internal
#'
#' @rdname wellarchitected_list_notifications
wellarchitected_list_notifications <- function(WorkloadId = NULL, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListNotifications",
    http_method = "POST",
    http_path = "/notifications",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults")
  )
  input <- .wellarchitected$list_notifications_input(WorkloadId = WorkloadId, NextToken = NextToken, MaxResults = MaxResults)
  output <- .wellarchitected$list_notifications_output()
  config <- get_config()
  svc <- .wellarchitected$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.wellarchitected$operations$list_notifications <- wellarchitected_list_notifications

#' List profile notifications
#'
#' @description
#' List profile notifications.
#'
#' See [https://www.paws-r-sdk.com/docs/wellarchitected_list_profile_notifications/](https://www.paws-r-sdk.com/docs/wellarchitected_list_profile_notifications/) for full documentation.
#'
#' @param WorkloadId 
#' @param NextToken 
#' @param MaxResults 
#'
#' @keywords internal
#'
#' @rdname wellarchitected_list_profile_notifications
wellarchitected_list_profile_notifications <- function(WorkloadId = NULL, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListProfileNotifications",
    http_method = "GET",
    http_path = "/profileNotifications/",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults")
  )
  input <- .wellarchitected$list_profile_notifications_input(WorkloadId = WorkloadId, NextToken = NextToken, MaxResults = MaxResults)
  output <- .wellarchitected$list_profile_notifications_output()
  config <- get_config()
  svc <- .wellarchitected$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.wellarchitected$operations$list_profile_notifications <- wellarchitected_list_profile_notifications

#' List profile shares
#'
#' @description
#' List profile shares.
#'
#' See [https://www.paws-r-sdk.com/docs/wellarchitected_list_profile_shares/](https://www.paws-r-sdk.com/docs/wellarchitected_list_profile_shares/) for full documentation.
#'
#' @param ProfileArn &#91;required&#93; The profile ARN.
#' @param SharedWithPrefix The Amazon Web Services account ID, IAM role, organization ID, or
#' organizational unit (OU) ID with which the profile is shared.
#' @param NextToken 
#' @param MaxResults The maximum number of results to return for this request.
#' @param Status 
#'
#' @keywords internal
#'
#' @rdname wellarchitected_list_profile_shares
wellarchitected_list_profile_shares <- function(ProfileArn, SharedWithPrefix = NULL, NextToken = NULL, MaxResults = NULL, Status = NULL) {
  op <- new_operation(
    name = "ListProfileShares",
    http_method = "GET",
    http_path = "/profiles/{ProfileArn}/shares",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults")
  )
  input <- .wellarchitected$list_profile_shares_input(ProfileArn = ProfileArn, SharedWithPrefix = SharedWithPrefix, NextToken = NextToken, MaxResults = MaxResults, Status = Status)
  output <- .wellarchitected$list_profile_shares_output()
  config <- get_config()
  svc <- .wellarchitected$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.wellarchitected$operations$list_profile_shares <- wellarchitected_list_profile_shares

#' List profiles
#'
#' @description
#' List profiles.
#'
#' See [https://www.paws-r-sdk.com/docs/wellarchitected_list_profiles/](https://www.paws-r-sdk.com/docs/wellarchitected_list_profiles/) for full documentation.
#'
#' @param ProfileNamePrefix Prefix for profile name.
#' @param ProfileOwnerType Profile owner type.
#' @param NextToken 
#' @param MaxResults 
#'
#' @keywords internal
#'
#' @rdname wellarchitected_list_profiles
wellarchitected_list_profiles <- function(ProfileNamePrefix = NULL, ProfileOwnerType = NULL, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListProfiles",
    http_method = "GET",
    http_path = "/profileSummaries",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults")
  )
  input <- .wellarchitected$list_profiles_input(ProfileNamePrefix = ProfileNamePrefix, ProfileOwnerType = ProfileOwnerType, NextToken = NextToken, MaxResults = MaxResults)
  output <- .wellarchitected$list_profiles_output()
  config <- get_config()
  svc <- .wellarchitected$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.wellarchitected$operations$list_profiles <- wellarchitected_list_profiles

#' List the workload invitations
#'
#' @description
#' List the workload invitations.
#'
#' See [https://www.paws-r-sdk.com/docs/wellarchitected_list_share_invitations/](https://www.paws-r-sdk.com/docs/wellarchitected_list_share_invitations/) for full documentation.
#'
#' @param WorkloadNamePrefix 
#' @param LensNamePrefix An optional string added to the beginning of each lens name returned in
#' the results.
#' @param ShareResourceType The type of share invitations to be returned.
#' @param NextToken 
#' @param MaxResults The maximum number of results to return for this request.
#' @param ProfileNamePrefix Profile name prefix.
#'
#' @keywords internal
#'
#' @rdname wellarchitected_list_share_invitations
wellarchitected_list_share_invitations <- function(WorkloadNamePrefix = NULL, LensNamePrefix = NULL, ShareResourceType = NULL, NextToken = NULL, MaxResults = NULL, ProfileNamePrefix = NULL) {
  op <- new_operation(
    name = "ListShareInvitations",
    http_method = "GET",
    http_path = "/shareInvitations",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults")
  )
  input <- .wellarchitected$list_share_invitations_input(WorkloadNamePrefix = WorkloadNamePrefix, LensNamePrefix = LensNamePrefix, ShareResourceType = ShareResourceType, NextToken = NextToken, MaxResults = MaxResults, ProfileNamePrefix = ProfileNamePrefix)
  output <- .wellarchitected$list_share_invitations_output()
  config <- get_config()
  svc <- .wellarchitected$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.wellarchitected$operations$list_share_invitations <- wellarchitected_list_share_invitations

#' List the tags for a resource
#'
#' @description
#' List the tags for a resource.
#'
#' See [https://www.paws-r-sdk.com/docs/wellarchitected_list_tags_for_resource/](https://www.paws-r-sdk.com/docs/wellarchitected_list_tags_for_resource/) for full documentation.
#'
#' @param WorkloadArn &#91;required&#93; 
#'
#' @keywords internal
#'
#' @rdname wellarchitected_list_tags_for_resource
wellarchitected_list_tags_for_resource <- function(WorkloadArn) {
  op <- new_operation(
    name = "ListTagsForResource",
    http_method = "GET",
    http_path = "/tags/{WorkloadArn}",
    paginator = list()
  )
  input <- .wellarchitected$list_tags_for_resource_input(WorkloadArn = WorkloadArn)
  output <- .wellarchitected$list_tags_for_resource_output()
  config <- get_config()
  svc <- .wellarchitected$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.wellarchitected$operations$list_tags_for_resource <- wellarchitected_list_tags_for_resource

#' List the workload shares associated with the workload
#'
#' @description
#' List the workload shares associated with the workload.
#'
#' See [https://www.paws-r-sdk.com/docs/wellarchitected_list_workload_shares/](https://www.paws-r-sdk.com/docs/wellarchitected_list_workload_shares/) for full documentation.
#'
#' @param WorkloadId &#91;required&#93; 
#' @param SharedWithPrefix The Amazon Web Services account ID, IAM role, organization ID, or
#' organizational unit (OU) ID with which the workload is shared.
#' @param NextToken 
#' @param MaxResults The maximum number of results to return for this request.
#' @param Status 
#'
#' @keywords internal
#'
#' @rdname wellarchitected_list_workload_shares
wellarchitected_list_workload_shares <- function(WorkloadId, SharedWithPrefix = NULL, NextToken = NULL, MaxResults = NULL, Status = NULL) {
  op <- new_operation(
    name = "ListWorkloadShares",
    http_method = "GET",
    http_path = "/workloads/{WorkloadId}/shares",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults")
  )
  input <- .wellarchitected$list_workload_shares_input(WorkloadId = WorkloadId, SharedWithPrefix = SharedWithPrefix, NextToken = NextToken, MaxResults = MaxResults, Status = Status)
  output <- .wellarchitected$list_workload_shares_output()
  config <- get_config()
  svc <- .wellarchitected$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.wellarchitected$operations$list_workload_shares <- wellarchitected_list_workload_shares

#' Paginated list of workloads
#'
#' @description
#' Paginated list of workloads.
#'
#' See [https://www.paws-r-sdk.com/docs/wellarchitected_list_workloads/](https://www.paws-r-sdk.com/docs/wellarchitected_list_workloads/) for full documentation.
#'
#' @param WorkloadNamePrefix 
#' @param NextToken 
#' @param MaxResults The maximum number of results to return for this request.
#'
#' @keywords internal
#'
#' @rdname wellarchitected_list_workloads
wellarchitected_list_workloads <- function(WorkloadNamePrefix = NULL, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListWorkloads",
    http_method = "POST",
    http_path = "/workloadsSummaries",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults")
  )
  input <- .wellarchitected$list_workloads_input(WorkloadNamePrefix = WorkloadNamePrefix, NextToken = NextToken, MaxResults = MaxResults)
  output <- .wellarchitected$list_workloads_output()
  config <- get_config()
  svc <- .wellarchitected$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.wellarchitected$operations$list_workloads <- wellarchitected_list_workloads

#' Adds one or more tags to the specified resource
#'
#' @description
#' Adds one or more tags to the specified resource.
#'
#' See [https://www.paws-r-sdk.com/docs/wellarchitected_tag_resource/](https://www.paws-r-sdk.com/docs/wellarchitected_tag_resource/) for full documentation.
#'
#' @param WorkloadArn &#91;required&#93; 
#' @param Tags &#91;required&#93; The tags for the resource.
#'
#' @keywords internal
#'
#' @rdname wellarchitected_tag_resource
wellarchitected_tag_resource <- function(WorkloadArn, Tags) {
  op <- new_operation(
    name = "TagResource",
    http_method = "POST",
    http_path = "/tags/{WorkloadArn}",
    paginator = list()
  )
  input <- .wellarchitected$tag_resource_input(WorkloadArn = WorkloadArn, Tags = Tags)
  output <- .wellarchitected$tag_resource_output()
  config <- get_config()
  svc <- .wellarchitected$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.wellarchitected$operations$tag_resource <- wellarchitected_tag_resource

#' Deletes specified tags from a resource
#'
#' @description
#' Deletes specified tags from a resource.
#'
#' See [https://www.paws-r-sdk.com/docs/wellarchitected_untag_resource/](https://www.paws-r-sdk.com/docs/wellarchitected_untag_resource/) for full documentation.
#'
#' @param WorkloadArn &#91;required&#93; 
#' @param TagKeys &#91;required&#93; A list of tag keys. Existing tags of the resource whose keys are members
#' of this list are removed from the resource.
#'
#' @keywords internal
#'
#' @rdname wellarchitected_untag_resource
wellarchitected_untag_resource <- function(WorkloadArn, TagKeys) {
  op <- new_operation(
    name = "UntagResource",
    http_method = "DELETE",
    http_path = "/tags/{WorkloadArn}",
    paginator = list()
  )
  input <- .wellarchitected$untag_resource_input(WorkloadArn = WorkloadArn, TagKeys = TagKeys)
  output <- .wellarchitected$untag_resource_output()
  config <- get_config()
  svc <- .wellarchitected$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.wellarchitected$operations$untag_resource <- wellarchitected_untag_resource

#' Update the answer to a specific question in a workload review
#'
#' @description
#' Update the answer to a specific question in a workload review.
#'
#' See [https://www.paws-r-sdk.com/docs/wellarchitected_update_answer/](https://www.paws-r-sdk.com/docs/wellarchitected_update_answer/) for full documentation.
#'
#' @param WorkloadId &#91;required&#93; 
#' @param LensAlias &#91;required&#93; 
#' @param QuestionId &#91;required&#93; 
#' @param SelectedChoices 
#' @param ChoiceUpdates A list of choices to update on a question in your workload. The String
#' key corresponds to the choice ID to be updated.
#' @param Notes 
#' @param IsApplicable 
#' @param Reason The reason why a question is not applicable to your workload.
#'
#' @keywords internal
#'
#' @rdname wellarchitected_update_answer
wellarchitected_update_answer <- function(WorkloadId, LensAlias, QuestionId, SelectedChoices = NULL, ChoiceUpdates = NULL, Notes = NULL, IsApplicable = NULL, Reason = NULL) {
  op <- new_operation(
    name = "UpdateAnswer",
    http_method = "PATCH",
    http_path = "/workloads/{WorkloadId}/lensReviews/{LensAlias}/answers/{QuestionId}",
    paginator = list()
  )
  input <- .wellarchitected$update_answer_input(WorkloadId = WorkloadId, LensAlias = LensAlias, QuestionId = QuestionId, SelectedChoices = SelectedChoices, ChoiceUpdates = ChoiceUpdates, Notes = Notes, IsApplicable = IsApplicable, Reason = Reason)
  output <- .wellarchitected$update_answer_output()
  config <- get_config()
  svc <- .wellarchitected$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.wellarchitected$operations$update_answer <- wellarchitected_update_answer

#' Updates whether the Amazon Web Services account is opted into
#' organization sharing and discovery integration features
#'
#' @description
#' Updates whether the Amazon Web Services account is opted into organization sharing and discovery integration features.
#'
#' See [https://www.paws-r-sdk.com/docs/wellarchitected_update_global_settings/](https://www.paws-r-sdk.com/docs/wellarchitected_update_global_settings/) for full documentation.
#'
#' @param OrganizationSharingStatus The status of organization sharing settings.
#' @param DiscoveryIntegrationStatus The status of discovery support settings.
#'
#' @keywords internal
#'
#' @rdname wellarchitected_update_global_settings
wellarchitected_update_global_settings <- function(OrganizationSharingStatus = NULL, DiscoveryIntegrationStatus = NULL) {
  op <- new_operation(
    name = "UpdateGlobalSettings",
    http_method = "PATCH",
    http_path = "/global-settings",
    paginator = list()
  )
  input <- .wellarchitected$update_global_settings_input(OrganizationSharingStatus = OrganizationSharingStatus, DiscoveryIntegrationStatus = DiscoveryIntegrationStatus)
  output <- .wellarchitected$update_global_settings_output()
  config <- get_config()
  svc <- .wellarchitected$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.wellarchitected$operations$update_global_settings <- wellarchitected_update_global_settings

#' Update lens review for a particular workload
#'
#' @description
#' Update lens review for a particular workload.
#'
#' See [https://www.paws-r-sdk.com/docs/wellarchitected_update_lens_review/](https://www.paws-r-sdk.com/docs/wellarchitected_update_lens_review/) for full documentation.
#'
#' @param WorkloadId &#91;required&#93; 
#' @param LensAlias &#91;required&#93; 
#' @param LensNotes 
#' @param PillarNotes 
#'
#' @keywords internal
#'
#' @rdname wellarchitected_update_lens_review
wellarchitected_update_lens_review <- function(WorkloadId, LensAlias, LensNotes = NULL, PillarNotes = NULL) {
  op <- new_operation(
    name = "UpdateLensReview",
    http_method = "PATCH",
    http_path = "/workloads/{WorkloadId}/lensReviews/{LensAlias}",
    paginator = list()
  )
  input <- .wellarchitected$update_lens_review_input(WorkloadId = WorkloadId, LensAlias = LensAlias, LensNotes = LensNotes, PillarNotes = PillarNotes)
  output <- .wellarchitected$update_lens_review_output()
  config <- get_config()
  svc <- .wellarchitected$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.wellarchitected$operations$update_lens_review <- wellarchitected_update_lens_review

#' Update a profile
#'
#' @description
#' Update a profile.
#'
#' See [https://www.paws-r-sdk.com/docs/wellarchitected_update_profile/](https://www.paws-r-sdk.com/docs/wellarchitected_update_profile/) for full documentation.
#'
#' @param ProfileArn &#91;required&#93; The profile ARN.
#' @param ProfileDescription The profile description.
#' @param ProfileQuestions Profile questions.
#'
#' @keywords internal
#'
#' @rdname wellarchitected_update_profile
wellarchitected_update_profile <- function(ProfileArn, ProfileDescription = NULL, ProfileQuestions = NULL) {
  op <- new_operation(
    name = "UpdateProfile",
    http_method = "PATCH",
    http_path = "/profiles/{ProfileArn}",
    paginator = list()
  )
  input <- .wellarchitected$update_profile_input(ProfileArn = ProfileArn, ProfileDescription = ProfileDescription, ProfileQuestions = ProfileQuestions)
  output <- .wellarchitected$update_profile_output()
  config <- get_config()
  svc <- .wellarchitected$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.wellarchitected$operations$update_profile <- wellarchitected_update_profile

#' Update a workload or custom lens share invitation
#'
#' @description
#' Update a workload or custom lens share invitation.
#'
#' See [https://www.paws-r-sdk.com/docs/wellarchitected_update_share_invitation/](https://www.paws-r-sdk.com/docs/wellarchitected_update_share_invitation/) for full documentation.
#'
#' @param ShareInvitationId &#91;required&#93; The ID assigned to the share invitation.
#' @param ShareInvitationAction &#91;required&#93; 
#'
#' @keywords internal
#'
#' @rdname wellarchitected_update_share_invitation
wellarchitected_update_share_invitation <- function(ShareInvitationId, ShareInvitationAction) {
  op <- new_operation(
    name = "UpdateShareInvitation",
    http_method = "PATCH",
    http_path = "/shareInvitations/{ShareInvitationId}",
    paginator = list()
  )
  input <- .wellarchitected$update_share_invitation_input(ShareInvitationId = ShareInvitationId, ShareInvitationAction = ShareInvitationAction)
  output <- .wellarchitected$update_share_invitation_output()
  config <- get_config()
  svc <- .wellarchitected$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.wellarchitected$operations$update_share_invitation <- wellarchitected_update_share_invitation

#' Update an existing workload
#'
#' @description
#' Update an existing workload.
#'
#' See [https://www.paws-r-sdk.com/docs/wellarchitected_update_workload/](https://www.paws-r-sdk.com/docs/wellarchitected_update_workload/) for full documentation.
#'
#' @param WorkloadId &#91;required&#93; 
#' @param WorkloadName 
#' @param Description 
#' @param Environment 
#' @param AccountIds 
#' @param AwsRegions 
#' @param NonAwsRegions 
#' @param PillarPriorities 
#' @param ArchitecturalDesign 
#' @param ReviewOwner 
#' @param IsReviewOwnerUpdateAcknowledged Flag indicating whether the workload owner has acknowledged that the
#' *Review owner* field is required.
#' 
#' If a **Review owner** is not added to the workload within 60 days of
#' acknowledgement, access to the workload is restricted until an owner is
#' added.
#' @param IndustryType 
#' @param Industry 
#' @param Notes 
#' @param ImprovementStatus 
#' @param DiscoveryConfig Well-Architected discovery configuration settings to associate to the
#' workload.
#' @param Applications List of AppRegistry application ARNs to associate to the workload.
#'
#' @keywords internal
#'
#' @rdname wellarchitected_update_workload
wellarchitected_update_workload <- function(WorkloadId, WorkloadName = NULL, Description = NULL, Environment = NULL, AccountIds = NULL, AwsRegions = NULL, NonAwsRegions = NULL, PillarPriorities = NULL, ArchitecturalDesign = NULL, ReviewOwner = NULL, IsReviewOwnerUpdateAcknowledged = NULL, IndustryType = NULL, Industry = NULL, Notes = NULL, ImprovementStatus = NULL, DiscoveryConfig = NULL, Applications = NULL) {
  op <- new_operation(
    name = "UpdateWorkload",
    http_method = "PATCH",
    http_path = "/workloads/{WorkloadId}",
    paginator = list()
  )
  input <- .wellarchitected$update_workload_input(WorkloadId = WorkloadId, WorkloadName = WorkloadName, Description = Description, Environment = Environment, AccountIds = AccountIds, AwsRegions = AwsRegions, NonAwsRegions = NonAwsRegions, PillarPriorities = PillarPriorities, ArchitecturalDesign = ArchitecturalDesign, ReviewOwner = ReviewOwner, IsReviewOwnerUpdateAcknowledged = IsReviewOwnerUpdateAcknowledged, IndustryType = IndustryType, Industry = Industry, Notes = Notes, ImprovementStatus = ImprovementStatus, DiscoveryConfig = DiscoveryConfig, Applications = Applications)
  output <- .wellarchitected$update_workload_output()
  config <- get_config()
  svc <- .wellarchitected$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.wellarchitected$operations$update_workload <- wellarchitected_update_workload

#' Update a workload share
#'
#' @description
#' Update a workload share.
#'
#' See [https://www.paws-r-sdk.com/docs/wellarchitected_update_workload_share/](https://www.paws-r-sdk.com/docs/wellarchitected_update_workload_share/) for full documentation.
#'
#' @param ShareId &#91;required&#93; 
#' @param WorkloadId &#91;required&#93; 
#' @param PermissionType &#91;required&#93; 
#'
#' @keywords internal
#'
#' @rdname wellarchitected_update_workload_share
wellarchitected_update_workload_share <- function(ShareId, WorkloadId, PermissionType) {
  op <- new_operation(
    name = "UpdateWorkloadShare",
    http_method = "PATCH",
    http_path = "/workloads/{WorkloadId}/shares/{ShareId}",
    paginator = list()
  )
  input <- .wellarchitected$update_workload_share_input(ShareId = ShareId, WorkloadId = WorkloadId, PermissionType = PermissionType)
  output <- .wellarchitected$update_workload_share_output()
  config <- get_config()
  svc <- .wellarchitected$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.wellarchitected$operations$update_workload_share <- wellarchitected_update_workload_share

#' Upgrade lens review for a particular workload
#'
#' @description
#' Upgrade lens review for a particular workload.
#'
#' See [https://www.paws-r-sdk.com/docs/wellarchitected_upgrade_lens_review/](https://www.paws-r-sdk.com/docs/wellarchitected_upgrade_lens_review/) for full documentation.
#'
#' @param WorkloadId &#91;required&#93; 
#' @param LensAlias &#91;required&#93; 
#' @param MilestoneName &#91;required&#93; 
#' @param ClientRequestToken 
#'
#' @keywords internal
#'
#' @rdname wellarchitected_upgrade_lens_review
wellarchitected_upgrade_lens_review <- function(WorkloadId, LensAlias, MilestoneName, ClientRequestToken = NULL) {
  op <- new_operation(
    name = "UpgradeLensReview",
    http_method = "PUT",
    http_path = "/workloads/{WorkloadId}/lensReviews/{LensAlias}/upgrade",
    paginator = list()
  )
  input <- .wellarchitected$upgrade_lens_review_input(WorkloadId = WorkloadId, LensAlias = LensAlias, MilestoneName = MilestoneName, ClientRequestToken = ClientRequestToken)
  output <- .wellarchitected$upgrade_lens_review_output()
  config <- get_config()
  svc <- .wellarchitected$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.wellarchitected$operations$upgrade_lens_review <- wellarchitected_upgrade_lens_review

#' Upgrade a profile
#'
#' @description
#' Upgrade a profile.
#'
#' See [https://www.paws-r-sdk.com/docs/wellarchitected_upgrade_profile_version/](https://www.paws-r-sdk.com/docs/wellarchitected_upgrade_profile_version/) for full documentation.
#'
#' @param WorkloadId &#91;required&#93; 
#' @param ProfileArn &#91;required&#93; The profile ARN.
#' @param MilestoneName 
#' @param ClientRequestToken 
#'
#' @keywords internal
#'
#' @rdname wellarchitected_upgrade_profile_version
wellarchitected_upgrade_profile_version <- function(WorkloadId, ProfileArn, MilestoneName = NULL, ClientRequestToken = NULL) {
  op <- new_operation(
    name = "UpgradeProfileVersion",
    http_method = "PUT",
    http_path = "/workloads/{WorkloadId}/profiles/{ProfileArn}/upgrade",
    paginator = list()
  )
  input <- .wellarchitected$upgrade_profile_version_input(WorkloadId = WorkloadId, ProfileArn = ProfileArn, MilestoneName = MilestoneName, ClientRequestToken = ClientRequestToken)
  output <- .wellarchitected$upgrade_profile_version_output()
  config <- get_config()
  svc <- .wellarchitected$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.wellarchitected$operations$upgrade_profile_version <- wellarchitected_upgrade_profile_version
