% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/redshift_operations.R
\name{redshift_modify_redshift_idc_application}
\alias{redshift_modify_redshift_idc_application}
\title{Changes an existing Amazon Redshift IAM Identity Center application}
\usage{
redshift_modify_redshift_idc_application(
  RedshiftIdcApplicationArn,
  IdentityNamespace = NULL,
  IamRoleArn = NULL,
  IdcDisplayName = NULL,
  AuthorizedTokenIssuerList = NULL,
  ServiceIntegrations = NULL
)
}
\arguments{
\item{RedshiftIdcApplicationArn}{[required] The ARN for the Redshift application that integrates with IAM Identity
Center.}

\item{IdentityNamespace}{The namespace for the Amazon Redshift IAM Identity Center application to
change. It determines which managed application verifies the connection
token.}

\item{IamRoleArn}{The IAM role ARN associated with the Amazon Redshift IAM Identity Center
application to change. It has the required permissions to be assumed and
invoke the IDC Identity Center API.}

\item{IdcDisplayName}{The display name for the Amazon Redshift IAM Identity Center application
to change. It appears on the console.}

\item{AuthorizedTokenIssuerList}{The authorized token issuer list for the Amazon Redshift IAM Identity
Center application to change.}

\item{ServiceIntegrations}{A collection of service integrations associated with the application.}
}
\description{
Changes an existing Amazon Redshift IAM Identity Center application.

See \url{https://www.paws-r-sdk.com/docs/redshift_modify_redshift_idc_application/} for full documentation.
}
\keyword{internal}
