% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dynamodb_operations.R
\name{dynamodb_list_backups}
\alias{dynamodb_list_backups}
\title{List DynamoDB backups that are associated with an Amazon Web Services
account and weren't made with Amazon Web Services Backup}
\usage{
dynamodb_list_backups(
  TableName = NULL,
  Limit = NULL,
  TimeRangeLowerBound = NULL,
  TimeRangeUpperBound = NULL,
  ExclusiveStartBackupArn = NULL,
  BackupType = NULL
)
}
\arguments{
\item{TableName}{Lists the backups from the table specified in \code{TableName}. You can also
provide the Amazon Resource Name (ARN) of the table in this parameter.}

\item{Limit}{Maximum number of backups to return at once.}

\item{TimeRangeLowerBound}{Only backups created after this time are listed. \code{TimeRangeLowerBound}
is inclusive.}

\item{TimeRangeUpperBound}{Only backups created before this time are listed. \code{TimeRangeUpperBound}
is exclusive.}

\item{ExclusiveStartBackupArn}{\code{LastEvaluatedBackupArn} is the Amazon Resource Name (ARN) of the backup
last evaluated when the current page of results was returned, inclusive
of the current page of results. This value may be specified as the
\code{ExclusiveStartBackupArn} of a new
\code{\link[=dynamodb_list_backups]{list_backups}} operation in order to fetch the
next page of results.}

\item{BackupType}{The backups from the table specified by \code{BackupType} are listed.

Where \code{BackupType} can be:
\itemize{
\item \code{USER} - On-demand backup created by you. (The default setting if no
other backup types are specified.)
\item \code{SYSTEM} - On-demand backup automatically created by DynamoDB.
\item \code{ALL} - All types of on-demand backups (USER and SYSTEM).
}}
}
\description{
List DynamoDB backups that are associated with an Amazon Web Services account and weren't made with Amazon Web Services Backup. To list these backups for a given table, specify \code{TableName}. \code{\link[=dynamodb_list_backups]{list_backups}} returns a paginated list of results with at most 1 MB worth of items in a page. You can also specify a maximum number of entries to be returned in a page.

See \url{https://www.paws-r-sdk.com/docs/dynamodb_list_backups/} for full documentation.
}
\keyword{internal}
