% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/redshiftserverless_operations.R
\name{redshiftserverless_update_scheduled_action}
\alias{redshiftserverless_update_scheduled_action}
\title{Updates a scheduled action}
\usage{
redshiftserverless_update_scheduled_action(
  enabled = NULL,
  endTime = NULL,
  roleArn = NULL,
  schedule = NULL,
  scheduledActionDescription = NULL,
  scheduledActionName,
  startTime = NULL,
  targetAction = NULL
)
}
\arguments{
\item{enabled}{Specifies whether to enable the scheduled action.}

\item{endTime}{The end time in UTC of the scheduled action to update.}

\item{roleArn}{The ARN of the IAM role to assume to run the scheduled action. This IAM
role must have permission to run the Amazon Redshift Serverless API
operation in the scheduled action. This IAM role must allow the Amazon
Redshift scheduler to schedule creating snapshots (Principal
scheduler.redshift.amazonaws.com) to assume permissions on your behalf.
For more information about the IAM role to use with the Amazon Redshift
scheduler, see \href{https://docs.aws.amazon.com/redshift/latest/mgmt/redshift-iam-access-control-identity-based.html}{Using Identity-Based Policies for Amazon Redshift}
in the Amazon Redshift Cluster Management Guide}

\item{schedule}{The schedule for a one-time (at timestamp format) or recurring (cron
format) scheduled action. Schedule invocations must be separated by at
least one hour. Times are in UTC.
\itemize{
\item Format of at timestamp is \code{yyyy-mm-ddThh:mm:ss}. For example,
\verb{2016-03-04T17:27:00}.
\item Format of cron expression is
\verb{(Minutes Hours Day-of-month Month Day-of-week Year)}. For example,
\code{"(0 10 ? * MON *)"}. For more information, see \href{https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-create-rule-schedule.html#CronExpressions}{Cron Expressions}
in the \emph{Amazon CloudWatch Events User Guide}.
}}

\item{scheduledActionDescription}{The descripion of the scheduled action to update to.}

\item{scheduledActionName}{[required] The name of the scheduled action to update to.}

\item{startTime}{The start time in UTC of the scheduled action to update to.}

\item{targetAction}{}
}
\description{
Updates a scheduled action.

See \url{https://www.paws-r-sdk.com/docs/redshiftserverless_update_scheduled_action/} for full documentation.
}
\keyword{internal}
