% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/redshiftserverless_operations.R
\name{redshiftserverless_restore_table_from_recovery_point}
\alias{redshiftserverless_restore_table_from_recovery_point}
\title{Restores a table from a recovery point to your Amazon Redshift
Serverless instance}
\usage{
redshiftserverless_restore_table_from_recovery_point(
  activateCaseSensitiveIdentifier = NULL,
  namespaceName,
  newTableName,
  recoveryPointId,
  sourceDatabaseName,
  sourceSchemaName = NULL,
  sourceTableName,
  targetDatabaseName = NULL,
  targetSchemaName = NULL,
  workgroupName
)
}
\arguments{
\item{activateCaseSensitiveIdentifier}{Indicates whether name identifiers for database, schema, and table are
case sensitive. If true, the names are case sensitive. If false, the
names are not case sensitive. The default is false.}

\item{namespaceName}{[required] Namespace of the recovery point to restore from.}

\item{newTableName}{[required] The name of the table to create from the restore operation.}

\item{recoveryPointId}{[required] The ID of the recovery point to restore the table from.}

\item{sourceDatabaseName}{[required] The name of the source database that contains the table being restored.}

\item{sourceSchemaName}{The name of the source schema that contains the table being restored.}

\item{sourceTableName}{[required] The name of the source table being restored.}

\item{targetDatabaseName}{The name of the database to restore the table to.}

\item{targetSchemaName}{The name of the schema to restore the table to.}

\item{workgroupName}{[required] The workgroup to restore the table to.}
}
\description{
Restores a table from a recovery point to your Amazon Redshift Serverless instance. You can't use this operation to restore tables with interleaved sort keys.

See \url{https://www.paws-r-sdk.com/docs/redshiftserverless_restore_table_from_recovery_point/} for full documentation.
}
\keyword{internal}
