# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include dynamodb_service.R
NULL

#' This operation allows you to perform batch reads or writes on data
#' stored in DynamoDB, using PartiQL
#'
#' @description
#' This operation allows you to perform batch reads or writes on data stored in DynamoDB, using PartiQL. Each read statement in a [`batch_execute_statement`][dynamodb_batch_execute_statement] must specify an equality condition on all key attributes. This enforces that each `SELECT` statement in a batch returns at most a single item.
#'
#' See [https://www.paws-r-sdk.com/docs/dynamodb_batch_execute_statement/](https://www.paws-r-sdk.com/docs/dynamodb_batch_execute_statement/) for full documentation.
#'
#' @param Statements &#91;required&#93; The list of PartiQL statements representing the batch to run.
#' @param ReturnConsumedCapacity 
#'
#' @keywords internal
#'
#' @rdname dynamodb_batch_execute_statement
dynamodb_batch_execute_statement <- function(Statements, ReturnConsumedCapacity = NULL) {
  op <- new_operation(
    name = "BatchExecuteStatement",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .dynamodb$batch_execute_statement_input(Statements = Statements, ReturnConsumedCapacity = ReturnConsumedCapacity)
  output <- .dynamodb$batch_execute_statement_output()
  config <- get_config()
  svc <- .dynamodb$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.dynamodb$operations$batch_execute_statement <- dynamodb_batch_execute_statement

#' The BatchGetItem operation returns the attributes of one or more items
#' from one or more tables
#'
#' @description
#' The [`batch_get_item`][dynamodb_batch_get_item] operation returns the attributes of one or more items from one or more tables. You identify requested items by primary key.
#'
#' See [https://www.paws-r-sdk.com/docs/dynamodb_batch_get_item/](https://www.paws-r-sdk.com/docs/dynamodb_batch_get_item/) for full documentation.
#'
#' @param RequestItems &#91;required&#93; A map of one or more table names and, for each table, a map that
#' describes one or more items to retrieve from that table. Each table name
#' can be used only once per [`batch_get_item`][dynamodb_batch_get_item]
#' request.
#' 
#' Each element in the map of items to retrieve consists of the following:
#' 
#' -   `ConsistentRead` - If `true`, a strongly consistent read is used; if
#'     `false` (the default), an eventually consistent read is used.
#' 
#' -   `ExpressionAttributeNames` - One or more substitution tokens for
#'     attribute names in the `ProjectionExpression` parameter. The
#'     following are some use cases for using `ExpressionAttributeNames`:
#' 
#'     -   To access an attribute whose name conflicts with a DynamoDB
#'         reserved word.
#' 
#'     -   To create a placeholder for repeating occurrences of an
#'         attribute name in an expression.
#' 
#'     -   To prevent special characters in an attribute name from being
#'         misinterpreted in an expression.
#' 
#'     Use the **#** character in an expression to dereference an
#'     attribute name. For example, consider the following attribute name:
#' 
#'     -   `Percentile`
#' 
#'     The name of this attribute conflicts with a reserved word, so it
#'     cannot be used directly in an expression. (For the complete list of
#'     reserved words, see [Reserved
#'     Words](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/ReservedWords.html)
#'     in the *Amazon DynamoDB Developer Guide*). To work around this, you
#'     could specify the following for `ExpressionAttributeNames`:
#' 
#'     -   `{"#P":"Percentile"}`
#' 
#'     You could then use this substitution in an expression, as in this
#'     example:
#' 
#'     -   `#P = :val`
#' 
#'     Tokens that begin with the **:** character are *expression attribute
#'     values*, which are placeholders for the actual value at runtime.
#' 
#'     For more information about expression attribute names, see
#'     [Accessing Item
#'     Attributes](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.Attributes.html)
#'     in the *Amazon DynamoDB Developer Guide*.
#' 
#' -   `Keys` - An array of primary key attribute values that define
#'     specific items in the table. For each primary key, you must provide
#'     *all* of the key attributes. For example, with a simple primary key,
#'     you only need to provide the partition key value. For a composite
#'     key, you must provide *both* the partition key value and the sort
#'     key value.
#' 
#' -   `ProjectionExpression` - A string that identifies one or more
#'     attributes to retrieve from the table. These attributes can include
#'     scalars, sets, or elements of a JSON document. The attributes in the
#'     expression must be separated by commas.
#' 
#'     If no attribute names are specified, then all attributes are
#'     returned. If any of the requested attributes are not found, they do
#'     not appear in the result.
#' 
#'     For more information, see [Accessing Item
#'     Attributes](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.Attributes.html)
#'     in the *Amazon DynamoDB Developer Guide*.
#' 
#' -   `AttributesToGet` - This is a legacy parameter. Use
#'     `ProjectionExpression` instead. For more information, see
#'     [AttributesToGet](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.AttributesToGet.html)
#'     in the *Amazon DynamoDB Developer Guide*.
#' @param ReturnConsumedCapacity 
#'
#' @keywords internal
#'
#' @rdname dynamodb_batch_get_item
dynamodb_batch_get_item <- function(RequestItems, ReturnConsumedCapacity = NULL) {
  op <- new_operation(
    name = "BatchGetItem",
    http_method = "POST",
    http_path = "/",
    paginator = list(input_token = "RequestItems", output_token = "UnprocessedKeys")
  )
  input <- .dynamodb$batch_get_item_input(RequestItems = RequestItems, ReturnConsumedCapacity = ReturnConsumedCapacity)
  output <- .dynamodb$batch_get_item_output()
  config <- get_config()
  svc <- .dynamodb$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.dynamodb$operations$batch_get_item <- dynamodb_batch_get_item

#' The BatchWriteItem operation puts or deletes multiple items in one or
#' more tables
#'
#' @description
#' The [`batch_write_item`][dynamodb_batch_write_item] operation puts or deletes multiple items in one or more tables. A single call to [`batch_write_item`][dynamodb_batch_write_item] can transmit up to 16MB of data over the network, consisting of up to 25 item put or delete operations. While individual items can be up to 400 KB once stored, it's important to note that an item's representation might be greater than 400KB while being sent in DynamoDB's JSON format for the API call. For more details on this distinction, see [Naming Rules and Data Types](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/HowItWorks.NamingRulesDataTypes.html).
#'
#' See [https://www.paws-r-sdk.com/docs/dynamodb_batch_write_item/](https://www.paws-r-sdk.com/docs/dynamodb_batch_write_item/) for full documentation.
#'
#' @param RequestItems &#91;required&#93; A map of one or more table names and, for each table, a list of
#' operations to be performed (`DeleteRequest` or `PutRequest`). Each
#' element in the map consists of the following:
#' 
#' -   `DeleteRequest` - Perform a [`delete_item`][dynamodb_delete_item]
#'     operation on the specified item. The item to be deleted is
#'     identified by a `Key` subelement:
#' 
#'     -   `Key` - A map of primary key attribute values that uniquely
#'         identify the item. Each entry in this map consists of an
#'         attribute name and an attribute value. For each primary key, you
#'         must provide *all* of the key attributes. For example, with a
#'         simple primary key, you only need to provide a value for the
#'         partition key. For a composite primary key, you must provide
#'         values for *both* the partition key and the sort key.
#' 
#' -   `PutRequest` - Perform a [`put_item`][dynamodb_put_item] operation
#'     on the specified item. The item to be put is identified by an `Item`
#'     subelement:
#' 
#'     -   `Item` - A map of attributes and their values. Each entry in
#'         this map consists of an attribute name and an attribute value.
#'         Attribute values must not be null; string and binary type
#'         attributes must have lengths greater than zero; and set type
#'         attributes must not be empty. Requests that contain empty values
#'         are rejected with a `ValidationException` exception.
#' 
#'         If you specify any attributes that are part of an index key,
#'         then the data types for those attributes must match those of the
#'         schema in the table's attribute definition.
#' @param ReturnConsumedCapacity 
#' @param ReturnItemCollectionMetrics Determines whether item collection metrics are returned. If set to
#' `SIZE`, the response includes statistics about item collections, if any,
#' that were modified during the operation are returned in the response. If
#' set to `NONE` (the default), no statistics are returned.
#'
#' @keywords internal
#'
#' @rdname dynamodb_batch_write_item
dynamodb_batch_write_item <- function(RequestItems, ReturnConsumedCapacity = NULL, ReturnItemCollectionMetrics = NULL) {
  op <- new_operation(
    name = "BatchWriteItem",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .dynamodb$batch_write_item_input(RequestItems = RequestItems, ReturnConsumedCapacity = ReturnConsumedCapacity, ReturnItemCollectionMetrics = ReturnItemCollectionMetrics)
  output <- .dynamodb$batch_write_item_output()
  config <- get_config()
  svc <- .dynamodb$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.dynamodb$operations$batch_write_item <- dynamodb_batch_write_item

#' Creates a backup for an existing table
#'
#' @description
#' Creates a backup for an existing table.
#'
#' See [https://www.paws-r-sdk.com/docs/dynamodb_create_backup/](https://www.paws-r-sdk.com/docs/dynamodb_create_backup/) for full documentation.
#'
#' @param TableName &#91;required&#93; The name of the table.
#' @param BackupName &#91;required&#93; Specified name for the backup.
#'
#' @keywords internal
#'
#' @rdname dynamodb_create_backup
dynamodb_create_backup <- function(TableName, BackupName) {
  op <- new_operation(
    name = "CreateBackup",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .dynamodb$create_backup_input(TableName = TableName, BackupName = BackupName)
  output <- .dynamodb$create_backup_output()
  config <- get_config()
  svc <- .dynamodb$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.dynamodb$operations$create_backup <- dynamodb_create_backup

#' Creates a global table from an existing table
#'
#' @description
#' Creates a global table from an existing table. A global table creates a replication relationship between two or more DynamoDB tables with the same table name in the provided Regions.
#'
#' See [https://www.paws-r-sdk.com/docs/dynamodb_create_global_table/](https://www.paws-r-sdk.com/docs/dynamodb_create_global_table/) for full documentation.
#'
#' @param GlobalTableName &#91;required&#93; The global table name.
#' @param ReplicationGroup &#91;required&#93; The Regions where the global table needs to be created.
#'
#' @keywords internal
#'
#' @rdname dynamodb_create_global_table
dynamodb_create_global_table <- function(GlobalTableName, ReplicationGroup) {
  op <- new_operation(
    name = "CreateGlobalTable",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .dynamodb$create_global_table_input(GlobalTableName = GlobalTableName, ReplicationGroup = ReplicationGroup)
  output <- .dynamodb$create_global_table_output()
  config <- get_config()
  svc <- .dynamodb$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.dynamodb$operations$create_global_table <- dynamodb_create_global_table

#' The CreateTable operation adds a new table to your account
#'
#' @description
#' The [`create_table`][dynamodb_create_table] operation adds a new table to your account. In an Amazon Web Services account, table names must be unique within each Region. That is, you can have two tables with same name if you create the tables in different Regions.
#'
#' See [https://www.paws-r-sdk.com/docs/dynamodb_create_table/](https://www.paws-r-sdk.com/docs/dynamodb_create_table/) for full documentation.
#'
#' @param AttributeDefinitions &#91;required&#93; An array of attributes that describe the key schema for the table and
#' indexes.
#' @param TableName &#91;required&#93; The name of the table to create.
#' @param KeySchema &#91;required&#93; Specifies the attributes that make up the primary key for a table or an
#' index. The attributes in `KeySchema` must also be defined in the
#' `AttributeDefinitions` array. For more information, see [Data
#' Model](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/HowItWorks.html)
#' in the *Amazon DynamoDB Developer Guide*.
#' 
#' Each `KeySchemaElement` in the array is composed of:
#' 
#' -   `AttributeName` - The name of this key attribute.
#' 
#' -   `KeyType` - The role that the key attribute will assume:
#' 
#'     -   `HASH` - partition key
#' 
#'     -   `RANGE` - sort key
#' 
#' The partition key of an item is also known as its *hash attribute*. The
#' term "hash attribute" derives from the DynamoDB usage of an internal
#' hash function to evenly distribute data items across partitions, based
#' on their partition key values.
#' 
#' The sort key of an item is also known as its *range attribute*. The term
#' "range attribute" derives from the way DynamoDB stores items with the
#' same partition key physically close together, in sorted order by the
#' sort key value.
#' 
#' For a simple primary key (partition key), you must provide exactly one
#' element with a `KeyType` of `HASH`.
#' 
#' For a composite primary key (partition key and sort key), you must
#' provide exactly two elements, in this order: The first element must have
#' a `KeyType` of `HASH`, and the second element must have a `KeyType` of
#' `RANGE`.
#' 
#' For more information, see [Working with
#' Tables](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/WorkingWithTables.html#WorkingWithTables.primary.key)
#' in the *Amazon DynamoDB Developer Guide*.
#' @param LocalSecondaryIndexes One or more local secondary indexes (the maximum is 5) to be created on
#' the table. Each index is scoped to a given partition key value. There is
#' a 10 GB size limit per partition key value; otherwise, the size of a
#' local secondary index is unconstrained.
#' 
#' Each local secondary index in the array includes the following:
#' 
#' -   `IndexName` - The name of the local secondary index. Must be unique
#'     only for this table.
#' 
#' -   `KeySchema` - Specifies the key schema for the local secondary
#'     index. The key schema must begin with the same partition key as the
#'     table.
#' 
#' -   `Projection` - Specifies attributes that are copied (projected) from
#'     the table into the index. These are in addition to the primary key
#'     attributes and index key attributes, which are automatically
#'     projected. Each attribute specification is composed of:
#' 
#'     -   `ProjectionType` - One of the following:
#' 
#'         -   `KEYS_ONLY` - Only the index and primary keys are projected
#'             into the index.
#' 
#'         -   `INCLUDE` - Only the specified table attributes are
#'             projected into the index. The list of projected attributes
#'             is in `NonKeyAttributes`.
#' 
#'         -   `ALL` - All of the table attributes are projected into the
#'             index.
#' 
#'     -   `NonKeyAttributes` - A list of one or more non-key attribute
#'         names that are projected into the secondary index. The total
#'         count of attributes provided in `NonKeyAttributes`, summed
#'         across all of the secondary indexes, must not exceed 100. If you
#'         project the same attribute into two different indexes, this
#'         counts as two distinct attributes when determining the total.
#' @param GlobalSecondaryIndexes One or more global secondary indexes (the maximum is 20) to be created
#' on the table. Each global secondary index in the array includes the
#' following:
#' 
#' -   `IndexName` - The name of the global secondary index. Must be unique
#'     only for this table.
#' 
#' -   `KeySchema` - Specifies the key schema for the global secondary
#'     index.
#' 
#' -   `Projection` - Specifies attributes that are copied (projected) from
#'     the table into the index. These are in addition to the primary key
#'     attributes and index key attributes, which are automatically
#'     projected. Each attribute specification is composed of:
#' 
#'     -   `ProjectionType` - One of the following:
#' 
#'         -   `KEYS_ONLY` - Only the index and primary keys are projected
#'             into the index.
#' 
#'         -   `INCLUDE` - Only the specified table attributes are
#'             projected into the index. The list of projected attributes
#'             is in `NonKeyAttributes`.
#' 
#'         -   `ALL` - All of the table attributes are projected into the
#'             index.
#' 
#'     -   `NonKeyAttributes` - A list of one or more non-key attribute
#'         names that are projected into the secondary index. The total
#'         count of attributes provided in `NonKeyAttributes`, summed
#'         across all of the secondary indexes, must not exceed 100. If you
#'         project the same attribute into two different indexes, this
#'         counts as two distinct attributes when determining the total.
#' 
#' -   `ProvisionedThroughput` - The provisioned throughput settings for
#'     the global secondary index, consisting of read and write capacity
#'     units.
#' @param BillingMode Controls how you are charged for read and write throughput and how you
#' manage capacity. This setting can be changed later.
#' 
#' -   `PROVISIONED` - We recommend using `PROVISIONED` for predictable
#'     workloads. `PROVISIONED` sets the billing mode to [Provisioned
#'     Mode](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/HowItWorks.ReadWriteCapacityMode.html#HowItWorks.ProvisionedThroughput.Manual).
#' 
#' -   `PAY_PER_REQUEST` - We recommend using `PAY_PER_REQUEST` for
#'     unpredictable workloads. `PAY_PER_REQUEST` sets the billing mode to
#'     [On-Demand
#'     Mode](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/HowItWorks.ReadWriteCapacityMode.html#HowItWorks.OnDemand).
#' @param ProvisionedThroughput Represents the provisioned throughput settings for a specified table or
#' index. The settings can be modified using the
#' [`update_table`][dynamodb_update_table] operation.
#' 
#' If you set BillingMode as `PROVISIONED`, you must specify this property.
#' If you set BillingMode as `PAY_PER_REQUEST`, you cannot specify this
#' property.
#' 
#' For current minimum and maximum provisioned throughput values, see
#' [Service, Account, and Table
#' Quotas](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/ServiceQuotas.html)
#' in the *Amazon DynamoDB Developer Guide*.
#' @param StreamSpecification The settings for DynamoDB Streams on the table. These settings consist
#' of:
#' 
#' -   `StreamEnabled` - Indicates whether DynamoDB Streams is to be
#'     enabled (true) or disabled (false).
#' 
#' -   `StreamViewType` - When an item in the table is modified,
#'     `StreamViewType` determines what information is written to the
#'     table's stream. Valid values for `StreamViewType` are:
#' 
#'     -   `KEYS_ONLY` - Only the key attributes of the modified item are
#'         written to the stream.
#' 
#'     -   `NEW_IMAGE` - The entire item, as it appears after it was
#'         modified, is written to the stream.
#' 
#'     -   `OLD_IMAGE` - The entire item, as it appeared before it was
#'         modified, is written to the stream.
#' 
#'     -   `NEW_AND_OLD_IMAGES` - Both the new and the old item images of
#'         the item are written to the stream.
#' @param SSESpecification Represents the settings used to enable server-side encryption.
#' @param Tags A list of key-value pairs to label the table. For more information, see
#' [Tagging for
#' DynamoDB](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Tagging.html).
#' @param TableClass The table class of the new table. Valid values are `STANDARD` and
#' `STANDARD_INFREQUENT_ACCESS`.
#' @param DeletionProtectionEnabled Indicates whether deletion protection is to be enabled (true) or
#' disabled (false) on the table.
#'
#' @keywords internal
#'
#' @rdname dynamodb_create_table
dynamodb_create_table <- function(AttributeDefinitions, TableName, KeySchema, LocalSecondaryIndexes = NULL, GlobalSecondaryIndexes = NULL, BillingMode = NULL, ProvisionedThroughput = NULL, StreamSpecification = NULL, SSESpecification = NULL, Tags = NULL, TableClass = NULL, DeletionProtectionEnabled = NULL) {
  op <- new_operation(
    name = "CreateTable",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .dynamodb$create_table_input(AttributeDefinitions = AttributeDefinitions, TableName = TableName, KeySchema = KeySchema, LocalSecondaryIndexes = LocalSecondaryIndexes, GlobalSecondaryIndexes = GlobalSecondaryIndexes, BillingMode = BillingMode, ProvisionedThroughput = ProvisionedThroughput, StreamSpecification = StreamSpecification, SSESpecification = SSESpecification, Tags = Tags, TableClass = TableClass, DeletionProtectionEnabled = DeletionProtectionEnabled)
  output <- .dynamodb$create_table_output()
  config <- get_config()
  svc <- .dynamodb$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.dynamodb$operations$create_table <- dynamodb_create_table

#' Deletes an existing backup of a table
#'
#' @description
#' Deletes an existing backup of a table.
#'
#' See [https://www.paws-r-sdk.com/docs/dynamodb_delete_backup/](https://www.paws-r-sdk.com/docs/dynamodb_delete_backup/) for full documentation.
#'
#' @param BackupArn &#91;required&#93; The ARN associated with the backup.
#'
#' @keywords internal
#'
#' @rdname dynamodb_delete_backup
dynamodb_delete_backup <- function(BackupArn) {
  op <- new_operation(
    name = "DeleteBackup",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .dynamodb$delete_backup_input(BackupArn = BackupArn)
  output <- .dynamodb$delete_backup_output()
  config <- get_config()
  svc <- .dynamodb$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.dynamodb$operations$delete_backup <- dynamodb_delete_backup

#' Deletes a single item in a table by primary key
#'
#' @description
#' Deletes a single item in a table by primary key. You can perform a conditional delete operation that deletes the item if it exists, or if it has an expected attribute value.
#'
#' See [https://www.paws-r-sdk.com/docs/dynamodb_delete_item/](https://www.paws-r-sdk.com/docs/dynamodb_delete_item/) for full documentation.
#'
#' @param TableName &#91;required&#93; The name of the table from which to delete the item.
#' @param Key &#91;required&#93; A map of attribute names to `AttributeValue` objects, representing the
#' primary key of the item to delete.
#' 
#' For the primary key, you must provide all of the key attributes. For
#' example, with a simple primary key, you only need to provide a value for
#' the partition key. For a composite primary key, you must provide values
#' for both the partition key and the sort key.
#' @param Expected This is a legacy parameter. Use `ConditionExpression` instead. For more
#' information, see
#' [Expected](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.Expected.html)
#' in the *Amazon DynamoDB Developer Guide*.
#' @param ConditionalOperator This is a legacy parameter. Use `ConditionExpression` instead. For more
#' information, see
#' [ConditionalOperator](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.ConditionalOperator.html)
#' in the *Amazon DynamoDB Developer Guide*.
#' @param ReturnValues Use `ReturnValues` if you want to get the item attributes as they
#' appeared before they were deleted. For
#' [`delete_item`][dynamodb_delete_item], the valid values are:
#' 
#' -   `NONE` - If `ReturnValues` is not specified, or if its value is
#'     `NONE`, then nothing is returned. (This setting is the default for
#'     `ReturnValues`.)
#' 
#' -   `ALL_OLD` - The content of the old item is returned.
#' 
#' There is no additional cost associated with requesting a return value
#' aside from the small network and processing overhead of receiving a
#' larger response. No read capacity units are consumed.
#' 
#' The `ReturnValues` parameter is used by several DynamoDB operations;
#' however, [`delete_item`][dynamodb_delete_item] does not recognize any
#' values other than `NONE` or `ALL_OLD`.
#' @param ReturnConsumedCapacity 
#' @param ReturnItemCollectionMetrics Determines whether item collection metrics are returned. If set to
#' `SIZE`, the response includes statistics about item collections, if any,
#' that were modified during the operation are returned in the response. If
#' set to `NONE` (the default), no statistics are returned.
#' @param ConditionExpression A condition that must be satisfied in order for a conditional
#' [`delete_item`][dynamodb_delete_item] to succeed.
#' 
#' An expression can contain any of the following:
#' 
#' -   Functions:
#'     `attribute_exists | attribute_not_exists | attribute_type | contains | begins_with | size`
#' 
#'     These function names are case-sensitive.
#' 
#' -   Comparison operators: `= | <> | < | > | <= | >= | BETWEEN | IN `
#' 
#' -   Logical operators: `AND | OR | NOT`
#' 
#' For more information about condition expressions, see [Condition
#' Expressions](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.ConditionExpressions.html)
#' in the *Amazon DynamoDB Developer Guide*.
#' @param ExpressionAttributeNames One or more substitution tokens for attribute names in an expression.
#' The following are some use cases for using `ExpressionAttributeNames`:
#' 
#' -   To access an attribute whose name conflicts with a DynamoDB reserved
#'     word.
#' 
#' -   To create a placeholder for repeating occurrences of an attribute
#'     name in an expression.
#' 
#' -   To prevent special characters in an attribute name from being
#'     misinterpreted in an expression.
#' 
#' Use the **#** character in an expression to dereference an attribute
#' name. For example, consider the following attribute name:
#' 
#' -   `Percentile`
#' 
#' The name of this attribute conflicts with a reserved word, so it cannot
#' be used directly in an expression. (For the complete list of reserved
#' words, see [Reserved
#' Words](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/ReservedWords.html)
#' in the *Amazon DynamoDB Developer Guide*). To work around this, you
#' could specify the following for `ExpressionAttributeNames`:
#' 
#' -   `{"#P":"Percentile"}`
#' 
#' You could then use this substitution in an expression, as in this
#' example:
#' 
#' -   `#P = :val`
#' 
#' Tokens that begin with the **:** character are *expression attribute
#' values*, which are placeholders for the actual value at runtime.
#' 
#' For more information on expression attribute names, see [Specifying Item
#' Attributes](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.Attributes.html)
#' in the *Amazon DynamoDB Developer Guide*.
#' @param ExpressionAttributeValues One or more values that can be substituted in an expression.
#' 
#' Use the **:** (colon) character in an expression to dereference an
#' attribute value. For example, suppose that you wanted to check whether
#' the value of the *ProductStatus* attribute was one of the following:
#' 
#' `Available | Backordered | Discontinued`
#' 
#' You would first need to specify `ExpressionAttributeValues` as follows:
#' 
#' `{ ":avail":{"S":"Available"}, ":back":{"S":"Backordered"}, ":disc":{"S":"Discontinued"} }`
#' 
#' You could then use these values in an expression, such as this:
#' 
#' `ProductStatus IN (:avail, :back, :disc)`
#' 
#' For more information on expression attribute values, see [Condition
#' Expressions](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.ConditionExpressions.html)
#' in the *Amazon DynamoDB Developer Guide*.
#' @param ReturnValuesOnConditionCheckFailure An optional parameter that returns the item attributes for a
#' [`delete_item`][dynamodb_delete_item] operation that failed a condition
#' check.
#' 
#' There is no additional cost associated with requesting a return value
#' aside from the small network and processing overhead of receiving a
#' larger response. No read capacity units are consumed.
#'
#' @keywords internal
#'
#' @rdname dynamodb_delete_item
dynamodb_delete_item <- function(TableName, Key, Expected = NULL, ConditionalOperator = NULL, ReturnValues = NULL, ReturnConsumedCapacity = NULL, ReturnItemCollectionMetrics = NULL, ConditionExpression = NULL, ExpressionAttributeNames = NULL, ExpressionAttributeValues = NULL, ReturnValuesOnConditionCheckFailure = NULL) {
  op <- new_operation(
    name = "DeleteItem",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .dynamodb$delete_item_input(TableName = TableName, Key = Key, Expected = Expected, ConditionalOperator = ConditionalOperator, ReturnValues = ReturnValues, ReturnConsumedCapacity = ReturnConsumedCapacity, ReturnItemCollectionMetrics = ReturnItemCollectionMetrics, ConditionExpression = ConditionExpression, ExpressionAttributeNames = ExpressionAttributeNames, ExpressionAttributeValues = ExpressionAttributeValues, ReturnValuesOnConditionCheckFailure = ReturnValuesOnConditionCheckFailure)
  output <- .dynamodb$delete_item_output()
  config <- get_config()
  svc <- .dynamodb$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.dynamodb$operations$delete_item <- dynamodb_delete_item

#' The DeleteTable operation deletes a table and all of its items
#'
#' @description
#' The [`delete_table`][dynamodb_delete_table] operation deletes a table and all of its items. After a [`delete_table`][dynamodb_delete_table] request, the specified table is in the `DELETING` state until DynamoDB completes the deletion. If the table is in the `ACTIVE` state, you can delete it. If a table is in `CREATING` or `UPDATING` states, then DynamoDB returns a `ResourceInUseException`. If the specified table does not exist, DynamoDB returns a `ResourceNotFoundException`. If table is already in the `DELETING` state, no error is returned.
#'
#' See [https://www.paws-r-sdk.com/docs/dynamodb_delete_table/](https://www.paws-r-sdk.com/docs/dynamodb_delete_table/) for full documentation.
#'
#' @param TableName &#91;required&#93; The name of the table to delete.
#'
#' @keywords internal
#'
#' @rdname dynamodb_delete_table
dynamodb_delete_table <- function(TableName) {
  op <- new_operation(
    name = "DeleteTable",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .dynamodb$delete_table_input(TableName = TableName)
  output <- .dynamodb$delete_table_output()
  config <- get_config()
  svc <- .dynamodb$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.dynamodb$operations$delete_table <- dynamodb_delete_table

#' Describes an existing backup of a table
#'
#' @description
#' Describes an existing backup of a table.
#'
#' See [https://www.paws-r-sdk.com/docs/dynamodb_describe_backup/](https://www.paws-r-sdk.com/docs/dynamodb_describe_backup/) for full documentation.
#'
#' @param BackupArn &#91;required&#93; The Amazon Resource Name (ARN) associated with the backup.
#'
#' @keywords internal
#'
#' @rdname dynamodb_describe_backup
dynamodb_describe_backup <- function(BackupArn) {
  op <- new_operation(
    name = "DescribeBackup",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .dynamodb$describe_backup_input(BackupArn = BackupArn)
  output <- .dynamodb$describe_backup_output()
  config <- get_config()
  svc <- .dynamodb$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.dynamodb$operations$describe_backup <- dynamodb_describe_backup

#' Checks the status of continuous backups and point in time recovery on
#' the specified table
#'
#' @description
#' Checks the status of continuous backups and point in time recovery on the specified table. Continuous backups are `ENABLED` on all tables at table creation. If point in time recovery is enabled, `PointInTimeRecoveryStatus` will be set to ENABLED.
#'
#' See [https://www.paws-r-sdk.com/docs/dynamodb_describe_continuous_backups/](https://www.paws-r-sdk.com/docs/dynamodb_describe_continuous_backups/) for full documentation.
#'
#' @param TableName &#91;required&#93; Name of the table for which the customer wants to check the continuous
#' backups and point in time recovery settings.
#'
#' @keywords internal
#'
#' @rdname dynamodb_describe_continuous_backups
dynamodb_describe_continuous_backups <- function(TableName) {
  op <- new_operation(
    name = "DescribeContinuousBackups",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .dynamodb$describe_continuous_backups_input(TableName = TableName)
  output <- .dynamodb$describe_continuous_backups_output()
  config <- get_config()
  svc <- .dynamodb$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.dynamodb$operations$describe_continuous_backups <- dynamodb_describe_continuous_backups

#' Returns information about contributor insights for a given table or
#' global secondary index
#'
#' @description
#' Returns information about contributor insights for a given table or global secondary index.
#'
#' See [https://www.paws-r-sdk.com/docs/dynamodb_describe_contributor_insights/](https://www.paws-r-sdk.com/docs/dynamodb_describe_contributor_insights/) for full documentation.
#'
#' @param TableName &#91;required&#93; The name of the table to describe.
#' @param IndexName The name of the global secondary index to describe, if applicable.
#'
#' @keywords internal
#'
#' @rdname dynamodb_describe_contributor_insights
dynamodb_describe_contributor_insights <- function(TableName, IndexName = NULL) {
  op <- new_operation(
    name = "DescribeContributorInsights",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .dynamodb$describe_contributor_insights_input(TableName = TableName, IndexName = IndexName)
  output <- .dynamodb$describe_contributor_insights_output()
  config <- get_config()
  svc <- .dynamodb$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.dynamodb$operations$describe_contributor_insights <- dynamodb_describe_contributor_insights

#' Returns the regional endpoint information
#'
#' @description
#' Returns the regional endpoint information. For more information on policy permissions, please see [Internetwork traffic privacy](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/inter-network-traffic-privacy.html#inter-network-traffic-DescribeEndpoints).
#'
#' See [https://www.paws-r-sdk.com/docs/dynamodb_describe_endpoints/](https://www.paws-r-sdk.com/docs/dynamodb_describe_endpoints/) for full documentation.
#'
#' @keywords internal
#'
#' @rdname dynamodb_describe_endpoints
dynamodb_describe_endpoints <- function() {
  op <- new_operation(
    name = "DescribeEndpoints",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .dynamodb$describe_endpoints_input()
  output <- .dynamodb$describe_endpoints_output()
  config <- get_config()
  svc <- .dynamodb$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.dynamodb$operations$describe_endpoints <- dynamodb_describe_endpoints

#' Describes an existing table export
#'
#' @description
#' Describes an existing table export.
#'
#' See [https://www.paws-r-sdk.com/docs/dynamodb_describe_export/](https://www.paws-r-sdk.com/docs/dynamodb_describe_export/) for full documentation.
#'
#' @param ExportArn &#91;required&#93; The Amazon Resource Name (ARN) associated with the export.
#'
#' @keywords internal
#'
#' @rdname dynamodb_describe_export
dynamodb_describe_export <- function(ExportArn) {
  op <- new_operation(
    name = "DescribeExport",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .dynamodb$describe_export_input(ExportArn = ExportArn)
  output <- .dynamodb$describe_export_output()
  config <- get_config()
  svc <- .dynamodb$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.dynamodb$operations$describe_export <- dynamodb_describe_export

#' Returns information about the specified global table
#'
#' @description
#' Returns information about the specified global table.
#'
#' See [https://www.paws-r-sdk.com/docs/dynamodb_describe_global_table/](https://www.paws-r-sdk.com/docs/dynamodb_describe_global_table/) for full documentation.
#'
#' @param GlobalTableName &#91;required&#93; The name of the global table.
#'
#' @keywords internal
#'
#' @rdname dynamodb_describe_global_table
dynamodb_describe_global_table <- function(GlobalTableName) {
  op <- new_operation(
    name = "DescribeGlobalTable",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .dynamodb$describe_global_table_input(GlobalTableName = GlobalTableName)
  output <- .dynamodb$describe_global_table_output()
  config <- get_config()
  svc <- .dynamodb$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.dynamodb$operations$describe_global_table <- dynamodb_describe_global_table

#' Describes Region-specific settings for a global table
#'
#' @description
#' Describes Region-specific settings for a global table.
#'
#' See [https://www.paws-r-sdk.com/docs/dynamodb_describe_global_table_settings/](https://www.paws-r-sdk.com/docs/dynamodb_describe_global_table_settings/) for full documentation.
#'
#' @param GlobalTableName &#91;required&#93; The name of the global table to describe.
#'
#' @keywords internal
#'
#' @rdname dynamodb_describe_global_table_settings
dynamodb_describe_global_table_settings <- function(GlobalTableName) {
  op <- new_operation(
    name = "DescribeGlobalTableSettings",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .dynamodb$describe_global_table_settings_input(GlobalTableName = GlobalTableName)
  output <- .dynamodb$describe_global_table_settings_output()
  config <- get_config()
  svc <- .dynamodb$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.dynamodb$operations$describe_global_table_settings <- dynamodb_describe_global_table_settings

#' Represents the properties of the import
#'
#' @description
#' Represents the properties of the import.
#'
#' See [https://www.paws-r-sdk.com/docs/dynamodb_describe_import/](https://www.paws-r-sdk.com/docs/dynamodb_describe_import/) for full documentation.
#'
#' @param ImportArn &#91;required&#93; The Amazon Resource Name (ARN) associated with the table you're
#' importing to.
#'
#' @keywords internal
#'
#' @rdname dynamodb_describe_import
dynamodb_describe_import <- function(ImportArn) {
  op <- new_operation(
    name = "DescribeImport",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .dynamodb$describe_import_input(ImportArn = ImportArn)
  output <- .dynamodb$describe_import_output()
  config <- get_config()
  svc <- .dynamodb$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.dynamodb$operations$describe_import <- dynamodb_describe_import

#' Returns information about the status of Kinesis streaming
#'
#' @description
#' Returns information about the status of Kinesis streaming.
#'
#' See [https://www.paws-r-sdk.com/docs/dynamodb_describe_kinesis_streaming_destination/](https://www.paws-r-sdk.com/docs/dynamodb_describe_kinesis_streaming_destination/) for full documentation.
#'
#' @param TableName &#91;required&#93; The name of the table being described.
#'
#' @keywords internal
#'
#' @rdname dynamodb_describe_kinesis_streaming_destination
dynamodb_describe_kinesis_streaming_destination <- function(TableName) {
  op <- new_operation(
    name = "DescribeKinesisStreamingDestination",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .dynamodb$describe_kinesis_streaming_destination_input(TableName = TableName)
  output <- .dynamodb$describe_kinesis_streaming_destination_output()
  config <- get_config()
  svc <- .dynamodb$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.dynamodb$operations$describe_kinesis_streaming_destination <- dynamodb_describe_kinesis_streaming_destination

#' Returns the current provisioned-capacity quotas for your Amazon Web
#' Services account in a Region, both for the Region as a whole and for any
#' one DynamoDB table that you create there
#'
#' @description
#' Returns the current provisioned-capacity quotas for your Amazon Web Services account in a Region, both for the Region as a whole and for any one DynamoDB table that you create there.
#'
#' See [https://www.paws-r-sdk.com/docs/dynamodb_describe_limits/](https://www.paws-r-sdk.com/docs/dynamodb_describe_limits/) for full documentation.
#'
#' @keywords internal
#'
#' @rdname dynamodb_describe_limits
dynamodb_describe_limits <- function() {
  op <- new_operation(
    name = "DescribeLimits",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .dynamodb$describe_limits_input()
  output <- .dynamodb$describe_limits_output()
  config <- get_config()
  svc <- .dynamodb$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.dynamodb$operations$describe_limits <- dynamodb_describe_limits

#' Returns information about the table, including the current status of the
#' table, when it was created, the primary key schema, and any indexes on
#' the table
#'
#' @description
#' Returns information about the table, including the current status of the table, when it was created, the primary key schema, and any indexes on the table.
#'
#' See [https://www.paws-r-sdk.com/docs/dynamodb_describe_table/](https://www.paws-r-sdk.com/docs/dynamodb_describe_table/) for full documentation.
#'
#' @param TableName &#91;required&#93; The name of the table to describe.
#'
#' @keywords internal
#'
#' @rdname dynamodb_describe_table
dynamodb_describe_table <- function(TableName) {
  op <- new_operation(
    name = "DescribeTable",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .dynamodb$describe_table_input(TableName = TableName)
  output <- .dynamodb$describe_table_output()
  config <- get_config()
  svc <- .dynamodb$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.dynamodb$operations$describe_table <- dynamodb_describe_table

#' Describes auto scaling settings across replicas of the global table at
#' once
#'
#' @description
#' Describes auto scaling settings across replicas of the global table at once.
#'
#' See [https://www.paws-r-sdk.com/docs/dynamodb_describe_table_replica_auto_scaling/](https://www.paws-r-sdk.com/docs/dynamodb_describe_table_replica_auto_scaling/) for full documentation.
#'
#' @param TableName &#91;required&#93; The name of the table.
#'
#' @keywords internal
#'
#' @rdname dynamodb_describe_table_replica_auto_scaling
dynamodb_describe_table_replica_auto_scaling <- function(TableName) {
  op <- new_operation(
    name = "DescribeTableReplicaAutoScaling",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .dynamodb$describe_table_replica_auto_scaling_input(TableName = TableName)
  output <- .dynamodb$describe_table_replica_auto_scaling_output()
  config <- get_config()
  svc <- .dynamodb$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.dynamodb$operations$describe_table_replica_auto_scaling <- dynamodb_describe_table_replica_auto_scaling

#' Gives a description of the Time to Live (TTL) status on the specified
#' table
#'
#' @description
#' Gives a description of the Time to Live (TTL) status on the specified table.
#'
#' See [https://www.paws-r-sdk.com/docs/dynamodb_describe_time_to_live/](https://www.paws-r-sdk.com/docs/dynamodb_describe_time_to_live/) for full documentation.
#'
#' @param TableName &#91;required&#93; The name of the table to be described.
#'
#' @keywords internal
#'
#' @rdname dynamodb_describe_time_to_live
dynamodb_describe_time_to_live <- function(TableName) {
  op <- new_operation(
    name = "DescribeTimeToLive",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .dynamodb$describe_time_to_live_input(TableName = TableName)
  output <- .dynamodb$describe_time_to_live_output()
  config <- get_config()
  svc <- .dynamodb$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.dynamodb$operations$describe_time_to_live <- dynamodb_describe_time_to_live

#' Stops replication from the DynamoDB table to the Kinesis data stream
#'
#' @description
#' Stops replication from the DynamoDB table to the Kinesis data stream. This is done without deleting either of the resources.
#'
#' See [https://www.paws-r-sdk.com/docs/dynamodb_disable_kinesis_streaming_destination/](https://www.paws-r-sdk.com/docs/dynamodb_disable_kinesis_streaming_destination/) for full documentation.
#'
#' @param TableName &#91;required&#93; The name of the DynamoDB table.
#' @param StreamArn &#91;required&#93; The ARN for a Kinesis data stream.
#'
#' @keywords internal
#'
#' @rdname dynamodb_disable_kinesis_streaming_destination
dynamodb_disable_kinesis_streaming_destination <- function(TableName, StreamArn) {
  op <- new_operation(
    name = "DisableKinesisStreamingDestination",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .dynamodb$disable_kinesis_streaming_destination_input(TableName = TableName, StreamArn = StreamArn)
  output <- .dynamodb$disable_kinesis_streaming_destination_output()
  config <- get_config()
  svc <- .dynamodb$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.dynamodb$operations$disable_kinesis_streaming_destination <- dynamodb_disable_kinesis_streaming_destination

#' Starts table data replication to the specified Kinesis data stream at a
#' timestamp chosen during the enable workflow
#'
#' @description
#' Starts table data replication to the specified Kinesis data stream at a timestamp chosen during the enable workflow. If this operation doesn't return results immediately, use DescribeKinesisStreamingDestination to check if streaming to the Kinesis data stream is ACTIVE.
#'
#' See [https://www.paws-r-sdk.com/docs/dynamodb_enable_kinesis_streaming_destination/](https://www.paws-r-sdk.com/docs/dynamodb_enable_kinesis_streaming_destination/) for full documentation.
#'
#' @param TableName &#91;required&#93; The name of the DynamoDB table.
#' @param StreamArn &#91;required&#93; The ARN for a Kinesis data stream.
#'
#' @keywords internal
#'
#' @rdname dynamodb_enable_kinesis_streaming_destination
dynamodb_enable_kinesis_streaming_destination <- function(TableName, StreamArn) {
  op <- new_operation(
    name = "EnableKinesisStreamingDestination",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .dynamodb$enable_kinesis_streaming_destination_input(TableName = TableName, StreamArn = StreamArn)
  output <- .dynamodb$enable_kinesis_streaming_destination_output()
  config <- get_config()
  svc <- .dynamodb$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.dynamodb$operations$enable_kinesis_streaming_destination <- dynamodb_enable_kinesis_streaming_destination

#' This operation allows you to perform reads and singleton writes on data
#' stored in DynamoDB, using PartiQL
#'
#' @description
#' This operation allows you to perform reads and singleton writes on data stored in DynamoDB, using PartiQL.
#'
#' See [https://www.paws-r-sdk.com/docs/dynamodb_execute_statement/](https://www.paws-r-sdk.com/docs/dynamodb_execute_statement/) for full documentation.
#'
#' @param Statement &#91;required&#93; The PartiQL statement representing the operation to run.
#' @param Parameters The parameters for the PartiQL statement, if any.
#' @param ConsistentRead The consistency of a read operation. If set to `true`, then a strongly
#' consistent read is used; otherwise, an eventually consistent read is
#' used.
#' @param NextToken Set this value to get remaining results, if `NextToken` was returned in
#' the statement response.
#' @param ReturnConsumedCapacity 
#' @param Limit The maximum number of items to evaluate (not necessarily the number of
#' matching items). If DynamoDB processes the number of items up to the
#' limit while processing the results, it stops the operation and returns
#' the matching values up to that point, along with a key in
#' `LastEvaluatedKey` to apply in a subsequent operation so you can pick up
#' where you left off. Also, if the processed dataset size exceeds 1 MB
#' before DynamoDB reaches this limit, it stops the operation and returns
#' the matching values up to the limit, and a key in `LastEvaluatedKey` to
#' apply in a subsequent operation to continue the operation.
#' @param ReturnValuesOnConditionCheckFailure An optional parameter that returns the item attributes for an
#' [`execute_statement`][dynamodb_execute_statement] operation that failed
#' a condition check.
#' 
#' There is no additional cost associated with requesting a return value
#' aside from the small network and processing overhead of receiving a
#' larger response. No read capacity units are consumed.
#'
#' @keywords internal
#'
#' @rdname dynamodb_execute_statement
dynamodb_execute_statement <- function(Statement, Parameters = NULL, ConsistentRead = NULL, NextToken = NULL, ReturnConsumedCapacity = NULL, Limit = NULL, ReturnValuesOnConditionCheckFailure = NULL) {
  op <- new_operation(
    name = "ExecuteStatement",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .dynamodb$execute_statement_input(Statement = Statement, Parameters = Parameters, ConsistentRead = ConsistentRead, NextToken = NextToken, ReturnConsumedCapacity = ReturnConsumedCapacity, Limit = Limit, ReturnValuesOnConditionCheckFailure = ReturnValuesOnConditionCheckFailure)
  output <- .dynamodb$execute_statement_output()
  config <- get_config()
  svc <- .dynamodb$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.dynamodb$operations$execute_statement <- dynamodb_execute_statement

#' This operation allows you to perform transactional reads or writes on
#' data stored in DynamoDB, using PartiQL
#'
#' @description
#' This operation allows you to perform transactional reads or writes on data stored in DynamoDB, using PartiQL.
#'
#' See [https://www.paws-r-sdk.com/docs/dynamodb_execute_transaction/](https://www.paws-r-sdk.com/docs/dynamodb_execute_transaction/) for full documentation.
#'
#' @param TransactStatements &#91;required&#93; The list of PartiQL statements representing the transaction to run.
#' @param ClientRequestToken Set this value to get remaining results, if `NextToken` was returned in
#' the statement response.
#' @param ReturnConsumedCapacity Determines the level of detail about either provisioned or on-demand
#' throughput consumption that is returned in the response. For more
#' information, see [`transact_get_items`][dynamodb_transact_get_items] and
#' [`transact_write_items`][dynamodb_transact_write_items].
#'
#' @keywords internal
#'
#' @rdname dynamodb_execute_transaction
dynamodb_execute_transaction <- function(TransactStatements, ClientRequestToken = NULL, ReturnConsumedCapacity = NULL) {
  op <- new_operation(
    name = "ExecuteTransaction",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .dynamodb$execute_transaction_input(TransactStatements = TransactStatements, ClientRequestToken = ClientRequestToken, ReturnConsumedCapacity = ReturnConsumedCapacity)
  output <- .dynamodb$execute_transaction_output()
  config <- get_config()
  svc <- .dynamodb$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.dynamodb$operations$execute_transaction <- dynamodb_execute_transaction

#' Exports table data to an S3 bucket
#'
#' @description
#' Exports table data to an S3 bucket. The table must have point in time recovery enabled, and you can export data from any time within the point in time recovery window.
#'
#' See [https://www.paws-r-sdk.com/docs/dynamodb_export_table_to_point_in_time/](https://www.paws-r-sdk.com/docs/dynamodb_export_table_to_point_in_time/) for full documentation.
#'
#' @param TableArn &#91;required&#93; The Amazon Resource Name (ARN) associated with the table to export.
#' @param ExportTime Time in the past from which to export table data, counted in seconds
#' from the start of the Unix epoch. The table export will be a snapshot of
#' the table's state at this point in time.
#' @param ClientToken Providing a `ClientToken` makes the call to
#' `ExportTableToPointInTimeInput` idempotent, meaning that multiple
#' identical calls have the same effect as one single call.
#' 
#' A client token is valid for 8 hours after the first request that uses it
#' is completed. After 8 hours, any request with the same client token is
#' treated as a new request. Do not resubmit the same request with the same
#' client token for more than 8 hours, or the result might not be
#' idempotent.
#' 
#' If you submit a request with the same client token but a change in other
#' parameters within the 8-hour idempotency window, DynamoDB returns an
#' `ImportConflictException`.
#' @param S3Bucket &#91;required&#93; The name of the Amazon S3 bucket to export the snapshot to.
#' @param S3BucketOwner The ID of the Amazon Web Services account that owns the bucket the
#' export will be stored in.
#' @param S3Prefix The Amazon S3 bucket prefix to use as the file name and path of the
#' exported snapshot.
#' @param S3SseAlgorithm Type of encryption used on the bucket where export data will be stored.
#' Valid values for `S3SseAlgorithm` are:
#' 
#' -   `AES256` - server-side encryption with Amazon S3 managed keys
#' 
#' -   `KMS` - server-side encryption with KMS managed keys
#' @param S3SseKmsKeyId The ID of the KMS managed key used to encrypt the S3 bucket where export
#' data will be stored (if applicable).
#' @param ExportFormat The format for the exported data. Valid values for `ExportFormat` are
#' `DYNAMODB_JSON` or `ION`.
#' @param ExportType Choice of whether to execute as a full export or incremental export.
#' Valid values are FULL_EXPORT or INCREMENTAL_EXPORT. The default value is
#' FULL_EXPORT. If INCREMENTAL_EXPORT is provided, the
#' IncrementalExportSpecification must also be used.
#' @param IncrementalExportSpecification Optional object containing the parameters specific to an incremental
#' export.
#'
#' @keywords internal
#'
#' @rdname dynamodb_export_table_to_point_in_time
dynamodb_export_table_to_point_in_time <- function(TableArn, ExportTime = NULL, ClientToken = NULL, S3Bucket, S3BucketOwner = NULL, S3Prefix = NULL, S3SseAlgorithm = NULL, S3SseKmsKeyId = NULL, ExportFormat = NULL, ExportType = NULL, IncrementalExportSpecification = NULL) {
  op <- new_operation(
    name = "ExportTableToPointInTime",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .dynamodb$export_table_to_point_in_time_input(TableArn = TableArn, ExportTime = ExportTime, ClientToken = ClientToken, S3Bucket = S3Bucket, S3BucketOwner = S3BucketOwner, S3Prefix = S3Prefix, S3SseAlgorithm = S3SseAlgorithm, S3SseKmsKeyId = S3SseKmsKeyId, ExportFormat = ExportFormat, ExportType = ExportType, IncrementalExportSpecification = IncrementalExportSpecification)
  output <- .dynamodb$export_table_to_point_in_time_output()
  config <- get_config()
  svc <- .dynamodb$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.dynamodb$operations$export_table_to_point_in_time <- dynamodb_export_table_to_point_in_time

#' The GetItem operation returns a set of attributes for the item with the
#' given primary key
#'
#' @description
#' The [`get_item`][dynamodb_get_item] operation returns a set of attributes for the item with the given primary key. If there is no matching item, [`get_item`][dynamodb_get_item] does not return any data and there will be no `Item` element in the response.
#'
#' See [https://www.paws-r-sdk.com/docs/dynamodb_get_item/](https://www.paws-r-sdk.com/docs/dynamodb_get_item/) for full documentation.
#'
#' @param TableName &#91;required&#93; The name of the table containing the requested item.
#' @param Key &#91;required&#93; A map of attribute names to `AttributeValue` objects, representing the
#' primary key of the item to retrieve.
#' 
#' For the primary key, you must provide all of the attributes. For
#' example, with a simple primary key, you only need to provide a value for
#' the partition key. For a composite primary key, you must provide values
#' for both the partition key and the sort key.
#' @param AttributesToGet This is a legacy parameter. Use `ProjectionExpression` instead. For more
#' information, see
#' [AttributesToGet](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.AttributesToGet.html)
#' in the *Amazon DynamoDB Developer Guide*.
#' @param ConsistentRead Determines the read consistency model: If set to `true`, then the
#' operation uses strongly consistent reads; otherwise, the operation uses
#' eventually consistent reads.
#' @param ReturnConsumedCapacity 
#' @param ProjectionExpression A string that identifies one or more attributes to retrieve from the
#' table. These attributes can include scalars, sets, or elements of a JSON
#' document. The attributes in the expression must be separated by commas.
#' 
#' If no attribute names are specified, then all attributes are returned.
#' If any of the requested attributes are not found, they do not appear in
#' the result.
#' 
#' For more information, see [Specifying Item
#' Attributes](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.Attributes.html)
#' in the *Amazon DynamoDB Developer Guide*.
#' @param ExpressionAttributeNames One or more substitution tokens for attribute names in an expression.
#' The following are some use cases for using `ExpressionAttributeNames`:
#' 
#' -   To access an attribute whose name conflicts with a DynamoDB reserved
#'     word.
#' 
#' -   To create a placeholder for repeating occurrences of an attribute
#'     name in an expression.
#' 
#' -   To prevent special characters in an attribute name from being
#'     misinterpreted in an expression.
#' 
#' Use the **#** character in an expression to dereference an attribute
#' name. For example, consider the following attribute name:
#' 
#' -   `Percentile`
#' 
#' The name of this attribute conflicts with a reserved word, so it cannot
#' be used directly in an expression. (For the complete list of reserved
#' words, see [Reserved
#' Words](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/ReservedWords.html)
#' in the *Amazon DynamoDB Developer Guide*). To work around this, you
#' could specify the following for `ExpressionAttributeNames`:
#' 
#' -   `{"#P":"Percentile"}`
#' 
#' You could then use this substitution in an expression, as in this
#' example:
#' 
#' -   `#P = :val`
#' 
#' Tokens that begin with the **:** character are *expression attribute
#' values*, which are placeholders for the actual value at runtime.
#' 
#' For more information on expression attribute names, see [Specifying Item
#' Attributes](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.Attributes.html)
#' in the *Amazon DynamoDB Developer Guide*.
#'
#' @keywords internal
#'
#' @rdname dynamodb_get_item
dynamodb_get_item <- function(TableName, Key, AttributesToGet = NULL, ConsistentRead = NULL, ReturnConsumedCapacity = NULL, ProjectionExpression = NULL, ExpressionAttributeNames = NULL) {
  op <- new_operation(
    name = "GetItem",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .dynamodb$get_item_input(TableName = TableName, Key = Key, AttributesToGet = AttributesToGet, ConsistentRead = ConsistentRead, ReturnConsumedCapacity = ReturnConsumedCapacity, ProjectionExpression = ProjectionExpression, ExpressionAttributeNames = ExpressionAttributeNames)
  output <- .dynamodb$get_item_output()
  config <- get_config()
  svc <- .dynamodb$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.dynamodb$operations$get_item <- dynamodb_get_item

#' Imports table data from an S3 bucket
#'
#' @description
#' Imports table data from an S3 bucket.
#'
#' See [https://www.paws-r-sdk.com/docs/dynamodb_import_table/](https://www.paws-r-sdk.com/docs/dynamodb_import_table/) for full documentation.
#'
#' @param ClientToken Providing a `ClientToken` makes the call to `ImportTableInput`
#' idempotent, meaning that multiple identical calls have the same effect
#' as one single call.
#' 
#' A client token is valid for 8 hours after the first request that uses it
#' is completed. After 8 hours, any request with the same client token is
#' treated as a new request. Do not resubmit the same request with the same
#' client token for more than 8 hours, or the result might not be
#' idempotent.
#' 
#' If you submit a request with the same client token but a change in other
#' parameters within the 8-hour idempotency window, DynamoDB returns an
#' `IdempotentParameterMismatch` exception.
#' @param S3BucketSource &#91;required&#93; The S3 bucket that provides the source for the import.
#' @param InputFormat &#91;required&#93; The format of the source data. Valid values for `ImportFormat` are
#' `CSV`, `DYNAMODB_JSON` or `ION`.
#' @param InputFormatOptions Additional properties that specify how the input is formatted,
#' @param InputCompressionType Type of compression to be used on the input coming from the imported
#' table.
#' @param TableCreationParameters &#91;required&#93; Parameters for the table to import the data into.
#'
#' @keywords internal
#'
#' @rdname dynamodb_import_table
dynamodb_import_table <- function(ClientToken = NULL, S3BucketSource, InputFormat, InputFormatOptions = NULL, InputCompressionType = NULL, TableCreationParameters) {
  op <- new_operation(
    name = "ImportTable",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .dynamodb$import_table_input(ClientToken = ClientToken, S3BucketSource = S3BucketSource, InputFormat = InputFormat, InputFormatOptions = InputFormatOptions, InputCompressionType = InputCompressionType, TableCreationParameters = TableCreationParameters)
  output <- .dynamodb$import_table_output()
  config <- get_config()
  svc <- .dynamodb$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.dynamodb$operations$import_table <- dynamodb_import_table

#' List DynamoDB backups that are associated with an Amazon Web Services
#' account and weren't made with Amazon Web Services Backup
#'
#' @description
#' List DynamoDB backups that are associated with an Amazon Web Services account and weren't made with Amazon Web Services Backup. To list these backups for a given table, specify `TableName`. [`list_backups`][dynamodb_list_backups] returns a paginated list of results with at most 1 MB worth of items in a page. You can also specify a maximum number of entries to be returned in a page.
#'
#' See [https://www.paws-r-sdk.com/docs/dynamodb_list_backups/](https://www.paws-r-sdk.com/docs/dynamodb_list_backups/) for full documentation.
#'
#' @param TableName The backups from the table specified by `TableName` are listed.
#' @param Limit Maximum number of backups to return at once.
#' @param TimeRangeLowerBound Only backups created after this time are listed. `TimeRangeLowerBound`
#' is inclusive.
#' @param TimeRangeUpperBound Only backups created before this time are listed. `TimeRangeUpperBound`
#' is exclusive.
#' @param ExclusiveStartBackupArn `LastEvaluatedBackupArn` is the Amazon Resource Name (ARN) of the backup
#' last evaluated when the current page of results was returned, inclusive
#' of the current page of results. This value may be specified as the
#' `ExclusiveStartBackupArn` of a new
#' [`list_backups`][dynamodb_list_backups] operation in order to fetch the
#' next page of results.
#' @param BackupType The backups from the table specified by `BackupType` are listed.
#' 
#' Where `BackupType` can be:
#' 
#' -   `USER` - On-demand backup created by you. (The default setting if no
#'     other backup types are specified.)
#' 
#' -   `SYSTEM` - On-demand backup automatically created by DynamoDB.
#' 
#' -   `ALL` - All types of on-demand backups (USER and SYSTEM).
#'
#' @keywords internal
#'
#' @rdname dynamodb_list_backups
dynamodb_list_backups <- function(TableName = NULL, Limit = NULL, TimeRangeLowerBound = NULL, TimeRangeUpperBound = NULL, ExclusiveStartBackupArn = NULL, BackupType = NULL) {
  op <- new_operation(
    name = "ListBackups",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .dynamodb$list_backups_input(TableName = TableName, Limit = Limit, TimeRangeLowerBound = TimeRangeLowerBound, TimeRangeUpperBound = TimeRangeUpperBound, ExclusiveStartBackupArn = ExclusiveStartBackupArn, BackupType = BackupType)
  output <- .dynamodb$list_backups_output()
  config <- get_config()
  svc <- .dynamodb$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.dynamodb$operations$list_backups <- dynamodb_list_backups

#' Returns a list of ContributorInsightsSummary for a table and all its
#' global secondary indexes
#'
#' @description
#' Returns a list of ContributorInsightsSummary for a table and all its global secondary indexes.
#'
#' See [https://www.paws-r-sdk.com/docs/dynamodb_list_contributor_insights/](https://www.paws-r-sdk.com/docs/dynamodb_list_contributor_insights/) for full documentation.
#'
#' @param TableName The name of the table.
#' @param NextToken A token to for the desired page, if there is one.
#' @param MaxResults Maximum number of results to return per page.
#'
#' @keywords internal
#'
#' @rdname dynamodb_list_contributor_insights
dynamodb_list_contributor_insights <- function(TableName = NULL, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListContributorInsights",
    http_method = "POST",
    http_path = "/",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken")
  )
  input <- .dynamodb$list_contributor_insights_input(TableName = TableName, NextToken = NextToken, MaxResults = MaxResults)
  output <- .dynamodb$list_contributor_insights_output()
  config <- get_config()
  svc <- .dynamodb$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.dynamodb$operations$list_contributor_insights <- dynamodb_list_contributor_insights

#' Lists completed exports within the past 90 days
#'
#' @description
#' Lists completed exports within the past 90 days.
#'
#' See [https://www.paws-r-sdk.com/docs/dynamodb_list_exports/](https://www.paws-r-sdk.com/docs/dynamodb_list_exports/) for full documentation.
#'
#' @param TableArn The Amazon Resource Name (ARN) associated with the exported table.
#' @param MaxResults Maximum number of results to return per page.
#' @param NextToken An optional string that, if supplied, must be copied from the output of
#' a previous call to [`list_exports`][dynamodb_list_exports]. When
#' provided in this manner, the API fetches the next page of results.
#'
#' @keywords internal
#'
#' @rdname dynamodb_list_exports
dynamodb_list_exports <- function(TableArn = NULL, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListExports",
    http_method = "POST",
    http_path = "/",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken")
  )
  input <- .dynamodb$list_exports_input(TableArn = TableArn, MaxResults = MaxResults, NextToken = NextToken)
  output <- .dynamodb$list_exports_output()
  config <- get_config()
  svc <- .dynamodb$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.dynamodb$operations$list_exports <- dynamodb_list_exports

#' Lists all global tables that have a replica in the specified Region
#'
#' @description
#' Lists all global tables that have a replica in the specified Region.
#'
#' See [https://www.paws-r-sdk.com/docs/dynamodb_list_global_tables/](https://www.paws-r-sdk.com/docs/dynamodb_list_global_tables/) for full documentation.
#'
#' @param ExclusiveStartGlobalTableName The first global table name that this operation will evaluate.
#' @param Limit The maximum number of table names to return, if the parameter is not
#' specified DynamoDB defaults to 100.
#' 
#' If the number of global tables DynamoDB finds reaches this limit, it
#' stops the operation and returns the table names collected up to that
#' point, with a table name in the `LastEvaluatedGlobalTableName` to apply
#' in a subsequent operation to the `ExclusiveStartGlobalTableName`
#' parameter.
#' @param RegionName Lists the global tables in a specific Region.
#'
#' @keywords internal
#'
#' @rdname dynamodb_list_global_tables
dynamodb_list_global_tables <- function(ExclusiveStartGlobalTableName = NULL, Limit = NULL, RegionName = NULL) {
  op <- new_operation(
    name = "ListGlobalTables",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .dynamodb$list_global_tables_input(ExclusiveStartGlobalTableName = ExclusiveStartGlobalTableName, Limit = Limit, RegionName = RegionName)
  output <- .dynamodb$list_global_tables_output()
  config <- get_config()
  svc <- .dynamodb$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.dynamodb$operations$list_global_tables <- dynamodb_list_global_tables

#' Lists completed imports within the past 90 days
#'
#' @description
#' Lists completed imports within the past 90 days.
#'
#' See [https://www.paws-r-sdk.com/docs/dynamodb_list_imports/](https://www.paws-r-sdk.com/docs/dynamodb_list_imports/) for full documentation.
#'
#' @param TableArn The Amazon Resource Name (ARN) associated with the table that was
#' imported to.
#' @param PageSize The number of `ImportSummary `objects returned in a single page.
#' @param NextToken An optional string that, if supplied, must be copied from the output of
#' a previous call to [`list_imports`][dynamodb_list_imports]. When
#' provided in this manner, the API fetches the next page of results.
#'
#' @keywords internal
#'
#' @rdname dynamodb_list_imports
dynamodb_list_imports <- function(TableArn = NULL, PageSize = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListImports",
    http_method = "POST",
    http_path = "/",
    paginator = list(input_token = "NextToken", limit_key = "PageSize", output_token = "NextToken")
  )
  input <- .dynamodb$list_imports_input(TableArn = TableArn, PageSize = PageSize, NextToken = NextToken)
  output <- .dynamodb$list_imports_output()
  config <- get_config()
  svc <- .dynamodb$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.dynamodb$operations$list_imports <- dynamodb_list_imports

#' Returns an array of table names associated with the current account and
#' endpoint
#'
#' @description
#' Returns an array of table names associated with the current account and endpoint. The output from [`list_tables`][dynamodb_list_tables] is paginated, with each page returning a maximum of 100 table names.
#'
#' See [https://www.paws-r-sdk.com/docs/dynamodb_list_tables/](https://www.paws-r-sdk.com/docs/dynamodb_list_tables/) for full documentation.
#'
#' @param ExclusiveStartTableName The first table name that this operation will evaluate. Use the value
#' that was returned for `LastEvaluatedTableName` in a previous operation,
#' so that you can obtain the next page of results.
#' @param Limit A maximum number of table names to return. If this parameter is not
#' specified, the limit is 100.
#'
#' @keywords internal
#'
#' @rdname dynamodb_list_tables
dynamodb_list_tables <- function(ExclusiveStartTableName = NULL, Limit = NULL) {
  op <- new_operation(
    name = "ListTables",
    http_method = "POST",
    http_path = "/",
    paginator = list(input_token = "ExclusiveStartTableName", limit_key = "Limit", output_token = "LastEvaluatedTableName", result_key = "TableNames")
  )
  input <- .dynamodb$list_tables_input(ExclusiveStartTableName = ExclusiveStartTableName, Limit = Limit)
  output <- .dynamodb$list_tables_output()
  config <- get_config()
  svc <- .dynamodb$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.dynamodb$operations$list_tables <- dynamodb_list_tables

#' List all tags on an Amazon DynamoDB resource
#'
#' @description
#' List all tags on an Amazon DynamoDB resource. You can call ListTagsOfResource up to 10 times per second, per account.
#'
#' See [https://www.paws-r-sdk.com/docs/dynamodb_list_tags_of_resource/](https://www.paws-r-sdk.com/docs/dynamodb_list_tags_of_resource/) for full documentation.
#'
#' @param ResourceArn &#91;required&#93; The Amazon DynamoDB resource with tags to be listed. This value is an
#' Amazon Resource Name (ARN).
#' @param NextToken An optional string that, if supplied, must be copied from the output of
#' a previous call to ListTagOfResource. When provided in this manner, this
#' API fetches the next page of results.
#'
#' @keywords internal
#'
#' @rdname dynamodb_list_tags_of_resource
dynamodb_list_tags_of_resource <- function(ResourceArn, NextToken = NULL) {
  op <- new_operation(
    name = "ListTagsOfResource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .dynamodb$list_tags_of_resource_input(ResourceArn = ResourceArn, NextToken = NextToken)
  output <- .dynamodb$list_tags_of_resource_output()
  config <- get_config()
  svc <- .dynamodb$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.dynamodb$operations$list_tags_of_resource <- dynamodb_list_tags_of_resource

#' Creates a new item, or replaces an old item with a new item
#'
#' @description
#' Creates a new item, or replaces an old item with a new item. If an item that has the same primary key as the new item already exists in the specified table, the new item completely replaces the existing item. You can perform a conditional put operation (add a new item if one with the specified primary key doesn't exist), or replace an existing item if it has certain attribute values. You can return the item's attribute values in the same operation, using the `ReturnValues` parameter.
#'
#' See [https://www.paws-r-sdk.com/docs/dynamodb_put_item/](https://www.paws-r-sdk.com/docs/dynamodb_put_item/) for full documentation.
#'
#' @param TableName &#91;required&#93; The name of the table to contain the item.
#' @param Item &#91;required&#93; A map of attribute name/value pairs, one for each attribute. Only the
#' primary key attributes are required; you can optionally provide other
#' attribute name-value pairs for the item.
#' 
#' You must provide all of the attributes for the primary key. For example,
#' with a simple primary key, you only need to provide a value for the
#' partition key. For a composite primary key, you must provide both values
#' for both the partition key and the sort key.
#' 
#' If you specify any attributes that are part of an index key, then the
#' data types for those attributes must match those of the schema in the
#' table's attribute definition.
#' 
#' Empty String and Binary attribute values are allowed. Attribute values
#' of type String and Binary must have a length greater than zero if the
#' attribute is used as a key attribute for a table or index.
#' 
#' For more information about primary keys, see [Primary
#' Key](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/HowItWorks.CoreComponents.html#HowItWorks.CoreComponents.PrimaryKey)
#' in the *Amazon DynamoDB Developer Guide*.
#' 
#' Each element in the `Item` map is an `AttributeValue` object.
#' @param Expected This is a legacy parameter. Use `ConditionExpression` instead. For more
#' information, see
#' [Expected](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.Expected.html)
#' in the *Amazon DynamoDB Developer Guide*.
#' @param ReturnValues Use `ReturnValues` if you want to get the item attributes as they
#' appeared before they were updated with the
#' [`put_item`][dynamodb_put_item] request. For
#' [`put_item`][dynamodb_put_item], the valid values are:
#' 
#' -   `NONE` - If `ReturnValues` is not specified, or if its value is
#'     `NONE`, then nothing is returned. (This setting is the default for
#'     `ReturnValues`.)
#' 
#' -   `ALL_OLD` - If [`put_item`][dynamodb_put_item] overwrote an
#'     attribute name-value pair, then the content of the old item is
#'     returned.
#' 
#' The values returned are strongly consistent.
#' 
#' There is no additional cost associated with requesting a return value
#' aside from the small network and processing overhead of receiving a
#' larger response. No read capacity units are consumed.
#' 
#' The `ReturnValues` parameter is used by several DynamoDB operations;
#' however, [`put_item`][dynamodb_put_item] does not recognize any values
#' other than `NONE` or `ALL_OLD`.
#' @param ReturnConsumedCapacity 
#' @param ReturnItemCollectionMetrics Determines whether item collection metrics are returned. If set to
#' `SIZE`, the response includes statistics about item collections, if any,
#' that were modified during the operation are returned in the response. If
#' set to `NONE` (the default), no statistics are returned.
#' @param ConditionalOperator This is a legacy parameter. Use `ConditionExpression` instead. For more
#' information, see
#' [ConditionalOperator](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.ConditionalOperator.html)
#' in the *Amazon DynamoDB Developer Guide*.
#' @param ConditionExpression A condition that must be satisfied in order for a conditional
#' [`put_item`][dynamodb_put_item] operation to succeed.
#' 
#' An expression can contain any of the following:
#' 
#' -   Functions:
#'     `attribute_exists | attribute_not_exists | attribute_type | contains | begins_with | size`
#' 
#'     These function names are case-sensitive.
#' 
#' -   Comparison operators: `= | <> | < | > | <= | >= | BETWEEN | IN `
#' 
#' -   Logical operators: `AND | OR | NOT`
#' 
#' For more information on condition expressions, see [Condition
#' Expressions](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.ConditionExpressions.html)
#' in the *Amazon DynamoDB Developer Guide*.
#' @param ExpressionAttributeNames One or more substitution tokens for attribute names in an expression.
#' The following are some use cases for using `ExpressionAttributeNames`:
#' 
#' -   To access an attribute whose name conflicts with a DynamoDB reserved
#'     word.
#' 
#' -   To create a placeholder for repeating occurrences of an attribute
#'     name in an expression.
#' 
#' -   To prevent special characters in an attribute name from being
#'     misinterpreted in an expression.
#' 
#' Use the **#** character in an expression to dereference an attribute
#' name. For example, consider the following attribute name:
#' 
#' -   `Percentile`
#' 
#' The name of this attribute conflicts with a reserved word, so it cannot
#' be used directly in an expression. (For the complete list of reserved
#' words, see [Reserved
#' Words](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/ReservedWords.html)
#' in the *Amazon DynamoDB Developer Guide*). To work around this, you
#' could specify the following for `ExpressionAttributeNames`:
#' 
#' -   `{"#P":"Percentile"}`
#' 
#' You could then use this substitution in an expression, as in this
#' example:
#' 
#' -   `#P = :val`
#' 
#' Tokens that begin with the **:** character are *expression attribute
#' values*, which are placeholders for the actual value at runtime.
#' 
#' For more information on expression attribute names, see [Specifying Item
#' Attributes](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.Attributes.html)
#' in the *Amazon DynamoDB Developer Guide*.
#' @param ExpressionAttributeValues One or more values that can be substituted in an expression.
#' 
#' Use the **:** (colon) character in an expression to dereference an
#' attribute value. For example, suppose that you wanted to check whether
#' the value of the *ProductStatus* attribute was one of the following:
#' 
#' `Available | Backordered | Discontinued`
#' 
#' You would first need to specify `ExpressionAttributeValues` as follows:
#' 
#' `{ ":avail":{"S":"Available"}, ":back":{"S":"Backordered"}, ":disc":{"S":"Discontinued"} }`
#' 
#' You could then use these values in an expression, such as this:
#' 
#' `ProductStatus IN (:avail, :back, :disc)`
#' 
#' For more information on expression attribute values, see [Condition
#' Expressions](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.ConditionExpressions.html)
#' in the *Amazon DynamoDB Developer Guide*.
#' @param ReturnValuesOnConditionCheckFailure An optional parameter that returns the item attributes for a
#' [`put_item`][dynamodb_put_item] operation that failed a condition check.
#' 
#' There is no additional cost associated with requesting a return value
#' aside from the small network and processing overhead of receiving a
#' larger response. No read capacity units are consumed.
#'
#' @keywords internal
#'
#' @rdname dynamodb_put_item
dynamodb_put_item <- function(TableName, Item, Expected = NULL, ReturnValues = NULL, ReturnConsumedCapacity = NULL, ReturnItemCollectionMetrics = NULL, ConditionalOperator = NULL, ConditionExpression = NULL, ExpressionAttributeNames = NULL, ExpressionAttributeValues = NULL, ReturnValuesOnConditionCheckFailure = NULL) {
  op <- new_operation(
    name = "PutItem",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .dynamodb$put_item_input(TableName = TableName, Item = Item, Expected = Expected, ReturnValues = ReturnValues, ReturnConsumedCapacity = ReturnConsumedCapacity, ReturnItemCollectionMetrics = ReturnItemCollectionMetrics, ConditionalOperator = ConditionalOperator, ConditionExpression = ConditionExpression, ExpressionAttributeNames = ExpressionAttributeNames, ExpressionAttributeValues = ExpressionAttributeValues, ReturnValuesOnConditionCheckFailure = ReturnValuesOnConditionCheckFailure)
  output <- .dynamodb$put_item_output()
  config <- get_config()
  svc <- .dynamodb$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.dynamodb$operations$put_item <- dynamodb_put_item

#' You must provide the name of the partition key attribute and a single
#' value for that attribute
#'
#' @description
#' You must provide the name of the partition key attribute and a single value for that attribute. [`query`][dynamodb_query] returns all items with that partition key value. Optionally, you can provide a sort key attribute and use a comparison operator to refine the search results.
#'
#' See [https://www.paws-r-sdk.com/docs/dynamodb_query/](https://www.paws-r-sdk.com/docs/dynamodb_query/) for full documentation.
#'
#' @param TableName &#91;required&#93; The name of the table containing the requested items.
#' @param IndexName The name of an index to query. This index can be any local secondary
#' index or global secondary index on the table. Note that if you use the
#' `IndexName` parameter, you must also provide `TableName.`
#' @param Select The attributes to be returned in the result. You can retrieve all item
#' attributes, specific item attributes, the count of matching items, or in
#' the case of an index, some or all of the attributes projected into the
#' index.
#' 
#' -   `ALL_ATTRIBUTES` - Returns all of the item attributes from the
#'     specified table or index. If you query a local secondary index, then
#'     for each matching item in the index, DynamoDB fetches the entire
#'     item from the parent table. If the index is configured to project
#'     all item attributes, then all of the data can be obtained from the
#'     local secondary index, and no fetching is required.
#' 
#' -   `ALL_PROJECTED_ATTRIBUTES` - Allowed only when querying an index.
#'     Retrieves all attributes that have been projected into the index. If
#'     the index is configured to project all attributes, this return value
#'     is equivalent to specifying `ALL_ATTRIBUTES`.
#' 
#' -   `COUNT` - Returns the number of matching items, rather than the
#'     matching items themselves. Note that this uses the same quantity of
#'     read capacity units as getting the items, and is subject to the same
#'     item size calculations.
#' 
#' -   `SPECIFIC_ATTRIBUTES` - Returns only the attributes listed in
#'     `ProjectionExpression`. This return value is equivalent to
#'     specifying `ProjectionExpression` without specifying any value for
#'     `Select`.
#' 
#'     If you query or scan a local secondary index and request only
#'     attributes that are projected into that index, the operation will
#'     read only the index and not the table. If any of the requested
#'     attributes are not projected into the local secondary index,
#'     DynamoDB fetches each of these attributes from the parent table.
#'     This extra fetching incurs additional throughput cost and latency.
#' 
#'     If you query or scan a global secondary index, you can only request
#'     attributes that are projected into the index. Global secondary index
#'     queries cannot fetch attributes from the parent table.
#' 
#' If neither `Select` nor `ProjectionExpression` are specified, DynamoDB
#' defaults to `ALL_ATTRIBUTES` when accessing a table, and
#' `ALL_PROJECTED_ATTRIBUTES` when accessing an index. You cannot use both
#' `Select` and `ProjectionExpression` together in a single request, unless
#' the value for `Select` is `SPECIFIC_ATTRIBUTES`. (This usage is
#' equivalent to specifying `ProjectionExpression` without any value for
#' `Select`.)
#' 
#' If you use the `ProjectionExpression` parameter, then the value for
#' `Select` can only be `SPECIFIC_ATTRIBUTES`. Any other value for `Select`
#' will return an error.
#' @param AttributesToGet This is a legacy parameter. Use `ProjectionExpression` instead. For more
#' information, see
#' [AttributesToGet](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.AttributesToGet.html)
#' in the *Amazon DynamoDB Developer Guide*.
#' @param Limit The maximum number of items to evaluate (not necessarily the number of
#' matching items). If DynamoDB processes the number of items up to the
#' limit while processing the results, it stops the operation and returns
#' the matching values up to that point, and a key in `LastEvaluatedKey` to
#' apply in a subsequent operation, so that you can pick up where you left
#' off. Also, if the processed dataset size exceeds 1 MB before DynamoDB
#' reaches this limit, it stops the operation and returns the matching
#' values up to the limit, and a key in `LastEvaluatedKey` to apply in a
#' subsequent operation to continue the operation. For more information,
#' see [Query and
#' Scan](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Query.html)
#' in the *Amazon DynamoDB Developer Guide*.
#' @param ConsistentRead Determines the read consistency model: If set to `true`, then the
#' operation uses strongly consistent reads; otherwise, the operation uses
#' eventually consistent reads.
#' 
#' Strongly consistent reads are not supported on global secondary indexes.
#' If you query a global secondary index with `ConsistentRead` set to
#' `true`, you will receive a `ValidationException`.
#' @param KeyConditions This is a legacy parameter. Use `KeyConditionExpression` instead. For
#' more information, see
#' [KeyConditions](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.KeyConditions.html)
#' in the *Amazon DynamoDB Developer Guide*.
#' @param QueryFilter This is a legacy parameter. Use `FilterExpression` instead. For more
#' information, see
#' [QueryFilter](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.QueryFilter.html)
#' in the *Amazon DynamoDB Developer Guide*.
#' @param ConditionalOperator This is a legacy parameter. Use `FilterExpression` instead. For more
#' information, see
#' [ConditionalOperator](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.ConditionalOperator.html)
#' in the *Amazon DynamoDB Developer Guide*.
#' @param ScanIndexForward Specifies the order for index traversal: If `true` (default), the
#' traversal is performed in ascending order; if `false`, the traversal is
#' performed in descending order.
#' 
#' Items with the same partition key value are stored in sorted order by
#' sort key. If the sort key data type is Number, the results are stored in
#' numeric order. For type String, the results are stored in order of UTF-8
#' bytes. For type Binary, DynamoDB treats each byte of the binary data as
#' unsigned.
#' 
#' If `ScanIndexForward` is `true`, DynamoDB returns the results in the
#' order in which they are stored (by sort key value). This is the default
#' behavior. If `ScanIndexForward` is `false`, DynamoDB reads the results
#' in reverse order by sort key value, and then returns the results to the
#' client.
#' @param ExclusiveStartKey The primary key of the first item that this operation will evaluate. Use
#' the value that was returned for `LastEvaluatedKey` in the previous
#' operation.
#' 
#' The data type for `ExclusiveStartKey` must be String, Number, or Binary.
#' No set data types are allowed.
#' @param ReturnConsumedCapacity 
#' @param ProjectionExpression A string that identifies one or more attributes to retrieve from the
#' table. These attributes can include scalars, sets, or elements of a JSON
#' document. The attributes in the expression must be separated by commas.
#' 
#' If no attribute names are specified, then all attributes will be
#' returned. If any of the requested attributes are not found, they will
#' not appear in the result.
#' 
#' For more information, see [Accessing Item
#' Attributes](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.Attributes.html)
#' in the *Amazon DynamoDB Developer Guide*.
#' @param FilterExpression A string that contains conditions that DynamoDB applies after the
#' [`query`][dynamodb_query] operation, but before the data is returned to
#' you. Items that do not satisfy the `FilterExpression` criteria are not
#' returned.
#' 
#' A `FilterExpression` does not allow key attributes. You cannot define a
#' filter expression based on a partition key or a sort key.
#' 
#' A `FilterExpression` is applied after the items have already been read;
#' the process of filtering does not consume any additional read capacity
#' units.
#' 
#' For more information, see [Filter
#' Expressions](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Query.html#Query.FilterExpression)
#' in the *Amazon DynamoDB Developer Guide*.
#' @param KeyConditionExpression The condition that specifies the key values for items to be retrieved by
#' the [`query`][dynamodb_query] action.
#' 
#' The condition must perform an equality test on a single partition key
#' value.
#' 
#' The condition can optionally perform one of several comparison tests on
#' a single sort key value. This allows [`query`][dynamodb_query] to
#' retrieve one item with a given partition key value and sort key value,
#' or several items that have the same partition key value but different
#' sort key values.
#' 
#' The partition key equality test is required, and must be specified in
#' the following format:
#' 
#' `partitionKeyName` *=* `:partitionkeyval`
#' 
#' If you also want to provide a condition for the sort key, it must be
#' combined using `AND` with the condition for the sort key. Following is
#' an example, using the **=** comparison operator for the sort key:
#' 
#' `partitionKeyName` `=` `:partitionkeyval` `AND` `sortKeyName` `=`
#' `:sortkeyval`
#' 
#' Valid comparisons for the sort key condition are as follows:
#' 
#' -   `sortKeyName` `=` `:sortkeyval` - true if the sort key value is
#'     equal to `:sortkeyval`.
#' 
#' -   `sortKeyName` `<` `:sortkeyval` - true if the sort key value is less
#'     than `:sortkeyval`.
#' 
#' -   `sortKeyName` `<=` `:sortkeyval` - true if the sort key value is
#'     less than or equal to `:sortkeyval`.
#' 
#' -   `sortKeyName` `>` `:sortkeyval` - true if the sort key value is
#'     greater than `:sortkeyval`.
#' 
#' -   `sortKeyName` `>= ` `:sortkeyval` - true if the sort key value is
#'     greater than or equal to `:sortkeyval`.
#' 
#' -   `sortKeyName` `BETWEEN` `:sortkeyval1` `AND` `:sortkeyval2` - true
#'     if the sort key value is greater than or equal to `:sortkeyval1`,
#'     and less than or equal to `:sortkeyval2`.
#' 
#' -   `begins_with (` `sortKeyName`, `:sortkeyval` `)` - true if the sort
#'     key value begins with a particular operand. (You cannot use this
#'     function with a sort key that is of type Number.) Note that the
#'     function name `begins_with` is case-sensitive.
#' 
#' Use the `ExpressionAttributeValues` parameter to replace tokens such as
#' `:partitionval` and `:sortval` with actual values at runtime.
#' 
#' You can optionally use the `ExpressionAttributeNames` parameter to
#' replace the names of the partition key and sort key with placeholder
#' tokens. This option might be necessary if an attribute name conflicts
#' with a DynamoDB reserved word. For example, the following
#' `KeyConditionExpression` parameter causes an error because *Size* is a
#' reserved word:
#' 
#' -   `Size = :myval`
#' 
#' To work around this, define a placeholder (such a `#S`) to represent the
#' attribute name *Size*. `KeyConditionExpression` then is as follows:
#' 
#' -   `#S = :myval`
#' 
#' For a list of reserved words, see [Reserved
#' Words](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/ReservedWords.html)
#' in the *Amazon DynamoDB Developer Guide*.
#' 
#' For more information on `ExpressionAttributeNames` and
#' `ExpressionAttributeValues`, see [Using Placeholders for Attribute Names
#' and
#' Values](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.ExpressionAttributeNames.html)
#' in the *Amazon DynamoDB Developer Guide*.
#' @param ExpressionAttributeNames One or more substitution tokens for attribute names in an expression.
#' The following are some use cases for using `ExpressionAttributeNames`:
#' 
#' -   To access an attribute whose name conflicts with a DynamoDB reserved
#'     word.
#' 
#' -   To create a placeholder for repeating occurrences of an attribute
#'     name in an expression.
#' 
#' -   To prevent special characters in an attribute name from being
#'     misinterpreted in an expression.
#' 
#' Use the **#** character in an expression to dereference an attribute
#' name. For example, consider the following attribute name:
#' 
#' -   `Percentile`
#' 
#' The name of this attribute conflicts with a reserved word, so it cannot
#' be used directly in an expression. (For the complete list of reserved
#' words, see [Reserved
#' Words](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/ReservedWords.html)
#' in the *Amazon DynamoDB Developer Guide*). To work around this, you
#' could specify the following for `ExpressionAttributeNames`:
#' 
#' -   `{"#P":"Percentile"}`
#' 
#' You could then use this substitution in an expression, as in this
#' example:
#' 
#' -   `#P = :val`
#' 
#' Tokens that begin with the **:** character are *expression attribute
#' values*, which are placeholders for the actual value at runtime.
#' 
#' For more information on expression attribute names, see [Specifying Item
#' Attributes](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.Attributes.html)
#' in the *Amazon DynamoDB Developer Guide*.
#' @param ExpressionAttributeValues One or more values that can be substituted in an expression.
#' 
#' Use the **:** (colon) character in an expression to dereference an
#' attribute value. For example, suppose that you wanted to check whether
#' the value of the *ProductStatus* attribute was one of the following:
#' 
#' `Available | Backordered | Discontinued`
#' 
#' You would first need to specify `ExpressionAttributeValues` as follows:
#' 
#' `{ ":avail":{"S":"Available"}, ":back":{"S":"Backordered"}, ":disc":{"S":"Discontinued"} }`
#' 
#' You could then use these values in an expression, such as this:
#' 
#' `ProductStatus IN (:avail, :back, :disc)`
#' 
#' For more information on expression attribute values, see [Specifying
#' Conditions](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.ConditionExpressions.html)
#' in the *Amazon DynamoDB Developer Guide*.
#'
#' @keywords internal
#'
#' @rdname dynamodb_query
dynamodb_query <- function(TableName, IndexName = NULL, Select = NULL, AttributesToGet = NULL, Limit = NULL, ConsistentRead = NULL, KeyConditions = NULL, QueryFilter = NULL, ConditionalOperator = NULL, ScanIndexForward = NULL, ExclusiveStartKey = NULL, ReturnConsumedCapacity = NULL, ProjectionExpression = NULL, FilterExpression = NULL, KeyConditionExpression = NULL, ExpressionAttributeNames = NULL, ExpressionAttributeValues = NULL) {
  op <- new_operation(
    name = "Query",
    http_method = "POST",
    http_path = "/",
    paginator = list(input_token = "ExclusiveStartKey", limit_key = "Limit", output_token = "LastEvaluatedKey", result_key = "Items")
  )
  input <- .dynamodb$query_input(TableName = TableName, IndexName = IndexName, Select = Select, AttributesToGet = AttributesToGet, Limit = Limit, ConsistentRead = ConsistentRead, KeyConditions = KeyConditions, QueryFilter = QueryFilter, ConditionalOperator = ConditionalOperator, ScanIndexForward = ScanIndexForward, ExclusiveStartKey = ExclusiveStartKey, ReturnConsumedCapacity = ReturnConsumedCapacity, ProjectionExpression = ProjectionExpression, FilterExpression = FilterExpression, KeyConditionExpression = KeyConditionExpression, ExpressionAttributeNames = ExpressionAttributeNames, ExpressionAttributeValues = ExpressionAttributeValues)
  output <- .dynamodb$query_output()
  config <- get_config()
  svc <- .dynamodb$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.dynamodb$operations$query <- dynamodb_query

#' Creates a new table from an existing backup
#'
#' @description
#' Creates a new table from an existing backup. Any number of users can execute up to 50 concurrent restores (any type of restore) in a given account.
#'
#' See [https://www.paws-r-sdk.com/docs/dynamodb_restore_table_from_backup/](https://www.paws-r-sdk.com/docs/dynamodb_restore_table_from_backup/) for full documentation.
#'
#' @param TargetTableName &#91;required&#93; The name of the new table to which the backup must be restored.
#' @param BackupArn &#91;required&#93; The Amazon Resource Name (ARN) associated with the backup.
#' @param BillingModeOverride The billing mode of the restored table.
#' @param GlobalSecondaryIndexOverride List of global secondary indexes for the restored table. The indexes
#' provided should match existing secondary indexes. You can choose to
#' exclude some or all of the indexes at the time of restore.
#' @param LocalSecondaryIndexOverride List of local secondary indexes for the restored table. The indexes
#' provided should match existing secondary indexes. You can choose to
#' exclude some or all of the indexes at the time of restore.
#' @param ProvisionedThroughputOverride Provisioned throughput settings for the restored table.
#' @param SSESpecificationOverride The new server-side encryption settings for the restored table.
#'
#' @keywords internal
#'
#' @rdname dynamodb_restore_table_from_backup
dynamodb_restore_table_from_backup <- function(TargetTableName, BackupArn, BillingModeOverride = NULL, GlobalSecondaryIndexOverride = NULL, LocalSecondaryIndexOverride = NULL, ProvisionedThroughputOverride = NULL, SSESpecificationOverride = NULL) {
  op <- new_operation(
    name = "RestoreTableFromBackup",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .dynamodb$restore_table_from_backup_input(TargetTableName = TargetTableName, BackupArn = BackupArn, BillingModeOverride = BillingModeOverride, GlobalSecondaryIndexOverride = GlobalSecondaryIndexOverride, LocalSecondaryIndexOverride = LocalSecondaryIndexOverride, ProvisionedThroughputOverride = ProvisionedThroughputOverride, SSESpecificationOverride = SSESpecificationOverride)
  output <- .dynamodb$restore_table_from_backup_output()
  config <- get_config()
  svc <- .dynamodb$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.dynamodb$operations$restore_table_from_backup <- dynamodb_restore_table_from_backup

#' Restores the specified table to the specified point in time within
#' EarliestRestorableDateTime and LatestRestorableDateTime
#'
#' @description
#' Restores the specified table to the specified point in time within `EarliestRestorableDateTime` and `LatestRestorableDateTime`. You can restore your table to any point in time during the last 35 days. Any number of users can execute up to 4 concurrent restores (any type of restore) in a given account.
#'
#' See [https://www.paws-r-sdk.com/docs/dynamodb_restore_table_to_point_in_time/](https://www.paws-r-sdk.com/docs/dynamodb_restore_table_to_point_in_time/) for full documentation.
#'
#' @param SourceTableArn The DynamoDB table that will be restored. This value is an Amazon
#' Resource Name (ARN).
#' @param SourceTableName Name of the source table that is being restored.
#' @param TargetTableName &#91;required&#93; The name of the new table to which it must be restored to.
#' @param UseLatestRestorableTime Restore the table to the latest possible time.
#' `LatestRestorableDateTime` is typically 5 minutes before the current
#' time.
#' @param RestoreDateTime Time in the past to restore the table to.
#' @param BillingModeOverride The billing mode of the restored table.
#' @param GlobalSecondaryIndexOverride List of global secondary indexes for the restored table. The indexes
#' provided should match existing secondary indexes. You can choose to
#' exclude some or all of the indexes at the time of restore.
#' @param LocalSecondaryIndexOverride List of local secondary indexes for the restored table. The indexes
#' provided should match existing secondary indexes. You can choose to
#' exclude some or all of the indexes at the time of restore.
#' @param ProvisionedThroughputOverride Provisioned throughput settings for the restored table.
#' @param SSESpecificationOverride The new server-side encryption settings for the restored table.
#'
#' @keywords internal
#'
#' @rdname dynamodb_restore_table_to_point_in_time
dynamodb_restore_table_to_point_in_time <- function(SourceTableArn = NULL, SourceTableName = NULL, TargetTableName, UseLatestRestorableTime = NULL, RestoreDateTime = NULL, BillingModeOverride = NULL, GlobalSecondaryIndexOverride = NULL, LocalSecondaryIndexOverride = NULL, ProvisionedThroughputOverride = NULL, SSESpecificationOverride = NULL) {
  op <- new_operation(
    name = "RestoreTableToPointInTime",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .dynamodb$restore_table_to_point_in_time_input(SourceTableArn = SourceTableArn, SourceTableName = SourceTableName, TargetTableName = TargetTableName, UseLatestRestorableTime = UseLatestRestorableTime, RestoreDateTime = RestoreDateTime, BillingModeOverride = BillingModeOverride, GlobalSecondaryIndexOverride = GlobalSecondaryIndexOverride, LocalSecondaryIndexOverride = LocalSecondaryIndexOverride, ProvisionedThroughputOverride = ProvisionedThroughputOverride, SSESpecificationOverride = SSESpecificationOverride)
  output <- .dynamodb$restore_table_to_point_in_time_output()
  config <- get_config()
  svc <- .dynamodb$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.dynamodb$operations$restore_table_to_point_in_time <- dynamodb_restore_table_to_point_in_time

#' The Scan operation returns one or more items and item attributes by
#' accessing every item in a table or a secondary index
#'
#' @description
#' The [`scan`][dynamodb_scan] operation returns one or more items and item attributes by accessing every item in a table or a secondary index. To have DynamoDB return fewer items, you can provide a `FilterExpression` operation.
#'
#' See [https://www.paws-r-sdk.com/docs/dynamodb_scan/](https://www.paws-r-sdk.com/docs/dynamodb_scan/) for full documentation.
#'
#' @param TableName &#91;required&#93; The name of the table containing the requested items; or, if you provide
#' `IndexName`, the name of the table to which that index belongs.
#' @param IndexName The name of a secondary index to scan. This index can be any local
#' secondary index or global secondary index. Note that if you use the
#' `IndexName` parameter, you must also provide `TableName`.
#' @param AttributesToGet This is a legacy parameter. Use `ProjectionExpression` instead. For more
#' information, see
#' [AttributesToGet](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.AttributesToGet.html)
#' in the *Amazon DynamoDB Developer Guide*.
#' @param Limit The maximum number of items to evaluate (not necessarily the number of
#' matching items). If DynamoDB processes the number of items up to the
#' limit while processing the results, it stops the operation and returns
#' the matching values up to that point, and a key in `LastEvaluatedKey` to
#' apply in a subsequent operation, so that you can pick up where you left
#' off. Also, if the processed dataset size exceeds 1 MB before DynamoDB
#' reaches this limit, it stops the operation and returns the matching
#' values up to the limit, and a key in `LastEvaluatedKey` to apply in a
#' subsequent operation to continue the operation. For more information,
#' see [Working with
#' Queries](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Query.html)
#' in the *Amazon DynamoDB Developer Guide*.
#' @param Select The attributes to be returned in the result. You can retrieve all item
#' attributes, specific item attributes, the count of matching items, or in
#' the case of an index, some or all of the attributes projected into the
#' index.
#' 
#' -   `ALL_ATTRIBUTES` - Returns all of the item attributes from the
#'     specified table or index. If you query a local secondary index, then
#'     for each matching item in the index, DynamoDB fetches the entire
#'     item from the parent table. If the index is configured to project
#'     all item attributes, then all of the data can be obtained from the
#'     local secondary index, and no fetching is required.
#' 
#' -   `ALL_PROJECTED_ATTRIBUTES` - Allowed only when querying an index.
#'     Retrieves all attributes that have been projected into the index. If
#'     the index is configured to project all attributes, this return value
#'     is equivalent to specifying `ALL_ATTRIBUTES`.
#' 
#' -   `COUNT` - Returns the number of matching items, rather than the
#'     matching items themselves. Note that this uses the same quantity of
#'     read capacity units as getting the items, and is subject to the same
#'     item size calculations.
#' 
#' -   `SPECIFIC_ATTRIBUTES` - Returns only the attributes listed in
#'     `ProjectionExpression`. This return value is equivalent to
#'     specifying `ProjectionExpression` without specifying any value for
#'     `Select`.
#' 
#'     If you query or scan a local secondary index and request only
#'     attributes that are projected into that index, the operation reads
#'     only the index and not the table. If any of the requested attributes
#'     are not projected into the local secondary index, DynamoDB fetches
#'     each of these attributes from the parent table. This extra fetching
#'     incurs additional throughput cost and latency.
#' 
#'     If you query or scan a global secondary index, you can only request
#'     attributes that are projected into the index. Global secondary index
#'     queries cannot fetch attributes from the parent table.
#' 
#' If neither `Select` nor `ProjectionExpression` are specified, DynamoDB
#' defaults to `ALL_ATTRIBUTES` when accessing a table, and
#' `ALL_PROJECTED_ATTRIBUTES` when accessing an index. You cannot use both
#' `Select` and `ProjectionExpression` together in a single request, unless
#' the value for `Select` is `SPECIFIC_ATTRIBUTES`. (This usage is
#' equivalent to specifying `ProjectionExpression` without any value for
#' `Select`.)
#' 
#' If you use the `ProjectionExpression` parameter, then the value for
#' `Select` can only be `SPECIFIC_ATTRIBUTES`. Any other value for `Select`
#' will return an error.
#' @param ScanFilter This is a legacy parameter. Use `FilterExpression` instead. For more
#' information, see
#' [ScanFilter](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.ScanFilter.html)
#' in the *Amazon DynamoDB Developer Guide*.
#' @param ConditionalOperator This is a legacy parameter. Use `FilterExpression` instead. For more
#' information, see
#' [ConditionalOperator](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.ConditionalOperator.html)
#' in the *Amazon DynamoDB Developer Guide*.
#' @param ExclusiveStartKey The primary key of the first item that this operation will evaluate. Use
#' the value that was returned for `LastEvaluatedKey` in the previous
#' operation.
#' 
#' The data type for `ExclusiveStartKey` must be String, Number or Binary.
#' No set data types are allowed.
#' 
#' In a parallel scan, a [`scan`][dynamodb_scan] request that includes
#' `ExclusiveStartKey` must specify the same segment whose previous
#' [`scan`][dynamodb_scan] returned the corresponding value of
#' `LastEvaluatedKey`.
#' @param ReturnConsumedCapacity 
#' @param TotalSegments For a parallel [`scan`][dynamodb_scan] request, `TotalSegments`
#' represents the total number of segments into which the
#' [`scan`][dynamodb_scan] operation will be divided. The value of
#' `TotalSegments` corresponds to the number of application workers that
#' will perform the parallel scan. For example, if you want to use four
#' application threads to scan a table or an index, specify a
#' `TotalSegments` value of 4.
#' 
#' The value for `TotalSegments` must be greater than or equal to 1, and
#' less than or equal to 1000000. If you specify a `TotalSegments` value of
#' 1, the [`scan`][dynamodb_scan] operation will be sequential rather than
#' parallel.
#' 
#' If you specify `TotalSegments`, you must also specify `Segment`.
#' @param Segment For a parallel [`scan`][dynamodb_scan] request, `Segment` identifies an
#' individual segment to be scanned by an application worker.
#' 
#' Segment IDs are zero-based, so the first segment is always 0. For
#' example, if you want to use four application threads to scan a table or
#' an index, then the first thread specifies a `Segment` value of 0, the
#' second thread specifies 1, and so on.
#' 
#' The value of `LastEvaluatedKey` returned from a parallel
#' [`scan`][dynamodb_scan] request must be used as `ExclusiveStartKey` with
#' the same segment ID in a subsequent [`scan`][dynamodb_scan] operation.
#' 
#' The value for `Segment` must be greater than or equal to 0, and less
#' than the value provided for `TotalSegments`.
#' 
#' If you provide `Segment`, you must also provide `TotalSegments`.
#' @param ProjectionExpression A string that identifies one or more attributes to retrieve from the
#' specified table or index. These attributes can include scalars, sets, or
#' elements of a JSON document. The attributes in the expression must be
#' separated by commas.
#' 
#' If no attribute names are specified, then all attributes will be
#' returned. If any of the requested attributes are not found, they will
#' not appear in the result.
#' 
#' For more information, see [Specifying Item
#' Attributes](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.Attributes.html)
#' in the *Amazon DynamoDB Developer Guide*.
#' @param FilterExpression A string that contains conditions that DynamoDB applies after the
#' [`scan`][dynamodb_scan] operation, but before the data is returned to
#' you. Items that do not satisfy the `FilterExpression` criteria are not
#' returned.
#' 
#' A `FilterExpression` is applied after the items have already been read;
#' the process of filtering does not consume any additional read capacity
#' units.
#' 
#' For more information, see [Filter
#' Expressions](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Scan.html#Scan.FilterExpression)
#' in the *Amazon DynamoDB Developer Guide*.
#' @param ExpressionAttributeNames One or more substitution tokens for attribute names in an expression.
#' The following are some use cases for using `ExpressionAttributeNames`:
#' 
#' -   To access an attribute whose name conflicts with a DynamoDB reserved
#'     word.
#' 
#' -   To create a placeholder for repeating occurrences of an attribute
#'     name in an expression.
#' 
#' -   To prevent special characters in an attribute name from being
#'     misinterpreted in an expression.
#' 
#' Use the **#** character in an expression to dereference an attribute
#' name. For example, consider the following attribute name:
#' 
#' -   `Percentile`
#' 
#' The name of this attribute conflicts with a reserved word, so it cannot
#' be used directly in an expression. (For the complete list of reserved
#' words, see [Reserved
#' Words](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/ReservedWords.html)
#' in the *Amazon DynamoDB Developer Guide*). To work around this, you
#' could specify the following for `ExpressionAttributeNames`:
#' 
#' -   `{"#P":"Percentile"}`
#' 
#' You could then use this substitution in an expression, as in this
#' example:
#' 
#' -   `#P = :val`
#' 
#' Tokens that begin with the **:** character are *expression attribute
#' values*, which are placeholders for the actual value at runtime.
#' 
#' For more information on expression attribute names, see [Specifying Item
#' Attributes](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.Attributes.html)
#' in the *Amazon DynamoDB Developer Guide*.
#' @param ExpressionAttributeValues One or more values that can be substituted in an expression.
#' 
#' Use the **:** (colon) character in an expression to dereference an
#' attribute value. For example, suppose that you wanted to check whether
#' the value of the `ProductStatus` attribute was one of the following:
#' 
#' `Available | Backordered | Discontinued`
#' 
#' You would first need to specify `ExpressionAttributeValues` as follows:
#' 
#' `{ ":avail":{"S":"Available"}, ":back":{"S":"Backordered"}, ":disc":{"S":"Discontinued"} }`
#' 
#' You could then use these values in an expression, such as this:
#' 
#' `ProductStatus IN (:avail, :back, :disc)`
#' 
#' For more information on expression attribute values, see [Condition
#' Expressions](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.ConditionExpressions.html)
#' in the *Amazon DynamoDB Developer Guide*.
#' @param ConsistentRead A Boolean value that determines the read consistency model during the
#' scan:
#' 
#' -   If `ConsistentRead` is `false`, then the data returned from
#'     [`scan`][dynamodb_scan] might not contain the results from other
#'     recently completed write operations
#'     ([`put_item`][dynamodb_put_item],
#'     [`update_item`][dynamodb_update_item], or
#'     [`delete_item`][dynamodb_delete_item]).
#' 
#' -   If `ConsistentRead` is `true`, then all of the write operations that
#'     completed before the [`scan`][dynamodb_scan] began are guaranteed to
#'     be contained in the [`scan`][dynamodb_scan] response.
#' 
#' The default setting for `ConsistentRead` is `false`.
#' 
#' The `ConsistentRead` parameter is not supported on global secondary
#' indexes. If you scan a global secondary index with `ConsistentRead` set
#' to true, you will receive a `ValidationException`.
#'
#' @keywords internal
#'
#' @rdname dynamodb_scan
dynamodb_scan <- function(TableName, IndexName = NULL, AttributesToGet = NULL, Limit = NULL, Select = NULL, ScanFilter = NULL, ConditionalOperator = NULL, ExclusiveStartKey = NULL, ReturnConsumedCapacity = NULL, TotalSegments = NULL, Segment = NULL, ProjectionExpression = NULL, FilterExpression = NULL, ExpressionAttributeNames = NULL, ExpressionAttributeValues = NULL, ConsistentRead = NULL) {
  op <- new_operation(
    name = "Scan",
    http_method = "POST",
    http_path = "/",
    paginator = list(input_token = "ExclusiveStartKey", limit_key = "Limit", output_token = "LastEvaluatedKey", result_key = "Items")
  )
  input <- .dynamodb$scan_input(TableName = TableName, IndexName = IndexName, AttributesToGet = AttributesToGet, Limit = Limit, Select = Select, ScanFilter = ScanFilter, ConditionalOperator = ConditionalOperator, ExclusiveStartKey = ExclusiveStartKey, ReturnConsumedCapacity = ReturnConsumedCapacity, TotalSegments = TotalSegments, Segment = Segment, ProjectionExpression = ProjectionExpression, FilterExpression = FilterExpression, ExpressionAttributeNames = ExpressionAttributeNames, ExpressionAttributeValues = ExpressionAttributeValues, ConsistentRead = ConsistentRead)
  output <- .dynamodb$scan_output()
  config <- get_config()
  svc <- .dynamodb$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.dynamodb$operations$scan <- dynamodb_scan

#' Associate a set of tags with an Amazon DynamoDB resource
#'
#' @description
#' Associate a set of tags with an Amazon DynamoDB resource. You can then activate these user-defined tags so that they appear on the Billing and Cost Management console for cost allocation tracking. You can call TagResource up to five times per second, per account.
#'
#' See [https://www.paws-r-sdk.com/docs/dynamodb_tag_resource/](https://www.paws-r-sdk.com/docs/dynamodb_tag_resource/) for full documentation.
#'
#' @param ResourceArn &#91;required&#93; Identifies the Amazon DynamoDB resource to which tags should be added.
#' This value is an Amazon Resource Name (ARN).
#' @param Tags &#91;required&#93; The tags to be assigned to the Amazon DynamoDB resource.
#'
#' @keywords internal
#'
#' @rdname dynamodb_tag_resource
dynamodb_tag_resource <- function(ResourceArn, Tags) {
  op <- new_operation(
    name = "TagResource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .dynamodb$tag_resource_input(ResourceArn = ResourceArn, Tags = Tags)
  output <- .dynamodb$tag_resource_output()
  config <- get_config()
  svc <- .dynamodb$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.dynamodb$operations$tag_resource <- dynamodb_tag_resource

#' TransactGetItems is a synchronous operation that atomically retrieves
#' multiple items from one or more tables (but not from indexes) in a
#' single account and Region
#'
#' @description
#' [`transact_get_items`][dynamodb_transact_get_items] is a synchronous operation that atomically retrieves multiple items from one or more tables (but not from indexes) in a single account and Region. A [`transact_get_items`][dynamodb_transact_get_items] call can contain up to 100 `TransactGetItem` objects, each of which contains a `Get` structure that specifies an item to retrieve from a table in the account and Region. A call to [`transact_get_items`][dynamodb_transact_get_items] cannot retrieve items from tables in more than one Amazon Web Services account or Region. The aggregate size of the items in the transaction cannot exceed 4 MB.
#'
#' See [https://www.paws-r-sdk.com/docs/dynamodb_transact_get_items/](https://www.paws-r-sdk.com/docs/dynamodb_transact_get_items/) for full documentation.
#'
#' @param TransactItems &#91;required&#93; An ordered array of up to 100 `TransactGetItem` objects, each of which
#' contains a `Get` structure.
#' @param ReturnConsumedCapacity A value of `TOTAL` causes consumed capacity information to be returned,
#' and a value of `NONE` prevents that information from being returned. No
#' other value is valid.
#'
#' @keywords internal
#'
#' @rdname dynamodb_transact_get_items
dynamodb_transact_get_items <- function(TransactItems, ReturnConsumedCapacity = NULL) {
  op <- new_operation(
    name = "TransactGetItems",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .dynamodb$transact_get_items_input(TransactItems = TransactItems, ReturnConsumedCapacity = ReturnConsumedCapacity)
  output <- .dynamodb$transact_get_items_output()
  config <- get_config()
  svc <- .dynamodb$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.dynamodb$operations$transact_get_items <- dynamodb_transact_get_items

#' TransactWriteItems is a synchronous write operation that groups up to
#' 100 action requests
#'
#' @description
#' [`transact_write_items`][dynamodb_transact_write_items] is a synchronous write operation that groups up to 100 action requests. These actions can target items in different tables, but not in different Amazon Web Services accounts or Regions, and no two actions can target the same item. For example, you cannot both `ConditionCheck` and `Update` the same item. The aggregate size of the items in the transaction cannot exceed 4 MB.
#'
#' See [https://www.paws-r-sdk.com/docs/dynamodb_transact_write_items/](https://www.paws-r-sdk.com/docs/dynamodb_transact_write_items/) for full documentation.
#'
#' @param TransactItems &#91;required&#93; An ordered array of up to 100 `TransactWriteItem` objects, each of which
#' contains a `ConditionCheck`, `Put`, `Update`, or `Delete` object. These
#' can operate on items in different tables, but the tables must reside in
#' the same Amazon Web Services account and Region, and no two of them can
#' operate on the same item.
#' @param ReturnConsumedCapacity 
#' @param ReturnItemCollectionMetrics Determines whether item collection metrics are returned. If set to
#' `SIZE`, the response includes statistics about item collections (if
#' any), that were modified during the operation and are returned in the
#' response. If set to `NONE` (the default), no statistics are returned.
#' @param ClientRequestToken Providing a `ClientRequestToken` makes the call to
#' [`transact_write_items`][dynamodb_transact_write_items] idempotent,
#' meaning that multiple identical calls have the same effect as one single
#' call.
#' 
#' Although multiple identical calls using the same client request token
#' produce the same result on the server (no side effects), the responses
#' to the calls might not be the same. If the `ReturnConsumedCapacity`
#' parameter is set, then the initial
#' [`transact_write_items`][dynamodb_transact_write_items] call returns the
#' amount of write capacity units consumed in making the changes.
#' Subsequent [`transact_write_items`][dynamodb_transact_write_items] calls
#' with the same client token return the number of read capacity units
#' consumed in reading the item.
#' 
#' A client request token is valid for 10 minutes after the first request
#' that uses it is completed. After 10 minutes, any request with the same
#' client token is treated as a new request. Do not resubmit the same
#' request with the same client token for more than 10 minutes, or the
#' result might not be idempotent.
#' 
#' If you submit a request with the same client token but a change in other
#' parameters within the 10-minute idempotency window, DynamoDB returns an
#' `IdempotentParameterMismatch` exception.
#'
#' @keywords internal
#'
#' @rdname dynamodb_transact_write_items
dynamodb_transact_write_items <- function(TransactItems, ReturnConsumedCapacity = NULL, ReturnItemCollectionMetrics = NULL, ClientRequestToken = NULL) {
  op <- new_operation(
    name = "TransactWriteItems",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .dynamodb$transact_write_items_input(TransactItems = TransactItems, ReturnConsumedCapacity = ReturnConsumedCapacity, ReturnItemCollectionMetrics = ReturnItemCollectionMetrics, ClientRequestToken = ClientRequestToken)
  output <- .dynamodb$transact_write_items_output()
  config <- get_config()
  svc <- .dynamodb$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.dynamodb$operations$transact_write_items <- dynamodb_transact_write_items

#' Removes the association of tags from an Amazon DynamoDB resource
#'
#' @description
#' Removes the association of tags from an Amazon DynamoDB resource. You can call [`untag_resource`][dynamodb_untag_resource] up to five times per second, per account.
#'
#' See [https://www.paws-r-sdk.com/docs/dynamodb_untag_resource/](https://www.paws-r-sdk.com/docs/dynamodb_untag_resource/) for full documentation.
#'
#' @param ResourceArn &#91;required&#93; The DynamoDB resource that the tags will be removed from. This value is
#' an Amazon Resource Name (ARN).
#' @param TagKeys &#91;required&#93; A list of tag keys. Existing tags of the resource whose keys are members
#' of this list will be removed from the DynamoDB resource.
#'
#' @keywords internal
#'
#' @rdname dynamodb_untag_resource
dynamodb_untag_resource <- function(ResourceArn, TagKeys) {
  op <- new_operation(
    name = "UntagResource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .dynamodb$untag_resource_input(ResourceArn = ResourceArn, TagKeys = TagKeys)
  output <- .dynamodb$untag_resource_output()
  config <- get_config()
  svc <- .dynamodb$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.dynamodb$operations$untag_resource <- dynamodb_untag_resource

#' UpdateContinuousBackups enables or disables point in time recovery for
#' the specified table
#'
#' @description
#' [`update_continuous_backups`][dynamodb_update_continuous_backups] enables or disables point in time recovery for the specified table. A successful [`update_continuous_backups`][dynamodb_update_continuous_backups] call returns the current `ContinuousBackupsDescription`. Continuous backups are `ENABLED` on all tables at table creation. If point in time recovery is enabled, `PointInTimeRecoveryStatus` will be set to ENABLED.
#'
#' See [https://www.paws-r-sdk.com/docs/dynamodb_update_continuous_backups/](https://www.paws-r-sdk.com/docs/dynamodb_update_continuous_backups/) for full documentation.
#'
#' @param TableName &#91;required&#93; The name of the table.
#' @param PointInTimeRecoverySpecification &#91;required&#93; Represents the settings used to enable point in time recovery.
#'
#' @keywords internal
#'
#' @rdname dynamodb_update_continuous_backups
dynamodb_update_continuous_backups <- function(TableName, PointInTimeRecoverySpecification) {
  op <- new_operation(
    name = "UpdateContinuousBackups",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .dynamodb$update_continuous_backups_input(TableName = TableName, PointInTimeRecoverySpecification = PointInTimeRecoverySpecification)
  output <- .dynamodb$update_continuous_backups_output()
  config <- get_config()
  svc <- .dynamodb$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.dynamodb$operations$update_continuous_backups <- dynamodb_update_continuous_backups

#' Updates the status for contributor insights for a specific table or
#' index
#'
#' @description
#' Updates the status for contributor insights for a specific table or index. CloudWatch Contributor Insights for DynamoDB graphs display the partition key and (if applicable) sort key of frequently accessed items and frequently throttled items in plaintext. If you require the use of Amazon Web Services Key Management Service (KMS) to encrypt this table’s partition key and sort key data with an Amazon Web Services managed key or customer managed key, you should not enable CloudWatch Contributor Insights for DynamoDB for this table.
#'
#' See [https://www.paws-r-sdk.com/docs/dynamodb_update_contributor_insights/](https://www.paws-r-sdk.com/docs/dynamodb_update_contributor_insights/) for full documentation.
#'
#' @param TableName &#91;required&#93; The name of the table.
#' @param IndexName The global secondary index name, if applicable.
#' @param ContributorInsightsAction &#91;required&#93; Represents the contributor insights action.
#'
#' @keywords internal
#'
#' @rdname dynamodb_update_contributor_insights
dynamodb_update_contributor_insights <- function(TableName, IndexName = NULL, ContributorInsightsAction) {
  op <- new_operation(
    name = "UpdateContributorInsights",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .dynamodb$update_contributor_insights_input(TableName = TableName, IndexName = IndexName, ContributorInsightsAction = ContributorInsightsAction)
  output <- .dynamodb$update_contributor_insights_output()
  config <- get_config()
  svc <- .dynamodb$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.dynamodb$operations$update_contributor_insights <- dynamodb_update_contributor_insights

#' Adds or removes replicas in the specified global table
#'
#' @description
#' Adds or removes replicas in the specified global table. The global table must already exist to be able to use this operation. Any replica to be added must be empty, have the same name as the global table, have the same key schema, have DynamoDB Streams enabled, and have the same provisioned and maximum write capacity units.
#'
#' See [https://www.paws-r-sdk.com/docs/dynamodb_update_global_table/](https://www.paws-r-sdk.com/docs/dynamodb_update_global_table/) for full documentation.
#'
#' @param GlobalTableName &#91;required&#93; The global table name.
#' @param ReplicaUpdates &#91;required&#93; A list of Regions that should be added or removed from the global table.
#'
#' @keywords internal
#'
#' @rdname dynamodb_update_global_table
dynamodb_update_global_table <- function(GlobalTableName, ReplicaUpdates) {
  op <- new_operation(
    name = "UpdateGlobalTable",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .dynamodb$update_global_table_input(GlobalTableName = GlobalTableName, ReplicaUpdates = ReplicaUpdates)
  output <- .dynamodb$update_global_table_output()
  config <- get_config()
  svc <- .dynamodb$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.dynamodb$operations$update_global_table <- dynamodb_update_global_table

#' Updates settings for a global table
#'
#' @description
#' Updates settings for a global table.
#'
#' See [https://www.paws-r-sdk.com/docs/dynamodb_update_global_table_settings/](https://www.paws-r-sdk.com/docs/dynamodb_update_global_table_settings/) for full documentation.
#'
#' @param GlobalTableName &#91;required&#93; The name of the global table
#' @param GlobalTableBillingMode The billing mode of the global table. If `GlobalTableBillingMode` is not
#' specified, the global table defaults to `PROVISIONED` capacity billing
#' mode.
#' 
#' -   `PROVISIONED` - We recommend using `PROVISIONED` for predictable
#'     workloads. `PROVISIONED` sets the billing mode to [Provisioned
#'     Mode](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/HowItWorks.ReadWriteCapacityMode.html#HowItWorks.ProvisionedThroughput.Manual).
#' 
#' -   `PAY_PER_REQUEST` - We recommend using `PAY_PER_REQUEST` for
#'     unpredictable workloads. `PAY_PER_REQUEST` sets the billing mode to
#'     [On-Demand
#'     Mode](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/HowItWorks.ReadWriteCapacityMode.html#HowItWorks.OnDemand).
#' @param GlobalTableProvisionedWriteCapacityUnits The maximum number of writes consumed per second before DynamoDB returns
#' a `ThrottlingException.`
#' @param GlobalTableProvisionedWriteCapacityAutoScalingSettingsUpdate Auto scaling settings for managing provisioned write capacity for the
#' global table.
#' @param GlobalTableGlobalSecondaryIndexSettingsUpdate Represents the settings of a global secondary index for a global table
#' that will be modified.
#' @param ReplicaSettingsUpdate Represents the settings for a global table in a Region that will be
#' modified.
#'
#' @keywords internal
#'
#' @rdname dynamodb_update_global_table_settings
dynamodb_update_global_table_settings <- function(GlobalTableName, GlobalTableBillingMode = NULL, GlobalTableProvisionedWriteCapacityUnits = NULL, GlobalTableProvisionedWriteCapacityAutoScalingSettingsUpdate = NULL, GlobalTableGlobalSecondaryIndexSettingsUpdate = NULL, ReplicaSettingsUpdate = NULL) {
  op <- new_operation(
    name = "UpdateGlobalTableSettings",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .dynamodb$update_global_table_settings_input(GlobalTableName = GlobalTableName, GlobalTableBillingMode = GlobalTableBillingMode, GlobalTableProvisionedWriteCapacityUnits = GlobalTableProvisionedWriteCapacityUnits, GlobalTableProvisionedWriteCapacityAutoScalingSettingsUpdate = GlobalTableProvisionedWriteCapacityAutoScalingSettingsUpdate, GlobalTableGlobalSecondaryIndexSettingsUpdate = GlobalTableGlobalSecondaryIndexSettingsUpdate, ReplicaSettingsUpdate = ReplicaSettingsUpdate)
  output <- .dynamodb$update_global_table_settings_output()
  config <- get_config()
  svc <- .dynamodb$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.dynamodb$operations$update_global_table_settings <- dynamodb_update_global_table_settings

#' Edits an existing item's attributes, or adds a new item to the table if
#' it does not already exist
#'
#' @description
#' Edits an existing item's attributes, or adds a new item to the table if it does not already exist. You can put, delete, or add attribute values. You can also perform a conditional update on an existing item (insert a new attribute name-value pair if it doesn't exist, or replace an existing name-value pair if it has certain expected attribute values).
#'
#' See [https://www.paws-r-sdk.com/docs/dynamodb_update_item/](https://www.paws-r-sdk.com/docs/dynamodb_update_item/) for full documentation.
#'
#' @param TableName &#91;required&#93; The name of the table containing the item to update.
#' @param Key &#91;required&#93; The primary key of the item to be updated. Each element consists of an
#' attribute name and a value for that attribute.
#' 
#' For the primary key, you must provide all of the attributes. For
#' example, with a simple primary key, you only need to provide a value for
#' the partition key. For a composite primary key, you must provide values
#' for both the partition key and the sort key.
#' @param AttributeUpdates This is a legacy parameter. Use `UpdateExpression` instead. For more
#' information, see
#' [AttributeUpdates](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.AttributeUpdates.html)
#' in the *Amazon DynamoDB Developer Guide*.
#' @param Expected This is a legacy parameter. Use `ConditionExpression` instead. For more
#' information, see
#' [Expected](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.Expected.html)
#' in the *Amazon DynamoDB Developer Guide*.
#' @param ConditionalOperator This is a legacy parameter. Use `ConditionExpression` instead. For more
#' information, see
#' [ConditionalOperator](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.ConditionalOperator.html)
#' in the *Amazon DynamoDB Developer Guide*.
#' @param ReturnValues Use `ReturnValues` if you want to get the item attributes as they appear
#' before or after they are successfully updated. For
#' [`update_item`][dynamodb_update_item], the valid values are:
#' 
#' -   `NONE` - If `ReturnValues` is not specified, or if its value is
#'     `NONE`, then nothing is returned. (This setting is the default for
#'     `ReturnValues`.)
#' 
#' -   `ALL_OLD` - Returns all of the attributes of the item, as they
#'     appeared before the UpdateItem operation.
#' 
#' -   `UPDATED_OLD` - Returns only the updated attributes, as they
#'     appeared before the UpdateItem operation.
#' 
#' -   `ALL_NEW` - Returns all of the attributes of the item, as they
#'     appear after the UpdateItem operation.
#' 
#' -   `UPDATED_NEW` - Returns only the updated attributes, as they appear
#'     after the UpdateItem operation.
#' 
#' There is no additional cost associated with requesting a return value
#' aside from the small network and processing overhead of receiving a
#' larger response. No read capacity units are consumed.
#' 
#' The values returned are strongly consistent.
#' @param ReturnConsumedCapacity 
#' @param ReturnItemCollectionMetrics Determines whether item collection metrics are returned. If set to
#' `SIZE`, the response includes statistics about item collections, if any,
#' that were modified during the operation are returned in the response. If
#' set to `NONE` (the default), no statistics are returned.
#' @param UpdateExpression An expression that defines one or more attributes to be updated, the
#' action to be performed on them, and new values for them.
#' 
#' The following action values are available for `UpdateExpression`.
#' 
#' -   `SET` - Adds one or more attributes and values to an item. If any of
#'     these attributes already exist, they are replaced by the new values.
#'     You can also use `SET` to add or subtract from an attribute that is
#'     of type Number. For example: `SET myNum = myNum + :val`
#' 
#'     `SET` supports the following functions:
#' 
#'     -   `if_not_exists (path, operand)` - if the item does not contain
#'         an attribute at the specified path, then `if_not_exists`
#'         evaluates to operand; otherwise, it evaluates to path. You can
#'         use this function to avoid overwriting an attribute that may
#'         already be present in the item.
#' 
#'     -   `list_append (operand, operand)` - evaluates to a list with a
#'         new element added to it. You can append the new element to the
#'         start or the end of the list by reversing the order of the
#'         operands.
#' 
#'     These function names are case-sensitive.
#' 
#' -   `REMOVE` - Removes one or more attributes from an item.
#' 
#' -   `ADD` - Adds the specified value to the item, if the attribute does
#'     not already exist. If the attribute does exist, then the behavior of
#'     `ADD` depends on the data type of the attribute:
#' 
#'     -   If the existing attribute is a number, and if `Value` is also a
#'         number, then `Value` is mathematically added to the existing
#'         attribute. If `Value` is a negative number, then it is
#'         subtracted from the existing attribute.
#' 
#'         If you use `ADD` to increment or decrement a number value for an
#'         item that doesn't exist before the update, DynamoDB uses `0` as
#'         the initial value.
#' 
#'         Similarly, if you use `ADD` for an existing item to increment or
#'         decrement an attribute value that doesn't exist before the
#'         update, DynamoDB uses `0` as the initial value. For example,
#'         suppose that the item you want to update doesn't have an
#'         attribute named `itemcount`, but you decide to `ADD` the number
#'         `3` to this attribute anyway. DynamoDB will create the
#'         `itemcount` attribute, set its initial value to `0`, and finally
#'         add `3` to it. The result will be a new `itemcount` attribute in
#'         the item, with a value of `3`.
#' 
#'     -   If the existing data type is a set and if `Value` is also a set,
#'         then `Value` is added to the existing set. For example, if the
#'         attribute value is the set `[1,2]`, and the `ADD` action
#'         specified `[3]`, then the final attribute value is `[1,2,3]`. An
#'         error occurs if an `ADD` action is specified for a set attribute
#'         and the attribute type specified does not match the existing set
#'         type.
#' 
#'         Both sets must have the same primitive data type. For example,
#'         if the existing data type is a set of strings, the `Value` must
#'         also be a set of strings.
#' 
#'     The `ADD` action only supports Number and set data types. In
#'     addition, `ADD` can only be used on top-level attributes, not nested
#'     attributes.
#' 
#' -   `DELETE` - Deletes an element from a set.
#' 
#'     If a set of values is specified, then those values are subtracted
#'     from the old set. For example, if the attribute value was the set
#'     `[a,b,c]` and the `DELETE` action specifies `[a,c]`, then the final
#'     attribute value is `[b]`. Specifying an empty set is an error.
#' 
#'     The `DELETE` action only supports set data types. In addition,
#'     `DELETE` can only be used on top-level attributes, not nested
#'     attributes.
#' 
#' You can have many actions in a single expression, such as the following:
#' `SET a=:value1, b=:value2 DELETE :value3, :value4, :value5`
#' 
#' For more information on update expressions, see [Modifying Items and
#' Attributes](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.UpdateExpressions.html)
#' in the *Amazon DynamoDB Developer Guide*.
#' @param ConditionExpression A condition that must be satisfied in order for a conditional update to
#' succeed.
#' 
#' An expression can contain any of the following:
#' 
#' -   Functions:
#'     `attribute_exists | attribute_not_exists | attribute_type | contains | begins_with | size`
#' 
#'     These function names are case-sensitive.
#' 
#' -   Comparison operators: `= | <> | < | > | <= | >= | BETWEEN | IN `
#' 
#' -   Logical operators: `AND | OR | NOT`
#' 
#' For more information about condition expressions, see [Specifying
#' Conditions](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.ConditionExpressions.html)
#' in the *Amazon DynamoDB Developer Guide*.
#' @param ExpressionAttributeNames One or more substitution tokens for attribute names in an expression.
#' The following are some use cases for using `ExpressionAttributeNames`:
#' 
#' -   To access an attribute whose name conflicts with a DynamoDB reserved
#'     word.
#' 
#' -   To create a placeholder for repeating occurrences of an attribute
#'     name in an expression.
#' 
#' -   To prevent special characters in an attribute name from being
#'     misinterpreted in an expression.
#' 
#' Use the **#** character in an expression to dereference an attribute
#' name. For example, consider the following attribute name:
#' 
#' -   `Percentile`
#' 
#' The name of this attribute conflicts with a reserved word, so it cannot
#' be used directly in an expression. (For the complete list of reserved
#' words, see [Reserved
#' Words](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/ReservedWords.html)
#' in the *Amazon DynamoDB Developer Guide*.) To work around this, you
#' could specify the following for `ExpressionAttributeNames`:
#' 
#' -   `{"#P":"Percentile"}`
#' 
#' You could then use this substitution in an expression, as in this
#' example:
#' 
#' -   `#P = :val`
#' 
#' Tokens that begin with the **:** character are *expression attribute
#' values*, which are placeholders for the actual value at runtime.
#' 
#' For more information about expression attribute names, see [Specifying
#' Item
#' Attributes](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.Attributes.html)
#' in the *Amazon DynamoDB Developer Guide*.
#' @param ExpressionAttributeValues One or more values that can be substituted in an expression.
#' 
#' Use the **:** (colon) character in an expression to dereference an
#' attribute value. For example, suppose that you wanted to check whether
#' the value of the `ProductStatus` attribute was one of the following:
#' 
#' `Available | Backordered | Discontinued`
#' 
#' You would first need to specify `ExpressionAttributeValues` as follows:
#' 
#' `{ ":avail":{"S":"Available"}, ":back":{"S":"Backordered"}, ":disc":{"S":"Discontinued"} }`
#' 
#' You could then use these values in an expression, such as this:
#' 
#' `ProductStatus IN (:avail, :back, :disc)`
#' 
#' For more information on expression attribute values, see [Condition
#' Expressions](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.ConditionExpressions.html)
#' in the *Amazon DynamoDB Developer Guide*.
#' @param ReturnValuesOnConditionCheckFailure An optional parameter that returns the item attributes for an
#' [`update_item`][dynamodb_update_item] operation that failed a condition
#' check.
#' 
#' There is no additional cost associated with requesting a return value
#' aside from the small network and processing overhead of receiving a
#' larger response. No read capacity units are consumed.
#'
#' @keywords internal
#'
#' @rdname dynamodb_update_item
dynamodb_update_item <- function(TableName, Key, AttributeUpdates = NULL, Expected = NULL, ConditionalOperator = NULL, ReturnValues = NULL, ReturnConsumedCapacity = NULL, ReturnItemCollectionMetrics = NULL, UpdateExpression = NULL, ConditionExpression = NULL, ExpressionAttributeNames = NULL, ExpressionAttributeValues = NULL, ReturnValuesOnConditionCheckFailure = NULL) {
  op <- new_operation(
    name = "UpdateItem",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .dynamodb$update_item_input(TableName = TableName, Key = Key, AttributeUpdates = AttributeUpdates, Expected = Expected, ConditionalOperator = ConditionalOperator, ReturnValues = ReturnValues, ReturnConsumedCapacity = ReturnConsumedCapacity, ReturnItemCollectionMetrics = ReturnItemCollectionMetrics, UpdateExpression = UpdateExpression, ConditionExpression = ConditionExpression, ExpressionAttributeNames = ExpressionAttributeNames, ExpressionAttributeValues = ExpressionAttributeValues, ReturnValuesOnConditionCheckFailure = ReturnValuesOnConditionCheckFailure)
  output <- .dynamodb$update_item_output()
  config <- get_config()
  svc <- .dynamodb$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.dynamodb$operations$update_item <- dynamodb_update_item

#' Modifies the provisioned throughput settings, global secondary indexes,
#' or DynamoDB Streams settings for a given table
#'
#' @description
#' Modifies the provisioned throughput settings, global secondary indexes, or DynamoDB Streams settings for a given table.
#'
#' See [https://www.paws-r-sdk.com/docs/dynamodb_update_table/](https://www.paws-r-sdk.com/docs/dynamodb_update_table/) for full documentation.
#'
#' @param AttributeDefinitions An array of attributes that describe the key schema for the table and
#' indexes. If you are adding a new global secondary index to the table,
#' `AttributeDefinitions` must include the key element(s) of the new index.
#' @param TableName &#91;required&#93; The name of the table to be updated.
#' @param BillingMode Controls how you are charged for read and write throughput and how you
#' manage capacity. When switching from pay-per-request to provisioned
#' capacity, initial provisioned capacity values must be set. The initial
#' provisioned capacity values are estimated based on the consumed read and
#' write capacity of your table and global secondary indexes over the past
#' 30 minutes.
#' 
#' -   `PROVISIONED` - We recommend using `PROVISIONED` for predictable
#'     workloads. `PROVISIONED` sets the billing mode to [Provisioned
#'     Mode](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/HowItWorks.ReadWriteCapacityMode.html#HowItWorks.ProvisionedThroughput.Manual).
#' 
#' -   `PAY_PER_REQUEST` - We recommend using `PAY_PER_REQUEST` for
#'     unpredictable workloads. `PAY_PER_REQUEST` sets the billing mode to
#'     [On-Demand
#'     Mode](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/HowItWorks.ReadWriteCapacityMode.html#HowItWorks.OnDemand).
#' @param ProvisionedThroughput The new provisioned throughput settings for the specified table or
#' index.
#' @param GlobalSecondaryIndexUpdates An array of one or more global secondary indexes for the table. For each
#' index in the array, you can request one action:
#' 
#' -   `Create` - add a new global secondary index to the table.
#' 
#' -   `Update` - modify the provisioned throughput settings of an existing
#'     global secondary index.
#' 
#' -   `Delete` - remove a global secondary index from the table.
#' 
#' You can create or delete only one global secondary index per
#' [`update_table`][dynamodb_update_table] operation.
#' 
#' For more information, see [Managing Global Secondary
#' Indexes](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/GSI.OnlineOps.html)
#' in the *Amazon DynamoDB Developer Guide*.
#' @param StreamSpecification Represents the DynamoDB Streams configuration for the table.
#' 
#' You receive a `ResourceInUseException` if you try to enable a stream on
#' a table that already has a stream, or if you try to disable a stream on
#' a table that doesn't have a stream.
#' @param SSESpecification The new server-side encryption settings for the specified table.
#' @param ReplicaUpdates A list of replica update actions (create, delete, or update) for the
#' table.
#' 
#' This property only applies to [Version 2019.11.21
#' (Current)](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/globaltables.V2.html)
#' of global tables.
#' @param TableClass The table class of the table to be updated. Valid values are `STANDARD`
#' and `STANDARD_INFREQUENT_ACCESS`.
#' @param DeletionProtectionEnabled Indicates whether deletion protection is to be enabled (true) or
#' disabled (false) on the table.
#'
#' @keywords internal
#'
#' @rdname dynamodb_update_table
dynamodb_update_table <- function(AttributeDefinitions = NULL, TableName, BillingMode = NULL, ProvisionedThroughput = NULL, GlobalSecondaryIndexUpdates = NULL, StreamSpecification = NULL, SSESpecification = NULL, ReplicaUpdates = NULL, TableClass = NULL, DeletionProtectionEnabled = NULL) {
  op <- new_operation(
    name = "UpdateTable",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .dynamodb$update_table_input(AttributeDefinitions = AttributeDefinitions, TableName = TableName, BillingMode = BillingMode, ProvisionedThroughput = ProvisionedThroughput, GlobalSecondaryIndexUpdates = GlobalSecondaryIndexUpdates, StreamSpecification = StreamSpecification, SSESpecification = SSESpecification, ReplicaUpdates = ReplicaUpdates, TableClass = TableClass, DeletionProtectionEnabled = DeletionProtectionEnabled)
  output <- .dynamodb$update_table_output()
  config <- get_config()
  svc <- .dynamodb$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.dynamodb$operations$update_table <- dynamodb_update_table

#' Updates auto scaling settings on your global tables at once
#'
#' @description
#' Updates auto scaling settings on your global tables at once.
#'
#' See [https://www.paws-r-sdk.com/docs/dynamodb_update_table_replica_auto_scaling/](https://www.paws-r-sdk.com/docs/dynamodb_update_table_replica_auto_scaling/) for full documentation.
#'
#' @param GlobalSecondaryIndexUpdates Represents the auto scaling settings of the global secondary indexes of
#' the replica to be updated.
#' @param TableName &#91;required&#93; The name of the global table to be updated.
#' @param ProvisionedWriteCapacityAutoScalingUpdate 
#' @param ReplicaUpdates Represents the auto scaling settings of replicas of the table that will
#' be modified.
#'
#' @keywords internal
#'
#' @rdname dynamodb_update_table_replica_auto_scaling
dynamodb_update_table_replica_auto_scaling <- function(GlobalSecondaryIndexUpdates = NULL, TableName, ProvisionedWriteCapacityAutoScalingUpdate = NULL, ReplicaUpdates = NULL) {
  op <- new_operation(
    name = "UpdateTableReplicaAutoScaling",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .dynamodb$update_table_replica_auto_scaling_input(GlobalSecondaryIndexUpdates = GlobalSecondaryIndexUpdates, TableName = TableName, ProvisionedWriteCapacityAutoScalingUpdate = ProvisionedWriteCapacityAutoScalingUpdate, ReplicaUpdates = ReplicaUpdates)
  output <- .dynamodb$update_table_replica_auto_scaling_output()
  config <- get_config()
  svc <- .dynamodb$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.dynamodb$operations$update_table_replica_auto_scaling <- dynamodb_update_table_replica_auto_scaling

#' The UpdateTimeToLive method enables or disables Time to Live (TTL) for
#' the specified table
#'
#' @description
#' The [`update_time_to_live`][dynamodb_update_time_to_live] method enables or disables Time to Live (TTL) for the specified table. A successful [`update_time_to_live`][dynamodb_update_time_to_live] call returns the current `TimeToLiveSpecification`. It can take up to one hour for the change to fully process. Any additional [`update_time_to_live`][dynamodb_update_time_to_live] calls for the same table during this one hour duration result in a `ValidationException`.
#'
#' See [https://www.paws-r-sdk.com/docs/dynamodb_update_time_to_live/](https://www.paws-r-sdk.com/docs/dynamodb_update_time_to_live/) for full documentation.
#'
#' @param TableName &#91;required&#93; The name of the table to be configured.
#' @param TimeToLiveSpecification &#91;required&#93; Represents the settings used to enable or disable Time to Live for the
#' specified table.
#'
#' @keywords internal
#'
#' @rdname dynamodb_update_time_to_live
dynamodb_update_time_to_live <- function(TableName, TimeToLiveSpecification) {
  op <- new_operation(
    name = "UpdateTimeToLive",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .dynamodb$update_time_to_live_input(TableName = TableName, TimeToLiveSpecification = TimeToLiveSpecification)
  output <- .dynamodb$update_time_to_live_output()
  config <- get_config()
  svc <- .dynamodb$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.dynamodb$operations$update_time_to_live <- dynamodb_update_time_to_live
