% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/redshiftdataapiservice_operations.R
\name{redshiftdataapiservice_execute_statement}
\alias{redshiftdataapiservice_execute_statement}
\title{Runs an SQL statement, which can be data manipulation language (DML) or
data definition language (DDL)}
\usage{
redshiftdataapiservice_execute_statement(
  ClusterIdentifier = NULL,
  Database,
  DbUser = NULL,
  Parameters = NULL,
  SecretArn = NULL,
  Sql,
  StatementName = NULL,
  WithEvent = NULL,
  WorkgroupName = NULL
)
}
\arguments{
\item{ClusterIdentifier}{The cluster identifier. This parameter is required when connecting to a
cluster and authenticating using either Secrets Manager or temporary
credentials.}

\item{Database}{[required] The name of the database. This parameter is required when authenticating
using either Secrets Manager or temporary credentials.}

\item{DbUser}{The database user name. This parameter is required when connecting to a
cluster and authenticating using temporary credentials.}

\item{Parameters}{The parameters for the SQL statement.}

\item{SecretArn}{The name or ARN of the secret that enables access to the database. This
parameter is required when authenticating using Secrets Manager.}

\item{Sql}{[required] The SQL statement text to run.}

\item{StatementName}{The name of the SQL statement. You can name the SQL statement when you
create it to identify the query.}

\item{WithEvent}{A value that indicates whether to send an event to the Amazon
EventBridge event bus after the SQL statement runs.}

\item{WorkgroupName}{The serverless workgroup name. This parameter is required when
connecting to a serverless workgroup and authenticating using either
Secrets Manager or temporary credentials.}
}
\description{
Runs an SQL statement, which can be data manipulation language (DML) or data definition language (DDL). This statement must be a single SQL statement. Depending on the authorization method, use one of the following combinations of request parameters:

See \url{https://paws-r.github.io/docs/redshiftdataapiservice/execute_statement.html} for full documentation.
}
\keyword{internal}
