% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/memorydb_operations.R
\name{memorydb_copy_snapshot}
\alias{memorydb_copy_snapshot}
\title{Makes a copy of an existing snapshot}
\usage{
memorydb_copy_snapshot(
  SourceSnapshotName,
  TargetSnapshotName,
  TargetBucket = NULL,
  KmsKeyId = NULL,
  Tags = NULL
)
}
\arguments{
\item{SourceSnapshotName}{[required] The name of an existing snapshot from which to make a copy.}

\item{TargetSnapshotName}{[required] A name for the snapshot copy. MemoryDB does not permit overwriting a
snapshot, therefore this name must be unique within its context -
MemoryDB or an Amazon S3 bucket if exporting.}

\item{TargetBucket}{The Amazon S3 bucket to which the snapshot is exported. This parameter
is used only when exporting a snapshot for external access. When using
this parameter to export a snapshot, be sure MemoryDB has the needed
permissions to this S3 bucket. For more information, see \href{https://docs.aws.amazon.com/memorydb/latest/devguide/snapshots-exporting.html}{Step 2: Grant MemoryDB Access to Your Amazon S3 Bucket}.}

\item{KmsKeyId}{The ID of the KMS key used to encrypt the target snapshot.}

\item{Tags}{A list of tags to be added to this resource. A tag is a key-value pair.
A tag key must be accompanied by a tag value, although null is accepted.}
}
\description{
Makes a copy of an existing snapshot.

See \url{https://paws-r.github.io/docs/memorydb/copy_snapshot.html} for full documentation.
}
\keyword{internal}
