% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rds_operations.R
\name{rds_restore_db_cluster_to_point_in_time}
\alias{rds_restore_db_cluster_to_point_in_time}
\title{Restores a DB cluster to an arbitrary point in time}
\usage{
rds_restore_db_cluster_to_point_in_time(DBClusterIdentifier,
  RestoreType, SourceDBClusterIdentifier, RestoreToTime,
  UseLatestRestorableTime, Port, DBSubnetGroupName, OptionGroupName,
  VpcSecurityGroupIds, Tags, KmsKeyId, EnableIAMDatabaseAuthentication,
  BacktrackWindow, EnableCloudwatchLogsExports,
  DBClusterParameterGroupName, DeletionProtection, CopyTagsToSnapshot)
}
\arguments{
\item{DBClusterIdentifier}{[required] The name of the new DB cluster to be created.

Constraints:
\itemize{
\item Must contain from 1 to 63 letters, numbers, or hyphens
\item First character must be a letter
\item Can\'t end with a hyphen or contain two consecutive hyphens
}}

\item{RestoreType}{The type of restore to be performed. You can specify one of the
following values:
\itemize{
\item \code{full-copy} - The new DB cluster is restored as a full copy of the
source DB cluster.
\item \code{copy-on-write} - The new DB cluster is restored as a clone of the
source DB cluster.
}

Constraints: You can\'t specify \code{copy-on-write} if the engine version of
the source DB cluster is earlier than 1.11.

If you don\'t specify a \code{RestoreType} value, then the new DB cluster is
restored as a full copy of the source DB cluster.}

\item{SourceDBClusterIdentifier}{[required] The identifier of the source DB cluster from which to restore.

Constraints:
\itemize{
\item Must match the identifier of an existing DBCluster.
}}

\item{RestoreToTime}{The date and time to restore the DB cluster to.

Valid Values: Value must be a time in Universal Coordinated Time (UTC)
format

Constraints:
\itemize{
\item Must be before the latest restorable time for the DB instance
\item Must be specified if \code{UseLatestRestorableTime} parameter isn\'t
provided
\item Can\'t be specified if the \code{UseLatestRestorableTime} parameter is
enabled
\item Can\'t be specified if the \code{RestoreType} parameter is
\code{copy-on-write}
}

Example: \verb{2015-03-07T23:45:00Z}}

\item{UseLatestRestorableTime}{A value that indicates whether to restore the DB cluster to the latest
restorable backup time. By default, the DB cluster isn\'t restored to
the latest restorable backup time.

Constraints: Can\'t be specified if \code{RestoreToTime} parameter is
provided.}

\item{Port}{The port number on which the new DB cluster accepts connections.

Constraints: A value from \code{1150-65535}.

Default: The default port for the engine.}

\item{DBSubnetGroupName}{The DB subnet group name to use for the new DB cluster.

Constraints: If supplied, must match the name of an existing
DBSubnetGroup.

Example: \code{mySubnetgroup}}

\item{OptionGroupName}{The name of the option group for the new DB cluster.}

\item{VpcSecurityGroupIds}{A list of VPC security groups that the new DB cluster belongs to.}

\item{Tags}{}

\item{KmsKeyId}{The AWS KMS key identifier to use when restoring an encrypted DB cluster
from an encrypted DB cluster.

The KMS key identifier is the Amazon Resource Name (ARN) for the KMS
encryption key. If you are restoring a DB cluster with the same AWS
account that owns the KMS encryption key used to encrypt the new DB
cluster, then you can use the KMS key alias instead of the ARN for the
KMS encryption key.

You can restore to a new DB cluster and encrypt the new DB cluster with
a KMS key that is different than the KMS key used to encrypt the source
DB cluster. The new DB cluster is encrypted with the KMS key identified
by the \code{KmsKeyId} parameter.

If you don\'t specify a value for the \code{KmsKeyId} parameter, then the
following occurs:
\itemize{
\item If the DB cluster is encrypted, then the restored DB cluster is
encrypted using the KMS key that was used to encrypt the source DB
cluster.
\item If the DB cluster isn\'t encrypted, then the restored DB cluster
isn\'t encrypted.
}

If \code{DBClusterIdentifier} refers to a DB cluster that isn\'t encrypted,
then the restore request is rejected.}

\item{EnableIAMDatabaseAuthentication}{A value that indicates whether to enable mapping of AWS Identity and
Access Management (IAM) accounts to database accounts. By default,
mapping is disabled.

For more information, see \href{https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/UsingWithRDS.IAMDBAuth.html}{IAM Database Authentication}
in the \emph{Amazon Aurora User Guide.}}

\item{BacktrackWindow}{The target backtrack window, in seconds. To disable backtracking, set
this value to 0.

Default: 0

Constraints:
\itemize{
\item If specified, this value must be set to a number from 0 to 259,200
(72 hours).
}}

\item{EnableCloudwatchLogsExports}{The list of logs that the restored DB cluster is to export to CloudWatch
Logs. The values in the list depend on the DB engine being used. For
more information, see \href{https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_LogAccess.html#USER_LogAccess.Procedural.UploadtoCloudWatch}{Publishing Database Logs to Amazon CloudWatch Logs}
in the \emph{Amazon Aurora User Guide}.}

\item{DBClusterParameterGroupName}{The name of the DB cluster parameter group to associate with this DB
cluster. If this argument is omitted, the default DB cluster parameter
group for the specified engine is used.

Constraints:
\itemize{
\item If supplied, must match the name of an existing DB cluster parameter
group.
\item Must be 1 to 255 letters, numbers, or hyphens.
\item First character must be a letter.
\item Can\'t end with a hyphen or contain two consecutive hyphens.
}}

\item{DeletionProtection}{A value that indicates whether the DB cluster has deletion protection
enabled. The database can\'t be deleted when deletion protection is
enabled. By default, deletion protection is disabled.}

\item{CopyTagsToSnapshot}{A value that indicates whether to copy all tags from the restored DB
cluster to snapshots of the restored DB cluster. The default is not to
copy them.}
}
\description{
Restores a DB cluster to an arbitrary point in time. Users can restore
to any point in time before \code{LatestRestorableTime} for up to
\code{BackupRetentionPeriod} days. The target DB cluster is created from the
source DB cluster with the same configuration as the original DB
cluster, except that the new DB cluster is created with the default DB
security group.
}
\details{
This action only restores the DB cluster, not the DB instances for that
DB cluster. You must invoke the \code{CreateDBInstance} action to create DB
instances for the restored DB cluster, specifying the identifier of the
restored DB cluster in \code{DBClusterIdentifier}. You can create DB
instances only after the \code{RestoreDBClusterToPointInTime} action has
completed and the DB cluster is available.

For more information on Amazon Aurora, see \href{https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_AuroraOverview.html}{What Is Amazon Aurora?}
in the \emph{Amazon Aurora User Guide.}

This action only applies to Aurora DB clusters.
}
\section{Request syntax}{
\preformatted{svc$restore_db_cluster_to_point_in_time(
  DBClusterIdentifier = "string",
  RestoreType = "string",
  SourceDBClusterIdentifier = "string",
  RestoreToTime = as.POSIXct(
    "2015-01-01"
  ),
  UseLatestRestorableTime = TRUE|FALSE,
  Port = 123,
  DBSubnetGroupName = "string",
  OptionGroupName = "string",
  VpcSecurityGroupIds = list(
    "string"
  ),
  Tags = list(
    list(
      Key = "string",
      Value = "string"
    )
  ),
  KmsKeyId = "string",
  EnableIAMDatabaseAuthentication = TRUE|FALSE,
  BacktrackWindow = 123,
  EnableCloudwatchLogsExports = list(
    "string"
  ),
  DBClusterParameterGroupName = "string",
  DeletionProtection = TRUE|FALSE,
  CopyTagsToSnapshot = TRUE|FALSE
)
}
}

\keyword{internal}
