% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rds_operations.R
\name{rds_describe_db_cluster_snapshot_attributes}
\alias{rds_describe_db_cluster_snapshot_attributes}
\title{Returns a list of DB cluster snapshot attribute names and values for a
manual DB cluster snapshot}
\usage{
rds_describe_db_cluster_snapshot_attributes(DBClusterSnapshotIdentifier)
}
\arguments{
\item{DBClusterSnapshotIdentifier}{[required] The identifier for the DB cluster snapshot to describe the attributes
for.}
}
\description{
Returns a list of DB cluster snapshot attribute names and values for a
manual DB cluster snapshot.
}
\details{
When sharing snapshots with other AWS accounts,
\code{DescribeDBClusterSnapshotAttributes} returns the \code{restore} attribute
and a list of IDs for the AWS accounts that are authorized to copy or
restore the manual DB cluster snapshot. If \code{all} is included in the list
of values for the \code{restore} attribute, then the manual DB cluster
snapshot is public and can be copied or restored by all AWS accounts.

To add or remove access for an AWS account to copy or restore a manual
DB cluster snapshot, or to make the manual DB cluster snapshot public or
private, use the \code{ModifyDBClusterSnapshotAttribute} API action.

This action only applies to Aurora DB clusters.
}
\section{Request syntax}{
\preformatted{svc$describe_db_cluster_snapshot_attributes(
  DBClusterSnapshotIdentifier = "string"
)
}
}

\keyword{internal}
