% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/elasticache_operations.R
\name{elasticache_modify_cache_cluster}
\alias{elasticache_modify_cache_cluster}
\title{Modifies the settings for a cluster}
\usage{
elasticache_modify_cache_cluster(CacheClusterId, NumCacheNodes,
  CacheNodeIdsToRemove, AZMode, NewAvailabilityZones,
  CacheSecurityGroupNames, SecurityGroupIds, PreferredMaintenanceWindow,
  NotificationTopicArn, CacheParameterGroupName, NotificationTopicStatus,
  ApplyImmediately, EngineVersion, AutoMinorVersionUpgrade,
  SnapshotRetentionLimit, SnapshotWindow, CacheNodeType, AuthToken,
  AuthTokenUpdateStrategy)
}
\arguments{
\item{CacheClusterId}{[required] The cluster identifier. This value is stored as a lowercase string.}

\item{NumCacheNodes}{The number of cache nodes that the cluster should have. If the value for
\code{NumCacheNodes} is greater than the sum of the number of current cache
nodes and the number of cache nodes pending creation (which may be
zero), more nodes are added. If the value is less than the number of
existing cache nodes, nodes are removed. If the value is equal to the
number of current cache nodes, any pending add or remove requests are
canceled.

If you are removing cache nodes, you must use the \code{CacheNodeIdsToRemove}
parameter to provide the IDs of the specific cache nodes to remove.

For clusters running Redis, this value must be 1. For clusters running
Memcached, this value must be between 1 and 20.

Adding or removing Memcached cache nodes can be applied immediately or
as a pending operation (see \code{ApplyImmediately}).

A pending operation to modify the number of cache nodes in a cluster
during its maintenance window, whether by adding or removing nodes in
accordance with the scale out architecture, is not queued. The
customer\'s latest request to add or remove nodes to the cluster
overrides any previous pending operations to modify the number of cache
nodes in the cluster. For example, a request to remove 2 nodes would
override a previous pending operation to remove 3 nodes. Similarly, a
request to add 2 nodes would override a previous pending operation to
remove 3 nodes and vice versa. As Memcached cache nodes may now be
provisioned in different Availability Zones with flexible cache node
placement, a request to add nodes does not automatically override a
previous pending operation to add nodes. The customer can modify the
previous pending operation to add more nodes or explicitly cancel the
pending request and retry the new request. To cancel pending operations
to modify the number of cache nodes in a cluster, use the
\code{ModifyCacheCluster} request and set \code{NumCacheNodes} equal to the number
of cache nodes currently in the cluster.}

\item{CacheNodeIdsToRemove}{A list of cache node IDs to be removed. A node ID is a numeric
identifier (0001, 0002, etc.). This parameter is only valid when
\code{NumCacheNodes} is less than the existing number of cache nodes. The
number of cache node IDs supplied in this parameter must match the
difference between the existing number of cache nodes in the cluster or
pending cache nodes, whichever is greater, and the value of
\code{NumCacheNodes} in the request.

For example: If you have 3 active cache nodes, 7 pending cache nodes,
and the number of cache nodes in this \code{ModifyCacheCluster} call is 5,
you must list 2 (7 - 5) cache node IDs to remove.}

\item{AZMode}{Specifies whether the new nodes in this Memcached cluster are all
created in a single Availability Zone or created across multiple
Availability Zones.

Valid values: \code{single-az} \\| \code{cross-az}.

This option is only supported for Memcached clusters.

You cannot specify \code{single-az} if the Memcached cluster already has
cache nodes in different Availability Zones. If \code{cross-az} is specified,
existing Memcached nodes remain in their current Availability Zone.

Only newly created nodes are located in different Availability Zones.}

\item{NewAvailabilityZones}{The list of Availability Zones where the new Memcached cache nodes are
created.

This parameter is only valid when \code{NumCacheNodes} in the request is
greater than the sum of the number of active cache nodes and the number
of cache nodes pending creation (which may be zero). The number of
Availability Zones supplied in this list must match the cache nodes
being added in this request.

This option is only supported on Memcached clusters.

Scenarios:
\itemize{
\item \strong{Scenario 1:} You have 3 active nodes and wish to add 2 nodes.
Specify \code{NumCacheNodes=5} (3 + 2) and optionally specify two
Availability Zones for the two new nodes.
\item \strong{Scenario 2:} You have 3 active nodes and 2 nodes pending creation
(from the scenario 1 call) and want to add 1 more node. Specify
\code{NumCacheNodes=6} ((3 + 2) + 1) and optionally specify an
Availability Zone for the new node.
\item \strong{Scenario 3:} You want to cancel all pending operations. Specify
\code{NumCacheNodes=3} to cancel all pending operations.
}

The Availability Zone placement of nodes pending creation cannot be
modified. If you wish to cancel any nodes pending creation, add 0 nodes
by setting \code{NumCacheNodes} to the number of current nodes.

If \code{cross-az} is specified, existing Memcached nodes remain in their
current Availability Zone. Only newly created nodes can be located in
different Availability Zones. For guidance on how to move existing
Memcached nodes to different Availability Zones, see the \strong{Availability
Zone Considerations} section of \href{https://docs.aws.amazon.com/AmazonElastiCache/latest/mem-ug/CacheNodes.SupportedTypes.html}{Cache Node Considerations for Memcached}.

\strong{Impact of new add/remove requests upon pending requests}
\itemize{
\item Scenario-1
\itemize{
\item Pending Action: Delete
\item New Request: Delete
\item Result: The new delete, pending or immediate, replaces the
pending delete.
}
\item Scenario-2
\itemize{
\item Pending Action: Delete
\item New Request: Create
\item Result: The new create, pending or immediate, replaces the
pending delete.
}
\item Scenario-3
\itemize{
\item Pending Action: Create
\item New Request: Delete
\item Result: The new delete, pending or immediate, replaces the
pending create.
}
\item Scenario-4
\itemize{
\item Pending Action: Create
\item New Request: Create
\item Result: The new create is added to the pending create.

\strong{Important:} If the new create request is \strong{Apply
Immediately - Yes}, all creates are performed immediately. If
the new create request is \strong{Apply Immediately - No}, all
creates are pending.
}
}}

\item{CacheSecurityGroupNames}{A list of cache security group names to authorize on this cluster. This
change is asynchronously applied as soon as possible.

You can use this parameter only with clusters that are created outside
of an Amazon Virtual Private Cloud (Amazon VPC).

Constraints: Must contain no more than 255 alphanumeric characters. Must
not be \"Default\".}

\item{SecurityGroupIds}{Specifies the VPC Security Groups associated with the cluster.

This parameter can be used only with clusters that are created in an
Amazon Virtual Private Cloud (Amazon VPC).}

\item{PreferredMaintenanceWindow}{Specifies the weekly time range during which maintenance on the cluster
is performed. It is specified as a range in the format
ddd:hh24:mi-ddd:hh24:mi (24H Clock UTC). The minimum maintenance window
is a 60 minute period.

Valid values for \code{ddd} are:
\itemize{
\item \code{sun}
\item \code{mon}
\item \code{tue}
\item \code{wed}
\item \code{thu}
\item \code{fri}
\item \code{sat}
}

Example: \code{sun:23:00-mon:01:30}}

\item{NotificationTopicArn}{The Amazon Resource Name (ARN) of the Amazon SNS topic to which
notifications are sent.

The Amazon SNS topic owner must be same as the cluster owner.}

\item{CacheParameterGroupName}{The name of the cache parameter group to apply to this cluster. This
change is asynchronously applied as soon as possible for parameters when
the \code{ApplyImmediately} parameter is specified as \code{true} for this
request.}

\item{NotificationTopicStatus}{The status of the Amazon SNS notification topic. Notifications are sent
only if the status is \code{active}.

Valid values: \code{active} \\| \code{inactive}}

\item{ApplyImmediately}{If \code{true}, this parameter causes the modifications in this request and
any pending modifications to be applied, asynchronously and as soon as
possible, regardless of the \code{PreferredMaintenanceWindow} setting for the
cluster.

If \code{false}, changes to the cluster are applied on the next maintenance
reboot, or the next failure reboot, whichever occurs first.

If you perform a \code{ModifyCacheCluster} before a pending modification is
applied, the pending modification is replaced by the newer modification.

Valid values: \code{true} \\| \code{false}

Default: \code{false}}

\item{EngineVersion}{The upgraded version of the cache engine to be run on the cache nodes.

\strong{Important:} You can upgrade to a newer engine version (see \href{https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/SelectEngine.html#VersionManagement}{Selecting a Cache Engine and Version}),
but you cannot downgrade to an earlier engine version. If you want to
use an earlier engine version, you must delete the existing cluster and
create it anew with the earlier engine version.}

\item{AutoMinorVersionUpgrade}{This parameter is currently disabled.}

\item{SnapshotRetentionLimit}{The number of days for which ElastiCache retains automatic cluster
snapshots before deleting them. For example, if you set
\code{SnapshotRetentionLimit} to 5, a snapshot that was taken today is
retained for 5 days before being deleted.

If the value of \code{SnapshotRetentionLimit} is set to zero (0), backups are
turned off.}

\item{SnapshotWindow}{The daily time range (in UTC) during which ElastiCache begins taking a
daily snapshot of your cluster.}

\item{CacheNodeType}{A valid cache node type that you want to scale this cluster up to.}

\item{AuthToken}{Reserved parameter. The password used to access a password protected
server. This parameter must be specified with the \code{auth-token-update}
parameter. Password constraints:
\itemize{
\item Must be only printable ASCII characters
\item Must be at least 16 characters and no more than 128 characters in
length
\item Cannot contain any of the following characters: \'/\', \'\"\', or
\'@\', \'\%\'
}

For more information, see AUTH password at AUTH.}

\item{AuthTokenUpdateStrategy}{Specifies the strategy to use to update the AUTH token. This parameter
must be specified with the \code{auth-token} parameter. Possible values:
\itemize{
\item Rotate
\item Set
}

For more information, see \href{https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/auth.html}{Authenticating Users with Redis AUTH}}
}
\description{
Modifies the settings for a cluster. You can use this operation to
change one or more cluster configuration parameters by specifying the
parameters and the new values.
}
\section{Request syntax}{
\preformatted{svc$modify_cache_cluster(
  CacheClusterId = "string",
  NumCacheNodes = 123,
  CacheNodeIdsToRemove = list(
    "string"
  ),
  AZMode = "single-az"|"cross-az",
  NewAvailabilityZones = list(
    "string"
  ),
  CacheSecurityGroupNames = list(
    "string"
  ),
  SecurityGroupIds = list(
    "string"
  ),
  PreferredMaintenanceWindow = "string",
  NotificationTopicArn = "string",
  CacheParameterGroupName = "string",
  NotificationTopicStatus = "string",
  ApplyImmediately = TRUE|FALSE,
  EngineVersion = "string",
  AutoMinorVersionUpgrade = TRUE|FALSE,
  SnapshotRetentionLimit = 123,
  SnapshotWindow = "string",
  CacheNodeType = "string",
  AuthToken = "string",
  AuthTokenUpdateStrategy = "SET"|"ROTATE"
)
}
}

\keyword{internal}
