% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rds_operations.R
\name{rds_stop_db_cluster}
\alias{rds_stop_db_cluster}
\title{Stops an Amazon Aurora DB cluster}
\usage{
rds_stop_db_cluster(DBClusterIdentifier)
}
\arguments{
\item{DBClusterIdentifier}{[required] The DB cluster identifier of the Amazon Aurora DB cluster to be stopped.
This parameter is stored as a lowercase string.}
}
\description{
Stops an Amazon Aurora DB cluster. When you stop a DB cluster, Aurora
retains the DB cluster\'s metadata, including its endpoints and DB
parameter groups. Aurora also retains the transaction logs so you can do
a point-in-time restore if necessary.
}
\details{
For more information, see \href{https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-cluster-stop-start.html}{Stopping and Starting an Aurora Cluster}
in the \emph{Amazon Aurora User Guide.}

This action only applies to Aurora DB clusters.
}
\section{Request syntax}{
\preformatted{svc$stop_db_cluster(
  DBClusterIdentifier = "string"
)
}
}

\keyword{internal}
