% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/elasticache_operations.R
\name{elasticache_add_tags_to_resource}
\alias{elasticache_add_tags_to_resource}
\title{Adds up to 50 cost allocation tags to the named resource}
\usage{
elasticache_add_tags_to_resource(ResourceName, Tags)
}
\arguments{
\item{ResourceName}{[required] The Amazon Resource Name (ARN) of the resource to which the tags are to
be added, for example
\code{arn:aws:elasticache:us-west-2:0123456789:cluster:myCluster} or
\code{arn:aws:elasticache:us-west-2:0123456789:snapshot:mySnapshot}.
ElastiCache resources are \emph{cluster} and \emph{snapshot}.

For more information about ARNs, see \href{https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html}{Amazon Resource Names (ARNs) and AWS Service Namespaces}.}

\item{Tags}{[required] A list of cost allocation tags to be added to this resource. A tag is a
key-value pair. A tag key must be accompanied by a tag value.}
}
\description{
Adds up to 50 cost allocation tags to the named resource. A cost
allocation tag is a key-value pair where the key and value are
case-sensitive. You can use cost allocation tags to categorize and track
your AWS costs.
}
\details{
When you apply tags to your ElastiCache resources, AWS generates a cost
allocation report as a comma-separated value (CSV) file with your usage
and costs aggregated by your tags. You can apply tags that represent
business categories (such as cost centers, application names, or owners)
to organize your costs across multiple services. For more information,
see \href{https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/Tagging.html}{Using Cost Allocation Tags in Amazon ElastiCache}
in the \emph{ElastiCache User Guide}.
}
\section{Request syntax}{
\preformatted{svc$add_tags_to_resource(
  ResourceName = "string",
  Tags = list(
    list(
      Key = "string",
      Value = "string"
    )
  )
)
}
}

\keyword{internal}
