# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include dynamodb_service.R
NULL

#' The BatchGetItem operation returns the attributes of one or more items
#' from one or more tables
#'
#' The `BatchGetItem` operation returns the attributes of one or more items
#' from one or more tables. You identify requested items by primary key.
#' 
#' A single operation can retrieve up to 16 MB of data, which can contain
#' as many as 100 items. `BatchGetItem` returns a partial result if the
#' response size limit is exceeded, the table\'s provisioned throughput is
#' exceeded, or an internal processing failure occurs. If a partial result
#' is returned, the operation returns a value for `UnprocessedKeys`. You
#' can use this value to retry the operation starting with the next item to
#' get.
#' 
#' If you request more than 100 items, `BatchGetItem` returns a
#' `ValidationException` with the message \"Too many items requested for
#' the BatchGetItem call.\"
#' 
#' For example, if you ask to retrieve 100 items, but each individual item
#' is 300 KB in size, the system returns 52 items (so as not to exceed the
#' 16 MB limit). It also returns an appropriate `UnprocessedKeys` value so
#' you can get the next page of results. If desired, your application can
#' include its own logic to assemble the pages of results into one dataset.
#' 
#' If *none* of the items can be processed due to insufficient provisioned
#' throughput on all of the tables in the request, then `BatchGetItem`
#' returns a `ProvisionedThroughputExceededException`. If *at least one* of
#' the items is successfully processed, then `BatchGetItem` completes
#' successfully, while returning the keys of the unread items in
#' `UnprocessedKeys`.
#' 
#' If DynamoDB returns any unprocessed items, you should retry the batch
#' operation on those items. However, *we strongly recommend that you use
#' an exponential backoff algorithm*. If you retry the batch operation
#' immediately, the underlying read or write requests can still fail due to
#' throttling on the individual tables. If you delay the batch operation
#' using exponential backoff, the individual requests in the batch are much
#' more likely to succeed.
#' 
#' For more information, see [Batch Operations and Error
#' Handling](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/ErrorHandling.html#BatchOperations)
#' in the *Amazon DynamoDB Developer Guide*.
#' 
#' By default, `BatchGetItem` performs eventually consistent reads on every
#' table in the request. If you want strongly consistent reads instead, you
#' can set `ConsistentRead` to `true` for any or all tables.
#' 
#' In order to minimize response latency, `BatchGetItem` retrieves items in
#' parallel.
#' 
#' When designing your application, keep in mind that DynamoDB does not
#' return items in any particular order. To help parse the response by
#' item, include the primary key values for the items in your request in
#' the `ProjectionExpression` parameter.
#' 
#' If a requested item does not exist, it is not returned in the result.
#' Requests for nonexistent items consume the minimum read capacity units
#' according to the type of read. For more information, see [Working with
#' Tables](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/WorkingWithTables.html#CapacityUnitCalculations)
#' in the *Amazon DynamoDB Developer Guide*.
#'
#' @usage
#' dynamodb_batch_get_item(RequestItems, ReturnConsumedCapacity)
#'
#' @param RequestItems &#91;required&#93; A map of one or more table names and, for each table, a map that
#' describes one or more items to retrieve from that table. Each table name
#' can be used only once per `BatchGetItem` request.
#' 
#' Each element in the map of items to retrieve consists of the following:
#' 
#' -   `ConsistentRead` - If `true`, a strongly consistent read is used; if
#'     `false` (the default), an eventually consistent read is used.
#' 
#' -   `ExpressionAttributeNames` - One or more substitution tokens for
#'     attribute names in the `ProjectionExpression` parameter. The
#'     following are some use cases for using `ExpressionAttributeNames`:
#' 
#'     -   To access an attribute whose name conflicts with a DynamoDB
#'         reserved word.
#' 
#'     -   To create a placeholder for repeating occurrences of an
#'         attribute name in an expression.
#' 
#'     -   To prevent special characters in an attribute name from being
#'         misinterpreted in an expression.
#' 
#'     Use the **\\#** character in an expression to dereference an
#'     attribute name. For example, consider the following attribute name:
#' 
#'     -   `Percentile`
#' 
#'     The name of this attribute conflicts with a reserved word, so it
#'     cannot be used directly in an expression. (For the complete list of
#'     reserved words, see [Reserved
#'     Words](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/ReservedWords.html)
#'     in the *Amazon DynamoDB Developer Guide*). To work around this, you
#'     could specify the following for `ExpressionAttributeNames`:
#' 
#'     -   `\{"#P":"Percentile"\}`
#' 
#'     You could then use this substitution in an expression, as in this
#'     example:
#' 
#'     -   `#P = :val`
#' 
#'     Tokens that begin with the **:** character are *expression attribute
#'     values*, which are placeholders for the actual value at runtime.
#' 
#'     For more information about expression attribute names, see
#'     [Accessing Item
#'     Attributes](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.AccessingItemAttributes.html)
#'     in the *Amazon DynamoDB Developer Guide*.
#' 
#' -   `Keys` - An array of primary key attribute values that define
#'     specific items in the table. For each primary key, you must provide
#'     *all* of the key attributes. For example, with a simple primary key,
#'     you only need to provide the partition key value. For a composite
#'     key, you must provide *both* the partition key value and the sort
#'     key value.
#' 
#' -   `ProjectionExpression` - A string that identifies one or more
#'     attributes to retrieve from the table. These attributes can include
#'     scalars, sets, or elements of a JSON document. The attributes in the
#'     expression must be separated by commas.
#' 
#'     If no attribute names are specified, then all attributes are
#'     returned. If any of the requested attributes are not found, they do
#'     not appear in the result.
#' 
#'     For more information, see [Accessing Item
#'     Attributes](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.AccessingItemAttributes.html)
#'     in the *Amazon DynamoDB Developer Guide*.
#' 
#' -   `AttributesToGet` - This is a legacy parameter. Use
#'     `ProjectionExpression` instead. For more information, see
#'     [AttributesToGet](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.AttributesToGet.html)
#'     in the *Amazon DynamoDB Developer Guide*.
#' @param ReturnConsumedCapacity 
#'
#' @section Request syntax:
#' ```
#' svc$batch_get_item(
#'   RequestItems = list(
#'     list(
#'       Keys = list(
#'         list(
#'           list(
#'             S = "string",
#'             N = "string",
#'             B = raw,
#'             SS = list(
#'               "string"
#'             ),
#'             NS = list(
#'               "string"
#'             ),
#'             BS = list(
#'               raw
#'             ),
#'             M = list(
#'               list()
#'             ),
#'             L = list(
#'               list()
#'             ),
#'             NULL = TRUE|FALSE,
#'             BOOL = TRUE|FALSE
#'           )
#'         )
#'       ),
#'       AttributesToGet = list(
#'         "string"
#'       ),
#'       ConsistentRead = TRUE|FALSE,
#'       ProjectionExpression = "string",
#'       ExpressionAttributeNames = list(
#'         "string"
#'       )
#'     )
#'   ),
#'   ReturnConsumedCapacity = "INDEXES"|"TOTAL"|"NONE"
#' )
#' ```
#'
#' @examples
#' # This example reads multiple items from the Music table using a batch of
#' # three GetItem requests.  Only the AlbumTitle attribute is returned.
#' \donttest{svc$batch_get_item(
#'   RequestItems = list(
#'     Music = list(
#'       Keys = list(
#'         list(
#'           Artist = list(
#'             S = "No One You Know"
#'           ),
#'           SongTitle = list(
#'             S = "Call Me Today"
#'           )
#'         ),
#'         list(
#'           Artist = list(
#'             S = "Acme Band"
#'           ),
#'           SongTitle = list(
#'             S = "Happy Day"
#'           )
#'         ),
#'         list(
#'           Artist = list(
#'             S = "No One You Know"
#'           ),
#'           SongTitle = list(
#'             S = "Scared of My Shadow"
#'           )
#'         )
#'       ),
#'       ProjectionExpression = "AlbumTitle"
#'     )
#'   )
#' )}
#'
#' @keywords internal
#'
#' @rdname dynamodb_batch_get_item
dynamodb_batch_get_item <- function(RequestItems, ReturnConsumedCapacity = NULL) {
  op <- new_operation(
    name = "BatchGetItem",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .dynamodb$batch_get_item_input(RequestItems = RequestItems, ReturnConsumedCapacity = ReturnConsumedCapacity)
  output <- .dynamodb$batch_get_item_output()
  config <- get_config()
  svc <- .dynamodb$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.dynamodb$operations$batch_get_item <- dynamodb_batch_get_item

#' The BatchWriteItem operation puts or deletes multiple items in one or
#' more tables
#'
#' The `BatchWriteItem` operation puts or deletes multiple items in one or
#' more tables. A single call to `BatchWriteItem` can write up to 16 MB of
#' data, which can comprise as many as 25 put or delete requests.
#' Individual items to be written can be as large as 400 KB.
#' 
#' `BatchWriteItem` cannot update items. To update items, use the
#' `UpdateItem` action.
#' 
#' The individual `PutItem` and `DeleteItem` operations specified in
#' `BatchWriteItem` are atomic; however `BatchWriteItem` as a whole is not.
#' If any requested operations fail because the table\'s provisioned
#' throughput is exceeded or an internal processing failure occurs, the
#' failed operations are returned in the `UnprocessedItems` response
#' parameter. You can investigate and optionally resend the requests.
#' Typically, you would call `BatchWriteItem` in a loop. Each iteration
#' would check for unprocessed items and submit a new `BatchWriteItem`
#' request with those unprocessed items until all items have been
#' processed.
#' 
#' If *none* of the items can be processed due to insufficient provisioned
#' throughput on all of the tables in the request, then `BatchWriteItem`
#' returns a `ProvisionedThroughputExceededException`.
#' 
#' If DynamoDB returns any unprocessed items, you should retry the batch
#' operation on those items. However, *we strongly recommend that you use
#' an exponential backoff algorithm*. If you retry the batch operation
#' immediately, the underlying read or write requests can still fail due to
#' throttling on the individual tables. If you delay the batch operation
#' using exponential backoff, the individual requests in the batch are much
#' more likely to succeed.
#' 
#' For more information, see [Batch Operations and Error
#' Handling](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/ErrorHandling.html#Programming.Errors.BatchOperations)
#' in the *Amazon DynamoDB Developer Guide*.
#' 
#' With `BatchWriteItem`, you can efficiently write or delete large amounts
#' of data, such as from Amazon EMR, or copy data from another database
#' into DynamoDB. In order to improve performance with these large-scale
#' operations, `BatchWriteItem` does not behave in the same way as
#' individual `PutItem` and `DeleteItem` calls would. For example, you
#' cannot specify conditions on individual put and delete requests, and
#' `BatchWriteItem` does not return deleted items in the response.
#' 
#' If you use a programming language that supports concurrency, you can use
#' threads to write items in parallel. Your application must include the
#' necessary logic to manage the threads. With languages that don\'t
#' support threading, you must update or delete the specified items one at
#' a time. In both situations, `BatchWriteItem` performs the specified put
#' and delete operations in parallel, giving you the power of the thread
#' pool approach without having to introduce complexity into your
#' application.
#' 
#' Parallel processing reduces latency, but each specified put and delete
#' request consumes the same number of write capacity units whether it is
#' processed in parallel or not. Delete operations on nonexistent items
#' consume one write capacity unit.
#' 
#' If one or more of the following is true, DynamoDB rejects the entire
#' batch write operation:
#' 
#' -   One or more tables specified in the `BatchWriteItem` request does
#'     not exist.
#' 
#' -   Primary key attributes specified on an item in the request do not
#'     match those in the corresponding table\'s primary key schema.
#' 
#' -   You try to perform multiple operations on the same item in the same
#'     `BatchWriteItem` request. For example, you cannot put and delete the
#'     same item in the same `BatchWriteItem` request.
#' 
#' -   Your request contains at least two items with identical hash and
#'     range keys (which essentially is two put operations).
#' 
#' -   There are more than 25 requests in the batch.
#' 
#' -   Any individual item in a batch exceeds 400 KB.
#' 
#' -   The total request size exceeds 16 MB.
#'
#' @usage
#' dynamodb_batch_write_item(RequestItems, ReturnConsumedCapacity,
#'   ReturnItemCollectionMetrics)
#'
#' @param RequestItems &#91;required&#93; A map of one or more table names and, for each table, a list of
#' operations to be performed (`DeleteRequest` or `PutRequest`). Each
#' element in the map consists of the following:
#' 
#' -   `DeleteRequest` - Perform a `DeleteItem` operation on the specified
#'     item. The item to be deleted is identified by a `Key` subelement:
#' 
#'     -   `Key` - A map of primary key attribute values that uniquely
#'         identify the item. Each entry in this map consists of an
#'         attribute name and an attribute value. For each primary key, you
#'         must provide *all* of the key attributes. For example, with a
#'         simple primary key, you only need to provide a value for the
#'         partition key. For a composite primary key, you must provide
#'         values for *both* the partition key and the sort key.
#' 
#' -   `PutRequest` - Perform a `PutItem` operation on the specified item.
#'     The item to be put is identified by an `Item` subelement:
#' 
#'     -   `Item` - A map of attributes and their values. Each entry in
#'         this map consists of an attribute name and an attribute value.
#'         Attribute values must not be null; string and binary type
#'         attributes must have lengths greater than zero; and set type
#'         attributes must not be empty. Requests that contain empty values
#'         are rejected with a `ValidationException` exception.
#' 
#'         If you specify any attributes that are part of an index key,
#'         then the data types for those attributes must match those of the
#'         schema in the table\'s attribute definition.
#' @param ReturnConsumedCapacity 
#' @param ReturnItemCollectionMetrics Determines whether item collection metrics are returned. If set to
#' `SIZE`, the response includes statistics about item collections, if any,
#' that were modified during the operation are returned in the response. If
#' set to `NONE` (the default), no statistics are returned.
#'
#' @section Request syntax:
#' ```
#' svc$batch_write_item(
#'   RequestItems = list(
#'     list(
#'       list(
#'         PutRequest = list(
#'           Item = list(
#'             list(
#'               S = "string",
#'               N = "string",
#'               B = raw,
#'               SS = list(
#'                 "string"
#'               ),
#'               NS = list(
#'                 "string"
#'               ),
#'               BS = list(
#'                 raw
#'               ),
#'               M = list(
#'                 list()
#'               ),
#'               L = list(
#'                 list()
#'               ),
#'               NULL = TRUE|FALSE,
#'               BOOL = TRUE|FALSE
#'             )
#'           )
#'         ),
#'         DeleteRequest = list(
#'           Key = list(
#'             list(
#'               S = "string",
#'               N = "string",
#'               B = raw,
#'               SS = list(
#'                 "string"
#'               ),
#'               NS = list(
#'                 "string"
#'               ),
#'               BS = list(
#'                 raw
#'               ),
#'               M = list(
#'                 list()
#'               ),
#'               L = list(
#'                 list()
#'               ),
#'               NULL = TRUE|FALSE,
#'               BOOL = TRUE|FALSE
#'             )
#'           )
#'         )
#'       )
#'     )
#'   ),
#'   ReturnConsumedCapacity = "INDEXES"|"TOTAL"|"NONE",
#'   ReturnItemCollectionMetrics = "SIZE"|"NONE"
#' )
#' ```
#'
#' @examples
#' # This example adds three new items to the Music table using a batch of
#' # three PutItem requests.
#' \donttest{svc$batch_write_item(
#'   RequestItems = list(
#'     Music = list(
#'       list(
#'         PutRequest = list(
#'           Item = list(
#'             AlbumTitle = list(
#'               S = "Somewhat Famous"
#'             ),
#'             Artist = list(
#'               S = "No One You Know"
#'             ),
#'             SongTitle = list(
#'               S = "Call Me Today"
#'             )
#'           )
#'         )
#'       ),
#'       list(
#'         PutRequest = list(
#'           Item = list(
#'             AlbumTitle = list(
#'               S = "Songs About Life"
#'             ),
#'             Artist = list(
#'               S = "Acme Band"
#'             ),
#'             SongTitle = list(
#'               S = "Happy Day"
#'             )
#'           )
#'         )
#'       ),
#'       list(
#'         PutRequest = list(
#'           Item = list(
#'             AlbumTitle = list(
#'               S = "Blue Sky Blues"
#'             ),
#'             Artist = list(
#'               S = "No One You Know"
#'             ),
#'             SongTitle = list(
#'               S = "Scared of My Shadow"
#'             )
#'           )
#'         )
#'       )
#'     )
#'   )
#' )}
#'
#' @keywords internal
#'
#' @rdname dynamodb_batch_write_item
dynamodb_batch_write_item <- function(RequestItems, ReturnConsumedCapacity = NULL, ReturnItemCollectionMetrics = NULL) {
  op <- new_operation(
    name = "BatchWriteItem",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .dynamodb$batch_write_item_input(RequestItems = RequestItems, ReturnConsumedCapacity = ReturnConsumedCapacity, ReturnItemCollectionMetrics = ReturnItemCollectionMetrics)
  output <- .dynamodb$batch_write_item_output()
  config <- get_config()
  svc <- .dynamodb$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.dynamodb$operations$batch_write_item <- dynamodb_batch_write_item

#' Creates a backup for an existing table
#'
#' Creates a backup for an existing table.
#' 
#' Each time you create an on-demand backup, the entire table data is
#' backed up. There is no limit to the number of on-demand backups that can
#' be taken.
#' 
#' When you create an on-demand backup, a time marker of the request is
#' cataloged, and the backup is created asynchronously, by applying all
#' changes until the time of the request to the last full table snapshot.
#' Backup requests are processed instantaneously and become available for
#' restore within minutes.
#' 
#' You can call `CreateBackup` at a maximum rate of 50 times per second.
#' 
#' All backups in DynamoDB work without consuming any provisioned
#' throughput on the table.
#' 
#' If you submit a backup request on 2018-12-14 at 14:25:00, the backup is
#' guaranteed to contain all data committed to the table up to 14:24:00,
#' and data committed after 14:26:00 will not be. The backup might contain
#' data modifications made between 14:24:00 and 14:26:00. On-demand backup
#' does not support causal consistency.
#' 
#' Along with data, the following are also included on the backups:
#' 
#' -   Global secondary indexes (GSIs)
#' 
#' -   Local secondary indexes (LSIs)
#' 
#' -   Streams
#' 
#' -   Provisioned read and write capacity
#'
#' @usage
#' dynamodb_create_backup(TableName, BackupName)
#'
#' @param TableName &#91;required&#93; The name of the table.
#' @param BackupName &#91;required&#93; Specified name for the backup.
#'
#' @section Request syntax:
#' ```
#' svc$create_backup(
#'   TableName = "string",
#'   BackupName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname dynamodb_create_backup
dynamodb_create_backup <- function(TableName, BackupName) {
  op <- new_operation(
    name = "CreateBackup",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .dynamodb$create_backup_input(TableName = TableName, BackupName = BackupName)
  output <- .dynamodb$create_backup_output()
  config <- get_config()
  svc <- .dynamodb$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.dynamodb$operations$create_backup <- dynamodb_create_backup

#' Creates a global table from an existing table
#'
#' Creates a global table from an existing table. A global table creates a
#' replication relationship between two or more DynamoDB tables with the
#' same table name in the provided Regions.
#' 
#' If you want to add a new replica table to a global table, each of the
#' following conditions must be true:
#' 
#' -   The table must have the same primary key as all of the other
#'     replicas.
#' 
#' -   The table must have the same name as all of the other replicas.
#' 
#' -   The table must have DynamoDB Streams enabled, with the stream
#'     containing both the new and the old images of the item.
#' 
#' -   None of the replica tables in the global table can contain any data.
#' 
#' If global secondary indexes are specified, then the following conditions
#' must also be met:
#' 
#' -   The global secondary indexes must have the same name.
#' 
#' -   The global secondary indexes must have the same hash key and sort
#'     key (if present).
#' 
#' Write capacity settings should be set consistently across your replica
#' tables and secondary indexes. DynamoDB strongly recommends enabling auto
#' scaling to manage the write capacity settings for all of your global
#' tables replicas and indexes.
#' 
#' If you prefer to manage write capacity settings manually, you should
#' provision equal replicated write capacity units to your replica tables.
#' You should also provision equal replicated write capacity units to
#' matching secondary indexes across your global table.
#'
#' @usage
#' dynamodb_create_global_table(GlobalTableName, ReplicationGroup)
#'
#' @param GlobalTableName &#91;required&#93; The global table name.
#' @param ReplicationGroup &#91;required&#93; The Regions where the global table needs to be created.
#'
#' @section Request syntax:
#' ```
#' svc$create_global_table(
#'   GlobalTableName = "string",
#'   ReplicationGroup = list(
#'     list(
#'       RegionName = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname dynamodb_create_global_table
dynamodb_create_global_table <- function(GlobalTableName, ReplicationGroup) {
  op <- new_operation(
    name = "CreateGlobalTable",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .dynamodb$create_global_table_input(GlobalTableName = GlobalTableName, ReplicationGroup = ReplicationGroup)
  output <- .dynamodb$create_global_table_output()
  config <- get_config()
  svc <- .dynamodb$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.dynamodb$operations$create_global_table <- dynamodb_create_global_table

#' The CreateTable operation adds a new table to your account
#'
#' The `CreateTable` operation adds a new table to your account. In an AWS
#' account, table names must be unique within each Region. That is, you can
#' have two tables with same name if you create the tables in different
#' Regions.
#' 
#' `CreateTable` is an asynchronous operation. Upon receiving a
#' `CreateTable` request, DynamoDB immediately returns a response with a
#' `TableStatus` of `CREATING`. After the table is created, DynamoDB sets
#' the `TableStatus` to `ACTIVE`. You can perform read and write operations
#' only on an `ACTIVE` table.
#' 
#' You can optionally define secondary indexes on the new table, as part of
#' the `CreateTable` operation. If you want to create multiple tables with
#' secondary indexes on them, you must create the tables sequentially. Only
#' one table with secondary indexes can be in the `CREATING` state at any
#' given time.
#' 
#' You can use the `DescribeTable` action to check the table status.
#'
#' @usage
#' dynamodb_create_table(AttributeDefinitions, TableName, KeySchema,
#'   LocalSecondaryIndexes, GlobalSecondaryIndexes, BillingMode,
#'   ProvisionedThroughput, StreamSpecification, SSESpecification, Tags)
#'
#' @param AttributeDefinitions &#91;required&#93; An array of attributes that describe the key schema for the table and
#' indexes.
#' @param TableName &#91;required&#93; The name of the table to create.
#' @param KeySchema &#91;required&#93; Specifies the attributes that make up the primary key for a table or an
#' index. The attributes in `KeySchema` must also be defined in the
#' `AttributeDefinitions` array. For more information, see [Data
#' Model](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/DataModel.html)
#' in the *Amazon DynamoDB Developer Guide*.
#' 
#' Each `KeySchemaElement` in the array is composed of:
#' 
#' -   `AttributeName` - The name of this key attribute.
#' 
#' -   `KeyType` - The role that the key attribute will assume:
#' 
#'     -   `HASH` - partition key
#' 
#'     -   `RANGE` - sort key
#' 
#' The partition key of an item is also known as its *hash attribute*. The
#' term \"hash attribute\" derives from the DynamoDB usage of an internal
#' hash function to evenly distribute data items across partitions, based
#' on their partition key values.
#' 
#' The sort key of an item is also known as its *range attribute*. The term
#' \"range attribute\" derives from the way DynamoDB stores items with the
#' same partition key physically close together, in sorted order by the
#' sort key value.
#' 
#' For a simple primary key (partition key), you must provide exactly one
#' element with a `KeyType` of `HASH`.
#' 
#' For a composite primary key (partition key and sort key), you must
#' provide exactly two elements, in this order: The first element must have
#' a `KeyType` of `HASH`, and the second element must have a `KeyType` of
#' `RANGE`.
#' 
#' For more information, see [Working with
#' Tables](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/WorkingWithTables.html#WorkingWithTables.primary.key)
#' in the *Amazon DynamoDB Developer Guide*.
#' @param LocalSecondaryIndexes One or more local secondary indexes (the maximum is 5) to be created on
#' the table. Each index is scoped to a given partition key value. There is
#' a 10 GB size limit per partition key value; otherwise, the size of a
#' local secondary index is unconstrained.
#' 
#' Each local secondary index in the array includes the following:
#' 
#' -   `IndexName` - The name of the local secondary index. Must be unique
#'     only for this table.
#' 
#' -   `KeySchema` - Specifies the key schema for the local secondary
#'     index. The key schema must begin with the same partition key as the
#'     table.
#' 
#' -   `Projection` - Specifies attributes that are copied (projected) from
#'     the table into the index. These are in addition to the primary key
#'     attributes and index key attributes, which are automatically
#'     projected. Each attribute specification is composed of:
#' 
#'     -   `ProjectionType` - One of the following:
#' 
#'         -   `KEYS_ONLY` - Only the index and primary keys are projected
#'             into the index.
#' 
#'         -   `INCLUDE` - Only the specified table attributes are
#'             projected into the index. The list of projected attributes
#'             is in `NonKeyAttributes`.
#' 
#'         -   `ALL` - All of the table attributes are projected into the
#'             index.
#' 
#'     -   `NonKeyAttributes` - A list of one or more non-key attribute
#'         names that are projected into the secondary index. The total
#'         count of attributes provided in `NonKeyAttributes`, summed
#'         across all of the secondary indexes, must not exceed 100. If you
#'         project the same attribute into two different indexes, this
#'         counts as two distinct attributes when determining the total.
#' @param GlobalSecondaryIndexes One or more global secondary indexes (the maximum is 20) to be created
#' on the table. Each global secondary index in the array includes the
#' following:
#' 
#' -   `IndexName` - The name of the global secondary index. Must be unique
#'     only for this table.
#' 
#' -   `KeySchema` - Specifies the key schema for the global secondary
#'     index.
#' 
#' -   `Projection` - Specifies attributes that are copied (projected) from
#'     the table into the index. These are in addition to the primary key
#'     attributes and index key attributes, which are automatically
#'     projected. Each attribute specification is composed of:
#' 
#'     -   `ProjectionType` - One of the following:
#' 
#'         -   `KEYS_ONLY` - Only the index and primary keys are projected
#'             into the index.
#' 
#'         -   `INCLUDE` - Only the specified table attributes are
#'             projected into the index. The list of projected attributes
#'             is in `NonKeyAttributes`.
#' 
#'         -   `ALL` - All of the table attributes are projected into the
#'             index.
#' 
#'     -   `NonKeyAttributes` - A list of one or more non-key attribute
#'         names that are projected into the secondary index. The total
#'         count of attributes provided in `NonKeyAttributes`, summed
#'         across all of the secondary indexes, must not exceed 100. If you
#'         project the same attribute into two different indexes, this
#'         counts as two distinct attributes when determining the total.
#' 
#' -   `ProvisionedThroughput` - The provisioned throughput settings for
#'     the global secondary index, consisting of read and write capacity
#'     units.
#' @param BillingMode Controls how you are charged for read and write throughput and how you
#' manage capacity. This setting can be changed later.
#' 
#' -   `PROVISIONED` - Sets the billing mode to `PROVISIONED`. We recommend
#'     using `PROVISIONED` for predictable workloads.
#' 
#' -   `PAY_PER_REQUEST` - Sets the billing mode to `PAY_PER_REQUEST`. We
#'     recommend using `PAY_PER_REQUEST` for unpredictable workloads.
#' @param ProvisionedThroughput Represents the provisioned throughput settings for a specified table or
#' index. The settings can be modified using the `UpdateTable` operation.
#' 
#' If you set BillingMode as `PROVISIONED`, you must specify this property.
#' If you set BillingMode as `PAY_PER_REQUEST`, you cannot specify this
#' property.
#' 
#' For current minimum and maximum provisioned throughput values, see
#' [Limits](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Limits.html)
#' in the *Amazon DynamoDB Developer Guide*.
#' @param StreamSpecification The settings for DynamoDB Streams on the table. These settings consist
#' of:
#' 
#' -   `StreamEnabled` - Indicates whether DynamoDB Streams is to be
#'     enabled (true) or disabled (false).
#' 
#' -   `StreamViewType` - When an item in the table is modified,
#'     `StreamViewType` determines what information is written to the
#'     table\'s stream. Valid values for `StreamViewType` are:
#' 
#'     -   `KEYS_ONLY` - Only the key attributes of the modified item are
#'         written to the stream.
#' 
#'     -   `NEW_IMAGE` - The entire item, as it appears after it was
#'         modified, is written to the stream.
#' 
#'     -   `OLD_IMAGE` - The entire item, as it appeared before it was
#'         modified, is written to the stream.
#' 
#'     -   `NEW_AND_OLD_IMAGES` - Both the new and the old item images of
#'         the item are written to the stream.
#' @param SSESpecification Represents the settings used to enable server-side encryption.
#' @param Tags A list of key-value pairs to label the table. For more information, see
#' [Tagging for
#' DynamoDB](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Tagging.html).
#'
#' @section Request syntax:
#' ```
#' svc$create_table(
#'   AttributeDefinitions = list(
#'     list(
#'       AttributeName = "string",
#'       AttributeType = "S"|"N"|"B"
#'     )
#'   ),
#'   TableName = "string",
#'   KeySchema = list(
#'     list(
#'       AttributeName = "string",
#'       KeyType = "HASH"|"RANGE"
#'     )
#'   ),
#'   LocalSecondaryIndexes = list(
#'     list(
#'       IndexName = "string",
#'       KeySchema = list(
#'         list(
#'           AttributeName = "string",
#'           KeyType = "HASH"|"RANGE"
#'         )
#'       ),
#'       Projection = list(
#'         ProjectionType = "ALL"|"KEYS_ONLY"|"INCLUDE",
#'         NonKeyAttributes = list(
#'           "string"
#'         )
#'       )
#'     )
#'   ),
#'   GlobalSecondaryIndexes = list(
#'     list(
#'       IndexName = "string",
#'       KeySchema = list(
#'         list(
#'           AttributeName = "string",
#'           KeyType = "HASH"|"RANGE"
#'         )
#'       ),
#'       Projection = list(
#'         ProjectionType = "ALL"|"KEYS_ONLY"|"INCLUDE",
#'         NonKeyAttributes = list(
#'           "string"
#'         )
#'       ),
#'       ProvisionedThroughput = list(
#'         ReadCapacityUnits = 123,
#'         WriteCapacityUnits = 123
#'       )
#'     )
#'   ),
#'   BillingMode = "PROVISIONED"|"PAY_PER_REQUEST",
#'   ProvisionedThroughput = list(
#'     ReadCapacityUnits = 123,
#'     WriteCapacityUnits = 123
#'   ),
#'   StreamSpecification = list(
#'     StreamEnabled = TRUE|FALSE,
#'     StreamViewType = "NEW_IMAGE"|"OLD_IMAGE"|"NEW_AND_OLD_IMAGES"|"KEYS_ONLY"
#'   ),
#'   SSESpecification = list(
#'     Enabled = TRUE|FALSE,
#'     SSEType = "AES256"|"KMS",
#'     KMSMasterKeyId = "string"
#'   ),
#'   Tags = list(
#'     list(
#'       Key = "string",
#'       Value = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @examples
#' # This example creates a table named Music.
#' \donttest{svc$create_table(
#'   AttributeDefinitions = list(
#'     list(
#'       AttributeName = "Artist",
#'       AttributeType = "S"
#'     ),
#'     list(
#'       AttributeName = "SongTitle",
#'       AttributeType = "S"
#'     )
#'   ),
#'   KeySchema = list(
#'     list(
#'       AttributeName = "Artist",
#'       KeyType = "HASH"
#'     ),
#'     list(
#'       AttributeName = "SongTitle",
#'       KeyType = "RANGE"
#'     )
#'   ),
#'   ProvisionedThroughput = list(
#'     ReadCapacityUnits = 5L,
#'     WriteCapacityUnits = 5L
#'   ),
#'   TableName = "Music"
#' )}
#'
#' @keywords internal
#'
#' @rdname dynamodb_create_table
dynamodb_create_table <- function(AttributeDefinitions, TableName, KeySchema, LocalSecondaryIndexes = NULL, GlobalSecondaryIndexes = NULL, BillingMode = NULL, ProvisionedThroughput = NULL, StreamSpecification = NULL, SSESpecification = NULL, Tags = NULL) {
  op <- new_operation(
    name = "CreateTable",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .dynamodb$create_table_input(AttributeDefinitions = AttributeDefinitions, TableName = TableName, KeySchema = KeySchema, LocalSecondaryIndexes = LocalSecondaryIndexes, GlobalSecondaryIndexes = GlobalSecondaryIndexes, BillingMode = BillingMode, ProvisionedThroughput = ProvisionedThroughput, StreamSpecification = StreamSpecification, SSESpecification = SSESpecification, Tags = Tags)
  output <- .dynamodb$create_table_output()
  config <- get_config()
  svc <- .dynamodb$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.dynamodb$operations$create_table <- dynamodb_create_table

#' Deletes an existing backup of a table
#'
#' Deletes an existing backup of a table.
#' 
#' You can call `DeleteBackup` at a maximum rate of 10 times per second.
#'
#' @usage
#' dynamodb_delete_backup(BackupArn)
#'
#' @param BackupArn &#91;required&#93; The ARN associated with the backup.
#'
#' @section Request syntax:
#' ```
#' svc$delete_backup(
#'   BackupArn = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname dynamodb_delete_backup
dynamodb_delete_backup <- function(BackupArn) {
  op <- new_operation(
    name = "DeleteBackup",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .dynamodb$delete_backup_input(BackupArn = BackupArn)
  output <- .dynamodb$delete_backup_output()
  config <- get_config()
  svc <- .dynamodb$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.dynamodb$operations$delete_backup <- dynamodb_delete_backup

#' Deletes a single item in a table by primary key
#'
#' Deletes a single item in a table by primary key. You can perform a
#' conditional delete operation that deletes the item if it exists, or if
#' it has an expected attribute value.
#' 
#' In addition to deleting an item, you can also return the item\'s
#' attribute values in the same operation, using the `ReturnValues`
#' parameter.
#' 
#' Unless you specify conditions, the `DeleteItem` is an idempotent
#' operation; running it multiple times on the same item or attribute does
#' *not* result in an error response.
#' 
#' Conditional deletes are useful for deleting items only if specific
#' conditions are met. If those conditions are met, DynamoDB performs the
#' delete. Otherwise, the item is not deleted.
#'
#' @usage
#' dynamodb_delete_item(TableName, Key, Expected, ConditionalOperator,
#'   ReturnValues, ReturnConsumedCapacity, ReturnItemCollectionMetrics,
#'   ConditionExpression, ExpressionAttributeNames,
#'   ExpressionAttributeValues)
#'
#' @param TableName &#91;required&#93; The name of the table from which to delete the item.
#' @param Key &#91;required&#93; A map of attribute names to `AttributeValue` objects, representing the
#' primary key of the item to delete.
#' 
#' For the primary key, you must provide all of the attributes. For
#' example, with a simple primary key, you only need to provide a value for
#' the partition key. For a composite primary key, you must provide values
#' for both the partition key and the sort key.
#' @param Expected This is a legacy parameter. Use `ConditionExpression` instead. For more
#' information, see
#' [Expected](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.Expected.html)
#' in the *Amazon DynamoDB Developer Guide*.
#' @param ConditionalOperator This is a legacy parameter. Use `ConditionExpression` instead. For more
#' information, see
#' [ConditionalOperator](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.ConditionalOperator.html)
#' in the *Amazon DynamoDB Developer Guide*.
#' @param ReturnValues Use `ReturnValues` if you want to get the item attributes as they
#' appeared before they were deleted. For `DeleteItem`, the valid values
#' are:
#' 
#' -   `NONE` - If `ReturnValues` is not specified, or if its value is
#'     `NONE`, then nothing is returned. (This setting is the default for
#'     `ReturnValues`.)
#' 
#' -   `ALL_OLD` - The content of the old item is returned.
#' 
#' The `ReturnValues` parameter is used by several DynamoDB operations;
#' however, `DeleteItem` does not recognize any values other than `NONE` or
#' `ALL_OLD`.
#' @param ReturnConsumedCapacity 
#' @param ReturnItemCollectionMetrics Determines whether item collection metrics are returned. If set to
#' `SIZE`, the response includes statistics about item collections, if any,
#' that were modified during the operation are returned in the response. If
#' set to `NONE` (the default), no statistics are returned.
#' @param ConditionExpression A condition that must be satisfied in order for a conditional
#' `DeleteItem` to succeed.
#' 
#' An expression can contain any of the following:
#' 
#' -   Functions:
#'     `attribute_exists | attribute_not_exists | attribute_type | contains | begins_with | size`
#' 
#'     These function names are case-sensitive.
#' 
#' -   Comparison operators:
#'     `= | &lt;&gt; | &lt; | &gt; | &lt;= | &gt;= | BETWEEN | IN `
#' 
#' -   Logical operators: `AND | OR | NOT`
#' 
#' For more information about condition expressions, see [Condition
#' Expressions](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.SpecifyingConditions.html)
#' in the *Amazon DynamoDB Developer Guide*.
#' @param ExpressionAttributeNames One or more substitution tokens for attribute names in an expression.
#' The following are some use cases for using `ExpressionAttributeNames`:
#' 
#' -   To access an attribute whose name conflicts with a DynamoDB reserved
#'     word.
#' 
#' -   To create a placeholder for repeating occurrences of an attribute
#'     name in an expression.
#' 
#' -   To prevent special characters in an attribute name from being
#'     misinterpreted in an expression.
#' 
#' Use the **\\#** character in an expression to dereference an attribute
#' name. For example, consider the following attribute name:
#' 
#' -   `Percentile`
#' 
#' The name of this attribute conflicts with a reserved word, so it cannot
#' be used directly in an expression. (For the complete list of reserved
#' words, see [Reserved
#' Words](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/ReservedWords.html)
#' in the *Amazon DynamoDB Developer Guide*). To work around this, you
#' could specify the following for `ExpressionAttributeNames`:
#' 
#' -   `\{"#P":"Percentile"\}`
#' 
#' You could then use this substitution in an expression, as in this
#' example:
#' 
#' -   `#P = :val`
#' 
#' Tokens that begin with the **:** character are *expression attribute
#' values*, which are placeholders for the actual value at runtime.
#' 
#' For more information on expression attribute names, see [Specifying Item
#' Attributes](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.AccessingItemAttributes.html)
#' in the *Amazon DynamoDB Developer Guide*.
#' @param ExpressionAttributeValues One or more values that can be substituted in an expression.
#' 
#' Use the **:** (colon) character in an expression to dereference an
#' attribute value. For example, suppose that you wanted to check whether
#' the value of the *ProductStatus* attribute was one of the following:
#' 
#' `Available | Backordered | Discontinued`
#' 
#' You would first need to specify `ExpressionAttributeValues` as follows:
#' 
#' `\{ ":avail":\{"S":"Available"\}, ":back":\{"S":"Backordered"\}, ":disc":\{"S":"Discontinued"\} \}`
#' 
#' You could then use these values in an expression, such as this:
#' 
#' `ProductStatus IN (:avail, :back, :disc)`
#' 
#' For more information on expression attribute values, see [Condition
#' Expressions](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.SpecifyingConditions.html)
#' in the *Amazon DynamoDB Developer Guide*.
#'
#' @section Request syntax:
#' ```
#' svc$delete_item(
#'   TableName = "string",
#'   Key = list(
#'     list(
#'       S = "string",
#'       N = "string",
#'       B = raw,
#'       SS = list(
#'         "string"
#'       ),
#'       NS = list(
#'         "string"
#'       ),
#'       BS = list(
#'         raw
#'       ),
#'       M = list(
#'         list()
#'       ),
#'       L = list(
#'         list()
#'       ),
#'       NULL = TRUE|FALSE,
#'       BOOL = TRUE|FALSE
#'     )
#'   ),
#'   Expected = list(
#'     list(
#'       Value = list(
#'         S = "string",
#'         N = "string",
#'         B = raw,
#'         SS = list(
#'           "string"
#'         ),
#'         NS = list(
#'           "string"
#'         ),
#'         BS = list(
#'           raw
#'         ),
#'         M = list(
#'           list()
#'         ),
#'         L = list(
#'           list()
#'         ),
#'         NULL = TRUE|FALSE,
#'         BOOL = TRUE|FALSE
#'       ),
#'       Exists = TRUE|FALSE,
#'       ComparisonOperator = "EQ"|"NE"|"IN"|"LE"|"LT"|"GE"|"GT"|"BETWEEN"|"NOT_NULL"|"NULL"|"CONTAINS"|"NOT_CONTAINS"|"BEGINS_WITH",
#'       AttributeValueList = list(
#'         list(
#'           S = "string",
#'           N = "string",
#'           B = raw,
#'           SS = list(
#'             "string"
#'           ),
#'           NS = list(
#'             "string"
#'           ),
#'           BS = list(
#'             raw
#'           ),
#'           M = list(
#'             list()
#'           ),
#'           L = list(
#'             list()
#'           ),
#'           NULL = TRUE|FALSE,
#'           BOOL = TRUE|FALSE
#'         )
#'       )
#'     )
#'   ),
#'   ConditionalOperator = "AND"|"OR",
#'   ReturnValues = "NONE"|"ALL_OLD"|"UPDATED_OLD"|"ALL_NEW"|"UPDATED_NEW",
#'   ReturnConsumedCapacity = "INDEXES"|"TOTAL"|"NONE",
#'   ReturnItemCollectionMetrics = "SIZE"|"NONE",
#'   ConditionExpression = "string",
#'   ExpressionAttributeNames = list(
#'     "string"
#'   ),
#'   ExpressionAttributeValues = list(
#'     list(
#'       S = "string",
#'       N = "string",
#'       B = raw,
#'       SS = list(
#'         "string"
#'       ),
#'       NS = list(
#'         "string"
#'       ),
#'       BS = list(
#'         raw
#'       ),
#'       M = list(
#'         list()
#'       ),
#'       L = list(
#'         list()
#'       ),
#'       NULL = TRUE|FALSE,
#'       BOOL = TRUE|FALSE
#'     )
#'   )
#' )
#' ```
#'
#' @examples
#' # This example deletes an item from the Music table.
#' \donttest{svc$delete_item(
#'   Key = list(
#'     Artist = list(
#'       S = "No One You Know"
#'     ),
#'     SongTitle = list(
#'       S = "Scared of My Shadow"
#'     )
#'   ),
#'   TableName = "Music"
#' )}
#'
#' @keywords internal
#'
#' @rdname dynamodb_delete_item
dynamodb_delete_item <- function(TableName, Key, Expected = NULL, ConditionalOperator = NULL, ReturnValues = NULL, ReturnConsumedCapacity = NULL, ReturnItemCollectionMetrics = NULL, ConditionExpression = NULL, ExpressionAttributeNames = NULL, ExpressionAttributeValues = NULL) {
  op <- new_operation(
    name = "DeleteItem",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .dynamodb$delete_item_input(TableName = TableName, Key = Key, Expected = Expected, ConditionalOperator = ConditionalOperator, ReturnValues = ReturnValues, ReturnConsumedCapacity = ReturnConsumedCapacity, ReturnItemCollectionMetrics = ReturnItemCollectionMetrics, ConditionExpression = ConditionExpression, ExpressionAttributeNames = ExpressionAttributeNames, ExpressionAttributeValues = ExpressionAttributeValues)
  output <- .dynamodb$delete_item_output()
  config <- get_config()
  svc <- .dynamodb$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.dynamodb$operations$delete_item <- dynamodb_delete_item

#' The DeleteTable operation deletes a table and all of its items
#'
#' The `DeleteTable` operation deletes a table and all of its items. After
#' a `DeleteTable` request, the specified table is in the `DELETING` state
#' until DynamoDB completes the deletion. If the table is in the `ACTIVE`
#' state, you can delete it. If a table is in `CREATING` or `UPDATING`
#' states, then DynamoDB returns a `ResourceInUseException`. If the
#' specified table does not exist, DynamoDB returns a
#' `ResourceNotFoundException`. If table is already in the `DELETING`
#' state, no error is returned.
#' 
#' DynamoDB might continue to accept data read and write operations, such
#' as `GetItem` and `PutItem`, on a table in the `DELETING` state until the
#' table deletion is complete.
#' 
#' When you delete a table, any indexes on that table are also deleted.
#' 
#' If you have DynamoDB Streams enabled on the table, then the
#' corresponding stream on that table goes into the `DISABLED` state, and
#' the stream is automatically deleted after 24 hours.
#' 
#' Use the `DescribeTable` action to check the status of the table.
#'
#' @usage
#' dynamodb_delete_table(TableName)
#'
#' @param TableName &#91;required&#93; The name of the table to delete.
#'
#' @section Request syntax:
#' ```
#' svc$delete_table(
#'   TableName = "string"
#' )
#' ```
#'
#' @examples
#' # This example deletes the Music table.
#' \donttest{svc$delete_table(
#'   TableName = "Music"
#' )}
#'
#' @keywords internal
#'
#' @rdname dynamodb_delete_table
dynamodb_delete_table <- function(TableName) {
  op <- new_operation(
    name = "DeleteTable",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .dynamodb$delete_table_input(TableName = TableName)
  output <- .dynamodb$delete_table_output()
  config <- get_config()
  svc <- .dynamodb$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.dynamodb$operations$delete_table <- dynamodb_delete_table

#' Describes an existing backup of a table
#'
#' Describes an existing backup of a table.
#' 
#' You can call `DescribeBackup` at a maximum rate of 10 times per second.
#'
#' @usage
#' dynamodb_describe_backup(BackupArn)
#'
#' @param BackupArn &#91;required&#93; The Amazon Resource Name (ARN) associated with the backup.
#'
#' @section Request syntax:
#' ```
#' svc$describe_backup(
#'   BackupArn = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname dynamodb_describe_backup
dynamodb_describe_backup <- function(BackupArn) {
  op <- new_operation(
    name = "DescribeBackup",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .dynamodb$describe_backup_input(BackupArn = BackupArn)
  output <- .dynamodb$describe_backup_output()
  config <- get_config()
  svc <- .dynamodb$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.dynamodb$operations$describe_backup <- dynamodb_describe_backup

#' Checks the status of continuous backups and point in time recovery on
#' the specified table
#'
#' Checks the status of continuous backups and point in time recovery on
#' the specified table. Continuous backups are `ENABLED` on all tables at
#' table creation. If point in time recovery is enabled,
#' `PointInTimeRecoveryStatus` will be set to ENABLED.
#' 
#' After continuous backups and point in time recovery are enabled, you can
#' restore to any point in time within `EarliestRestorableDateTime` and
#' `LatestRestorableDateTime`.
#' 
#' `LatestRestorableDateTime` is typically 5 minutes before the current
#' time. You can restore your table to any point in time during the last 35
#' days.
#' 
#' You can call `DescribeContinuousBackups` at a maximum rate of 10 times
#' per second.
#'
#' @usage
#' dynamodb_describe_continuous_backups(TableName)
#'
#' @param TableName &#91;required&#93; Name of the table for which the customer wants to check the continuous
#' backups and point in time recovery settings.
#'
#' @section Request syntax:
#' ```
#' svc$describe_continuous_backups(
#'   TableName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname dynamodb_describe_continuous_backups
dynamodb_describe_continuous_backups <- function(TableName) {
  op <- new_operation(
    name = "DescribeContinuousBackups",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .dynamodb$describe_continuous_backups_input(TableName = TableName)
  output <- .dynamodb$describe_continuous_backups_output()
  config <- get_config()
  svc <- .dynamodb$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.dynamodb$operations$describe_continuous_backups <- dynamodb_describe_continuous_backups

#' Returns the regional endpoint information
#'
#' Returns the regional endpoint information.
#'
#' @usage
#' dynamodb_describe_endpoints()
#'
#' @section Request syntax:
#' ```
#' svc$describe_endpoints()
#' ```
#'
#' @keywords internal
#'
#' @rdname dynamodb_describe_endpoints
dynamodb_describe_endpoints <- function() {
  op <- new_operation(
    name = "DescribeEndpoints",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .dynamodb$describe_endpoints_input()
  output <- .dynamodb$describe_endpoints_output()
  config <- get_config()
  svc <- .dynamodb$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.dynamodb$operations$describe_endpoints <- dynamodb_describe_endpoints

#' Returns information about the specified global table
#'
#' Returns information about the specified global table.
#'
#' @usage
#' dynamodb_describe_global_table(GlobalTableName)
#'
#' @param GlobalTableName &#91;required&#93; The name of the global table.
#'
#' @section Request syntax:
#' ```
#' svc$describe_global_table(
#'   GlobalTableName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname dynamodb_describe_global_table
dynamodb_describe_global_table <- function(GlobalTableName) {
  op <- new_operation(
    name = "DescribeGlobalTable",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .dynamodb$describe_global_table_input(GlobalTableName = GlobalTableName)
  output <- .dynamodb$describe_global_table_output()
  config <- get_config()
  svc <- .dynamodb$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.dynamodb$operations$describe_global_table <- dynamodb_describe_global_table

#' Describes Region-specific settings for a global table
#'
#' Describes Region-specific settings for a global table.
#'
#' @usage
#' dynamodb_describe_global_table_settings(GlobalTableName)
#'
#' @param GlobalTableName &#91;required&#93; The name of the global table to describe.
#'
#' @section Request syntax:
#' ```
#' svc$describe_global_table_settings(
#'   GlobalTableName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname dynamodb_describe_global_table_settings
dynamodb_describe_global_table_settings <- function(GlobalTableName) {
  op <- new_operation(
    name = "DescribeGlobalTableSettings",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .dynamodb$describe_global_table_settings_input(GlobalTableName = GlobalTableName)
  output <- .dynamodb$describe_global_table_settings_output()
  config <- get_config()
  svc <- .dynamodb$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.dynamodb$operations$describe_global_table_settings <- dynamodb_describe_global_table_settings

#' Returns the current provisioned-capacity limits for your AWS account in
#' a Region, both for the Region as a whole and for any one DynamoDB table
#' that you create there
#'
#' Returns the current provisioned-capacity limits for your AWS account in
#' a Region, both for the Region as a whole and for any one DynamoDB table
#' that you create there.
#' 
#' When you establish an AWS account, the account has initial limits on the
#' maximum read capacity units and write capacity units that you can
#' provision across all of your DynamoDB tables in a given Region. Also,
#' there are per-table limits that apply when you create a table there. For
#' more information, see
#' [Limits](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Limits.html)
#' page in the *Amazon DynamoDB Developer Guide*.
#' 
#' Although you can increase these limits by filing a case at [AWS Support
#' Center](https://console.aws.amazon.com/support/home#/), obtaining the
#' increase is not instantaneous. The `DescribeLimits` action lets you
#' write code to compare the capacity you are currently using to those
#' limits imposed by your account so that you have enough time to apply for
#' an increase before you hit a limit.
#' 
#' For example, you could use one of the AWS SDKs to do the following:
#' 
#' 1.  Call `DescribeLimits` for a particular Region to obtain your current
#'     account limits on provisioned capacity there.
#' 
#' 2.  Create a variable to hold the aggregate read capacity units
#'     provisioned for all your tables in that Region, and one to hold the
#'     aggregate write capacity units. Zero them both.
#' 
#' 3.  Call `ListTables` to obtain a list of all your DynamoDB tables.
#' 
#' 4.  For each table name listed by `ListTables`, do the following:
#' 
#'     -   Call `DescribeTable` with the table name.
#' 
#'     -   Use the data returned by `DescribeTable` to add the read
#'         capacity units and write capacity units provisioned for the
#'         table itself to your variables.
#' 
#'     -   If the table has one or more global secondary indexes (GSIs),
#'         loop over these GSIs and add their provisioned capacity values
#'         to your variables as well.
#' 
#' 5.  Report the account limits for that Region returned by
#'     `DescribeLimits`, along with the total current provisioned capacity
#'     levels you have calculated.
#' 
#' This will let you see whether you are getting close to your
#' account-level limits.
#' 
#' The per-table limits apply only when you are creating a new table. They
#' restrict the sum of the provisioned capacity of the new table itself and
#' all its global secondary indexes.
#' 
#' For existing tables and their GSIs, DynamoDB doesn\'t let you increase
#' provisioned capacity extremely rapidly. But the only upper limit that
#' applies is that the aggregate provisioned capacity over all your tables
#' and GSIs cannot exceed either of the per-account limits.
#' 
#' `DescribeLimits` should only be called periodically. You can expect
#' throttling errors if you call it more than once in a minute.
#' 
#' The `DescribeLimits` Request element has no content.
#'
#' @usage
#' dynamodb_describe_limits()
#'
#' @section Request syntax:
#' ```
#' svc$describe_limits()
#' ```
#'
#' @examples
#' # The following example returns the maximum read and write capacity units
#' # per table, and for the AWS account, in the current AWS region.
#' \donttest{svc$describe_limits()}
#'
#' @keywords internal
#'
#' @rdname dynamodb_describe_limits
dynamodb_describe_limits <- function() {
  op <- new_operation(
    name = "DescribeLimits",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .dynamodb$describe_limits_input()
  output <- .dynamodb$describe_limits_output()
  config <- get_config()
  svc <- .dynamodb$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.dynamodb$operations$describe_limits <- dynamodb_describe_limits

#' Returns information about the table, including the current status of the
#' table, when it was created, the primary key schema, and any indexes on
#' the table
#'
#' Returns information about the table, including the current status of the
#' table, when it was created, the primary key schema, and any indexes on
#' the table.
#' 
#' If you issue a `DescribeTable` request immediately after a `CreateTable`
#' request, DynamoDB might return a `ResourceNotFoundException`. This is
#' because `DescribeTable` uses an eventually consistent query, and the
#' metadata for your table might not be available at that moment. Wait for
#' a few seconds, and then try the `DescribeTable` request again.
#'
#' @usage
#' dynamodb_describe_table(TableName)
#'
#' @param TableName &#91;required&#93; The name of the table to describe.
#'
#' @section Request syntax:
#' ```
#' svc$describe_table(
#'   TableName = "string"
#' )
#' ```
#'
#' @examples
#' # This example describes the Music table.
#' \donttest{svc$describe_table(
#'   TableName = "Music"
#' )}
#'
#' @keywords internal
#'
#' @rdname dynamodb_describe_table
dynamodb_describe_table <- function(TableName) {
  op <- new_operation(
    name = "DescribeTable",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .dynamodb$describe_table_input(TableName = TableName)
  output <- .dynamodb$describe_table_output()
  config <- get_config()
  svc <- .dynamodb$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.dynamodb$operations$describe_table <- dynamodb_describe_table

#' Gives a description of the Time to Live (TTL) status on the specified
#' table
#'
#' Gives a description of the Time to Live (TTL) status on the specified
#' table.
#'
#' @usage
#' dynamodb_describe_time_to_live(TableName)
#'
#' @param TableName &#91;required&#93; The name of the table to be described.
#'
#' @section Request syntax:
#' ```
#' svc$describe_time_to_live(
#'   TableName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname dynamodb_describe_time_to_live
dynamodb_describe_time_to_live <- function(TableName) {
  op <- new_operation(
    name = "DescribeTimeToLive",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .dynamodb$describe_time_to_live_input(TableName = TableName)
  output <- .dynamodb$describe_time_to_live_output()
  config <- get_config()
  svc <- .dynamodb$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.dynamodb$operations$describe_time_to_live <- dynamodb_describe_time_to_live

#' The GetItem operation returns a set of attributes for the item with the
#' given primary key
#'
#' The `GetItem` operation returns a set of attributes for the item with
#' the given primary key. If there is no matching item, `GetItem` does not
#' return any data and there will be no `Item` element in the response.
#' 
#' `GetItem` provides an eventually consistent read by default. If your
#' application requires a strongly consistent read, set `ConsistentRead` to
#' `true`. Although a strongly consistent read might take more time than an
#' eventually consistent read, it always returns the last updated value.
#'
#' @usage
#' dynamodb_get_item(TableName, Key, AttributesToGet, ConsistentRead,
#'   ReturnConsumedCapacity, ProjectionExpression, ExpressionAttributeNames)
#'
#' @param TableName &#91;required&#93; The name of the table containing the requested item.
#' @param Key &#91;required&#93; A map of attribute names to `AttributeValue` objects, representing the
#' primary key of the item to retrieve.
#' 
#' For the primary key, you must provide all of the attributes. For
#' example, with a simple primary key, you only need to provide a value for
#' the partition key. For a composite primary key, you must provide values
#' for both the partition key and the sort key.
#' @param AttributesToGet This is a legacy parameter. Use `ProjectionExpression` instead. For more
#' information, see
#' [AttributesToGet](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.AttributesToGet.html)
#' in the *Amazon DynamoDB Developer Guide*.
#' @param ConsistentRead Determines the read consistency model: If set to `true`, then the
#' operation uses strongly consistent reads; otherwise, the operation uses
#' eventually consistent reads.
#' @param ReturnConsumedCapacity 
#' @param ProjectionExpression A string that identifies one or more attributes to retrieve from the
#' table. These attributes can include scalars, sets, or elements of a JSON
#' document. The attributes in the expression must be separated by commas.
#' 
#' If no attribute names are specified, then all attributes are returned.
#' If any of the requested attributes are not found, they do not appear in
#' the result.
#' 
#' For more information, see [Specifying Item
#' Attributes](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.AccessingItemAttributes.html)
#' in the *Amazon DynamoDB Developer Guide*.
#' @param ExpressionAttributeNames One or more substitution tokens for attribute names in an expression.
#' The following are some use cases for using `ExpressionAttributeNames`:
#' 
#' -   To access an attribute whose name conflicts with a DynamoDB reserved
#'     word.
#' 
#' -   To create a placeholder for repeating occurrences of an attribute
#'     name in an expression.
#' 
#' -   To prevent special characters in an attribute name from being
#'     misinterpreted in an expression.
#' 
#' Use the **\\#** character in an expression to dereference an attribute
#' name. For example, consider the following attribute name:
#' 
#' -   `Percentile`
#' 
#' The name of this attribute conflicts with a reserved word, so it cannot
#' be used directly in an expression. (For the complete list of reserved
#' words, see [Reserved
#' Words](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/ReservedWords.html)
#' in the *Amazon DynamoDB Developer Guide*). To work around this, you
#' could specify the following for `ExpressionAttributeNames`:
#' 
#' -   `\{"#P":"Percentile"\}`
#' 
#' You could then use this substitution in an expression, as in this
#' example:
#' 
#' -   `#P = :val`
#' 
#' Tokens that begin with the **:** character are *expression attribute
#' values*, which are placeholders for the actual value at runtime.
#' 
#' For more information on expression attribute names, see [Specifying Item
#' Attributes](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.AccessingItemAttributes.html)
#' in the *Amazon DynamoDB Developer Guide*.
#'
#' @section Request syntax:
#' ```
#' svc$get_item(
#'   TableName = "string",
#'   Key = list(
#'     list(
#'       S = "string",
#'       N = "string",
#'       B = raw,
#'       SS = list(
#'         "string"
#'       ),
#'       NS = list(
#'         "string"
#'       ),
#'       BS = list(
#'         raw
#'       ),
#'       M = list(
#'         list()
#'       ),
#'       L = list(
#'         list()
#'       ),
#'       NULL = TRUE|FALSE,
#'       BOOL = TRUE|FALSE
#'     )
#'   ),
#'   AttributesToGet = list(
#'     "string"
#'   ),
#'   ConsistentRead = TRUE|FALSE,
#'   ReturnConsumedCapacity = "INDEXES"|"TOTAL"|"NONE",
#'   ProjectionExpression = "string",
#'   ExpressionAttributeNames = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @examples
#' # This example retrieves an item from the Music table. The table has a
#' # partition key and a sort key (Artist and SongTitle), so you must specify
#' # both of these attributes.
#' \donttest{svc$get_item(
#'   Key = list(
#'     Artist = list(
#'       S = "Acme Band"
#'     ),
#'     SongTitle = list(
#'       S = "Happy Day"
#'     )
#'   ),
#'   TableName = "Music"
#' )}
#'
#' @keywords internal
#'
#' @rdname dynamodb_get_item
dynamodb_get_item <- function(TableName, Key, AttributesToGet = NULL, ConsistentRead = NULL, ReturnConsumedCapacity = NULL, ProjectionExpression = NULL, ExpressionAttributeNames = NULL) {
  op <- new_operation(
    name = "GetItem",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .dynamodb$get_item_input(TableName = TableName, Key = Key, AttributesToGet = AttributesToGet, ConsistentRead = ConsistentRead, ReturnConsumedCapacity = ReturnConsumedCapacity, ProjectionExpression = ProjectionExpression, ExpressionAttributeNames = ExpressionAttributeNames)
  output <- .dynamodb$get_item_output()
  config <- get_config()
  svc <- .dynamodb$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.dynamodb$operations$get_item <- dynamodb_get_item

#' List backups associated with an AWS account
#'
#' List backups associated with an AWS account. To list backups for a given
#' table, specify `TableName`. `ListBackups` returns a paginated list of
#' results with at most 1 MB worth of items in a page. You can also specify
#' a limit for the maximum number of entries to be returned in a page.
#' 
#' In the request, start time is inclusive, but end time is exclusive. Note
#' that these limits are for the time at which the original backup was
#' requested.
#' 
#' You can call `ListBackups` a maximum of five times per second.
#'
#' @usage
#' dynamodb_list_backups(TableName, Limit, TimeRangeLowerBound,
#'   TimeRangeUpperBound, ExclusiveStartBackupArn, BackupType)
#'
#' @param TableName The backups from the table specified by `TableName` are listed.
#' @param Limit Maximum number of backups to return at once.
#' @param TimeRangeLowerBound Only backups created after this time are listed. `TimeRangeLowerBound`
#' is inclusive.
#' @param TimeRangeUpperBound Only backups created before this time are listed. `TimeRangeUpperBound`
#' is exclusive.
#' @param ExclusiveStartBackupArn `LastEvaluatedBackupArn` is the Amazon Resource Name (ARN) of the backup
#' last evaluated when the current page of results was returned, inclusive
#' of the current page of results. This value may be specified as the
#' `ExclusiveStartBackupArn` of a new `ListBackups` operation in order to
#' fetch the next page of results.
#' @param BackupType The backups from the table specified by `BackupType` are listed.
#' 
#' Where `BackupType` can be:
#' 
#' -   `USER` - On-demand backup created by you.
#' 
#' -   `SYSTEM` - On-demand backup automatically created by DynamoDB.
#' 
#' -   `ALL` - All types of on-demand backups (USER and SYSTEM).
#'
#' @section Request syntax:
#' ```
#' svc$list_backups(
#'   TableName = "string",
#'   Limit = 123,
#'   TimeRangeLowerBound = as.POSIXct(
#'     "2015-01-01"
#'   ),
#'   TimeRangeUpperBound = as.POSIXct(
#'     "2015-01-01"
#'   ),
#'   ExclusiveStartBackupArn = "string",
#'   BackupType = "USER"|"SYSTEM"|"AWS_BACKUP"|"ALL"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname dynamodb_list_backups
dynamodb_list_backups <- function(TableName = NULL, Limit = NULL, TimeRangeLowerBound = NULL, TimeRangeUpperBound = NULL, ExclusiveStartBackupArn = NULL, BackupType = NULL) {
  op <- new_operation(
    name = "ListBackups",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .dynamodb$list_backups_input(TableName = TableName, Limit = Limit, TimeRangeLowerBound = TimeRangeLowerBound, TimeRangeUpperBound = TimeRangeUpperBound, ExclusiveStartBackupArn = ExclusiveStartBackupArn, BackupType = BackupType)
  output <- .dynamodb$list_backups_output()
  config <- get_config()
  svc <- .dynamodb$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.dynamodb$operations$list_backups <- dynamodb_list_backups

#' Lists all global tables that have a replica in the specified Region
#'
#' Lists all global tables that have a replica in the specified Region.
#'
#' @usage
#' dynamodb_list_global_tables(ExclusiveStartGlobalTableName, Limit,
#'   RegionName)
#'
#' @param ExclusiveStartGlobalTableName The first global table name that this operation will evaluate.
#' @param Limit The maximum number of table names to return.
#' @param RegionName Lists the global tables in a specific Region.
#'
#' @section Request syntax:
#' ```
#' svc$list_global_tables(
#'   ExclusiveStartGlobalTableName = "string",
#'   Limit = 123,
#'   RegionName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname dynamodb_list_global_tables
dynamodb_list_global_tables <- function(ExclusiveStartGlobalTableName = NULL, Limit = NULL, RegionName = NULL) {
  op <- new_operation(
    name = "ListGlobalTables",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .dynamodb$list_global_tables_input(ExclusiveStartGlobalTableName = ExclusiveStartGlobalTableName, Limit = Limit, RegionName = RegionName)
  output <- .dynamodb$list_global_tables_output()
  config <- get_config()
  svc <- .dynamodb$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.dynamodb$operations$list_global_tables <- dynamodb_list_global_tables

#' Returns an array of table names associated with the current account and
#' endpoint
#'
#' Returns an array of table names associated with the current account and
#' endpoint. The output from `ListTables` is paginated, with each page
#' returning a maximum of 100 table names.
#'
#' @usage
#' dynamodb_list_tables(ExclusiveStartTableName, Limit)
#'
#' @param ExclusiveStartTableName The first table name that this operation will evaluate. Use the value
#' that was returned for `LastEvaluatedTableName` in a previous operation,
#' so that you can obtain the next page of results.
#' @param Limit A maximum number of table names to return. If this parameter is not
#' specified, the limit is 100.
#'
#' @section Request syntax:
#' ```
#' svc$list_tables(
#'   ExclusiveStartTableName = "string",
#'   Limit = 123
#' )
#' ```
#'
#' @examples
#' # This example lists all of the tables associated with the current AWS
#' # account and endpoint.
#' \donttest{svc$list_tables()}
#'
#' @keywords internal
#'
#' @rdname dynamodb_list_tables
dynamodb_list_tables <- function(ExclusiveStartTableName = NULL, Limit = NULL) {
  op <- new_operation(
    name = "ListTables",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .dynamodb$list_tables_input(ExclusiveStartTableName = ExclusiveStartTableName, Limit = Limit)
  output <- .dynamodb$list_tables_output()
  config <- get_config()
  svc <- .dynamodb$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.dynamodb$operations$list_tables <- dynamodb_list_tables

#' List all tags on an Amazon DynamoDB resource
#'
#' List all tags on an Amazon DynamoDB resource. You can call
#' ListTagsOfResource up to 10 times per second, per account.
#' 
#' For an overview on tagging DynamoDB resources, see [Tagging for
#' DynamoDB](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Tagging.html)
#' in the *Amazon DynamoDB Developer Guide*.
#'
#' @usage
#' dynamodb_list_tags_of_resource(ResourceArn, NextToken)
#'
#' @param ResourceArn &#91;required&#93; The Amazon DynamoDB resource with tags to be listed. This value is an
#' Amazon Resource Name (ARN).
#' @param NextToken An optional string that, if supplied, must be copied from the output of
#' a previous call to ListTagOfResource. When provided in this manner, this
#' API fetches the next page of results.
#'
#' @section Request syntax:
#' ```
#' svc$list_tags_of_resource(
#'   ResourceArn = "string",
#'   NextToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname dynamodb_list_tags_of_resource
dynamodb_list_tags_of_resource <- function(ResourceArn, NextToken = NULL) {
  op <- new_operation(
    name = "ListTagsOfResource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .dynamodb$list_tags_of_resource_input(ResourceArn = ResourceArn, NextToken = NextToken)
  output <- .dynamodb$list_tags_of_resource_output()
  config <- get_config()
  svc <- .dynamodb$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.dynamodb$operations$list_tags_of_resource <- dynamodb_list_tags_of_resource

#' Creates a new item, or replaces an old item with a new item
#'
#' Creates a new item, or replaces an old item with a new item. If an item
#' that has the same primary key as the new item already exists in the
#' specified table, the new item completely replaces the existing item. You
#' can perform a conditional put operation (add a new item if one with the
#' specified primary key doesn\'t exist), or replace an existing item if it
#' has certain attribute values. You can return the item\'s attribute
#' values in the same operation, using the `ReturnValues` parameter.
#' 
#' This topic provides general information about the `PutItem` API.
#' 
#' For information on how to call the `PutItem` API using the AWS SDK in
#' specific languages, see the following:
#' 
#' -   [PutItem in the AWS Command Line
#'     Interface](http://docs.aws.amazon.com/goto/aws-cli/dynamodb-2012-08-10/PutItem)
#' 
#' -   [PutItem in the AWS SDK for
#'     .NET](http://docs.aws.amazon.com/goto/DotNetSDKV3/dynamodb-2012-08-10/PutItem)
#' 
#' -   [PutItem in the AWS SDK for
#'     C++](http://docs.aws.amazon.com/goto/SdkForCpp/dynamodb-2012-08-10/PutItem)
#' 
#' -   [PutItem in the AWS SDK for
#'     Go](http://docs.aws.amazon.com/goto/SdkForGoV1/dynamodb-2012-08-10/PutItem)
#' 
#' -   [PutItem in the AWS SDK for
#'     Java](http://docs.aws.amazon.com/goto/SdkForJava/dynamodb-2012-08-10/PutItem)
#' 
#' -   [PutItem in the AWS SDK for
#'     JavaScript](http://docs.aws.amazon.com/goto/AWSJavaScriptSDK/dynamodb-2012-08-10/PutItem)
#' 
#' -   [PutItem in the AWS SDK for PHP
#'     V3](http://docs.aws.amazon.com/goto/SdkForPHPV3/dynamodb-2012-08-10/PutItem)
#' 
#' -   [PutItem in the AWS SDK for
#'     Python](http://docs.aws.amazon.com/goto/boto3/dynamodb-2012-08-10/PutItem)
#' 
#' -   [PutItem in the AWS SDK for Ruby
#'     V2](http://docs.aws.amazon.com/goto/SdkForRubyV2/dynamodb-2012-08-10/PutItem)
#' 
#' When you add an item, the primary key attributes are the only required
#' attributes. Attribute values cannot be null. String and Binary type
#' attributes must have lengths greater than zero. Set type attributes
#' cannot be empty. Requests with empty values will be rejected with a
#' `ValidationException` exception.
#' 
#' To prevent a new item from replacing an existing item, use a conditional
#' expression that contains the `attribute_not_exists` function with the
#' name of the attribute being used as the partition key for the table.
#' Since every record must contain that attribute, the
#' `attribute_not_exists` function will only succeed if no matching item
#' exists.
#' 
#' For more information about `PutItem`, see [Working with
#' Items](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/WorkingWithItems.html)
#' in the *Amazon DynamoDB Developer Guide*.
#'
#' @usage
#' dynamodb_put_item(TableName, Item, Expected, ReturnValues,
#'   ReturnConsumedCapacity, ReturnItemCollectionMetrics,
#'   ConditionalOperator, ConditionExpression, ExpressionAttributeNames,
#'   ExpressionAttributeValues)
#'
#' @param TableName &#91;required&#93; The name of the table to contain the item.
#' @param Item &#91;required&#93; A map of attribute name/value pairs, one for each attribute. Only the
#' primary key attributes are required; you can optionally provide other
#' attribute name-value pairs for the item.
#' 
#' You must provide all of the attributes for the primary key. For example,
#' with a simple primary key, you only need to provide a value for the
#' partition key. For a composite primary key, you must provide both values
#' for both the partition key and the sort key.
#' 
#' If you specify any attributes that are part of an index key, then the
#' data types for those attributes must match those of the schema in the
#' table\'s attribute definition.
#' 
#' For more information about primary keys, see [Primary
#' Key](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/HowItWorks.CoreComponents.html#HowItWorks.CoreComponents.PrimaryKey)
#' in the *Amazon DynamoDB Developer Guide*.
#' 
#' Each element in the `Item` map is an `AttributeValue` object.
#' @param Expected This is a legacy parameter. Use `ConditionExpression` instead. For more
#' information, see
#' [Expected](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.Expected.html)
#' in the *Amazon DynamoDB Developer Guide*.
#' @param ReturnValues Use `ReturnValues` if you want to get the item attributes as they
#' appeared before they were updated with the `PutItem` request. For
#' `PutItem`, the valid values are:
#' 
#' -   `NONE` - If `ReturnValues` is not specified, or if its value is
#'     `NONE`, then nothing is returned. (This setting is the default for
#'     `ReturnValues`.)
#' 
#' -   `ALL_OLD` - If `PutItem` overwrote an attribute name-value pair,
#'     then the content of the old item is returned.
#' 
#' The `ReturnValues` parameter is used by several DynamoDB operations;
#' however, `PutItem` does not recognize any values other than `NONE` or
#' `ALL_OLD`.
#' @param ReturnConsumedCapacity 
#' @param ReturnItemCollectionMetrics Determines whether item collection metrics are returned. If set to
#' `SIZE`, the response includes statistics about item collections, if any,
#' that were modified during the operation are returned in the response. If
#' set to `NONE` (the default), no statistics are returned.
#' @param ConditionalOperator This is a legacy parameter. Use `ConditionExpression` instead. For more
#' information, see
#' [ConditionalOperator](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.ConditionalOperator.html)
#' in the *Amazon DynamoDB Developer Guide*.
#' @param ConditionExpression A condition that must be satisfied in order for a conditional `PutItem`
#' operation to succeed.
#' 
#' An expression can contain any of the following:
#' 
#' -   Functions:
#'     `attribute_exists | attribute_not_exists | attribute_type | contains | begins_with | size`
#' 
#'     These function names are case-sensitive.
#' 
#' -   Comparison operators:
#'     `= | &lt;&gt; | &lt; | &gt; | &lt;= | &gt;= | BETWEEN | IN `
#' 
#' -   Logical operators: `AND | OR | NOT`
#' 
#' For more information on condition expressions, see [Condition
#' Expressions](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.SpecifyingConditions.html)
#' in the *Amazon DynamoDB Developer Guide*.
#' @param ExpressionAttributeNames One or more substitution tokens for attribute names in an expression.
#' The following are some use cases for using `ExpressionAttributeNames`:
#' 
#' -   To access an attribute whose name conflicts with a DynamoDB reserved
#'     word.
#' 
#' -   To create a placeholder for repeating occurrences of an attribute
#'     name in an expression.
#' 
#' -   To prevent special characters in an attribute name from being
#'     misinterpreted in an expression.
#' 
#' Use the **\\#** character in an expression to dereference an attribute
#' name. For example, consider the following attribute name:
#' 
#' -   `Percentile`
#' 
#' The name of this attribute conflicts with a reserved word, so it cannot
#' be used directly in an expression. (For the complete list of reserved
#' words, see [Reserved
#' Words](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/ReservedWords.html)
#' in the *Amazon DynamoDB Developer Guide*). To work around this, you
#' could specify the following for `ExpressionAttributeNames`:
#' 
#' -   `\{"#P":"Percentile"\}`
#' 
#' You could then use this substitution in an expression, as in this
#' example:
#' 
#' -   `#P = :val`
#' 
#' Tokens that begin with the **:** character are *expression attribute
#' values*, which are placeholders for the actual value at runtime.
#' 
#' For more information on expression attribute names, see [Specifying Item
#' Attributes](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.AccessingItemAttributes.html)
#' in the *Amazon DynamoDB Developer Guide*.
#' @param ExpressionAttributeValues One or more values that can be substituted in an expression.
#' 
#' Use the **:** (colon) character in an expression to dereference an
#' attribute value. For example, suppose that you wanted to check whether
#' the value of the *ProductStatus* attribute was one of the following:
#' 
#' `Available | Backordered | Discontinued`
#' 
#' You would first need to specify `ExpressionAttributeValues` as follows:
#' 
#' `\{ ":avail":\{"S":"Available"\}, ":back":\{"S":"Backordered"\}, ":disc":\{"S":"Discontinued"\} \}`
#' 
#' You could then use these values in an expression, such as this:
#' 
#' `ProductStatus IN (:avail, :back, :disc)`
#' 
#' For more information on expression attribute values, see [Condition
#' Expressions](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.SpecifyingConditions.html)
#' in the *Amazon DynamoDB Developer Guide*.
#'
#' @section Request syntax:
#' ```
#' svc$put_item(
#'   TableName = "string",
#'   Item = list(
#'     list(
#'       S = "string",
#'       N = "string",
#'       B = raw,
#'       SS = list(
#'         "string"
#'       ),
#'       NS = list(
#'         "string"
#'       ),
#'       BS = list(
#'         raw
#'       ),
#'       M = list(
#'         list()
#'       ),
#'       L = list(
#'         list()
#'       ),
#'       NULL = TRUE|FALSE,
#'       BOOL = TRUE|FALSE
#'     )
#'   ),
#'   Expected = list(
#'     list(
#'       Value = list(
#'         S = "string",
#'         N = "string",
#'         B = raw,
#'         SS = list(
#'           "string"
#'         ),
#'         NS = list(
#'           "string"
#'         ),
#'         BS = list(
#'           raw
#'         ),
#'         M = list(
#'           list()
#'         ),
#'         L = list(
#'           list()
#'         ),
#'         NULL = TRUE|FALSE,
#'         BOOL = TRUE|FALSE
#'       ),
#'       Exists = TRUE|FALSE,
#'       ComparisonOperator = "EQ"|"NE"|"IN"|"LE"|"LT"|"GE"|"GT"|"BETWEEN"|"NOT_NULL"|"NULL"|"CONTAINS"|"NOT_CONTAINS"|"BEGINS_WITH",
#'       AttributeValueList = list(
#'         list(
#'           S = "string",
#'           N = "string",
#'           B = raw,
#'           SS = list(
#'             "string"
#'           ),
#'           NS = list(
#'             "string"
#'           ),
#'           BS = list(
#'             raw
#'           ),
#'           M = list(
#'             list()
#'           ),
#'           L = list(
#'             list()
#'           ),
#'           NULL = TRUE|FALSE,
#'           BOOL = TRUE|FALSE
#'         )
#'       )
#'     )
#'   ),
#'   ReturnValues = "NONE"|"ALL_OLD"|"UPDATED_OLD"|"ALL_NEW"|"UPDATED_NEW",
#'   ReturnConsumedCapacity = "INDEXES"|"TOTAL"|"NONE",
#'   ReturnItemCollectionMetrics = "SIZE"|"NONE",
#'   ConditionalOperator = "AND"|"OR",
#'   ConditionExpression = "string",
#'   ExpressionAttributeNames = list(
#'     "string"
#'   ),
#'   ExpressionAttributeValues = list(
#'     list(
#'       S = "string",
#'       N = "string",
#'       B = raw,
#'       SS = list(
#'         "string"
#'       ),
#'       NS = list(
#'         "string"
#'       ),
#'       BS = list(
#'         raw
#'       ),
#'       M = list(
#'         list()
#'       ),
#'       L = list(
#'         list()
#'       ),
#'       NULL = TRUE|FALSE,
#'       BOOL = TRUE|FALSE
#'     )
#'   )
#' )
#' ```
#'
#' @examples
#' # This example adds a new item to the Music table.
#' \donttest{svc$put_item(
#'   Item = list(
#'     AlbumTitle = list(
#'       S = "Somewhat Famous"
#'     ),
#'     Artist = list(
#'       S = "No One You Know"
#'     ),
#'     SongTitle = list(
#'       S = "Call Me Today"
#'     )
#'   ),
#'   ReturnConsumedCapacity = "TOTAL",
#'   TableName = "Music"
#' )}
#'
#' @keywords internal
#'
#' @rdname dynamodb_put_item
dynamodb_put_item <- function(TableName, Item, Expected = NULL, ReturnValues = NULL, ReturnConsumedCapacity = NULL, ReturnItemCollectionMetrics = NULL, ConditionalOperator = NULL, ConditionExpression = NULL, ExpressionAttributeNames = NULL, ExpressionAttributeValues = NULL) {
  op <- new_operation(
    name = "PutItem",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .dynamodb$put_item_input(TableName = TableName, Item = Item, Expected = Expected, ReturnValues = ReturnValues, ReturnConsumedCapacity = ReturnConsumedCapacity, ReturnItemCollectionMetrics = ReturnItemCollectionMetrics, ConditionalOperator = ConditionalOperator, ConditionExpression = ConditionExpression, ExpressionAttributeNames = ExpressionAttributeNames, ExpressionAttributeValues = ExpressionAttributeValues)
  output <- .dynamodb$put_item_output()
  config <- get_config()
  svc <- .dynamodb$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.dynamodb$operations$put_item <- dynamodb_put_item

#' The Query operation finds items based on primary key values
#'
#' The `Query` operation finds items based on primary key values. You can
#' query any table or secondary index that has a composite primary key (a
#' partition key and a sort key).
#' 
#' Use the `KeyConditionExpression` parameter to provide a specific value
#' for the partition key. The `Query` operation will return all of the
#' items from the table or index with that partition key value. You can
#' optionally narrow the scope of the `Query` operation by specifying a
#' sort key value and a comparison operator in `KeyConditionExpression`. To
#' further refine the `Query` results, you can optionally provide a
#' `FilterExpression`. A `FilterExpression` determines which items within
#' the results should be returned to you. All of the other results are
#' discarded.
#' 
#' A `Query` operation always returns a result set. If no matching items
#' are found, the result set will be empty. Queries that do not return
#' results consume the minimum number of read capacity units for that type
#' of read operation.
#' 
#' DynamoDB calculates the number of read capacity units consumed based on
#' item size, not on the amount of data that is returned to an application.
#' The number of capacity units consumed will be the same whether you
#' request all of the attributes (the default behavior) or just some of
#' them (using a projection expression). The number will also be the same
#' whether or not you use a `FilterExpression`.
#' 
#' `Query` results are always sorted by the sort key value. If the data
#' type of the sort key is Number, the results are returned in numeric
#' order; otherwise, the results are returned in order of UTF-8 bytes. By
#' default, the sort order is ascending. To reverse the order, set the
#' `ScanIndexForward` parameter to false.
#' 
#' A single `Query` operation will read up to the maximum number of items
#' set (if using the `Limit` parameter) or a maximum of 1 MB of data and
#' then apply any filtering to the results using `FilterExpression`. If
#' `LastEvaluatedKey` is present in the response, you will need to paginate
#' the result set. For more information, see [Paginating the
#' Results](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Query.html#Query.Pagination)
#' in the *Amazon DynamoDB Developer Guide*.
#' 
#' `FilterExpression` is applied after a `Query` finishes, but before the
#' results are returned. A `FilterExpression` cannot contain partition key
#' or sort key attributes. You need to specify those attributes in the
#' `KeyConditionExpression`.
#' 
#' A `Query` operation can return an empty result set and a
#' `LastEvaluatedKey` if all the items read for the page of results are
#' filtered out.
#' 
#' You can query a table, a local secondary index, or a global secondary
#' index. For a query on a table or on a local secondary index, you can set
#' the `ConsistentRead` parameter to `true` and obtain a strongly
#' consistent result. Global secondary indexes support eventually
#' consistent reads only, so do not specify `ConsistentRead` when querying
#' a global secondary index.
#'
#' @usage
#' dynamodb_query(TableName, IndexName, Select, AttributesToGet, Limit,
#'   ConsistentRead, KeyConditions, QueryFilter, ConditionalOperator,
#'   ScanIndexForward, ExclusiveStartKey, ReturnConsumedCapacity,
#'   ProjectionExpression, FilterExpression, KeyConditionExpression,
#'   ExpressionAttributeNames, ExpressionAttributeValues)
#'
#' @param TableName &#91;required&#93; The name of the table containing the requested items.
#' @param IndexName The name of an index to query. This index can be any local secondary
#' index or global secondary index on the table. Note that if you use the
#' `IndexName` parameter, you must also provide `TableName.`
#' @param Select The attributes to be returned in the result. You can retrieve all item
#' attributes, specific item attributes, the count of matching items, or in
#' the case of an index, some or all of the attributes projected into the
#' index.
#' 
#' -   `ALL_ATTRIBUTES` - Returns all of the item attributes from the
#'     specified table or index. If you query a local secondary index, then
#'     for each matching item in the index, DynamoDB fetches the entire
#'     item from the parent table. If the index is configured to project
#'     all item attributes, then all of the data can be obtained from the
#'     local secondary index, and no fetching is required.
#' 
#' -   `ALL_PROJECTED_ATTRIBUTES` - Allowed only when querying an index.
#'     Retrieves all attributes that have been projected into the index. If
#'     the index is configured to project all attributes, this return value
#'     is equivalent to specifying `ALL_ATTRIBUTES`.
#' 
#' -   `COUNT` - Returns the number of matching items, rather than the
#'     matching items themselves.
#' 
#' -   `SPECIFIC_ATTRIBUTES` - Returns only the attributes listed in
#'     `AttributesToGet`. This return value is equivalent to specifying
#'     `AttributesToGet` without specifying any value for `Select`.
#' 
#'     If you query or scan a local secondary index and request only
#'     attributes that are projected into that index, the operation will
#'     read only the index and not the table. If any of the requested
#'     attributes are not projected into the local secondary index,
#'     DynamoDB fetches each of these attributes from the parent table.
#'     This extra fetching incurs additional throughput cost and latency.
#' 
#'     If you query or scan a global secondary index, you can only request
#'     attributes that are projected into the index. Global secondary index
#'     queries cannot fetch attributes from the parent table.
#' 
#' If neither `Select` nor `AttributesToGet` are specified, DynamoDB
#' defaults to `ALL_ATTRIBUTES` when accessing a table, and
#' `ALL_PROJECTED_ATTRIBUTES` when accessing an index. You cannot use both
#' `Select` and `AttributesToGet` together in a single request, unless the
#' value for `Select` is `SPECIFIC_ATTRIBUTES`. (This usage is equivalent
#' to specifying `AttributesToGet` without any value for `Select`.)
#' 
#' If you use the `ProjectionExpression` parameter, then the value for
#' `Select` can only be `SPECIFIC_ATTRIBUTES`. Any other value for `Select`
#' will return an error.
#' @param AttributesToGet This is a legacy parameter. Use `ProjectionExpression` instead. For more
#' information, see
#' [AttributesToGet](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.AttributesToGet.html)
#' in the *Amazon DynamoDB Developer Guide*.
#' @param Limit The maximum number of items to evaluate (not necessarily the number of
#' matching items). If DynamoDB processes the number of items up to the
#' limit while processing the results, it stops the operation and returns
#' the matching values up to that point, and a key in `LastEvaluatedKey` to
#' apply in a subsequent operation, so that you can pick up where you left
#' off. Also, if the processed dataset size exceeds 1 MB before DynamoDB
#' reaches this limit, it stops the operation and returns the matching
#' values up to the limit, and a key in `LastEvaluatedKey` to apply in a
#' subsequent operation to continue the operation. For more information,
#' see [Query and
#' Scan](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/QueryAndScan.html)
#' in the *Amazon DynamoDB Developer Guide*.
#' @param ConsistentRead Determines the read consistency model: If set to `true`, then the
#' operation uses strongly consistent reads; otherwise, the operation uses
#' eventually consistent reads.
#' 
#' Strongly consistent reads are not supported on global secondary indexes.
#' If you query a global secondary index with `ConsistentRead` set to
#' `true`, you will receive a `ValidationException`.
#' @param KeyConditions This is a legacy parameter. Use `KeyConditionExpression` instead. For
#' more information, see
#' [KeyConditions](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.KeyConditions.html)
#' in the *Amazon DynamoDB Developer Guide*.
#' @param QueryFilter This is a legacy parameter. Use `FilterExpression` instead. For more
#' information, see
#' [QueryFilter](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.QueryFilter.html)
#' in the *Amazon DynamoDB Developer Guide*.
#' @param ConditionalOperator This is a legacy parameter. Use `FilterExpression` instead. For more
#' information, see
#' [ConditionalOperator](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.ConditionalOperator.html)
#' in the *Amazon DynamoDB Developer Guide*.
#' @param ScanIndexForward Specifies the order for index traversal: If `true` (default), the
#' traversal is performed in ascending order; if `false`, the traversal is
#' performed in descending order.
#' 
#' Items with the same partition key value are stored in sorted order by
#' sort key. If the sort key data type is Number, the results are stored in
#' numeric order. For type String, the results are stored in order of UTF-8
#' bytes. For type Binary, DynamoDB treats each byte of the binary data as
#' unsigned.
#' 
#' If `ScanIndexForward` is `true`, DynamoDB returns the results in the
#' order in which they are stored (by sort key value). This is the default
#' behavior. If `ScanIndexForward` is `false`, DynamoDB reads the results
#' in reverse order by sort key value, and then returns the results to the
#' client.
#' @param ExclusiveStartKey The primary key of the first item that this operation will evaluate. Use
#' the value that was returned for `LastEvaluatedKey` in the previous
#' operation.
#' 
#' The data type for `ExclusiveStartKey` must be String, Number, or Binary.
#' No set data types are allowed.
#' @param ReturnConsumedCapacity 
#' @param ProjectionExpression A string that identifies one or more attributes to retrieve from the
#' table. These attributes can include scalars, sets, or elements of a JSON
#' document. The attributes in the expression must be separated by commas.
#' 
#' If no attribute names are specified, then all attributes will be
#' returned. If any of the requested attributes are not found, they will
#' not appear in the result.
#' 
#' For more information, see [Accessing Item
#' Attributes](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.AccessingItemAttributes.html)
#' in the *Amazon DynamoDB Developer Guide*.
#' @param FilterExpression A string that contains conditions that DynamoDB applies after the
#' `Query` operation, but before the data is returned to you. Items that do
#' not satisfy the `FilterExpression` criteria are not returned.
#' 
#' A `FilterExpression` does not allow key attributes. You cannot define a
#' filter expression based on a partition key or a sort key.
#' 
#' A `FilterExpression` is applied after the items have already been read;
#' the process of filtering does not consume any additional read capacity
#' units.
#' 
#' For more information, see [Filter
#' Expressions](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/QueryAndScan.html#FilteringResults)
#' in the *Amazon DynamoDB Developer Guide*.
#' @param KeyConditionExpression The condition that specifies the key values for items to be retrieved by
#' the `Query` action.
#' 
#' The condition must perform an equality test on a single partition key
#' value.
#' 
#' The condition can optionally perform one of several comparison tests on
#' a single sort key value. This allows `Query` to retrieve one item with a
#' given partition key value and sort key value, or several items that have
#' the same partition key value but different sort key values.
#' 
#' The partition key equality test is required, and must be specified in
#' the following format:
#' 
#' `partitionKeyName` *=* `:partitionkeyval`
#' 
#' If you also want to provide a condition for the sort key, it must be
#' combined using `AND` with the condition for the sort key. Following is
#' an example, using the **=** comparison operator for the sort key:
#' 
#' `partitionKeyName` `=` `:partitionkeyval` `AND` `sortKeyName` `=`
#' `:sortkeyval`
#' 
#' Valid comparisons for the sort key condition are as follows:
#' 
#' -   `sortKeyName` `=` `:sortkeyval` - true if the sort key value is
#'     equal to `:sortkeyval`.
#' 
#' -   `sortKeyName` `&lt;` `:sortkeyval` - true if the sort key value is
#'     less than `:sortkeyval`.
#' 
#' -   `sortKeyName` `&lt;=` `:sortkeyval` - true if the sort key value is
#'     less than or equal to `:sortkeyval`.
#' 
#' -   `sortKeyName` `&gt;` `:sortkeyval` - true if the sort key value is
#'     greater than `:sortkeyval`.
#' 
#' -   `sortKeyName` `&gt;= ` `:sortkeyval` - true if the sort key value is
#'     greater than or equal to `:sortkeyval`.
#' 
#' -   `sortKeyName` `BETWEEN` `:sortkeyval1` `AND` `:sortkeyval2` - true
#'     if the sort key value is greater than or equal to `:sortkeyval1`,
#'     and less than or equal to `:sortkeyval2`.
#' 
#' -   `begins_with (` `sortKeyName`, `:sortkeyval` `)` - true if the sort
#'     key value begins with a particular operand. (You cannot use this
#'     function with a sort key that is of type Number.) Note that the
#'     function name `begins_with` is case-sensitive.
#' 
#' Use the `ExpressionAttributeValues` parameter to replace tokens such as
#' `:partitionval` and `:sortval` with actual values at runtime.
#' 
#' You can optionally use the `ExpressionAttributeNames` parameter to
#' replace the names of the partition key and sort key with placeholder
#' tokens. This option might be necessary if an attribute name conflicts
#' with a DynamoDB reserved word. For example, the following
#' `KeyConditionExpression` parameter causes an error because *Size* is a
#' reserved word:
#' 
#' -   `Size = :myval`
#' 
#' To work around this, define a placeholder (such a `#S`) to represent the
#' attribute name *Size*. `KeyConditionExpression` then is as follows:
#' 
#' -   `#S = :myval`
#' 
#' For a list of reserved words, see [Reserved
#' Words](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/ReservedWords.html)
#' in the *Amazon DynamoDB Developer Guide*.
#' 
#' For more information on `ExpressionAttributeNames` and
#' `ExpressionAttributeValues`, see [Using Placeholders for Attribute Names
#' and
#' Values](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/ExpressionPlaceholders.html)
#' in the *Amazon DynamoDB Developer Guide*.
#' @param ExpressionAttributeNames One or more substitution tokens for attribute names in an expression.
#' The following are some use cases for using `ExpressionAttributeNames`:
#' 
#' -   To access an attribute whose name conflicts with a DynamoDB reserved
#'     word.
#' 
#' -   To create a placeholder for repeating occurrences of an attribute
#'     name in an expression.
#' 
#' -   To prevent special characters in an attribute name from being
#'     misinterpreted in an expression.
#' 
#' Use the **\\#** character in an expression to dereference an attribute
#' name. For example, consider the following attribute name:
#' 
#' -   `Percentile`
#' 
#' The name of this attribute conflicts with a reserved word, so it cannot
#' be used directly in an expression. (For the complete list of reserved
#' words, see [Reserved
#' Words](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/ReservedWords.html)
#' in the *Amazon DynamoDB Developer Guide*). To work around this, you
#' could specify the following for `ExpressionAttributeNames`:
#' 
#' -   `\{"#P":"Percentile"\}`
#' 
#' You could then use this substitution in an expression, as in this
#' example:
#' 
#' -   `#P = :val`
#' 
#' Tokens that begin with the **:** character are *expression attribute
#' values*, which are placeholders for the actual value at runtime.
#' 
#' For more information on expression attribute names, see [Specifying Item
#' Attributes](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.AccessingItemAttributes.html)
#' in the *Amazon DynamoDB Developer Guide*.
#' @param ExpressionAttributeValues One or more values that can be substituted in an expression.
#' 
#' Use the **:** (colon) character in an expression to dereference an
#' attribute value. For example, suppose that you wanted to check whether
#' the value of the *ProductStatus* attribute was one of the following:
#' 
#' `Available | Backordered | Discontinued`
#' 
#' You would first need to specify `ExpressionAttributeValues` as follows:
#' 
#' `\{ ":avail":\{"S":"Available"\}, ":back":\{"S":"Backordered"\}, ":disc":\{"S":"Discontinued"\} \}`
#' 
#' You could then use these values in an expression, such as this:
#' 
#' `ProductStatus IN (:avail, :back, :disc)`
#' 
#' For more information on expression attribute values, see [Specifying
#' Conditions](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.SpecifyingConditions.html)
#' in the *Amazon DynamoDB Developer Guide*.
#'
#' @section Request syntax:
#' ```
#' svc$query(
#'   TableName = "string",
#'   IndexName = "string",
#'   Select = "ALL_ATTRIBUTES"|"ALL_PROJECTED_ATTRIBUTES"|"SPECIFIC_ATTRIBUTES"|"COUNT",
#'   AttributesToGet = list(
#'     "string"
#'   ),
#'   Limit = 123,
#'   ConsistentRead = TRUE|FALSE,
#'   KeyConditions = list(
#'     list(
#'       AttributeValueList = list(
#'         list(
#'           S = "string",
#'           N = "string",
#'           B = raw,
#'           SS = list(
#'             "string"
#'           ),
#'           NS = list(
#'             "string"
#'           ),
#'           BS = list(
#'             raw
#'           ),
#'           M = list(
#'             list()
#'           ),
#'           L = list(
#'             list()
#'           ),
#'           NULL = TRUE|FALSE,
#'           BOOL = TRUE|FALSE
#'         )
#'       ),
#'       ComparisonOperator = "EQ"|"NE"|"IN"|"LE"|"LT"|"GE"|"GT"|"BETWEEN"|"NOT_NULL"|"NULL"|"CONTAINS"|"NOT_CONTAINS"|"BEGINS_WITH"
#'     )
#'   ),
#'   QueryFilter = list(
#'     list(
#'       AttributeValueList = list(
#'         list(
#'           S = "string",
#'           N = "string",
#'           B = raw,
#'           SS = list(
#'             "string"
#'           ),
#'           NS = list(
#'             "string"
#'           ),
#'           BS = list(
#'             raw
#'           ),
#'           M = list(
#'             list()
#'           ),
#'           L = list(
#'             list()
#'           ),
#'           NULL = TRUE|FALSE,
#'           BOOL = TRUE|FALSE
#'         )
#'       ),
#'       ComparisonOperator = "EQ"|"NE"|"IN"|"LE"|"LT"|"GE"|"GT"|"BETWEEN"|"NOT_NULL"|"NULL"|"CONTAINS"|"NOT_CONTAINS"|"BEGINS_WITH"
#'     )
#'   ),
#'   ConditionalOperator = "AND"|"OR",
#'   ScanIndexForward = TRUE|FALSE,
#'   ExclusiveStartKey = list(
#'     list(
#'       S = "string",
#'       N = "string",
#'       B = raw,
#'       SS = list(
#'         "string"
#'       ),
#'       NS = list(
#'         "string"
#'       ),
#'       BS = list(
#'         raw
#'       ),
#'       M = list(
#'         list()
#'       ),
#'       L = list(
#'         list()
#'       ),
#'       NULL = TRUE|FALSE,
#'       BOOL = TRUE|FALSE
#'     )
#'   ),
#'   ReturnConsumedCapacity = "INDEXES"|"TOTAL"|"NONE",
#'   ProjectionExpression = "string",
#'   FilterExpression = "string",
#'   KeyConditionExpression = "string",
#'   ExpressionAttributeNames = list(
#'     "string"
#'   ),
#'   ExpressionAttributeValues = list(
#'     list(
#'       S = "string",
#'       N = "string",
#'       B = raw,
#'       SS = list(
#'         "string"
#'       ),
#'       NS = list(
#'         "string"
#'       ),
#'       BS = list(
#'         raw
#'       ),
#'       M = list(
#'         list()
#'       ),
#'       L = list(
#'         list()
#'       ),
#'       NULL = TRUE|FALSE,
#'       BOOL = TRUE|FALSE
#'     )
#'   )
#' )
#' ```
#'
#' @examples
#' # This example queries items in the Music table. The table has a partition
#' # key and sort key (Artist and SongTitle), but this query only specifies
#' # the partition key value. It returns song titles by the artist named "No
#' # One You Know".
#' \donttest{svc$query(
#'   ExpressionAttributeValues = list(
#'     `:v1` = list(
#'       S = "No One You Know"
#'     )
#'   ),
#'   KeyConditionExpression = "Artist = :v1",
#'   ProjectionExpression = "SongTitle",
#'   TableName = "Music"
#' )}
#'
#' @keywords internal
#'
#' @rdname dynamodb_query
dynamodb_query <- function(TableName, IndexName = NULL, Select = NULL, AttributesToGet = NULL, Limit = NULL, ConsistentRead = NULL, KeyConditions = NULL, QueryFilter = NULL, ConditionalOperator = NULL, ScanIndexForward = NULL, ExclusiveStartKey = NULL, ReturnConsumedCapacity = NULL, ProjectionExpression = NULL, FilterExpression = NULL, KeyConditionExpression = NULL, ExpressionAttributeNames = NULL, ExpressionAttributeValues = NULL) {
  op <- new_operation(
    name = "Query",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .dynamodb$query_input(TableName = TableName, IndexName = IndexName, Select = Select, AttributesToGet = AttributesToGet, Limit = Limit, ConsistentRead = ConsistentRead, KeyConditions = KeyConditions, QueryFilter = QueryFilter, ConditionalOperator = ConditionalOperator, ScanIndexForward = ScanIndexForward, ExclusiveStartKey = ExclusiveStartKey, ReturnConsumedCapacity = ReturnConsumedCapacity, ProjectionExpression = ProjectionExpression, FilterExpression = FilterExpression, KeyConditionExpression = KeyConditionExpression, ExpressionAttributeNames = ExpressionAttributeNames, ExpressionAttributeValues = ExpressionAttributeValues)
  output <- .dynamodb$query_output()
  config <- get_config()
  svc <- .dynamodb$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.dynamodb$operations$query <- dynamodb_query

#' Creates a new table from an existing backup
#'
#' Creates a new table from an existing backup. Any number of users can
#' execute up to 4 concurrent restores (any type of restore) in a given
#' account.
#' 
#' You can call `RestoreTableFromBackup` at a maximum rate of 10 times per
#' second.
#' 
#' You must manually set up the following on the restored table:
#' 
#' -   Auto scaling policies
#' 
#' -   IAM policies
#' 
#' -   Amazon CloudWatch metrics and alarms
#' 
#' -   Tags
#' 
#' -   Stream settings
#' 
#' -   Time to Live (TTL) settings
#'
#' @usage
#' dynamodb_restore_table_from_backup(TargetTableName, BackupArn)
#'
#' @param TargetTableName &#91;required&#93; The name of the new table to which the backup must be restored.
#' @param BackupArn &#91;required&#93; The Amazon Resource Name (ARN) associated with the backup.
#'
#' @section Request syntax:
#' ```
#' svc$restore_table_from_backup(
#'   TargetTableName = "string",
#'   BackupArn = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname dynamodb_restore_table_from_backup
dynamodb_restore_table_from_backup <- function(TargetTableName, BackupArn) {
  op <- new_operation(
    name = "RestoreTableFromBackup",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .dynamodb$restore_table_from_backup_input(TargetTableName = TargetTableName, BackupArn = BackupArn)
  output <- .dynamodb$restore_table_from_backup_output()
  config <- get_config()
  svc <- .dynamodb$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.dynamodb$operations$restore_table_from_backup <- dynamodb_restore_table_from_backup

#' Restores the specified table to the specified point in time within
#' EarliestRestorableDateTime and LatestRestorableDateTime
#'
#' Restores the specified table to the specified point in time within
#' `EarliestRestorableDateTime` and `LatestRestorableDateTime`. You can
#' restore your table to any point in time during the last 35 days. Any
#' number of users can execute up to 4 concurrent restores (any type of
#' restore) in a given account.
#' 
#' When you restore using point in time recovery, DynamoDB restores your
#' table data to the state based on the selected date and time
#' (day:hour:minute:second) to a new table.
#' 
#' Along with data, the following are also included on the new restored
#' table using point in time recovery:
#' 
#' -   Global secondary indexes (GSIs)
#' 
#' -   Local secondary indexes (LSIs)
#' 
#' -   Provisioned read and write capacity
#' 
#' -   Encryption settings
#' 
#'     All these settings come from the current settings of the source
#'     table at the time of restore.
#' 
#' You must manually set up the following on the restored table:
#' 
#' -   Auto scaling policies
#' 
#' -   IAM policies
#' 
#' -   Amazon CloudWatch metrics and alarms
#' 
#' -   Tags
#' 
#' -   Stream settings
#' 
#' -   Time to Live (TTL) settings
#' 
#' -   Point in time recovery settings
#'
#' @usage
#' dynamodb_restore_table_to_point_in_time(SourceTableName,
#'   TargetTableName, UseLatestRestorableTime, RestoreDateTime)
#'
#' @param SourceTableName &#91;required&#93; Name of the source table that is being restored.
#' @param TargetTableName &#91;required&#93; The name of the new table to which it must be restored to.
#' @param UseLatestRestorableTime Restore the table to the latest possible time.
#' `LatestRestorableDateTime` is typically 5 minutes before the current
#' time.
#' @param RestoreDateTime Time in the past to restore the table to.
#'
#' @section Request syntax:
#' ```
#' svc$restore_table_to_point_in_time(
#'   SourceTableName = "string",
#'   TargetTableName = "string",
#'   UseLatestRestorableTime = TRUE|FALSE,
#'   RestoreDateTime = as.POSIXct(
#'     "2015-01-01"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname dynamodb_restore_table_to_point_in_time
dynamodb_restore_table_to_point_in_time <- function(SourceTableName, TargetTableName, UseLatestRestorableTime = NULL, RestoreDateTime = NULL) {
  op <- new_operation(
    name = "RestoreTableToPointInTime",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .dynamodb$restore_table_to_point_in_time_input(SourceTableName = SourceTableName, TargetTableName = TargetTableName, UseLatestRestorableTime = UseLatestRestorableTime, RestoreDateTime = RestoreDateTime)
  output <- .dynamodb$restore_table_to_point_in_time_output()
  config <- get_config()
  svc <- .dynamodb$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.dynamodb$operations$restore_table_to_point_in_time <- dynamodb_restore_table_to_point_in_time

#' The Scan operation returns one or more items and item attributes by
#' accessing every item in a table or a secondary index
#'
#' The `Scan` operation returns one or more items and item attributes by
#' accessing every item in a table or a secondary index. To have DynamoDB
#' return fewer items, you can provide a `FilterExpression` operation.
#' 
#' If the total number of scanned items exceeds the maximum dataset size
#' limit of 1 MB, the scan stops and results are returned to the user as a
#' `LastEvaluatedKey` value to continue the scan in a subsequent operation.
#' The results also include the number of items exceeding the limit. A scan
#' can result in no table data meeting the filter criteria.
#' 
#' A single `Scan` operation reads up to the maximum number of items set
#' (if using the `Limit` parameter) or a maximum of 1 MB of data and then
#' apply any filtering to the results using `FilterExpression`. If
#' `LastEvaluatedKey` is present in the response, you need to paginate the
#' result set. For more information, see [Paginating the
#' Results](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Scan.html#Scan.Pagination)
#' in the *Amazon DynamoDB Developer Guide*.
#' 
#' `Scan` operations proceed sequentially; however, for faster performance
#' on a large table or secondary index, applications can request a parallel
#' `Scan` operation by providing the `Segment` and `TotalSegments`
#' parameters. For more information, see [Parallel
#' Scan](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Scan.html#Scan.ParallelScan)
#' in the *Amazon DynamoDB Developer Guide*.
#' 
#' `Scan` uses eventually consistent reads when accessing the data in a
#' table; therefore, the result set might not include the changes to data
#' in the table immediately before the operation began. If you need a
#' consistent copy of the data, as of the time that the `Scan` begins, you
#' can set the `ConsistentRead` parameter to `true`.
#'
#' @usage
#' dynamodb_scan(TableName, IndexName, AttributesToGet, Limit, Select,
#'   ScanFilter, ConditionalOperator, ExclusiveStartKey,
#'   ReturnConsumedCapacity, TotalSegments, Segment, ProjectionExpression,
#'   FilterExpression, ExpressionAttributeNames, ExpressionAttributeValues,
#'   ConsistentRead)
#'
#' @param TableName &#91;required&#93; The name of the table containing the requested items; or, if you provide
#' `IndexName`, the name of the table to which that index belongs.
#' @param IndexName The name of a secondary index to scan. This index can be any local
#' secondary index or global secondary index. Note that if you use the
#' `IndexName` parameter, you must also provide `TableName`.
#' @param AttributesToGet This is a legacy parameter. Use `ProjectionExpression` instead. For more
#' information, see
#' [AttributesToGet](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.AttributesToGet.html)
#' in the *Amazon DynamoDB Developer Guide*.
#' @param Limit The maximum number of items to evaluate (not necessarily the number of
#' matching items). If DynamoDB processes the number of items up to the
#' limit while processing the results, it stops the operation and returns
#' the matching values up to that point, and a key in `LastEvaluatedKey` to
#' apply in a subsequent operation, so that you can pick up where you left
#' off. Also, if the processed dataset size exceeds 1 MB before DynamoDB
#' reaches this limit, it stops the operation and returns the matching
#' values up to the limit, and a key in `LastEvaluatedKey` to apply in a
#' subsequent operation to continue the operation. For more information,
#' see [Working with
#' Queries](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/QueryAndScan.html)
#' in the *Amazon DynamoDB Developer Guide*.
#' @param Select The attributes to be returned in the result. You can retrieve all item
#' attributes, specific item attributes, the count of matching items, or in
#' the case of an index, some or all of the attributes projected into the
#' index.
#' 
#' -   `ALL_ATTRIBUTES` - Returns all of the item attributes from the
#'     specified table or index. If you query a local secondary index, then
#'     for each matching item in the index, DynamoDB fetches the entire
#'     item from the parent table. If the index is configured to project
#'     all item attributes, then all of the data can be obtained from the
#'     local secondary index, and no fetching is required.
#' 
#' -   `ALL_PROJECTED_ATTRIBUTES` - Allowed only when querying an index.
#'     Retrieves all attributes that have been projected into the index. If
#'     the index is configured to project all attributes, this return value
#'     is equivalent to specifying `ALL_ATTRIBUTES`.
#' 
#' -   `COUNT` - Returns the number of matching items, rather than the
#'     matching items themselves.
#' 
#' -   `SPECIFIC_ATTRIBUTES` - Returns only the attributes listed in
#'     `AttributesToGet`. This return value is equivalent to specifying
#'     `AttributesToGet` without specifying any value for `Select`.
#' 
#'     If you query or scan a local secondary index and request only
#'     attributes that are projected into that index, the operation reads
#'     only the index and not the table. If any of the requested attributes
#'     are not projected into the local secondary index, DynamoDB fetches
#'     each of these attributes from the parent table. This extra fetching
#'     incurs additional throughput cost and latency.
#' 
#'     If you query or scan a global secondary index, you can only request
#'     attributes that are projected into the index. Global secondary index
#'     queries cannot fetch attributes from the parent table.
#' 
#' If neither `Select` nor `AttributesToGet` are specified, DynamoDB
#' defaults to `ALL_ATTRIBUTES` when accessing a table, and
#' `ALL_PROJECTED_ATTRIBUTES` when accessing an index. You cannot use both
#' `Select` and `AttributesToGet` together in a single request, unless the
#' value for `Select` is `SPECIFIC_ATTRIBUTES`. (This usage is equivalent
#' to specifying `AttributesToGet` without any value for `Select`.)
#' 
#' If you use the `ProjectionExpression` parameter, then the value for
#' `Select` can only be `SPECIFIC_ATTRIBUTES`. Any other value for `Select`
#' will return an error.
#' @param ScanFilter This is a legacy parameter. Use `FilterExpression` instead. For more
#' information, see
#' [ScanFilter](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.ScanFilter.html)
#' in the *Amazon DynamoDB Developer Guide*.
#' @param ConditionalOperator This is a legacy parameter. Use `FilterExpression` instead. For more
#' information, see
#' [ConditionalOperator](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.ConditionalOperator.html)
#' in the *Amazon DynamoDB Developer Guide*.
#' @param ExclusiveStartKey The primary key of the first item that this operation will evaluate. Use
#' the value that was returned for `LastEvaluatedKey` in the previous
#' operation.
#' 
#' The data type for `ExclusiveStartKey` must be String, Number or Binary.
#' No set data types are allowed.
#' 
#' In a parallel scan, a `Scan` request that includes `ExclusiveStartKey`
#' must specify the same segment whose previous `Scan` returned the
#' corresponding value of `LastEvaluatedKey`.
#' @param ReturnConsumedCapacity 
#' @param TotalSegments For a parallel `Scan` request, `TotalSegments` represents the total
#' number of segments into which the `Scan` operation will be divided. The
#' value of `TotalSegments` corresponds to the number of application
#' workers that will perform the parallel scan. For example, if you want to
#' use four application threads to scan a table or an index, specify a
#' `TotalSegments` value of 4.
#' 
#' The value for `TotalSegments` must be greater than or equal to 1, and
#' less than or equal to 1000000. If you specify a `TotalSegments` value of
#' 1, the `Scan` operation will be sequential rather than parallel.
#' 
#' If you specify `TotalSegments`, you must also specify `Segment`.
#' @param Segment For a parallel `Scan` request, `Segment` identifies an individual
#' segment to be scanned by an application worker.
#' 
#' Segment IDs are zero-based, so the first segment is always 0. For
#' example, if you want to use four application threads to scan a table or
#' an index, then the first thread specifies a `Segment` value of 0, the
#' second thread specifies 1, and so on.
#' 
#' The value of `LastEvaluatedKey` returned from a parallel `Scan` request
#' must be used as `ExclusiveStartKey` with the same segment ID in a
#' subsequent `Scan` operation.
#' 
#' The value for `Segment` must be greater than or equal to 0, and less
#' than the value provided for `TotalSegments`.
#' 
#' If you provide `Segment`, you must also provide `TotalSegments`.
#' @param ProjectionExpression A string that identifies one or more attributes to retrieve from the
#' specified table or index. These attributes can include scalars, sets, or
#' elements of a JSON document. The attributes in the expression must be
#' separated by commas.
#' 
#' If no attribute names are specified, then all attributes will be
#' returned. If any of the requested attributes are not found, they will
#' not appear in the result.
#' 
#' For more information, see [Specifying Item
#' Attributes](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.AccessingItemAttributes.html)
#' in the *Amazon DynamoDB Developer Guide*.
#' @param FilterExpression A string that contains conditions that DynamoDB applies after the `Scan`
#' operation, but before the data is returned to you. Items that do not
#' satisfy the `FilterExpression` criteria are not returned.
#' 
#' A `FilterExpression` is applied after the items have already been read;
#' the process of filtering does not consume any additional read capacity
#' units.
#' 
#' For more information, see [Filter
#' Expressions](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/QueryAndScan.html#FilteringResults)
#' in the *Amazon DynamoDB Developer Guide*.
#' @param ExpressionAttributeNames One or more substitution tokens for attribute names in an expression.
#' The following are some use cases for using `ExpressionAttributeNames`:
#' 
#' -   To access an attribute whose name conflicts with a DynamoDB reserved
#'     word.
#' 
#' -   To create a placeholder for repeating occurrences of an attribute
#'     name in an expression.
#' 
#' -   To prevent special characters in an attribute name from being
#'     misinterpreted in an expression.
#' 
#' Use the **\\#** character in an expression to dereference an attribute
#' name. For example, consider the following attribute name:
#' 
#' -   `Percentile`
#' 
#' The name of this attribute conflicts with a reserved word, so it cannot
#' be used directly in an expression. (For the complete list of reserved
#' words, see [Reserved
#' Words](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/ReservedWords.html)
#' in the *Amazon DynamoDB Developer Guide*). To work around this, you
#' could specify the following for `ExpressionAttributeNames`:
#' 
#' -   `\{"#P":"Percentile"\}`
#' 
#' You could then use this substitution in an expression, as in this
#' example:
#' 
#' -   `#P = :val`
#' 
#' Tokens that begin with the **:** character are *expression attribute
#' values*, which are placeholders for the actual value at runtime.
#' 
#' For more information on expression attribute names, see [Specifying Item
#' Attributes](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.AccessingItemAttributes.html)
#' in the *Amazon DynamoDB Developer Guide*.
#' @param ExpressionAttributeValues One or more values that can be substituted in an expression.
#' 
#' Use the **:** (colon) character in an expression to dereference an
#' attribute value. For example, suppose that you wanted to check whether
#' the value of the `ProductStatus` attribute was one of the following:
#' 
#' `Available | Backordered | Discontinued`
#' 
#' You would first need to specify `ExpressionAttributeValues` as follows:
#' 
#' `\{ ":avail":\{"S":"Available"\}, ":back":\{"S":"Backordered"\}, ":disc":\{"S":"Discontinued"\} \}`
#' 
#' You could then use these values in an expression, such as this:
#' 
#' `ProductStatus IN (:avail, :back, :disc)`
#' 
#' For more information on expression attribute values, see [Condition
#' Expressions](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.SpecifyingConditions.html)
#' in the *Amazon DynamoDB Developer Guide*.
#' @param ConsistentRead A Boolean value that determines the read consistency model during the
#' scan:
#' 
#' -   If `ConsistentRead` is `false`, then the data returned from `Scan`
#'     might not contain the results from other recently completed write
#'     operations (`PutItem`, `UpdateItem`, or `DeleteItem`).
#' 
#' -   If `ConsistentRead` is `true`, then all of the write operations that
#'     completed before the `Scan` began are guaranteed to be contained in
#'     the `Scan` response.
#' 
#' The default setting for `ConsistentRead` is `false`.
#' 
#' The `ConsistentRead` parameter is not supported on global secondary
#' indexes. If you scan a global secondary index with `ConsistentRead` set
#' to true, you will receive a `ValidationException`.
#'
#' @section Request syntax:
#' ```
#' svc$scan(
#'   TableName = "string",
#'   IndexName = "string",
#'   AttributesToGet = list(
#'     "string"
#'   ),
#'   Limit = 123,
#'   Select = "ALL_ATTRIBUTES"|"ALL_PROJECTED_ATTRIBUTES"|"SPECIFIC_ATTRIBUTES"|"COUNT",
#'   ScanFilter = list(
#'     list(
#'       AttributeValueList = list(
#'         list(
#'           S = "string",
#'           N = "string",
#'           B = raw,
#'           SS = list(
#'             "string"
#'           ),
#'           NS = list(
#'             "string"
#'           ),
#'           BS = list(
#'             raw
#'           ),
#'           M = list(
#'             list()
#'           ),
#'           L = list(
#'             list()
#'           ),
#'           NULL = TRUE|FALSE,
#'           BOOL = TRUE|FALSE
#'         )
#'       ),
#'       ComparisonOperator = "EQ"|"NE"|"IN"|"LE"|"LT"|"GE"|"GT"|"BETWEEN"|"NOT_NULL"|"NULL"|"CONTAINS"|"NOT_CONTAINS"|"BEGINS_WITH"
#'     )
#'   ),
#'   ConditionalOperator = "AND"|"OR",
#'   ExclusiveStartKey = list(
#'     list(
#'       S = "string",
#'       N = "string",
#'       B = raw,
#'       SS = list(
#'         "string"
#'       ),
#'       NS = list(
#'         "string"
#'       ),
#'       BS = list(
#'         raw
#'       ),
#'       M = list(
#'         list()
#'       ),
#'       L = list(
#'         list()
#'       ),
#'       NULL = TRUE|FALSE,
#'       BOOL = TRUE|FALSE
#'     )
#'   ),
#'   ReturnConsumedCapacity = "INDEXES"|"TOTAL"|"NONE",
#'   TotalSegments = 123,
#'   Segment = 123,
#'   ProjectionExpression = "string",
#'   FilterExpression = "string",
#'   ExpressionAttributeNames = list(
#'     "string"
#'   ),
#'   ExpressionAttributeValues = list(
#'     list(
#'       S = "string",
#'       N = "string",
#'       B = raw,
#'       SS = list(
#'         "string"
#'       ),
#'       NS = list(
#'         "string"
#'       ),
#'       BS = list(
#'         raw
#'       ),
#'       M = list(
#'         list()
#'       ),
#'       L = list(
#'         list()
#'       ),
#'       NULL = TRUE|FALSE,
#'       BOOL = TRUE|FALSE
#'     )
#'   ),
#'   ConsistentRead = TRUE|FALSE
#' )
#' ```
#'
#' @examples
#' # This example scans the entire Music table, and then narrows the results
#' # to songs by the artist "No One You Know". For each item, only the album
#' # title and song title are returned.
#' \donttest{svc$scan(
#'   ExpressionAttributeNames = list(
#'     `#AT` = "AlbumTitle",
#'     `#ST` = "SongTitle"
#'   ),
#'   ExpressionAttributeValues = list(
#'     `:a` = list(
#'       S = "No One You Know"
#'     )
#'   ),
#'   FilterExpression = "Artist = :a",
#'   ProjectionExpression = "#ST, #AT",
#'   TableName = "Music"
#' )}
#'
#' @keywords internal
#'
#' @rdname dynamodb_scan
dynamodb_scan <- function(TableName, IndexName = NULL, AttributesToGet = NULL, Limit = NULL, Select = NULL, ScanFilter = NULL, ConditionalOperator = NULL, ExclusiveStartKey = NULL, ReturnConsumedCapacity = NULL, TotalSegments = NULL, Segment = NULL, ProjectionExpression = NULL, FilterExpression = NULL, ExpressionAttributeNames = NULL, ExpressionAttributeValues = NULL, ConsistentRead = NULL) {
  op <- new_operation(
    name = "Scan",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .dynamodb$scan_input(TableName = TableName, IndexName = IndexName, AttributesToGet = AttributesToGet, Limit = Limit, Select = Select, ScanFilter = ScanFilter, ConditionalOperator = ConditionalOperator, ExclusiveStartKey = ExclusiveStartKey, ReturnConsumedCapacity = ReturnConsumedCapacity, TotalSegments = TotalSegments, Segment = Segment, ProjectionExpression = ProjectionExpression, FilterExpression = FilterExpression, ExpressionAttributeNames = ExpressionAttributeNames, ExpressionAttributeValues = ExpressionAttributeValues, ConsistentRead = ConsistentRead)
  output <- .dynamodb$scan_output()
  config <- get_config()
  svc <- .dynamodb$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.dynamodb$operations$scan <- dynamodb_scan

#' Associate a set of tags with an Amazon DynamoDB resource
#'
#' Associate a set of tags with an Amazon DynamoDB resource. You can then
#' activate these user-defined tags so that they appear on the Billing and
#' Cost Management console for cost allocation tracking. You can call
#' TagResource up to five times per second, per account.
#' 
#' For an overview on tagging DynamoDB resources, see [Tagging for
#' DynamoDB](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Tagging.html)
#' in the *Amazon DynamoDB Developer Guide*.
#'
#' @usage
#' dynamodb_tag_resource(ResourceArn, Tags)
#'
#' @param ResourceArn &#91;required&#93; Identifies the Amazon DynamoDB resource to which tags should be added.
#' This value is an Amazon Resource Name (ARN).
#' @param Tags &#91;required&#93; The tags to be assigned to the Amazon DynamoDB resource.
#'
#' @section Request syntax:
#' ```
#' svc$tag_resource(
#'   ResourceArn = "string",
#'   Tags = list(
#'     list(
#'       Key = "string",
#'       Value = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname dynamodb_tag_resource
dynamodb_tag_resource <- function(ResourceArn, Tags) {
  op <- new_operation(
    name = "TagResource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .dynamodb$tag_resource_input(ResourceArn = ResourceArn, Tags = Tags)
  output <- .dynamodb$tag_resource_output()
  config <- get_config()
  svc <- .dynamodb$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.dynamodb$operations$tag_resource <- dynamodb_tag_resource

#' TransactGetItems is a synchronous operation that atomically retrieves
#' multiple items from one or more tables (but not from indexes) in a
#' single account and Region
#'
#' `TransactGetItems` is a synchronous operation that atomically retrieves
#' multiple items from one or more tables (but not from indexes) in a
#' single account and Region. A `TransactGetItems` call can contain up to
#' 25 `TransactGetItem` objects, each of which contains a `Get` structure
#' that specifies an item to retrieve from a table in the account and
#' Region. A call to `TransactGetItems` cannot retrieve items from tables
#' in more than one AWS account or Region. The aggregate size of the items
#' in the transaction cannot exceed 4 MB.
#' 
#' All AWS Regions and AWS GovCloud (US) support up to 25 items per
#' transaction with up to 4 MB of data, except the following AWS Regions:
#' 
#' -   China (Beijing)
#' 
#' -   China (Ningxia)
#' 
#' The China (Beijing) and China (Ningxia) Regions support up to 10 items
#' per transaction with up to 4 MB of data.
#' 
#' DynamoDB rejects the entire `TransactGetItems` request if any of the
#' following is true:
#' 
#' -   A conflicting operation is in the process of updating an item to be
#'     read.
#' 
#' -   There is insufficient provisioned capacity for the transaction to be
#'     completed.
#' 
#' -   There is a user error, such as an invalid data format.
#' 
#' -   The aggregate size of the items in the transaction cannot exceed 4
#'     MB.
#'
#' @usage
#' dynamodb_transact_get_items(TransactItems, ReturnConsumedCapacity)
#'
#' @param TransactItems &#91;required&#93; An ordered array of up to 25 `TransactGetItem` objects, each of which
#' contains a `Get` structure.
#' @param ReturnConsumedCapacity A value of `TOTAL` causes consumed capacity information to be returned,
#' and a value of `NONE` prevents that information from being returned. No
#' other value is valid.
#'
#' @section Request syntax:
#' ```
#' svc$transact_get_items(
#'   TransactItems = list(
#'     list(
#'       Get = list(
#'         Key = list(
#'           list(
#'             S = "string",
#'             N = "string",
#'             B = raw,
#'             SS = list(
#'               "string"
#'             ),
#'             NS = list(
#'               "string"
#'             ),
#'             BS = list(
#'               raw
#'             ),
#'             M = list(
#'               list()
#'             ),
#'             L = list(
#'               list()
#'             ),
#'             NULL = TRUE|FALSE,
#'             BOOL = TRUE|FALSE
#'           )
#'         ),
#'         TableName = "string",
#'         ProjectionExpression = "string",
#'         ExpressionAttributeNames = list(
#'           "string"
#'         )
#'       )
#'     )
#'   ),
#'   ReturnConsumedCapacity = "INDEXES"|"TOTAL"|"NONE"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname dynamodb_transact_get_items
dynamodb_transact_get_items <- function(TransactItems, ReturnConsumedCapacity = NULL) {
  op <- new_operation(
    name = "TransactGetItems",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .dynamodb$transact_get_items_input(TransactItems = TransactItems, ReturnConsumedCapacity = ReturnConsumedCapacity)
  output <- .dynamodb$transact_get_items_output()
  config <- get_config()
  svc <- .dynamodb$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.dynamodb$operations$transact_get_items <- dynamodb_transact_get_items

#' TransactWriteItems is a synchronous write operation that groups up to 25
#' action requests
#'
#' `TransactWriteItems` is a synchronous write operation that groups up to
#' 25 action requests. These actions can target items in different tables,
#' but not in different AWS accounts or Regions, and no two actions can
#' target the same item. For example, you cannot both `ConditionCheck` and
#' `Update` the same item. The aggregate size of the items in the
#' transaction cannot exceed 4 MB.
#' 
#' All AWS Regions and AWS GovCloud (US) support up to 25 items per
#' transaction with up to 4 MB of data, except the following AWS Regions:
#' 
#' -   China (Beijing)
#' 
#' -   China (Ningxia)
#' 
#' The China (Beijing) and China (Ningxia) Regions support up to 10 items
#' per transaction with up to 4 MB of data.
#' 
#' The actions are completed atomically so that either all of them succeed,
#' or all of them fail. They are defined by the following objects:
#' 
#' -   `Put` Â --- Â  Initiates a `PutItem` operation to write a new item.
#'     This structure specifies the primary key of the item to be written,
#'     the name of the table to write it in, an optional condition
#'     expression that must be satisfied for the write to succeed, a list
#'     of the item\'s attributes, and a field indicating whether to
#'     retrieve the item\'s attributes if the condition is not met.
#' 
#' -   `Update` Â --- Â  Initiates an `UpdateItem` operation to update an
#'     existing item. This structure specifies the primary key of the item
#'     to be updated, the name of the table where it resides, an optional
#'     condition expression that must be satisfied for the update to
#'     succeed, an expression that defines one or more attributes to be
#'     updated, and a field indicating whether to retrieve the item\'s
#'     attributes if the condition is not met.
#' 
#' -   `Delete` Â --- Â  Initiates a `DeleteItem` operation to delete an
#'     existing item. This structure specifies the primary key of the item
#'     to be deleted, the name of the table where it resides, an optional
#'     condition expression that must be satisfied for the deletion to
#'     succeed, and a field indicating whether to retrieve the item\'s
#'     attributes if the condition is not met.
#' 
#' -   `ConditionCheck` Â --- Â  Applies a condition to an item that is not
#'     being modified by the transaction. This structure specifies the
#'     primary key of the item to be checked, the name of the table where
#'     it resides, a condition expression that must be satisfied for the
#'     transaction to succeed, and a field indicating whether to retrieve
#'     the item\'s attributes if the condition is not met.
#' 
#' DynamoDB rejects the entire `TransactWriteItems` request if any of the
#' following is true:
#' 
#' -   A condition in one of the condition expressions is not met.
#' 
#' -   An ongoing operation is in the process of updating the same item.
#' 
#' -   There is insufficient provisioned capacity for the transaction to be
#'     completed.
#' 
#' -   An item size becomes too large (bigger than 400 KB), a local
#'     secondary index (LSI) becomes too large, or a similar validation
#'     error occurs because of changes made by the transaction.
#' 
#' -   The aggregate size of the items in the transaction exceeds 4 MB.
#' 
#' -   There is a user error, such as an invalid data format.
#'
#' @usage
#' dynamodb_transact_write_items(TransactItems, ReturnConsumedCapacity,
#'   ReturnItemCollectionMetrics, ClientRequestToken)
#'
#' @param TransactItems &#91;required&#93; An ordered array of up to 25 `TransactWriteItem` objects, each of which
#' contains a `ConditionCheck`, `Put`, `Update`, or `Delete` object. These
#' can operate on items in different tables, but the tables must reside in
#' the same AWS account and Region, and no two of them can operate on the
#' same item.
#' @param ReturnConsumedCapacity 
#' @param ReturnItemCollectionMetrics Determines whether item collection metrics are returned. If set to
#' `SIZE`, the response includes statistics about item collections (if
#' any), that were modified during the operation and are returned in the
#' response. If set to `NONE` (the default), no statistics are returned.
#' @param ClientRequestToken Providing a `ClientRequestToken` makes the call to `TransactWriteItems`
#' idempotent, meaning that multiple identical calls have the same effect
#' as one single call.
#' 
#' Although multiple identical calls using the same client request token
#' produce the same result on the server (no side effects), the responses
#' to the calls might not be the same. If the `ReturnConsumedCapacity&gt;`
#' parameter is set, then the initial `TransactWriteItems` call returns the
#' amount of write capacity units consumed in making the changes.
#' Subsequent `TransactWriteItems` calls with the same client token return
#' the number of read capacity units consumed in reading the item.
#' 
#' A client request token is valid for 10 minutes after the first request
#' that uses it is completed. After 10 minutes, any request with the same
#' client token is treated as a new request. Do not resubmit the same
#' request with the same client token for more than 10 minutes, or the
#' result might not be idempotent.
#' 
#' If you submit a request with the same client token but a change in other
#' parameters within the 10-minute idempotency window, DynamoDB returns an
#' `IdempotentParameterMismatch` exception.
#'
#' @section Request syntax:
#' ```
#' svc$transact_write_items(
#'   TransactItems = list(
#'     list(
#'       ConditionCheck = list(
#'         Key = list(
#'           list(
#'             S = "string",
#'             N = "string",
#'             B = raw,
#'             SS = list(
#'               "string"
#'             ),
#'             NS = list(
#'               "string"
#'             ),
#'             BS = list(
#'               raw
#'             ),
#'             M = list(
#'               list()
#'             ),
#'             L = list(
#'               list()
#'             ),
#'             NULL = TRUE|FALSE,
#'             BOOL = TRUE|FALSE
#'           )
#'         ),
#'         TableName = "string",
#'         ConditionExpression = "string",
#'         ExpressionAttributeNames = list(
#'           "string"
#'         ),
#'         ExpressionAttributeValues = list(
#'           list(
#'             S = "string",
#'             N = "string",
#'             B = raw,
#'             SS = list(
#'               "string"
#'             ),
#'             NS = list(
#'               "string"
#'             ),
#'             BS = list(
#'               raw
#'             ),
#'             M = list(
#'               list()
#'             ),
#'             L = list(
#'               list()
#'             ),
#'             NULL = TRUE|FALSE,
#'             BOOL = TRUE|FALSE
#'           )
#'         ),
#'         ReturnValuesOnConditionCheckFailure = "ALL_OLD"|"NONE"
#'       ),
#'       Put = list(
#'         Item = list(
#'           list(
#'             S = "string",
#'             N = "string",
#'             B = raw,
#'             SS = list(
#'               "string"
#'             ),
#'             NS = list(
#'               "string"
#'             ),
#'             BS = list(
#'               raw
#'             ),
#'             M = list(
#'               list()
#'             ),
#'             L = list(
#'               list()
#'             ),
#'             NULL = TRUE|FALSE,
#'             BOOL = TRUE|FALSE
#'           )
#'         ),
#'         TableName = "string",
#'         ConditionExpression = "string",
#'         ExpressionAttributeNames = list(
#'           "string"
#'         ),
#'         ExpressionAttributeValues = list(
#'           list(
#'             S = "string",
#'             N = "string",
#'             B = raw,
#'             SS = list(
#'               "string"
#'             ),
#'             NS = list(
#'               "string"
#'             ),
#'             BS = list(
#'               raw
#'             ),
#'             M = list(
#'               list()
#'             ),
#'             L = list(
#'               list()
#'             ),
#'             NULL = TRUE|FALSE,
#'             BOOL = TRUE|FALSE
#'           )
#'         ),
#'         ReturnValuesOnConditionCheckFailure = "ALL_OLD"|"NONE"
#'       ),
#'       Delete = list(
#'         Key = list(
#'           list(
#'             S = "string",
#'             N = "string",
#'             B = raw,
#'             SS = list(
#'               "string"
#'             ),
#'             NS = list(
#'               "string"
#'             ),
#'             BS = list(
#'               raw
#'             ),
#'             M = list(
#'               list()
#'             ),
#'             L = list(
#'               list()
#'             ),
#'             NULL = TRUE|FALSE,
#'             BOOL = TRUE|FALSE
#'           )
#'         ),
#'         TableName = "string",
#'         ConditionExpression = "string",
#'         ExpressionAttributeNames = list(
#'           "string"
#'         ),
#'         ExpressionAttributeValues = list(
#'           list(
#'             S = "string",
#'             N = "string",
#'             B = raw,
#'             SS = list(
#'               "string"
#'             ),
#'             NS = list(
#'               "string"
#'             ),
#'             BS = list(
#'               raw
#'             ),
#'             M = list(
#'               list()
#'             ),
#'             L = list(
#'               list()
#'             ),
#'             NULL = TRUE|FALSE,
#'             BOOL = TRUE|FALSE
#'           )
#'         ),
#'         ReturnValuesOnConditionCheckFailure = "ALL_OLD"|"NONE"
#'       ),
#'       Update = list(
#'         Key = list(
#'           list(
#'             S = "string",
#'             N = "string",
#'             B = raw,
#'             SS = list(
#'               "string"
#'             ),
#'             NS = list(
#'               "string"
#'             ),
#'             BS = list(
#'               raw
#'             ),
#'             M = list(
#'               list()
#'             ),
#'             L = list(
#'               list()
#'             ),
#'             NULL = TRUE|FALSE,
#'             BOOL = TRUE|FALSE
#'           )
#'         ),
#'         UpdateExpression = "string",
#'         TableName = "string",
#'         ConditionExpression = "string",
#'         ExpressionAttributeNames = list(
#'           "string"
#'         ),
#'         ExpressionAttributeValues = list(
#'           list(
#'             S = "string",
#'             N = "string",
#'             B = raw,
#'             SS = list(
#'               "string"
#'             ),
#'             NS = list(
#'               "string"
#'             ),
#'             BS = list(
#'               raw
#'             ),
#'             M = list(
#'               list()
#'             ),
#'             L = list(
#'               list()
#'             ),
#'             NULL = TRUE|FALSE,
#'             BOOL = TRUE|FALSE
#'           )
#'         ),
#'         ReturnValuesOnConditionCheckFailure = "ALL_OLD"|"NONE"
#'       )
#'     )
#'   ),
#'   ReturnConsumedCapacity = "INDEXES"|"TOTAL"|"NONE",
#'   ReturnItemCollectionMetrics = "SIZE"|"NONE",
#'   ClientRequestToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname dynamodb_transact_write_items
dynamodb_transact_write_items <- function(TransactItems, ReturnConsumedCapacity = NULL, ReturnItemCollectionMetrics = NULL, ClientRequestToken = NULL) {
  op <- new_operation(
    name = "TransactWriteItems",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .dynamodb$transact_write_items_input(TransactItems = TransactItems, ReturnConsumedCapacity = ReturnConsumedCapacity, ReturnItemCollectionMetrics = ReturnItemCollectionMetrics, ClientRequestToken = ClientRequestToken)
  output <- .dynamodb$transact_write_items_output()
  config <- get_config()
  svc <- .dynamodb$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.dynamodb$operations$transact_write_items <- dynamodb_transact_write_items

#' Removes the association of tags from an Amazon DynamoDB resource
#'
#' Removes the association of tags from an Amazon DynamoDB resource. You
#' can call `UntagResource` up to five times per second, per account.
#' 
#' For an overview on tagging DynamoDB resources, see [Tagging for
#' DynamoDB](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Tagging.html)
#' in the *Amazon DynamoDB Developer Guide*.
#'
#' @usage
#' dynamodb_untag_resource(ResourceArn, TagKeys)
#'
#' @param ResourceArn &#91;required&#93; The DynamoDB resource that the tags will be removed from. This value is
#' an Amazon Resource Name (ARN).
#' @param TagKeys &#91;required&#93; A list of tag keys. Existing tags of the resource whose keys are members
#' of this list will be removed from the DynamoDB resource.
#'
#' @section Request syntax:
#' ```
#' svc$untag_resource(
#'   ResourceArn = "string",
#'   TagKeys = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname dynamodb_untag_resource
dynamodb_untag_resource <- function(ResourceArn, TagKeys) {
  op <- new_operation(
    name = "UntagResource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .dynamodb$untag_resource_input(ResourceArn = ResourceArn, TagKeys = TagKeys)
  output <- .dynamodb$untag_resource_output()
  config <- get_config()
  svc <- .dynamodb$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.dynamodb$operations$untag_resource <- dynamodb_untag_resource

#' UpdateContinuousBackups enables or disables point in time recovery for
#' the specified table
#'
#' `UpdateContinuousBackups` enables or disables point in time recovery for
#' the specified table. A successful `UpdateContinuousBackups` call returns
#' the current `ContinuousBackupsDescription`. Continuous backups are
#' `ENABLED` on all tables at table creation. If point in time recovery is
#' enabled, `PointInTimeRecoveryStatus` will be set to ENABLED.
#' 
#' Once continuous backups and point in time recovery are enabled, you can
#' restore to any point in time within `EarliestRestorableDateTime` and
#' `LatestRestorableDateTime`.
#' 
#' `LatestRestorableDateTime` is typically 5 minutes before the current
#' time. You can restore your table to any point in time during the last 35
#' days.
#'
#' @usage
#' dynamodb_update_continuous_backups(TableName,
#'   PointInTimeRecoverySpecification)
#'
#' @param TableName &#91;required&#93; The name of the table.
#' @param PointInTimeRecoverySpecification &#91;required&#93; Represents the settings used to enable point in time recovery.
#'
#' @section Request syntax:
#' ```
#' svc$update_continuous_backups(
#'   TableName = "string",
#'   PointInTimeRecoverySpecification = list(
#'     PointInTimeRecoveryEnabled = TRUE|FALSE
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname dynamodb_update_continuous_backups
dynamodb_update_continuous_backups <- function(TableName, PointInTimeRecoverySpecification) {
  op <- new_operation(
    name = "UpdateContinuousBackups",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .dynamodb$update_continuous_backups_input(TableName = TableName, PointInTimeRecoverySpecification = PointInTimeRecoverySpecification)
  output <- .dynamodb$update_continuous_backups_output()
  config <- get_config()
  svc <- .dynamodb$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.dynamodb$operations$update_continuous_backups <- dynamodb_update_continuous_backups

#' Adds or removes replicas in the specified global table
#'
#' Adds or removes replicas in the specified global table. The global table
#' must already exist to be able to use this operation. Any replica to be
#' added must be empty, have the same name as the global table, have the
#' same key schema, have DynamoDB Streams enabled, and have the same
#' provisioned and maximum write capacity units.
#' 
#' Although you can use `UpdateGlobalTable` to add replicas and remove
#' replicas in a single request, for simplicity we recommend that you issue
#' separate requests for adding or removing replicas.
#' 
#' If global secondary indexes are specified, then the following conditions
#' must also be met:
#' 
#' -   The global secondary indexes must have the same name.
#' 
#' -   The global secondary indexes must have the same hash key and sort
#'     key (if present).
#' 
#' -   The global secondary indexes must have the same provisioned and
#'     maximum write capacity units.
#'
#' @usage
#' dynamodb_update_global_table(GlobalTableName, ReplicaUpdates)
#'
#' @param GlobalTableName &#91;required&#93; The global table name.
#' @param ReplicaUpdates &#91;required&#93; A list of Regions that should be added or removed from the global table.
#'
#' @section Request syntax:
#' ```
#' svc$update_global_table(
#'   GlobalTableName = "string",
#'   ReplicaUpdates = list(
#'     list(
#'       Create = list(
#'         RegionName = "string"
#'       ),
#'       Delete = list(
#'         RegionName = "string"
#'       )
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname dynamodb_update_global_table
dynamodb_update_global_table <- function(GlobalTableName, ReplicaUpdates) {
  op <- new_operation(
    name = "UpdateGlobalTable",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .dynamodb$update_global_table_input(GlobalTableName = GlobalTableName, ReplicaUpdates = ReplicaUpdates)
  output <- .dynamodb$update_global_table_output()
  config <- get_config()
  svc <- .dynamodb$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.dynamodb$operations$update_global_table <- dynamodb_update_global_table

#' Updates settings for a global table
#'
#' Updates settings for a global table.
#'
#' @usage
#' dynamodb_update_global_table_settings(GlobalTableName,
#'   GlobalTableBillingMode, GlobalTableProvisionedWriteCapacityUnits,
#'   GlobalTableProvisionedWriteCapacityAutoScalingSettingsUpdate,
#'   GlobalTableGlobalSecondaryIndexSettingsUpdate, ReplicaSettingsUpdate)
#'
#' @param GlobalTableName &#91;required&#93; The name of the global table
#' @param GlobalTableBillingMode The billing mode of the global table. If `GlobalTableBillingMode` is not
#' specified, the global table defaults to `PROVISIONED` capacity billing
#' mode.
#' @param GlobalTableProvisionedWriteCapacityUnits The maximum number of writes consumed per second before DynamoDB returns
#' a `ThrottlingException.`
#' @param GlobalTableProvisionedWriteCapacityAutoScalingSettingsUpdate Auto scaling settings for managing provisioned write capacity for the
#' global table.
#' @param GlobalTableGlobalSecondaryIndexSettingsUpdate Represents the settings of a global secondary index for a global table
#' that will be modified.
#' @param ReplicaSettingsUpdate Represents the settings for a global table in a Region that will be
#' modified.
#'
#' @section Request syntax:
#' ```
#' svc$update_global_table_settings(
#'   GlobalTableName = "string",
#'   GlobalTableBillingMode = "PROVISIONED"|"PAY_PER_REQUEST",
#'   GlobalTableProvisionedWriteCapacityUnits = 123,
#'   GlobalTableProvisionedWriteCapacityAutoScalingSettingsUpdate = list(
#'     MinimumUnits = 123,
#'     MaximumUnits = 123,
#'     AutoScalingDisabled = TRUE|FALSE,
#'     AutoScalingRoleArn = "string",
#'     ScalingPolicyUpdate = list(
#'       PolicyName = "string",
#'       TargetTrackingScalingPolicyConfiguration = list(
#'         DisableScaleIn = TRUE|FALSE,
#'         ScaleInCooldown = 123,
#'         ScaleOutCooldown = 123,
#'         TargetValue = 123.0
#'       )
#'     )
#'   ),
#'   GlobalTableGlobalSecondaryIndexSettingsUpdate = list(
#'     list(
#'       IndexName = "string",
#'       ProvisionedWriteCapacityUnits = 123,
#'       ProvisionedWriteCapacityAutoScalingSettingsUpdate = list(
#'         MinimumUnits = 123,
#'         MaximumUnits = 123,
#'         AutoScalingDisabled = TRUE|FALSE,
#'         AutoScalingRoleArn = "string",
#'         ScalingPolicyUpdate = list(
#'           PolicyName = "string",
#'           TargetTrackingScalingPolicyConfiguration = list(
#'             DisableScaleIn = TRUE|FALSE,
#'             ScaleInCooldown = 123,
#'             ScaleOutCooldown = 123,
#'             TargetValue = 123.0
#'           )
#'         )
#'       )
#'     )
#'   ),
#'   ReplicaSettingsUpdate = list(
#'     list(
#'       RegionName = "string",
#'       ReplicaProvisionedReadCapacityUnits = 123,
#'       ReplicaProvisionedReadCapacityAutoScalingSettingsUpdate = list(
#'         MinimumUnits = 123,
#'         MaximumUnits = 123,
#'         AutoScalingDisabled = TRUE|FALSE,
#'         AutoScalingRoleArn = "string",
#'         ScalingPolicyUpdate = list(
#'           PolicyName = "string",
#'           TargetTrackingScalingPolicyConfiguration = list(
#'             DisableScaleIn = TRUE|FALSE,
#'             ScaleInCooldown = 123,
#'             ScaleOutCooldown = 123,
#'             TargetValue = 123.0
#'           )
#'         )
#'       ),
#'       ReplicaGlobalSecondaryIndexSettingsUpdate = list(
#'         list(
#'           IndexName = "string",
#'           ProvisionedReadCapacityUnits = 123,
#'           ProvisionedReadCapacityAutoScalingSettingsUpdate = list(
#'             MinimumUnits = 123,
#'             MaximumUnits = 123,
#'             AutoScalingDisabled = TRUE|FALSE,
#'             AutoScalingRoleArn = "string",
#'             ScalingPolicyUpdate = list(
#'               PolicyName = "string",
#'               TargetTrackingScalingPolicyConfiguration = list(
#'                 DisableScaleIn = TRUE|FALSE,
#'                 ScaleInCooldown = 123,
#'                 ScaleOutCooldown = 123,
#'                 TargetValue = 123.0
#'               )
#'             )
#'           )
#'         )
#'       )
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname dynamodb_update_global_table_settings
dynamodb_update_global_table_settings <- function(GlobalTableName, GlobalTableBillingMode = NULL, GlobalTableProvisionedWriteCapacityUnits = NULL, GlobalTableProvisionedWriteCapacityAutoScalingSettingsUpdate = NULL, GlobalTableGlobalSecondaryIndexSettingsUpdate = NULL, ReplicaSettingsUpdate = NULL) {
  op <- new_operation(
    name = "UpdateGlobalTableSettings",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .dynamodb$update_global_table_settings_input(GlobalTableName = GlobalTableName, GlobalTableBillingMode = GlobalTableBillingMode, GlobalTableProvisionedWriteCapacityUnits = GlobalTableProvisionedWriteCapacityUnits, GlobalTableProvisionedWriteCapacityAutoScalingSettingsUpdate = GlobalTableProvisionedWriteCapacityAutoScalingSettingsUpdate, GlobalTableGlobalSecondaryIndexSettingsUpdate = GlobalTableGlobalSecondaryIndexSettingsUpdate, ReplicaSettingsUpdate = ReplicaSettingsUpdate)
  output <- .dynamodb$update_global_table_settings_output()
  config <- get_config()
  svc <- .dynamodb$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.dynamodb$operations$update_global_table_settings <- dynamodb_update_global_table_settings

#' Edits an existing item's attributes, or adds a new item to the table if
#' it does not already exist
#'
#' Edits an existing item\'s attributes, or adds a new item to the table if
#' it does not already exist. You can put, delete, or add attribute values.
#' You can also perform a conditional update on an existing item (insert a
#' new attribute name-value pair if it doesn\'t exist, or replace an
#' existing name-value pair if it has certain expected attribute values).
#' 
#' You can also return the item\'s attribute values in the same
#' `UpdateItem` operation using the `ReturnValues` parameter.
#'
#' @usage
#' dynamodb_update_item(TableName, Key, AttributeUpdates, Expected,
#'   ConditionalOperator, ReturnValues, ReturnConsumedCapacity,
#'   ReturnItemCollectionMetrics, UpdateExpression, ConditionExpression,
#'   ExpressionAttributeNames, ExpressionAttributeValues)
#'
#' @param TableName &#91;required&#93; The name of the table containing the item to update.
#' @param Key &#91;required&#93; The primary key of the item to be updated. Each element consists of an
#' attribute name and a value for that attribute.
#' 
#' For the primary key, you must provide all of the attributes. For
#' example, with a simple primary key, you only need to provide a value for
#' the partition key. For a composite primary key, you must provide values
#' for both the partition key and the sort key.
#' @param AttributeUpdates This is a legacy parameter. Use `UpdateExpression` instead. For more
#' information, see
#' [AttributeUpdates](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.AttributeUpdates.html)
#' in the *Amazon DynamoDB Developer Guide*.
#' @param Expected This is a legacy parameter. Use `ConditionExpression` instead. For more
#' information, see
#' [Expected](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.Expected.html)
#' in the *Amazon DynamoDB Developer Guide*.
#' @param ConditionalOperator This is a legacy parameter. Use `ConditionExpression` instead. For more
#' information, see
#' [ConditionalOperator](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.ConditionalOperator.html)
#' in the *Amazon DynamoDB Developer Guide*.
#' @param ReturnValues Use `ReturnValues` if you want to get the item attributes as they appear
#' before or after they are updated. For `UpdateItem`, the valid values
#' are:
#' 
#' -   `NONE` - If `ReturnValues` is not specified, or if its value is
#'     `NONE`, then nothing is returned. (This setting is the default for
#'     `ReturnValues`.)
#' 
#' -   `ALL_OLD` - Returns all of the attributes of the item, as they
#'     appeared before the UpdateItem operation.
#' 
#' -   `UPDATED_OLD` - Returns only the updated attributes, as they
#'     appeared before the UpdateItem operation.
#' 
#' -   `ALL_NEW` - Returns all of the attributes of the item, as they
#'     appear after the UpdateItem operation.
#' 
#' -   `UPDATED_NEW` - Returns only the updated attributes, as they appear
#'     after the UpdateItem operation.
#' 
#' There is no additional cost associated with requesting a return value
#' aside from the small network and processing overhead of receiving a
#' larger response. No read capacity units are consumed.
#' 
#' The values returned are strongly consistent.
#' @param ReturnConsumedCapacity 
#' @param ReturnItemCollectionMetrics Determines whether item collection metrics are returned. If set to
#' `SIZE`, the response includes statistics about item collections, if any,
#' that were modified during the operation are returned in the response. If
#' set to `NONE` (the default), no statistics are returned.
#' @param UpdateExpression An expression that defines one or more attributes to be updated, the
#' action to be performed on them, and new values for them.
#' 
#' The following action values are available for `UpdateExpression`.
#' 
#' -   `SET` - Adds one or more attributes and values to an item. If any of
#'     these attributes already exist, they are replaced by the new values.
#'     You can also use `SET` to add or subtract from an attribute that is
#'     of type Number. For example: `SET myNum = myNum + :val`
#' 
#'     `SET` supports the following functions:
#' 
#'     -   `if_not_exists (path, operand)` - if the item does not contain
#'         an attribute at the specified path, then `if_not_exists`
#'         evaluates to operand; otherwise, it evaluates to path. You can
#'         use this function to avoid overwriting an attribute that may
#'         already be present in the item.
#' 
#'     -   `list_append (operand, operand)` - evaluates to a list with a
#'         new element added to it. You can append the new element to the
#'         start or the end of the list by reversing the order of the
#'         operands.
#' 
#'     These function names are case-sensitive.
#' 
#' -   `REMOVE` - Removes one or more attributes from an item.
#' 
#' -   `ADD` - Adds the specified value to the item, if the attribute does
#'     not already exist. If the attribute does exist, then the behavior of
#'     `ADD` depends on the data type of the attribute:
#' 
#'     -   If the existing attribute is a number, and if `Value` is also a
#'         number, then `Value` is mathematically added to the existing
#'         attribute. If `Value` is a negative number, then it is
#'         subtracted from the existing attribute.
#' 
#'         If you use `ADD` to increment or decrement a number value for an
#'         item that doesn\'t exist before the update, DynamoDB uses `0` as
#'         the initial value.
#' 
#'         Similarly, if you use `ADD` for an existing item to increment or
#'         decrement an attribute value that doesn\'t exist before the
#'         update, DynamoDB uses `0` as the initial value. For example,
#'         suppose that the item you want to update doesn\'t have an
#'         attribute named `itemcount`, but you decide to `ADD` the number
#'         `3` to this attribute anyway. DynamoDB will create the
#'         `itemcount` attribute, set its initial value to `0`, and finally
#'         add `3` to it. The result will be a new `itemcount` attribute in
#'         the item, with a value of `3`.
#' 
#'     -   If the existing data type is a set and if `Value` is also a set,
#'         then `Value` is added to the existing set. For example, if the
#'         attribute value is the set `\\[1,2\\]`, and the `ADD` action
#'         specified `\\[3\\]`, then the final attribute value is
#'         `\\[1,2,3\\]`. An error occurs if an `ADD` action is specified
#'         for a set attribute and the attribute type specified does not
#'         match the existing set type.
#' 
#'         Both sets must have the same primitive data type. For example,
#'         if the existing data type is a set of strings, the `Value` must
#'         also be a set of strings.
#' 
#'     The `ADD` action only supports Number and set data types. In
#'     addition, `ADD` can only be used on top-level attributes, not nested
#'     attributes.
#' 
#' -   `DELETE` - Deletes an element from a set.
#' 
#'     If a set of values is specified, then those values are subtracted
#'     from the old set. For example, if the attribute value was the set
#'     `\\[a,b,c\\]` and the `DELETE` action specifies `\\[a,c\\]`, then
#'     the final attribute value is `\\[b\\]`. Specifying an empty set is
#'     an error.
#' 
#'     The `DELETE` action only supports set data types. In addition,
#'     `DELETE` can only be used on top-level attributes, not nested
#'     attributes.
#' 
#' You can have many actions in a single expression, such as the following:
#' `SET a=:value1, b=:value2 DELETE :value3, :value4, :value5`
#' 
#' For more information on update expressions, see [Modifying Items and
#' Attributes](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.Modifying.html)
#' in the *Amazon DynamoDB Developer Guide*.
#' @param ConditionExpression A condition that must be satisfied in order for a conditional update to
#' succeed.
#' 
#' An expression can contain any of the following:
#' 
#' -   Functions:
#'     `attribute_exists | attribute_not_exists | attribute_type | contains | begins_with | size`
#' 
#'     These function names are case-sensitive.
#' 
#' -   Comparison operators:
#'     `= | &lt;&gt; | &lt; | &gt; | &lt;= | &gt;= | BETWEEN | IN `
#' 
#' -   Logical operators: `AND | OR | NOT`
#' 
#' For more information about condition expressions, see [Specifying
#' Conditions](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.SpecifyingConditions.html)
#' in the *Amazon DynamoDB Developer Guide*.
#' @param ExpressionAttributeNames One or more substitution tokens for attribute names in an expression.
#' The following are some use cases for using `ExpressionAttributeNames`:
#' 
#' -   To access an attribute whose name conflicts with a DynamoDB reserved
#'     word.
#' 
#' -   To create a placeholder for repeating occurrences of an attribute
#'     name in an expression.
#' 
#' -   To prevent special characters in an attribute name from being
#'     misinterpreted in an expression.
#' 
#' Use the **\\#** character in an expression to dereference an attribute
#' name. For example, consider the following attribute name:
#' 
#' -   `Percentile`
#' 
#' The name of this attribute conflicts with a reserved word, so it cannot
#' be used directly in an expression. (For the complete list of reserved
#' words, see [Reserved
#' Words](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/ReservedWords.html)
#' in the *Amazon DynamoDB Developer Guide*.) To work around this, you
#' could specify the following for `ExpressionAttributeNames`:
#' 
#' -   `\{"#P":"Percentile"\}`
#' 
#' You could then use this substitution in an expression, as in this
#' example:
#' 
#' -   `#P = :val`
#' 
#' Tokens that begin with the **:** character are *expression attribute
#' values*, which are placeholders for the actual value at runtime.
#' 
#' For more information about expression attribute names, see [Specifying
#' Item
#' Attributes](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.AccessingItemAttributes.html)
#' in the *Amazon DynamoDB Developer Guide*.
#' @param ExpressionAttributeValues One or more values that can be substituted in an expression.
#' 
#' Use the **:** (colon) character in an expression to dereference an
#' attribute value. For example, suppose that you wanted to check whether
#' the value of the `ProductStatus` attribute was one of the following:
#' 
#' `Available | Backordered | Discontinued`
#' 
#' You would first need to specify `ExpressionAttributeValues` as follows:
#' 
#' `\{ ":avail":\{"S":"Available"\}, ":back":\{"S":"Backordered"\}, ":disc":\{"S":"Discontinued"\} \}`
#' 
#' You could then use these values in an expression, such as this:
#' 
#' `ProductStatus IN (:avail, :back, :disc)`
#' 
#' For more information on expression attribute values, see [Condition
#' Expressions](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.SpecifyingConditions.html)
#' in the *Amazon DynamoDB Developer Guide*.
#'
#' @section Request syntax:
#' ```
#' svc$update_item(
#'   TableName = "string",
#'   Key = list(
#'     list(
#'       S = "string",
#'       N = "string",
#'       B = raw,
#'       SS = list(
#'         "string"
#'       ),
#'       NS = list(
#'         "string"
#'       ),
#'       BS = list(
#'         raw
#'       ),
#'       M = list(
#'         list()
#'       ),
#'       L = list(
#'         list()
#'       ),
#'       NULL = TRUE|FALSE,
#'       BOOL = TRUE|FALSE
#'     )
#'   ),
#'   AttributeUpdates = list(
#'     list(
#'       Value = list(
#'         S = "string",
#'         N = "string",
#'         B = raw,
#'         SS = list(
#'           "string"
#'         ),
#'         NS = list(
#'           "string"
#'         ),
#'         BS = list(
#'           raw
#'         ),
#'         M = list(
#'           list()
#'         ),
#'         L = list(
#'           list()
#'         ),
#'         NULL = TRUE|FALSE,
#'         BOOL = TRUE|FALSE
#'       ),
#'       Action = "ADD"|"PUT"|"DELETE"
#'     )
#'   ),
#'   Expected = list(
#'     list(
#'       Value = list(
#'         S = "string",
#'         N = "string",
#'         B = raw,
#'         SS = list(
#'           "string"
#'         ),
#'         NS = list(
#'           "string"
#'         ),
#'         BS = list(
#'           raw
#'         ),
#'         M = list(
#'           list()
#'         ),
#'         L = list(
#'           list()
#'         ),
#'         NULL = TRUE|FALSE,
#'         BOOL = TRUE|FALSE
#'       ),
#'       Exists = TRUE|FALSE,
#'       ComparisonOperator = "EQ"|"NE"|"IN"|"LE"|"LT"|"GE"|"GT"|"BETWEEN"|"NOT_NULL"|"NULL"|"CONTAINS"|"NOT_CONTAINS"|"BEGINS_WITH",
#'       AttributeValueList = list(
#'         list(
#'           S = "string",
#'           N = "string",
#'           B = raw,
#'           SS = list(
#'             "string"
#'           ),
#'           NS = list(
#'             "string"
#'           ),
#'           BS = list(
#'             raw
#'           ),
#'           M = list(
#'             list()
#'           ),
#'           L = list(
#'             list()
#'           ),
#'           NULL = TRUE|FALSE,
#'           BOOL = TRUE|FALSE
#'         )
#'       )
#'     )
#'   ),
#'   ConditionalOperator = "AND"|"OR",
#'   ReturnValues = "NONE"|"ALL_OLD"|"UPDATED_OLD"|"ALL_NEW"|"UPDATED_NEW",
#'   ReturnConsumedCapacity = "INDEXES"|"TOTAL"|"NONE",
#'   ReturnItemCollectionMetrics = "SIZE"|"NONE",
#'   UpdateExpression = "string",
#'   ConditionExpression = "string",
#'   ExpressionAttributeNames = list(
#'     "string"
#'   ),
#'   ExpressionAttributeValues = list(
#'     list(
#'       S = "string",
#'       N = "string",
#'       B = raw,
#'       SS = list(
#'         "string"
#'       ),
#'       NS = list(
#'         "string"
#'       ),
#'       BS = list(
#'         raw
#'       ),
#'       M = list(
#'         list()
#'       ),
#'       L = list(
#'         list()
#'       ),
#'       NULL = TRUE|FALSE,
#'       BOOL = TRUE|FALSE
#'     )
#'   )
#' )
#' ```
#'
#' @examples
#' # This example updates an item in the Music table. It adds a new attribute
#' # (Year) and modifies the AlbumTitle attribute.  All of the attributes in
#' # the item, as they appear after the update, are returned in the response.
#' \donttest{svc$update_item(
#'   ExpressionAttributeNames = list(
#'     `#AT` = "AlbumTitle",
#'     `#Y` = "Year"
#'   ),
#'   ExpressionAttributeValues = list(
#'     `:t` = list(
#'       S = "Louder Than Ever"
#'     ),
#'     `:y` = list(
#'       N = "2015"
#'     )
#'   ),
#'   Key = list(
#'     Artist = list(
#'       S = "Acme Band"
#'     ),
#'     SongTitle = list(
#'       S = "Happy Day"
#'     )
#'   ),
#'   ReturnValues = "ALL_NEW",
#'   TableName = "Music",
#'   UpdateExpression = "SET #Y = :y, #AT = :t"
#' )}
#'
#' @keywords internal
#'
#' @rdname dynamodb_update_item
dynamodb_update_item <- function(TableName, Key, AttributeUpdates = NULL, Expected = NULL, ConditionalOperator = NULL, ReturnValues = NULL, ReturnConsumedCapacity = NULL, ReturnItemCollectionMetrics = NULL, UpdateExpression = NULL, ConditionExpression = NULL, ExpressionAttributeNames = NULL, ExpressionAttributeValues = NULL) {
  op <- new_operation(
    name = "UpdateItem",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .dynamodb$update_item_input(TableName = TableName, Key = Key, AttributeUpdates = AttributeUpdates, Expected = Expected, ConditionalOperator = ConditionalOperator, ReturnValues = ReturnValues, ReturnConsumedCapacity = ReturnConsumedCapacity, ReturnItemCollectionMetrics = ReturnItemCollectionMetrics, UpdateExpression = UpdateExpression, ConditionExpression = ConditionExpression, ExpressionAttributeNames = ExpressionAttributeNames, ExpressionAttributeValues = ExpressionAttributeValues)
  output <- .dynamodb$update_item_output()
  config <- get_config()
  svc <- .dynamodb$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.dynamodb$operations$update_item <- dynamodb_update_item

#' Modifies the provisioned throughput settings, global secondary indexes,
#' or DynamoDB Streams settings for a given table
#'
#' Modifies the provisioned throughput settings, global secondary indexes,
#' or DynamoDB Streams settings for a given table.
#' 
#' You can only perform one of the following operations at once:
#' 
#' -   Modify the provisioned throughput settings of the table.
#' 
#' -   Enable or disable DynamoDB Streams on the table.
#' 
#' -   Remove a global secondary index from the table.
#' 
#' -   Create a new global secondary index on the table. After the index
#'     begins backfilling, you can use `UpdateTable` to perform other
#'     operations.
#' 
#' `UpdateTable` is an asynchronous operation; while it is executing, the
#' table status changes from `ACTIVE` to `UPDATING`. While it is
#' `UPDATING`, you cannot issue another `UpdateTable` request. When the
#' table returns to the `ACTIVE` state, the `UpdateTable` operation is
#' complete.
#'
#' @usage
#' dynamodb_update_table(AttributeDefinitions, TableName, BillingMode,
#'   ProvisionedThroughput, GlobalSecondaryIndexUpdates, StreamSpecification,
#'   SSESpecification)
#'
#' @param AttributeDefinitions An array of attributes that describe the key schema for the table and
#' indexes. If you are adding a new global secondary index to the table,
#' `AttributeDefinitions` must include the key element(s) of the new index.
#' @param TableName &#91;required&#93; The name of the table to be updated.
#' @param BillingMode Controls how you are charged for read and write throughput and how you
#' manage capacity. When switching from pay-per-request to provisioned
#' capacity, initial provisioned capacity values must be set. The initial
#' provisioned capacity values are estimated based on the consumed read and
#' write capacity of your table and global secondary indexes over the past
#' 30 minutes.
#' 
#' -   `PROVISIONED` - Sets the billing mode to `PROVISIONED`. We recommend
#'     using `PROVISIONED` for predictable workloads.
#' 
#' -   `PAY_PER_REQUEST` - Sets the billing mode to `PAY_PER_REQUEST`. We
#'     recommend using `PAY_PER_REQUEST` for unpredictable workloads.
#' @param ProvisionedThroughput The new provisioned throughput settings for the specified table or
#' index.
#' @param GlobalSecondaryIndexUpdates An array of one or more global secondary indexes for the table. For each
#' index in the array, you can request one action:
#' 
#' -   `Create` - add a new global secondary index to the table.
#' 
#' -   `Update` - modify the provisioned throughput settings of an existing
#'     global secondary index.
#' 
#' -   `Delete` - remove a global secondary index from the table.
#' 
#' For more information, see [Managing Global Secondary
#' Indexes](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/GSI.OnlineOps.html)
#' in the *Amazon DynamoDB Developer Guide*.
#' @param StreamSpecification Represents the DynamoDB Streams configuration for the table.
#' 
#' You receive a `ResourceInUseException` if you try to enable a stream on
#' a table that already has a stream, or if you try to disable a stream on
#' a table that doesn\'t have a stream.
#' @param SSESpecification The new server-side encryption settings for the specified table.
#'
#' @section Request syntax:
#' ```
#' svc$update_table(
#'   AttributeDefinitions = list(
#'     list(
#'       AttributeName = "string",
#'       AttributeType = "S"|"N"|"B"
#'     )
#'   ),
#'   TableName = "string",
#'   BillingMode = "PROVISIONED"|"PAY_PER_REQUEST",
#'   ProvisionedThroughput = list(
#'     ReadCapacityUnits = 123,
#'     WriteCapacityUnits = 123
#'   ),
#'   GlobalSecondaryIndexUpdates = list(
#'     list(
#'       Update = list(
#'         IndexName = "string",
#'         ProvisionedThroughput = list(
#'           ReadCapacityUnits = 123,
#'           WriteCapacityUnits = 123
#'         )
#'       ),
#'       Create = list(
#'         IndexName = "string",
#'         KeySchema = list(
#'           list(
#'             AttributeName = "string",
#'             KeyType = "HASH"|"RANGE"
#'           )
#'         ),
#'         Projection = list(
#'           ProjectionType = "ALL"|"KEYS_ONLY"|"INCLUDE",
#'           NonKeyAttributes = list(
#'             "string"
#'           )
#'         ),
#'         ProvisionedThroughput = list(
#'           ReadCapacityUnits = 123,
#'           WriteCapacityUnits = 123
#'         )
#'       ),
#'       Delete = list(
#'         IndexName = "string"
#'       )
#'     )
#'   ),
#'   StreamSpecification = list(
#'     StreamEnabled = TRUE|FALSE,
#'     StreamViewType = "NEW_IMAGE"|"OLD_IMAGE"|"NEW_AND_OLD_IMAGES"|"KEYS_ONLY"
#'   ),
#'   SSESpecification = list(
#'     Enabled = TRUE|FALSE,
#'     SSEType = "AES256"|"KMS",
#'     KMSMasterKeyId = "string"
#'   )
#' )
#' ```
#'
#' @examples
#' # This example increases the provisioned read and write capacity on the
#' # Music table.
#' \donttest{svc$update_table(
#'   ProvisionedThroughput = list(
#'     ReadCapacityUnits = 10L,
#'     WriteCapacityUnits = 10L
#'   ),
#'   TableName = "MusicCollection"
#' )}
#'
#' @keywords internal
#'
#' @rdname dynamodb_update_table
dynamodb_update_table <- function(AttributeDefinitions = NULL, TableName, BillingMode = NULL, ProvisionedThroughput = NULL, GlobalSecondaryIndexUpdates = NULL, StreamSpecification = NULL, SSESpecification = NULL) {
  op <- new_operation(
    name = "UpdateTable",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .dynamodb$update_table_input(AttributeDefinitions = AttributeDefinitions, TableName = TableName, BillingMode = BillingMode, ProvisionedThroughput = ProvisionedThroughput, GlobalSecondaryIndexUpdates = GlobalSecondaryIndexUpdates, StreamSpecification = StreamSpecification, SSESpecification = SSESpecification)
  output <- .dynamodb$update_table_output()
  config <- get_config()
  svc <- .dynamodb$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.dynamodb$operations$update_table <- dynamodb_update_table

#' The UpdateTimeToLive method enables or disables Time to Live (TTL) for
#' the specified table
#'
#' The `UpdateTimeToLive` method enables or disables Time to Live (TTL) for
#' the specified table. A successful `UpdateTimeToLive` call returns the
#' current `TimeToLiveSpecification`. It can take up to one hour for the
#' change to fully process. Any additional `UpdateTimeToLive` calls for the
#' same table during this one hour duration result in a
#' `ValidationException`.
#' 
#' TTL compares the current time in epoch time format to the time stored in
#' the TTL attribute of an item. If the epoch time value stored in the
#' attribute is less than the current time, the item is marked as expired
#' and subsequently deleted.
#' 
#' The epoch time format is the number of seconds elapsed since 12:00:00 AM
#' January 1, 1970 UTC.
#' 
#' DynamoDB deletes expired items on a best-effort basis to ensure
#' availability of throughput for other data operations.
#' 
#' DynamoDB typically deletes expired items within two days of expiration.
#' The exact duration within which an item gets deleted after expiration is
#' specific to the nature of the workload. Items that have expired and not
#' been deleted will still show up in reads, queries, and scans.
#' 
#' As items are deleted, they are removed from any local secondary index
#' and global secondary index immediately in the same eventually consistent
#' way as a standard delete operation.
#' 
#' For more information, see [Time To
#' Live](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/TTL.html)
#' in the Amazon DynamoDB Developer Guide.
#'
#' @usage
#' dynamodb_update_time_to_live(TableName, TimeToLiveSpecification)
#'
#' @param TableName &#91;required&#93; The name of the table to be configured.
#' @param TimeToLiveSpecification &#91;required&#93; Represents the settings used to enable or disable Time to Live for the
#' specified table.
#'
#' @section Request syntax:
#' ```
#' svc$update_time_to_live(
#'   TableName = "string",
#'   TimeToLiveSpecification = list(
#'     Enabled = TRUE|FALSE,
#'     AttributeName = "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname dynamodb_update_time_to_live
dynamodb_update_time_to_live <- function(TableName, TimeToLiveSpecification) {
  op <- new_operation(
    name = "UpdateTimeToLive",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .dynamodb$update_time_to_live_input(TableName = TableName, TimeToLiveSpecification = TimeToLiveSpecification)
  output <- .dynamodb$update_time_to_live_output()
  config <- get_config()
  svc <- .dynamodb$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.dynamodb$operations$update_time_to_live <- dynamodb_update_time_to_live
