% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dynamodb_operations.R
\name{dynamodb_restore_table_from_backup}
\alias{dynamodb_restore_table_from_backup}
\title{Creates a new table from an existing backup}
\usage{
dynamodb_restore_table_from_backup(TargetTableName, BackupArn)
}
\arguments{
\item{TargetTableName}{[required] The name of the new table to which the backup must be restored.}

\item{BackupArn}{[required] The Amazon Resource Name (ARN) associated with the backup.}
}
\description{
Creates a new table from an existing backup. Any number of users can
execute up to 4 concurrent restores (any type of restore) in a given
account.
}
\details{
You can call \code{RestoreTableFromBackup} at a maximum rate of 10 times per
second.

You must manually set up the following on the restored table:
\itemize{
\item Auto scaling policies
\item IAM policies
\item Amazon CloudWatch metrics and alarms
\item Tags
\item Stream settings
\item Time to Live (TTL) settings
}
}
\section{Request syntax}{
\preformatted{svc$restore_table_from_backup(
  TargetTableName = "string",
  BackupArn = "string"
)
}
}

\keyword{internal}
