% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/redshift_operations.R
\name{redshift_describe_scheduled_actions}
\alias{redshift_describe_scheduled_actions}
\title{Describes properties of scheduled actions}
\usage{
redshift_describe_scheduled_actions(ScheduledActionName,
  TargetActionType, StartTime, EndTime, Active, Filters, Marker,
  MaxRecords)
}
\arguments{
\item{ScheduledActionName}{The name of the scheduled action to retrieve.}

\item{TargetActionType}{The type of the scheduled actions to retrieve.}

\item{StartTime}{The start time in UTC of the scheduled actions to retrieve. Only active
scheduled actions that have invocations after this time are retrieved.}

\item{EndTime}{The end time in UTC of the scheduled action to retrieve. Only active
scheduled actions that have invocations before this time are retrieved.}

\item{Active}{If true, retrieve only active scheduled actions. If false, retrieve only
disabled scheduled actions.}

\item{Filters}{List of scheduled action filters.}

\item{Marker}{An optional parameter that specifies the starting point to return a set
of response records. When the results of a
\code{\link[=redshift_describe_scheduled_actions]{describe_scheduled_actions}}
request exceed the value specified in \code{MaxRecords}, AWS returns a value
in the \code{Marker} field of the response. You can retrieve the next set of
response records by providing the returned marker value in the \code{Marker}
parameter and retrying the request.}

\item{MaxRecords}{The maximum number of response records to return in each call. If the
number of remaining response records exceeds the specified \code{MaxRecords}
value, a value is returned in a \code{marker} field of the response. You can
retrieve the next set of records by retrying the command with the
returned marker value.

Default: \code{100}

Constraints: minimum 20, maximum 100.}
}
\value{
A list with the following syntax:\preformatted{list(
  Marker = "string",
  ScheduledActions = list(
    list(
      ScheduledActionName = "string",
      TargetAction = list(
        ResizeCluster = list(
          ClusterIdentifier = "string",
          ClusterType = "string",
          NodeType = "string",
          NumberOfNodes = 123,
          Classic = TRUE|FALSE
        ),
        PauseCluster = list(
          ClusterIdentifier = "string"
        ),
        ResumeCluster = list(
          ClusterIdentifier = "string"
        )
      ),
      Schedule = "string",
      IamRole = "string",
      ScheduledActionDescription = "string",
      State = "ACTIVE"|"DISABLED",
      NextInvocations = list(
        as.POSIXct(
          "2015-01-01"
        )
      ),
      StartTime = as.POSIXct(
        "2015-01-01"
      ),
      EndTime = as.POSIXct(
        "2015-01-01"
      )
    )
  )
)
}
}
\description{
Describes properties of scheduled actions.
}
\section{Request syntax}{
\preformatted{svc$describe_scheduled_actions(
  ScheduledActionName = "string",
  TargetActionType = "ResizeCluster"|"PauseCluster"|"ResumeCluster",
  StartTime = as.POSIXct(
    "2015-01-01"
  ),
  EndTime = as.POSIXct(
    "2015-01-01"
  ),
  Active = TRUE|FALSE,
  Filters = list(
    list(
      Name = "cluster-identifier"|"iam-role",
      Values = list(
        "string"
      )
    )
  ),
  Marker = "string",
  MaxRecords = 123
)
}
}

\keyword{internal}
