% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rds_operations.R
\name{rds_describe_certificates}
\alias{rds_describe_certificates}
\title{Lists the set of CA certificates provided by Amazon RDS for this AWS
account}
\usage{
rds_describe_certificates(CertificateIdentifier, Filters, MaxRecords,
  Marker)
}
\arguments{
\item{CertificateIdentifier}{The user-supplied certificate identifier. If this parameter is
specified, information for only the identified certificate is returned.
This parameter isn't case-sensitive.

Constraints:
\itemize{
\item Must match an existing CertificateIdentifier.
}}

\item{Filters}{This parameter isn't currently supported.}

\item{MaxRecords}{The maximum number of records to include in the response. If more
records exist than the specified \code{MaxRecords} value, a pagination token
called a marker is included in the response so you can retrieve the
remaining results.

Default: 100

Constraints: Minimum 20, maximum 100.}

\item{Marker}{An optional pagination token provided by a previous
\code{\link[=rds_describe_certificates]{describe_certificates}} request. If this
parameter is specified, the response includes only records beyond the
marker, up to the value specified by \code{MaxRecords}.}
}
\value{
A list with the following syntax:\preformatted{list(
  Certificates = list(
    list(
      CertificateIdentifier = "string",
      CertificateType = "string",
      Thumbprint = "string",
      ValidFrom = as.POSIXct(
        "2015-01-01"
      ),
      ValidTill = as.POSIXct(
        "2015-01-01"
      ),
      CertificateArn = "string",
      CustomerOverride = TRUE|FALSE,
      CustomerOverrideValidTill = as.POSIXct(
        "2015-01-01"
      )
    )
  ),
  Marker = "string"
)
}
}
\description{
Lists the set of CA certificates provided by Amazon RDS for this AWS
account.
}
\section{Request syntax}{
\preformatted{svc$describe_certificates(
  CertificateIdentifier = "string",
  Filters = list(
    list(
      Name = "string",
      Values = list(
        "string"
      )
    )
  ),
  MaxRecords = 123,
  Marker = "string"
)
}
}

\keyword{internal}
