% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dynamodb_operations.R
\name{dynamodb_tag_resource}
\alias{dynamodb_tag_resource}
\title{Associate a set of tags with an Amazon DynamoDB resource}
\usage{
dynamodb_tag_resource(ResourceArn, Tags)
}
\arguments{
\item{ResourceArn}{[required] Identifies the Amazon DynamoDB resource to which tags should be added.
This value is an Amazon Resource Name (ARN).}

\item{Tags}{[required] The tags to be assigned to the Amazon DynamoDB resource.}
}
\description{
Associate a set of tags with an Amazon DynamoDB resource. You can then
activate these user-defined tags so that they appear on the Billing and
Cost Management console for cost allocation tracking. You can call
TagResource up to 5 times per second, per account.
}
\details{
For an overview on tagging DynamoDB resources, see \href{http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Tagging.html}{Tagging for DynamoDB}
in the \emph{Amazon DynamoDB Developer Guide}.
}
\section{Request syntax}{
\preformatted{svc$tag_resource(
  ResourceArn = "string",
  Tags = list(
    list(
      Key = "string",
      Value = "string"
    )
  )
)
}
}

\keyword{internal}
