% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/customerprofiles_operations.R
\name{customerprofiles_get_similar_profiles}
\alias{customerprofiles_get_similar_profiles}
\title{Returns a set of profiles that belong to the same matching group using
the matchId or profileId}
\usage{
customerprofiles_get_similar_profiles(
  NextToken = NULL,
  MaxResults = NULL,
  DomainName,
  MatchType,
  SearchKey,
  SearchValue
)
}
\arguments{
\item{NextToken}{The pagination token from the previous
\code{\link[=customerprofiles_get_similar_profiles]{get_similar_profiles}} API
call.}

\item{MaxResults}{The maximum number of objects returned per page.}

\item{DomainName}{[required] The unique name of the domain.}

\item{MatchType}{[required] Specify the type of matching to get similar profiles for.}

\item{SearchKey}{[required] The string indicating the search key to be used.}

\item{SearchValue}{[required] The string based on \code{SearchKey} to be searched for similar profiles.}
}
\description{
Returns a set of profiles that belong to the same matching group using the \code{matchId} or \code{profileId}. You can also specify the type of matching that you want for finding similar profiles using either \code{RULE_BASED_MATCHING} or \code{ML_BASED_MATCHING}.

See \url{https://www.paws-r-sdk.com/docs/customerprofiles_get_similar_profiles/} for full documentation.
}
\keyword{internal}
