% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pinpoint_operations.R
\name{pinpoint_get_segment_export_jobs}
\alias{pinpoint_get_segment_export_jobs}
\title{Retrieves information about the status and settings of the export jobs
for a segment}
\usage{
pinpoint_get_segment_export_jobs(
  ApplicationId,
  PageSize = NULL,
  SegmentId,
  Token = NULL
)
}
\arguments{
\item{ApplicationId}{[required] The unique identifier for the application. This identifier is displayed
as the \strong{Project ID} on the Amazon Pinpoint console.}

\item{PageSize}{The maximum number of items to include in each page of a paginated
response. This parameter is not supported for application, campaign, and
journey metrics.}

\item{SegmentId}{[required] The unique identifier for the segment.}

\item{Token}{The NextToken string that specifies which page of results to return in a
paginated response.}
}
\description{
Retrieves information about the status and settings of the export jobs for a segment.

See \url{https://www.paws-r-sdk.com/docs/pinpoint_get_segment_export_jobs/} for full documentation.
}
\keyword{internal}
