# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include pinpointsmsvoicev2_service.R
NULL

#' Associates the specified origination identity with a pool
#'
#' @description
#' Associates the specified origination identity with a pool.
#'
#' See [https://www.paws-r-sdk.com/docs/pinpointsmsvoicev2_associate_origination_identity/](https://www.paws-r-sdk.com/docs/pinpointsmsvoicev2_associate_origination_identity/) for full documentation.
#'
#' @param PoolId &#91;required&#93; The pool to update with the new Identity. This value can be either the
#' PoolId or PoolArn, and you can find these values using
#' [`describe_pools`][pinpointsmsvoicev2_describe_pools].
#' @param OriginationIdentity &#91;required&#93; The origination identity to use, such as PhoneNumberId, PhoneNumberArn,
#' SenderId, or SenderIdArn. You can use
#' [`describe_phone_numbers`][pinpointsmsvoicev2_describe_phone_numbers] to
#' find the values for PhoneNumberId and PhoneNumberArn, while
#' [`describe_sender_ids`][pinpointsmsvoicev2_describe_sender_ids] can be
#' used to get the values for SenderId and SenderIdArn.
#' @param IsoCountryCode &#91;required&#93; The new two-character code, in ISO 3166-1 alpha-2 format, for the
#' country or region of the origination identity.
#' @param ClientToken Unique, case-sensitive identifier that you provide to ensure the
#' idempotency of the request. If you don't specify a client token, a
#' randomly generated token is used for the request to ensure idempotency.
#'
#' @keywords internal
#'
#' @rdname pinpointsmsvoicev2_associate_origination_identity
pinpointsmsvoicev2_associate_origination_identity <- function(PoolId, OriginationIdentity, IsoCountryCode, ClientToken = NULL) {
  op <- new_operation(
    name = "AssociateOriginationIdentity",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .pinpointsmsvoicev2$associate_origination_identity_input(PoolId = PoolId, OriginationIdentity = OriginationIdentity, IsoCountryCode = IsoCountryCode, ClientToken = ClientToken)
  output <- .pinpointsmsvoicev2$associate_origination_identity_output()
  config <- get_config()
  svc <- .pinpointsmsvoicev2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpointsmsvoicev2$operations$associate_origination_identity <- pinpointsmsvoicev2_associate_origination_identity

#' Associate a protect configuration with a configuration set
#'
#' @description
#' Associate a protect configuration with a configuration set. This replaces the configuration sets current protect configuration. A configuration set can only be associated with one protect configuration at a time. A protect configuration can be associated with multiple configuration sets.
#'
#' See [https://www.paws-r-sdk.com/docs/pinpointsmsvoicev2_associate_protect_configuration/](https://www.paws-r-sdk.com/docs/pinpointsmsvoicev2_associate_protect_configuration/) for full documentation.
#'
#' @param ProtectConfigurationId &#91;required&#93; The unique identifier for the protect configuration.
#' @param ConfigurationSetName &#91;required&#93; The name of the ConfigurationSet.
#'
#' @keywords internal
#'
#' @rdname pinpointsmsvoicev2_associate_protect_configuration
pinpointsmsvoicev2_associate_protect_configuration <- function(ProtectConfigurationId, ConfigurationSetName) {
  op <- new_operation(
    name = "AssociateProtectConfiguration",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .pinpointsmsvoicev2$associate_protect_configuration_input(ProtectConfigurationId = ProtectConfigurationId, ConfigurationSetName = ConfigurationSetName)
  output <- .pinpointsmsvoicev2$associate_protect_configuration_output()
  config <- get_config()
  svc <- .pinpointsmsvoicev2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpointsmsvoicev2$operations$associate_protect_configuration <- pinpointsmsvoicev2_associate_protect_configuration

#' Creates a new configuration set
#'
#' @description
#' Creates a new configuration set. After you create the configuration set, you can add one or more event destinations to it.
#'
#' See [https://www.paws-r-sdk.com/docs/pinpointsmsvoicev2_create_configuration_set/](https://www.paws-r-sdk.com/docs/pinpointsmsvoicev2_create_configuration_set/) for full documentation.
#'
#' @param ConfigurationSetName &#91;required&#93; The name to use for the new configuration set.
#' @param Tags An array of key and value pair tags that's associated with the new
#' configuration set.
#' @param ClientToken Unique, case-sensitive identifier that you provide to ensure the
#' idempotency of the request. If you don't specify a client token, a
#' randomly generated token is used for the request to ensure idempotency.
#'
#' @keywords internal
#'
#' @rdname pinpointsmsvoicev2_create_configuration_set
pinpointsmsvoicev2_create_configuration_set <- function(ConfigurationSetName, Tags = NULL, ClientToken = NULL) {
  op <- new_operation(
    name = "CreateConfigurationSet",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .pinpointsmsvoicev2$create_configuration_set_input(ConfigurationSetName = ConfigurationSetName, Tags = Tags, ClientToken = ClientToken)
  output <- .pinpointsmsvoicev2$create_configuration_set_output()
  config <- get_config()
  svc <- .pinpointsmsvoicev2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpointsmsvoicev2$operations$create_configuration_set <- pinpointsmsvoicev2_create_configuration_set

#' Creates a new event destination in a configuration set
#'
#' @description
#' Creates a new event destination in a configuration set.
#'
#' See [https://www.paws-r-sdk.com/docs/pinpointsmsvoicev2_create_event_destination/](https://www.paws-r-sdk.com/docs/pinpointsmsvoicev2_create_event_destination/) for full documentation.
#'
#' @param ConfigurationSetName &#91;required&#93; Either the name of the configuration set or the configuration set ARN to
#' apply event logging to. The ConfigurateSetName and ConfigurationSetArn
#' can be found using the
#' [`describe_configuration_sets`][pinpointsmsvoicev2_describe_configuration_sets]
#' action.
#' @param EventDestinationName &#91;required&#93; The name that identifies the event destination.
#' @param MatchingEventTypes &#91;required&#93; An array of event types that determine which events to log. If "ALL" is
#' used, then AWS End User Messaging SMS and Voice logs every event type.
#' 
#' The `TEXT_SENT` event type is not supported.
#' @param CloudWatchLogsDestination An object that contains information about an event destination for
#' logging to Amazon CloudWatch Logs.
#' @param KinesisFirehoseDestination An object that contains information about an event destination for
#' logging to Amazon Data Firehose.
#' @param SnsDestination An object that contains information about an event destination for
#' logging to Amazon SNS.
#' @param ClientToken Unique, case-sensitive identifier that you provide to ensure the
#' idempotency of the request. If you don't specify a client token, a
#' randomly generated token is used for the request to ensure idempotency.
#'
#' @keywords internal
#'
#' @rdname pinpointsmsvoicev2_create_event_destination
pinpointsmsvoicev2_create_event_destination <- function(ConfigurationSetName, EventDestinationName, MatchingEventTypes, CloudWatchLogsDestination = NULL, KinesisFirehoseDestination = NULL, SnsDestination = NULL, ClientToken = NULL) {
  op <- new_operation(
    name = "CreateEventDestination",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .pinpointsmsvoicev2$create_event_destination_input(ConfigurationSetName = ConfigurationSetName, EventDestinationName = EventDestinationName, MatchingEventTypes = MatchingEventTypes, CloudWatchLogsDestination = CloudWatchLogsDestination, KinesisFirehoseDestination = KinesisFirehoseDestination, SnsDestination = SnsDestination, ClientToken = ClientToken)
  output <- .pinpointsmsvoicev2$create_event_destination_output()
  config <- get_config()
  svc <- .pinpointsmsvoicev2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpointsmsvoicev2$operations$create_event_destination <- pinpointsmsvoicev2_create_event_destination

#' Creates a new opt-out list
#'
#' @description
#' Creates a new opt-out list.
#'
#' See [https://www.paws-r-sdk.com/docs/pinpointsmsvoicev2_create_opt_out_list/](https://www.paws-r-sdk.com/docs/pinpointsmsvoicev2_create_opt_out_list/) for full documentation.
#'
#' @param OptOutListName &#91;required&#93; The name of the new OptOutList.
#' @param Tags An array of tags (key and value pairs) to associate with the new
#' OptOutList.
#' @param ClientToken Unique, case-sensitive identifier that you provide to ensure the
#' idempotency of the request. If you don't specify a client token, a
#' randomly generated token is used for the request to ensure idempotency.
#'
#' @keywords internal
#'
#' @rdname pinpointsmsvoicev2_create_opt_out_list
pinpointsmsvoicev2_create_opt_out_list <- function(OptOutListName, Tags = NULL, ClientToken = NULL) {
  op <- new_operation(
    name = "CreateOptOutList",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .pinpointsmsvoicev2$create_opt_out_list_input(OptOutListName = OptOutListName, Tags = Tags, ClientToken = ClientToken)
  output <- .pinpointsmsvoicev2$create_opt_out_list_output()
  config <- get_config()
  svc <- .pinpointsmsvoicev2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpointsmsvoicev2$operations$create_opt_out_list <- pinpointsmsvoicev2_create_opt_out_list

#' Creates a new pool and associates the specified origination identity to
#' the pool
#'
#' @description
#' Creates a new pool and associates the specified origination identity to the pool. A pool can include one or more phone numbers and SenderIds that are associated with your Amazon Web Services account.
#'
#' See [https://www.paws-r-sdk.com/docs/pinpointsmsvoicev2_create_pool/](https://www.paws-r-sdk.com/docs/pinpointsmsvoicev2_create_pool/) for full documentation.
#'
#' @param OriginationIdentity &#91;required&#93; The origination identity to use such as a PhoneNumberId, PhoneNumberArn,
#' SenderId or SenderIdArn. You can use
#' [`describe_phone_numbers`][pinpointsmsvoicev2_describe_phone_numbers] to
#' find the values for PhoneNumberId and PhoneNumberArn while
#' [`describe_sender_ids`][pinpointsmsvoicev2_describe_sender_ids] can be
#' used to get the values for SenderId and SenderIdArn.
#' 
#' After the pool is created you can add more origination identities to the
#' pool by using
#' [`associate_origination_identity`][pinpointsmsvoicev2_associate_origination_identity].
#' @param IsoCountryCode &#91;required&#93; The new two-character code, in ISO 3166-1 alpha-2 format, for the
#' country or region of the new pool.
#' @param MessageType &#91;required&#93; The type of message. Valid values are TRANSACTIONAL for messages that
#' are critical or time-sensitive and PROMOTIONAL for messages that aren't
#' critical or time-sensitive. After the pool is created the MessageType
#' can't be changed.
#' @param DeletionProtectionEnabled By default this is set to false. When set to true the pool can't be
#' deleted. You can change this value using the
#' [`update_pool`][pinpointsmsvoicev2_update_pool] action.
#' @param Tags An array of tags (key and value pairs) associated with the pool.
#' @param ClientToken Unique, case-sensitive identifier that you provide to ensure the
#' idempotency of the request. If you don't specify a client token, a
#' randomly generated token is used for the request to ensure idempotency.
#'
#' @keywords internal
#'
#' @rdname pinpointsmsvoicev2_create_pool
pinpointsmsvoicev2_create_pool <- function(OriginationIdentity, IsoCountryCode, MessageType, DeletionProtectionEnabled = NULL, Tags = NULL, ClientToken = NULL) {
  op <- new_operation(
    name = "CreatePool",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .pinpointsmsvoicev2$create_pool_input(OriginationIdentity = OriginationIdentity, IsoCountryCode = IsoCountryCode, MessageType = MessageType, DeletionProtectionEnabled = DeletionProtectionEnabled, Tags = Tags, ClientToken = ClientToken)
  output <- .pinpointsmsvoicev2$create_pool_output()
  config <- get_config()
  svc <- .pinpointsmsvoicev2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpointsmsvoicev2$operations$create_pool <- pinpointsmsvoicev2_create_pool

#' Create a new protect configuration
#'
#' @description
#' Create a new protect configuration. By default all country rule sets for each capability are set to `ALLOW`. Update the country rule sets using [`update_protect_configuration_country_rule_set`][pinpointsmsvoicev2_update_protect_configuration_country_rule_set]. A protect configurations name is stored as a Tag with the key set to `Name` and value as the name of the protect configuration.
#'
#' See [https://www.paws-r-sdk.com/docs/pinpointsmsvoicev2_create_protect_configuration/](https://www.paws-r-sdk.com/docs/pinpointsmsvoicev2_create_protect_configuration/) for full documentation.
#'
#' @param ClientToken Unique, case-sensitive identifier that you provide to ensure the
#' idempotency of the request. If you don't specify a client token, a
#' randomly generated token is used for the request to ensure idempotency.
#' @param DeletionProtectionEnabled When set to true deletion protection is enabled. By default this is set
#' to false.
#' @param Tags An array of key and value pair tags that are associated with the
#' resource.
#'
#' @keywords internal
#'
#' @rdname pinpointsmsvoicev2_create_protect_configuration
pinpointsmsvoicev2_create_protect_configuration <- function(ClientToken = NULL, DeletionProtectionEnabled = NULL, Tags = NULL) {
  op <- new_operation(
    name = "CreateProtectConfiguration",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .pinpointsmsvoicev2$create_protect_configuration_input(ClientToken = ClientToken, DeletionProtectionEnabled = DeletionProtectionEnabled, Tags = Tags)
  output <- .pinpointsmsvoicev2$create_protect_configuration_output()
  config <- get_config()
  svc <- .pinpointsmsvoicev2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpointsmsvoicev2$operations$create_protect_configuration <- pinpointsmsvoicev2_create_protect_configuration

#' Creates a new registration based on the RegistrationType field
#'
#' @description
#' Creates a new registration based on the **RegistrationType** field.
#'
#' See [https://www.paws-r-sdk.com/docs/pinpointsmsvoicev2_create_registration/](https://www.paws-r-sdk.com/docs/pinpointsmsvoicev2_create_registration/) for full documentation.
#'
#' @param RegistrationType &#91;required&#93; The type of registration form to create. The list of
#' **RegistrationTypes** can be found using the
#' [`describe_registration_type_definitions`][pinpointsmsvoicev2_describe_registration_type_definitions]
#' action.
#' @param Tags An array of tags (key and value pairs) to associate with the
#' registration.
#' @param ClientToken Unique, case-sensitive identifier that you provide to ensure the
#' idempotency of the request. If you don't specify a client token, a
#' randomly generated token is used for the request to ensure idempotency.
#'
#' @keywords internal
#'
#' @rdname pinpointsmsvoicev2_create_registration
pinpointsmsvoicev2_create_registration <- function(RegistrationType, Tags = NULL, ClientToken = NULL) {
  op <- new_operation(
    name = "CreateRegistration",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .pinpointsmsvoicev2$create_registration_input(RegistrationType = RegistrationType, Tags = Tags, ClientToken = ClientToken)
  output <- .pinpointsmsvoicev2$create_registration_output()
  config <- get_config()
  svc <- .pinpointsmsvoicev2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpointsmsvoicev2$operations$create_registration <- pinpointsmsvoicev2_create_registration

#' Associate the registration with an origination identity such as a phone
#' number or sender ID
#'
#' @description
#' Associate the registration with an origination identity such as a phone number or sender ID.
#'
#' See [https://www.paws-r-sdk.com/docs/pinpointsmsvoicev2_create_registration_association/](https://www.paws-r-sdk.com/docs/pinpointsmsvoicev2_create_registration_association/) for full documentation.
#'
#' @param RegistrationId &#91;required&#93; The unique identifier for the registration.
#' @param ResourceId &#91;required&#93; The unique identifier for the origination identity. For example this
#' could be a **PhoneNumberId** or **SenderId**.
#'
#' @keywords internal
#'
#' @rdname pinpointsmsvoicev2_create_registration_association
pinpointsmsvoicev2_create_registration_association <- function(RegistrationId, ResourceId) {
  op <- new_operation(
    name = "CreateRegistrationAssociation",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .pinpointsmsvoicev2$create_registration_association_input(RegistrationId = RegistrationId, ResourceId = ResourceId)
  output <- .pinpointsmsvoicev2$create_registration_association_output()
  config <- get_config()
  svc <- .pinpointsmsvoicev2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpointsmsvoicev2$operations$create_registration_association <- pinpointsmsvoicev2_create_registration_association

#' Create a new registration attachment to use for uploading a file or a
#' URL to a file
#'
#' @description
#' Create a new registration attachment to use for uploading a file or a URL to a file. The maximum file size is 1MiB and valid file extensions are PDF, JPEG and PNG. For example, many sender ID registrations require a signed “letter of authorization” (LOA) to be submitted.
#'
#' See [https://www.paws-r-sdk.com/docs/pinpointsmsvoicev2_create_registration_attachment/](https://www.paws-r-sdk.com/docs/pinpointsmsvoicev2_create_registration_attachment/) for full documentation.
#'
#' @param AttachmentBody The registration file to upload. The maximum file size is 1MiB and valid
#' file extensions are PDF, JPEG and PNG.
#' @param AttachmentUrl A URL to the required registration file. For example, you can provide
#' the S3 object URL.
#' @param Tags An array of tags (key and value pairs) to associate with the
#' registration attachment.
#' @param ClientToken Unique, case-sensitive identifier that you provide to ensure the
#' idempotency of the request. If you don't specify a client token, a
#' randomly generated token is used for the request to ensure idempotency.
#'
#' @keywords internal
#'
#' @rdname pinpointsmsvoicev2_create_registration_attachment
pinpointsmsvoicev2_create_registration_attachment <- function(AttachmentBody = NULL, AttachmentUrl = NULL, Tags = NULL, ClientToken = NULL) {
  op <- new_operation(
    name = "CreateRegistrationAttachment",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .pinpointsmsvoicev2$create_registration_attachment_input(AttachmentBody = AttachmentBody, AttachmentUrl = AttachmentUrl, Tags = Tags, ClientToken = ClientToken)
  output <- .pinpointsmsvoicev2$create_registration_attachment_output()
  config <- get_config()
  svc <- .pinpointsmsvoicev2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpointsmsvoicev2$operations$create_registration_attachment <- pinpointsmsvoicev2_create_registration_attachment

#' Create a new version of the registration and increase the VersionNumber
#'
#' @description
#' Create a new version of the registration and increase the **VersionNumber**. The previous version of the registration becomes read-only.
#'
#' See [https://www.paws-r-sdk.com/docs/pinpointsmsvoicev2_create_registration_version/](https://www.paws-r-sdk.com/docs/pinpointsmsvoicev2_create_registration_version/) for full documentation.
#'
#' @param RegistrationId &#91;required&#93; The unique identifier for the registration.
#'
#' @keywords internal
#'
#' @rdname pinpointsmsvoicev2_create_registration_version
pinpointsmsvoicev2_create_registration_version <- function(RegistrationId) {
  op <- new_operation(
    name = "CreateRegistrationVersion",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .pinpointsmsvoicev2$create_registration_version_input(RegistrationId = RegistrationId)
  output <- .pinpointsmsvoicev2$create_registration_version_output()
  config <- get_config()
  svc <- .pinpointsmsvoicev2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpointsmsvoicev2$operations$create_registration_version <- pinpointsmsvoicev2_create_registration_version

#' You can only send messages to verified destination numbers when your
#' account is in the sandbox
#'
#' @description
#' You can only send messages to verified destination numbers when your account is in the sandbox. You can add up to 10 verified destination numbers.
#'
#' See [https://www.paws-r-sdk.com/docs/pinpointsmsvoicev2_create_verified_destination_number/](https://www.paws-r-sdk.com/docs/pinpointsmsvoicev2_create_verified_destination_number/) for full documentation.
#'
#' @param DestinationPhoneNumber &#91;required&#93; The verified destination phone number, in E.164 format.
#' @param Tags An array of tags (key and value pairs) to associate with the destination
#' number.
#' @param ClientToken Unique, case-sensitive identifier that you provide to ensure the
#' idempotency of the request. If you don't specify a client token, a
#' randomly generated token is used for the request to ensure idempotency.
#'
#' @keywords internal
#'
#' @rdname pinpointsmsvoicev2_create_verified_destination_number
pinpointsmsvoicev2_create_verified_destination_number <- function(DestinationPhoneNumber, Tags = NULL, ClientToken = NULL) {
  op <- new_operation(
    name = "CreateVerifiedDestinationNumber",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .pinpointsmsvoicev2$create_verified_destination_number_input(DestinationPhoneNumber = DestinationPhoneNumber, Tags = Tags, ClientToken = ClientToken)
  output <- .pinpointsmsvoicev2$create_verified_destination_number_output()
  config <- get_config()
  svc <- .pinpointsmsvoicev2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpointsmsvoicev2$operations$create_verified_destination_number <- pinpointsmsvoicev2_create_verified_destination_number

#' Removes the current account default protect configuration
#'
#' @description
#' Removes the current account default protect configuration.
#'
#' See [https://www.paws-r-sdk.com/docs/pinpointsmsvoicev2_delete_account_default_protect_configuration/](https://www.paws-r-sdk.com/docs/pinpointsmsvoicev2_delete_account_default_protect_configuration/) for full documentation.
#'

#'
#' @keywords internal
#'
#' @rdname pinpointsmsvoicev2_delete_accoun_defaul_protec_config
pinpointsmsvoicev2_delete_account_default_protect_configuration <- function() {
  op <- new_operation(
    name = "DeleteAccountDefaultProtectConfiguration",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .pinpointsmsvoicev2$delete_account_default_protect_configuration_input()
  output <- .pinpointsmsvoicev2$delete_account_default_protect_configuration_output()
  config <- get_config()
  svc <- .pinpointsmsvoicev2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpointsmsvoicev2$operations$delete_account_default_protect_configuration <- pinpointsmsvoicev2_delete_account_default_protect_configuration

#' Deletes an existing configuration set
#'
#' @description
#' Deletes an existing configuration set.
#'
#' See [https://www.paws-r-sdk.com/docs/pinpointsmsvoicev2_delete_configuration_set/](https://www.paws-r-sdk.com/docs/pinpointsmsvoicev2_delete_configuration_set/) for full documentation.
#'
#' @param ConfigurationSetName &#91;required&#93; The name of the configuration set or the configuration set ARN that you
#' want to delete. The ConfigurationSetName and ConfigurationSetArn can be
#' found using the
#' [`describe_configuration_sets`][pinpointsmsvoicev2_describe_configuration_sets]
#' action.
#'
#' @keywords internal
#'
#' @rdname pinpointsmsvoicev2_delete_configuration_set
pinpointsmsvoicev2_delete_configuration_set <- function(ConfigurationSetName) {
  op <- new_operation(
    name = "DeleteConfigurationSet",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .pinpointsmsvoicev2$delete_configuration_set_input(ConfigurationSetName = ConfigurationSetName)
  output <- .pinpointsmsvoicev2$delete_configuration_set_output()
  config <- get_config()
  svc <- .pinpointsmsvoicev2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpointsmsvoicev2$operations$delete_configuration_set <- pinpointsmsvoicev2_delete_configuration_set

#' Deletes an existing default message type on a configuration set
#'
#' @description
#' Deletes an existing default message type on a configuration set.
#'
#' See [https://www.paws-r-sdk.com/docs/pinpointsmsvoicev2_delete_default_message_type/](https://www.paws-r-sdk.com/docs/pinpointsmsvoicev2_delete_default_message_type/) for full documentation.
#'
#' @param ConfigurationSetName &#91;required&#93; The name of the configuration set or the configuration set Amazon
#' Resource Name (ARN) to delete the default message type from. The
#' ConfigurationSetName and ConfigurationSetArn can be found using the
#' [`describe_configuration_sets`][pinpointsmsvoicev2_describe_configuration_sets]
#' action.
#'
#' @keywords internal
#'
#' @rdname pinpointsmsvoicev2_delete_default_message_type
pinpointsmsvoicev2_delete_default_message_type <- function(ConfigurationSetName) {
  op <- new_operation(
    name = "DeleteDefaultMessageType",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .pinpointsmsvoicev2$delete_default_message_type_input(ConfigurationSetName = ConfigurationSetName)
  output <- .pinpointsmsvoicev2$delete_default_message_type_output()
  config <- get_config()
  svc <- .pinpointsmsvoicev2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpointsmsvoicev2$operations$delete_default_message_type <- pinpointsmsvoicev2_delete_default_message_type

#' Deletes an existing default sender ID on a configuration set
#'
#' @description
#' Deletes an existing default sender ID on a configuration set.
#'
#' See [https://www.paws-r-sdk.com/docs/pinpointsmsvoicev2_delete_default_sender_id/](https://www.paws-r-sdk.com/docs/pinpointsmsvoicev2_delete_default_sender_id/) for full documentation.
#'
#' @param ConfigurationSetName &#91;required&#93; The name of the configuration set or the configuration set Amazon
#' Resource Name (ARN) to delete the default sender ID from. The
#' ConfigurationSetName and ConfigurationSetArn can be found using the
#' [`describe_configuration_sets`][pinpointsmsvoicev2_describe_configuration_sets]
#' action.
#'
#' @keywords internal
#'
#' @rdname pinpointsmsvoicev2_delete_default_sender_id
pinpointsmsvoicev2_delete_default_sender_id <- function(ConfigurationSetName) {
  op <- new_operation(
    name = "DeleteDefaultSenderId",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .pinpointsmsvoicev2$delete_default_sender_id_input(ConfigurationSetName = ConfigurationSetName)
  output <- .pinpointsmsvoicev2$delete_default_sender_id_output()
  config <- get_config()
  svc <- .pinpointsmsvoicev2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpointsmsvoicev2$operations$delete_default_sender_id <- pinpointsmsvoicev2_delete_default_sender_id

#' Deletes an existing event destination
#'
#' @description
#' Deletes an existing event destination.
#'
#' See [https://www.paws-r-sdk.com/docs/pinpointsmsvoicev2_delete_event_destination/](https://www.paws-r-sdk.com/docs/pinpointsmsvoicev2_delete_event_destination/) for full documentation.
#'
#' @param ConfigurationSetName &#91;required&#93; The name of the configuration set or the configuration set's Amazon
#' Resource Name (ARN) to remove the event destination from. The
#' ConfigurateSetName and ConfigurationSetArn can be found using the
#' [`describe_configuration_sets`][pinpointsmsvoicev2_describe_configuration_sets]
#' action.
#' @param EventDestinationName &#91;required&#93; The name of the event destination to delete.
#'
#' @keywords internal
#'
#' @rdname pinpointsmsvoicev2_delete_event_destination
pinpointsmsvoicev2_delete_event_destination <- function(ConfigurationSetName, EventDestinationName) {
  op <- new_operation(
    name = "DeleteEventDestination",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .pinpointsmsvoicev2$delete_event_destination_input(ConfigurationSetName = ConfigurationSetName, EventDestinationName = EventDestinationName)
  output <- .pinpointsmsvoicev2$delete_event_destination_output()
  config <- get_config()
  svc <- .pinpointsmsvoicev2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpointsmsvoicev2$operations$delete_event_destination <- pinpointsmsvoicev2_delete_event_destination

#' Deletes an existing keyword from an origination phone number or pool
#'
#' @description
#' Deletes an existing keyword from an origination phone number or pool.
#'
#' See [https://www.paws-r-sdk.com/docs/pinpointsmsvoicev2_delete_keyword/](https://www.paws-r-sdk.com/docs/pinpointsmsvoicev2_delete_keyword/) for full documentation.
#'
#' @param OriginationIdentity &#91;required&#93; The origination identity to use such as a PhoneNumberId, PhoneNumberArn,
#' PoolId or PoolArn. You can use
#' [`describe_phone_numbers`][pinpointsmsvoicev2_describe_phone_numbers] to
#' find the values for PhoneNumberId and PhoneNumberArn and
#' [`describe_pools`][pinpointsmsvoicev2_describe_pools] to find the values
#' of PoolId and PoolArn.
#' @param Keyword &#91;required&#93; The keyword to delete.
#'
#' @keywords internal
#'
#' @rdname pinpointsmsvoicev2_delete_keyword
pinpointsmsvoicev2_delete_keyword <- function(OriginationIdentity, Keyword) {
  op <- new_operation(
    name = "DeleteKeyword",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .pinpointsmsvoicev2$delete_keyword_input(OriginationIdentity = OriginationIdentity, Keyword = Keyword)
  output <- .pinpointsmsvoicev2$delete_keyword_output()
  config <- get_config()
  svc <- .pinpointsmsvoicev2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpointsmsvoicev2$operations$delete_keyword <- pinpointsmsvoicev2_delete_keyword

#' Deletes an account-level monthly spending limit override for sending
#' multimedia messages (MMS)
#'
#' @description
#' Deletes an account-level monthly spending limit override for sending multimedia messages (MMS). Deleting a spend limit override will set the `EnforcedLimit` to equal the `MaxLimit`, which is controlled by Amazon Web Services. For more information on spend limits (quotas) see [Quotas for Server Migration Service](https://docs.aws.amazon.com/sms-voice/latest/userguide/quotas.html) in the *Server Migration Service User Guide*.
#'
#' See [https://www.paws-r-sdk.com/docs/pinpointsmsvoicev2_delete_media_message_spend_limit_override/](https://www.paws-r-sdk.com/docs/pinpointsmsvoicev2_delete_media_message_spend_limit_override/) for full documentation.
#'

#'
#' @keywords internal
#'
#' @rdname pinpointsmsvoicev2_delete_media_message_spend_limit_override
pinpointsmsvoicev2_delete_media_message_spend_limit_override <- function() {
  op <- new_operation(
    name = "DeleteMediaMessageSpendLimitOverride",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .pinpointsmsvoicev2$delete_media_message_spend_limit_override_input()
  output <- .pinpointsmsvoicev2$delete_media_message_spend_limit_override_output()
  config <- get_config()
  svc <- .pinpointsmsvoicev2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpointsmsvoicev2$operations$delete_media_message_spend_limit_override <- pinpointsmsvoicev2_delete_media_message_spend_limit_override

#' Deletes an existing opt-out list
#'
#' @description
#' Deletes an existing opt-out list. All opted out phone numbers in the opt-out list are deleted.
#'
#' See [https://www.paws-r-sdk.com/docs/pinpointsmsvoicev2_delete_opt_out_list/](https://www.paws-r-sdk.com/docs/pinpointsmsvoicev2_delete_opt_out_list/) for full documentation.
#'
#' @param OptOutListName &#91;required&#93; The OptOutListName or OptOutListArn of the OptOutList to delete. You can
#' use
#' [`describe_opt_out_lists`][pinpointsmsvoicev2_describe_opt_out_lists] to
#' find the values for OptOutListName and OptOutListArn.
#'
#' @keywords internal
#'
#' @rdname pinpointsmsvoicev2_delete_opt_out_list
pinpointsmsvoicev2_delete_opt_out_list <- function(OptOutListName) {
  op <- new_operation(
    name = "DeleteOptOutList",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .pinpointsmsvoicev2$delete_opt_out_list_input(OptOutListName = OptOutListName)
  output <- .pinpointsmsvoicev2$delete_opt_out_list_output()
  config <- get_config()
  svc <- .pinpointsmsvoicev2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpointsmsvoicev2$operations$delete_opt_out_list <- pinpointsmsvoicev2_delete_opt_out_list

#' Deletes an existing opted out destination phone number from the
#' specified opt-out list
#'
#' @description
#' Deletes an existing opted out destination phone number from the specified opt-out list.
#'
#' See [https://www.paws-r-sdk.com/docs/pinpointsmsvoicev2_delete_opted_out_number/](https://www.paws-r-sdk.com/docs/pinpointsmsvoicev2_delete_opted_out_number/) for full documentation.
#'
#' @param OptOutListName &#91;required&#93; The OptOutListName or OptOutListArn to remove the phone number from.
#' @param OptedOutNumber &#91;required&#93; The phone number, in E.164 format, to remove from the OptOutList.
#'
#' @keywords internal
#'
#' @rdname pinpointsmsvoicev2_delete_opted_out_number
pinpointsmsvoicev2_delete_opted_out_number <- function(OptOutListName, OptedOutNumber) {
  op <- new_operation(
    name = "DeleteOptedOutNumber",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .pinpointsmsvoicev2$delete_opted_out_number_input(OptOutListName = OptOutListName, OptedOutNumber = OptedOutNumber)
  output <- .pinpointsmsvoicev2$delete_opted_out_number_output()
  config <- get_config()
  svc <- .pinpointsmsvoicev2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpointsmsvoicev2$operations$delete_opted_out_number <- pinpointsmsvoicev2_delete_opted_out_number

#' Deletes an existing pool
#'
#' @description
#' Deletes an existing pool. Deleting a pool disassociates all origination identities from that pool.
#'
#' See [https://www.paws-r-sdk.com/docs/pinpointsmsvoicev2_delete_pool/](https://www.paws-r-sdk.com/docs/pinpointsmsvoicev2_delete_pool/) for full documentation.
#'
#' @param PoolId &#91;required&#93; The PoolId or PoolArn of the pool to delete. You can use
#' [`describe_pools`][pinpointsmsvoicev2_describe_pools] to find the values
#' for PoolId and PoolArn .
#'
#' @keywords internal
#'
#' @rdname pinpointsmsvoicev2_delete_pool
pinpointsmsvoicev2_delete_pool <- function(PoolId) {
  op <- new_operation(
    name = "DeletePool",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .pinpointsmsvoicev2$delete_pool_input(PoolId = PoolId)
  output <- .pinpointsmsvoicev2$delete_pool_output()
  config <- get_config()
  svc <- .pinpointsmsvoicev2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpointsmsvoicev2$operations$delete_pool <- pinpointsmsvoicev2_delete_pool

#' Permanently delete the protect configuration
#'
#' @description
#' Permanently delete the protect configuration. The protect configuration must have deletion protection disabled and must not be associated as the account default protect configuration or associated with a configuration set.
#'
#' See [https://www.paws-r-sdk.com/docs/pinpointsmsvoicev2_delete_protect_configuration/](https://www.paws-r-sdk.com/docs/pinpointsmsvoicev2_delete_protect_configuration/) for full documentation.
#'
#' @param ProtectConfigurationId &#91;required&#93; The unique identifier for the protect configuration.
#'
#' @keywords internal
#'
#' @rdname pinpointsmsvoicev2_delete_protect_configuration
pinpointsmsvoicev2_delete_protect_configuration <- function(ProtectConfigurationId) {
  op <- new_operation(
    name = "DeleteProtectConfiguration",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .pinpointsmsvoicev2$delete_protect_configuration_input(ProtectConfigurationId = ProtectConfigurationId)
  output <- .pinpointsmsvoicev2$delete_protect_configuration_output()
  config <- get_config()
  svc <- .pinpointsmsvoicev2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpointsmsvoicev2$operations$delete_protect_configuration <- pinpointsmsvoicev2_delete_protect_configuration

#' Permanently delete an existing registration from your account
#'
#' @description
#' Permanently delete an existing registration from your account.
#'
#' See [https://www.paws-r-sdk.com/docs/pinpointsmsvoicev2_delete_registration/](https://www.paws-r-sdk.com/docs/pinpointsmsvoicev2_delete_registration/) for full documentation.
#'
#' @param RegistrationId &#91;required&#93; The unique identifier for the registration.
#'
#' @keywords internal
#'
#' @rdname pinpointsmsvoicev2_delete_registration
pinpointsmsvoicev2_delete_registration <- function(RegistrationId) {
  op <- new_operation(
    name = "DeleteRegistration",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .pinpointsmsvoicev2$delete_registration_input(RegistrationId = RegistrationId)
  output <- .pinpointsmsvoicev2$delete_registration_output()
  config <- get_config()
  svc <- .pinpointsmsvoicev2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpointsmsvoicev2$operations$delete_registration <- pinpointsmsvoicev2_delete_registration

#' Permanently delete the specified registration attachment
#'
#' @description
#' Permanently delete the specified registration attachment.
#'
#' See [https://www.paws-r-sdk.com/docs/pinpointsmsvoicev2_delete_registration_attachment/](https://www.paws-r-sdk.com/docs/pinpointsmsvoicev2_delete_registration_attachment/) for full documentation.
#'
#' @param RegistrationAttachmentId &#91;required&#93; The unique identifier for the registration attachment.
#'
#' @keywords internal
#'
#' @rdname pinpointsmsvoicev2_delete_registration_attachment
pinpointsmsvoicev2_delete_registration_attachment <- function(RegistrationAttachmentId) {
  op <- new_operation(
    name = "DeleteRegistrationAttachment",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .pinpointsmsvoicev2$delete_registration_attachment_input(RegistrationAttachmentId = RegistrationAttachmentId)
  output <- .pinpointsmsvoicev2$delete_registration_attachment_output()
  config <- get_config()
  svc <- .pinpointsmsvoicev2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpointsmsvoicev2$operations$delete_registration_attachment <- pinpointsmsvoicev2_delete_registration_attachment

#' Delete the value in a registration form field
#'
#' @description
#' Delete the value in a registration form field.
#'
#' See [https://www.paws-r-sdk.com/docs/pinpointsmsvoicev2_delete_registration_field_value/](https://www.paws-r-sdk.com/docs/pinpointsmsvoicev2_delete_registration_field_value/) for full documentation.
#'
#' @param RegistrationId &#91;required&#93; The unique identifier for the registration.
#' @param FieldPath &#91;required&#93; The path to the registration form field. You can use
#' [`describe_registration_field_definitions`][pinpointsmsvoicev2_describe_registration_field_definitions]
#' for a list of **FieldPaths**.
#'
#' @keywords internal
#'
#' @rdname pinpointsmsvoicev2_delete_registration_field_value
pinpointsmsvoicev2_delete_registration_field_value <- function(RegistrationId, FieldPath) {
  op <- new_operation(
    name = "DeleteRegistrationFieldValue",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .pinpointsmsvoicev2$delete_registration_field_value_input(RegistrationId = RegistrationId, FieldPath = FieldPath)
  output <- .pinpointsmsvoicev2$delete_registration_field_value_output()
  config <- get_config()
  svc <- .pinpointsmsvoicev2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpointsmsvoicev2$operations$delete_registration_field_value <- pinpointsmsvoicev2_delete_registration_field_value

#' Deletes an account-level monthly spending limit override for sending
#' text messages
#'
#' @description
#' Deletes an account-level monthly spending limit override for sending text messages. Deleting a spend limit override will set the `EnforcedLimit` to equal the `MaxLimit`, which is controlled by Amazon Web Services. For more information on spend limits (quotas) see [Quotas](https://docs.aws.amazon.com/sms-voice/latest/userguide/quotas.html) in the *AWS End User Messaging SMS User Guide*.
#'
#' See [https://www.paws-r-sdk.com/docs/pinpointsmsvoicev2_delete_text_message_spend_limit_override/](https://www.paws-r-sdk.com/docs/pinpointsmsvoicev2_delete_text_message_spend_limit_override/) for full documentation.
#'

#'
#' @keywords internal
#'
#' @rdname pinpointsmsvoicev2_delete_text_message_spend_limit_override
pinpointsmsvoicev2_delete_text_message_spend_limit_override <- function() {
  op <- new_operation(
    name = "DeleteTextMessageSpendLimitOverride",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .pinpointsmsvoicev2$delete_text_message_spend_limit_override_input()
  output <- .pinpointsmsvoicev2$delete_text_message_spend_limit_override_output()
  config <- get_config()
  svc <- .pinpointsmsvoicev2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpointsmsvoicev2$operations$delete_text_message_spend_limit_override <- pinpointsmsvoicev2_delete_text_message_spend_limit_override

#' Delete a verified destination phone number
#'
#' @description
#' Delete a verified destination phone number.
#'
#' See [https://www.paws-r-sdk.com/docs/pinpointsmsvoicev2_delete_verified_destination_number/](https://www.paws-r-sdk.com/docs/pinpointsmsvoicev2_delete_verified_destination_number/) for full documentation.
#'
#' @param VerifiedDestinationNumberId &#91;required&#93; The unique identifier for the verified destination phone number.
#'
#' @keywords internal
#'
#' @rdname pinpointsmsvoicev2_delete_verified_destination_number
pinpointsmsvoicev2_delete_verified_destination_number <- function(VerifiedDestinationNumberId) {
  op <- new_operation(
    name = "DeleteVerifiedDestinationNumber",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .pinpointsmsvoicev2$delete_verified_destination_number_input(VerifiedDestinationNumberId = VerifiedDestinationNumberId)
  output <- .pinpointsmsvoicev2$delete_verified_destination_number_output()
  config <- get_config()
  svc <- .pinpointsmsvoicev2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpointsmsvoicev2$operations$delete_verified_destination_number <- pinpointsmsvoicev2_delete_verified_destination_number

#' Deletes an account level monthly spend limit override for sending voice
#' messages
#'
#' @description
#' Deletes an account level monthly spend limit override for sending voice messages. Deleting a spend limit override sets the `EnforcedLimit` equal to the `MaxLimit`, which is controlled by Amazon Web Services. For more information on spending limits (quotas) see [Quotas](https://docs.aws.amazon.com/sms-voice/latest/userguide/quotas.html) in the *AWS End User Messaging SMS User Guide*.
#'
#' See [https://www.paws-r-sdk.com/docs/pinpointsmsvoicev2_delete_voice_message_spend_limit_override/](https://www.paws-r-sdk.com/docs/pinpointsmsvoicev2_delete_voice_message_spend_limit_override/) for full documentation.
#'

#'
#' @keywords internal
#'
#' @rdname pinpointsmsvoicev2_delete_voice_message_spend_limit_override
pinpointsmsvoicev2_delete_voice_message_spend_limit_override <- function() {
  op <- new_operation(
    name = "DeleteVoiceMessageSpendLimitOverride",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .pinpointsmsvoicev2$delete_voice_message_spend_limit_override_input()
  output <- .pinpointsmsvoicev2$delete_voice_message_spend_limit_override_output()
  config <- get_config()
  svc <- .pinpointsmsvoicev2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpointsmsvoicev2$operations$delete_voice_message_spend_limit_override <- pinpointsmsvoicev2_delete_voice_message_spend_limit_override

#' Describes attributes of your Amazon Web Services account
#'
#' @description
#' Describes attributes of your Amazon Web Services account. The supported account attributes include account tier, which indicates whether your account is in the sandbox or production environment. When you're ready to move your account out of the sandbox, create an Amazon Web Services Support case for a service limit increase request.
#'
#' See [https://www.paws-r-sdk.com/docs/pinpointsmsvoicev2_describe_account_attributes/](https://www.paws-r-sdk.com/docs/pinpointsmsvoicev2_describe_account_attributes/) for full documentation.
#'
#' @param NextToken The token to be used for the next set of paginated results. You don't
#' need to supply a value for this field in the initial request.
#' @param MaxResults The maximum number of results to return per each request.
#'
#' @keywords internal
#'
#' @rdname pinpointsmsvoicev2_describe_account_attributes
pinpointsmsvoicev2_describe_account_attributes <- function(NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "DescribeAccountAttributes",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults", result_key = "AccountAttributes")
  )
  input <- .pinpointsmsvoicev2$describe_account_attributes_input(NextToken = NextToken, MaxResults = MaxResults)
  output <- .pinpointsmsvoicev2$describe_account_attributes_output()
  config <- get_config()
  svc <- .pinpointsmsvoicev2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpointsmsvoicev2$operations$describe_account_attributes <- pinpointsmsvoicev2_describe_account_attributes

#' Describes the current AWS End User Messaging SMS and Voice SMS Voice V2
#' resource quotas for your account
#'
#' @description
#' Describes the current AWS End User Messaging SMS and Voice SMS Voice V2 resource quotas for your account. The description for a quota includes the quota name, current usage toward that quota, and the quota's maximum value.
#'
#' See [https://www.paws-r-sdk.com/docs/pinpointsmsvoicev2_describe_account_limits/](https://www.paws-r-sdk.com/docs/pinpointsmsvoicev2_describe_account_limits/) for full documentation.
#'
#' @param NextToken The token to be used for the next set of paginated results. You don't
#' need to supply a value for this field in the initial request.
#' @param MaxResults The maximum number of results to return per each request.
#'
#' @keywords internal
#'
#' @rdname pinpointsmsvoicev2_describe_account_limits
pinpointsmsvoicev2_describe_account_limits <- function(NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "DescribeAccountLimits",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults", result_key = "AccountLimits")
  )
  input <- .pinpointsmsvoicev2$describe_account_limits_input(NextToken = NextToken, MaxResults = MaxResults)
  output <- .pinpointsmsvoicev2$describe_account_limits_output()
  config <- get_config()
  svc <- .pinpointsmsvoicev2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpointsmsvoicev2$operations$describe_account_limits <- pinpointsmsvoicev2_describe_account_limits

#' Describes the specified configuration sets or all in your account
#'
#' @description
#' Describes the specified configuration sets or all in your account.
#'
#' See [https://www.paws-r-sdk.com/docs/pinpointsmsvoicev2_describe_configuration_sets/](https://www.paws-r-sdk.com/docs/pinpointsmsvoicev2_describe_configuration_sets/) for full documentation.
#'
#' @param ConfigurationSetNames An array of strings. Each element can be either a ConfigurationSetName
#' or ConfigurationSetArn.
#' @param Filters An array of filters to apply to the results that are returned.
#' @param NextToken The token to be used for the next set of paginated results. You don't
#' need to supply a value for this field in the initial request.
#' @param MaxResults The maximum number of results to return per each request.
#'
#' @keywords internal
#'
#' @rdname pinpointsmsvoicev2_describe_configuration_sets
pinpointsmsvoicev2_describe_configuration_sets <- function(ConfigurationSetNames = NULL, Filters = NULL, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "DescribeConfigurationSets",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults", result_key = "ConfigurationSets")
  )
  input <- .pinpointsmsvoicev2$describe_configuration_sets_input(ConfigurationSetNames = ConfigurationSetNames, Filters = Filters, NextToken = NextToken, MaxResults = MaxResults)
  output <- .pinpointsmsvoicev2$describe_configuration_sets_output()
  config <- get_config()
  svc <- .pinpointsmsvoicev2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpointsmsvoicev2$operations$describe_configuration_sets <- pinpointsmsvoicev2_describe_configuration_sets

#' Describes the specified keywords or all keywords on your origination
#' phone number or pool
#'
#' @description
#' Describes the specified keywords or all keywords on your origination phone number or pool.
#'
#' See [https://www.paws-r-sdk.com/docs/pinpointsmsvoicev2_describe_keywords/](https://www.paws-r-sdk.com/docs/pinpointsmsvoicev2_describe_keywords/) for full documentation.
#'
#' @param OriginationIdentity &#91;required&#93; The origination identity to use such as a PhoneNumberId, PhoneNumberArn,
#' SenderId or SenderIdArn. You can use
#' [`describe_phone_numbers`][pinpointsmsvoicev2_describe_phone_numbers] to
#' find the values for PhoneNumberId and PhoneNumberArn while
#' [`describe_sender_ids`][pinpointsmsvoicev2_describe_sender_ids] can be
#' used to get the values for SenderId and SenderIdArn.
#' @param Keywords An array of keywords to search for.
#' @param Filters An array of keyword filters to filter the results.
#' @param NextToken The token to be used for the next set of paginated results. You don't
#' need to supply a value for this field in the initial request.
#' @param MaxResults The maximum number of results to return per each request.
#'
#' @keywords internal
#'
#' @rdname pinpointsmsvoicev2_describe_keywords
pinpointsmsvoicev2_describe_keywords <- function(OriginationIdentity, Keywords = NULL, Filters = NULL, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "DescribeKeywords",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults", result_key = "Keywords")
  )
  input <- .pinpointsmsvoicev2$describe_keywords_input(OriginationIdentity = OriginationIdentity, Keywords = Keywords, Filters = Filters, NextToken = NextToken, MaxResults = MaxResults)
  output <- .pinpointsmsvoicev2$describe_keywords_output()
  config <- get_config()
  svc <- .pinpointsmsvoicev2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpointsmsvoicev2$operations$describe_keywords <- pinpointsmsvoicev2_describe_keywords

#' Describes the specified opt-out list or all opt-out lists in your
#' account
#'
#' @description
#' Describes the specified opt-out list or all opt-out lists in your account.
#'
#' See [https://www.paws-r-sdk.com/docs/pinpointsmsvoicev2_describe_opt_out_lists/](https://www.paws-r-sdk.com/docs/pinpointsmsvoicev2_describe_opt_out_lists/) for full documentation.
#'
#' @param OptOutListNames The OptOutLists to show the details of. This is an array of strings that
#' can be either the OptOutListName or OptOutListArn.
#' @param NextToken The token to be used for the next set of paginated results. You don't
#' need to supply a value for this field in the initial request.
#' @param MaxResults The maximum number of results to return per each request.
#'
#' @keywords internal
#'
#' @rdname pinpointsmsvoicev2_describe_opt_out_lists
pinpointsmsvoicev2_describe_opt_out_lists <- function(OptOutListNames = NULL, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "DescribeOptOutLists",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults", result_key = "OptOutLists")
  )
  input <- .pinpointsmsvoicev2$describe_opt_out_lists_input(OptOutListNames = OptOutListNames, NextToken = NextToken, MaxResults = MaxResults)
  output <- .pinpointsmsvoicev2$describe_opt_out_lists_output()
  config <- get_config()
  svc <- .pinpointsmsvoicev2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpointsmsvoicev2$operations$describe_opt_out_lists <- pinpointsmsvoicev2_describe_opt_out_lists

#' Describes the specified opted out destination numbers or all opted out
#' destination numbers in an opt-out list
#'
#' @description
#' Describes the specified opted out destination numbers or all opted out destination numbers in an opt-out list.
#'
#' See [https://www.paws-r-sdk.com/docs/pinpointsmsvoicev2_describe_opted_out_numbers/](https://www.paws-r-sdk.com/docs/pinpointsmsvoicev2_describe_opted_out_numbers/) for full documentation.
#'
#' @param OptOutListName &#91;required&#93; The OptOutListName or OptOutListArn of the OptOutList. You can use
#' [`describe_opt_out_lists`][pinpointsmsvoicev2_describe_opt_out_lists] to
#' find the values for OptOutListName and OptOutListArn.
#' @param OptedOutNumbers An array of phone numbers to search for in the OptOutList.
#' @param Filters An array of OptedOutFilter objects to filter the results on.
#' @param NextToken The token to be used for the next set of paginated results. You don't
#' need to supply a value for this field in the initial request.
#' @param MaxResults The maximum number of results to return per each request.
#'
#' @keywords internal
#'
#' @rdname pinpointsmsvoicev2_describe_opted_out_numbers
pinpointsmsvoicev2_describe_opted_out_numbers <- function(OptOutListName, OptedOutNumbers = NULL, Filters = NULL, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "DescribeOptedOutNumbers",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults", result_key = "OptedOutNumbers")
  )
  input <- .pinpointsmsvoicev2$describe_opted_out_numbers_input(OptOutListName = OptOutListName, OptedOutNumbers = OptedOutNumbers, Filters = Filters, NextToken = NextToken, MaxResults = MaxResults)
  output <- .pinpointsmsvoicev2$describe_opted_out_numbers_output()
  config <- get_config()
  svc <- .pinpointsmsvoicev2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpointsmsvoicev2$operations$describe_opted_out_numbers <- pinpointsmsvoicev2_describe_opted_out_numbers

#' Describes the specified origination phone number, or all the phone
#' numbers in your account
#'
#' @description
#' Describes the specified origination phone number, or all the phone numbers in your account.
#'
#' See [https://www.paws-r-sdk.com/docs/pinpointsmsvoicev2_describe_phone_numbers/](https://www.paws-r-sdk.com/docs/pinpointsmsvoicev2_describe_phone_numbers/) for full documentation.
#'
#' @param PhoneNumberIds The unique identifier of phone numbers to find information about. This
#' is an array of strings that can be either the PhoneNumberId or
#' PhoneNumberArn.
#' @param Filters An array of PhoneNumberFilter objects to filter the results.
#' @param NextToken The token to be used for the next set of paginated results. You don't
#' need to supply a value for this field in the initial request.
#' @param MaxResults The maximum number of results to return per each request.
#'
#' @keywords internal
#'
#' @rdname pinpointsmsvoicev2_describe_phone_numbers
pinpointsmsvoicev2_describe_phone_numbers <- function(PhoneNumberIds = NULL, Filters = NULL, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "DescribePhoneNumbers",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults", result_key = "PhoneNumbers")
  )
  input <- .pinpointsmsvoicev2$describe_phone_numbers_input(PhoneNumberIds = PhoneNumberIds, Filters = Filters, NextToken = NextToken, MaxResults = MaxResults)
  output <- .pinpointsmsvoicev2$describe_phone_numbers_output()
  config <- get_config()
  svc <- .pinpointsmsvoicev2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpointsmsvoicev2$operations$describe_phone_numbers <- pinpointsmsvoicev2_describe_phone_numbers

#' Retrieves the specified pools or all pools associated with your Amazon
#' Web Services account
#'
#' @description
#' Retrieves the specified pools or all pools associated with your Amazon Web Services account.
#'
#' See [https://www.paws-r-sdk.com/docs/pinpointsmsvoicev2_describe_pools/](https://www.paws-r-sdk.com/docs/pinpointsmsvoicev2_describe_pools/) for full documentation.
#'
#' @param PoolIds The unique identifier of pools to find. This is an array of strings that
#' can be either the PoolId or PoolArn.
#' @param Filters An array of PoolFilter objects to filter the results.
#' @param NextToken The token to be used for the next set of paginated results. You don't
#' need to supply a value for this field in the initial request.
#' @param MaxResults The maximum number of results to return per each request.
#'
#' @keywords internal
#'
#' @rdname pinpointsmsvoicev2_describe_pools
pinpointsmsvoicev2_describe_pools <- function(PoolIds = NULL, Filters = NULL, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "DescribePools",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults", result_key = "Pools")
  )
  input <- .pinpointsmsvoicev2$describe_pools_input(PoolIds = PoolIds, Filters = Filters, NextToken = NextToken, MaxResults = MaxResults)
  output <- .pinpointsmsvoicev2$describe_pools_output()
  config <- get_config()
  svc <- .pinpointsmsvoicev2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpointsmsvoicev2$operations$describe_pools <- pinpointsmsvoicev2_describe_pools

#' Retrieves the protect configurations that match any of filters
#'
#' @description
#' Retrieves the protect configurations that match any of filters. If a filter isn’t provided then all protect configurations are returned.
#'
#' See [https://www.paws-r-sdk.com/docs/pinpointsmsvoicev2_describe_protect_configurations/](https://www.paws-r-sdk.com/docs/pinpointsmsvoicev2_describe_protect_configurations/) for full documentation.
#'
#' @param ProtectConfigurationIds An array of protect configuration identifiers to search for.
#' @param Filters An array of ProtectConfigurationFilter objects to filter the results.
#' @param NextToken The token to be used for the next set of paginated results. You don't
#' need to supply a value for this field in the initial request.
#' @param MaxResults The maximum number of results to return per each request.
#'
#' @keywords internal
#'
#' @rdname pinpointsmsvoicev2_describe_protect_configurations
pinpointsmsvoicev2_describe_protect_configurations <- function(ProtectConfigurationIds = NULL, Filters = NULL, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "DescribeProtectConfigurations",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults", result_key = "ProtectConfigurations")
  )
  input <- .pinpointsmsvoicev2$describe_protect_configurations_input(ProtectConfigurationIds = ProtectConfigurationIds, Filters = Filters, NextToken = NextToken, MaxResults = MaxResults)
  output <- .pinpointsmsvoicev2$describe_protect_configurations_output()
  config <- get_config()
  svc <- .pinpointsmsvoicev2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpointsmsvoicev2$operations$describe_protect_configurations <- pinpointsmsvoicev2_describe_protect_configurations

#' Retrieves the specified registration attachments or all registration
#' attachments associated with your Amazon Web Services account
#'
#' @description
#' Retrieves the specified registration attachments or all registration attachments associated with your Amazon Web Services account.
#'
#' See [https://www.paws-r-sdk.com/docs/pinpointsmsvoicev2_describe_registration_attachments/](https://www.paws-r-sdk.com/docs/pinpointsmsvoicev2_describe_registration_attachments/) for full documentation.
#'
#' @param RegistrationAttachmentIds The unique identifier of registration attachments to find. This is an
#' array of **RegistrationAttachmentId**.
#' @param Filters An array of RegistrationAttachmentFilter objects to filter the results.
#' @param NextToken The token to be used for the next set of paginated results. You don't
#' need to supply a value for this field in the initial request.
#' @param MaxResults The maximum number of results to return per each request.
#'
#' @keywords internal
#'
#' @rdname pinpointsmsvoicev2_describe_registration_attachments
pinpointsmsvoicev2_describe_registration_attachments <- function(RegistrationAttachmentIds = NULL, Filters = NULL, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "DescribeRegistrationAttachments",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults", result_key = "RegistrationAttachments")
  )
  input <- .pinpointsmsvoicev2$describe_registration_attachments_input(RegistrationAttachmentIds = RegistrationAttachmentIds, Filters = Filters, NextToken = NextToken, MaxResults = MaxResults)
  output <- .pinpointsmsvoicev2$describe_registration_attachments_output()
  config <- get_config()
  svc <- .pinpointsmsvoicev2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpointsmsvoicev2$operations$describe_registration_attachments <- pinpointsmsvoicev2_describe_registration_attachments

#' Retrieves the specified registration type field definitions
#'
#' @description
#' Retrieves the specified registration type field definitions. You can use DescribeRegistrationFieldDefinitions to view the requirements for creating, filling out, and submitting each registration type.
#'
#' See [https://www.paws-r-sdk.com/docs/pinpointsmsvoicev2_describe_registration_field_definitions/](https://www.paws-r-sdk.com/docs/pinpointsmsvoicev2_describe_registration_field_definitions/) for full documentation.
#'
#' @param RegistrationType &#91;required&#93; The type of registration form. The list of **RegistrationTypes** can be
#' found using the
#' [`describe_registration_type_definitions`][pinpointsmsvoicev2_describe_registration_type_definitions]
#' action.
#' @param SectionPath The path to the section of the registration.
#' @param FieldPaths An array of paths to the registration form field.
#' @param NextToken The token to be used for the next set of paginated results. You don't
#' need to supply a value for this field in the initial request.
#' @param MaxResults The maximum number of results to return per each request.
#'
#' @keywords internal
#'
#' @rdname pinpointsmsvoicev2_describe_registration_field_definitions
pinpointsmsvoicev2_describe_registration_field_definitions <- function(RegistrationType, SectionPath = NULL, FieldPaths = NULL, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "DescribeRegistrationFieldDefinitions",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults", result_key = "RegistrationFieldDefinitions")
  )
  input <- .pinpointsmsvoicev2$describe_registration_field_definitions_input(RegistrationType = RegistrationType, SectionPath = SectionPath, FieldPaths = FieldPaths, NextToken = NextToken, MaxResults = MaxResults)
  output <- .pinpointsmsvoicev2$describe_registration_field_definitions_output()
  config <- get_config()
  svc <- .pinpointsmsvoicev2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpointsmsvoicev2$operations$describe_registration_field_definitions <- pinpointsmsvoicev2_describe_registration_field_definitions

#' Retrieves the specified registration field values
#'
#' @description
#' Retrieves the specified registration field values.
#'
#' See [https://www.paws-r-sdk.com/docs/pinpointsmsvoicev2_describe_registration_field_values/](https://www.paws-r-sdk.com/docs/pinpointsmsvoicev2_describe_registration_field_values/) for full documentation.
#'
#' @param RegistrationId &#91;required&#93; The unique identifier for the registration.
#' @param VersionNumber The version number of the registration.
#' @param SectionPath The path to the section of the registration.
#' @param FieldPaths An array of paths to the registration form field.
#' @param NextToken The token to be used for the next set of paginated results. You don't
#' need to supply a value for this field in the initial request.
#' @param MaxResults The maximum number of results to return per each request.
#'
#' @keywords internal
#'
#' @rdname pinpointsmsvoicev2_describe_registration_field_values
pinpointsmsvoicev2_describe_registration_field_values <- function(RegistrationId, VersionNumber = NULL, SectionPath = NULL, FieldPaths = NULL, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "DescribeRegistrationFieldValues",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults", result_key = "RegistrationFieldValues")
  )
  input <- .pinpointsmsvoicev2$describe_registration_field_values_input(RegistrationId = RegistrationId, VersionNumber = VersionNumber, SectionPath = SectionPath, FieldPaths = FieldPaths, NextToken = NextToken, MaxResults = MaxResults)
  output <- .pinpointsmsvoicev2$describe_registration_field_values_output()
  config <- get_config()
  svc <- .pinpointsmsvoicev2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpointsmsvoicev2$operations$describe_registration_field_values <- pinpointsmsvoicev2_describe_registration_field_values

#' Retrieves the specified registration section definitions
#'
#' @description
#' Retrieves the specified registration section definitions. You can use DescribeRegistrationSectionDefinitions to view the requirements for creating, filling out, and submitting each registration type.
#'
#' See [https://www.paws-r-sdk.com/docs/pinpointsmsvoicev2_describe_registration_section_definitions/](https://www.paws-r-sdk.com/docs/pinpointsmsvoicev2_describe_registration_section_definitions/) for full documentation.
#'
#' @param RegistrationType &#91;required&#93; The type of registration form. The list of **RegistrationTypes** can be
#' found using the
#' [`describe_registration_type_definitions`][pinpointsmsvoicev2_describe_registration_type_definitions]
#' action.
#' @param SectionPaths An array of paths for the registration form section.
#' @param NextToken The token to be used for the next set of paginated results. You don't
#' need to supply a value for this field in the initial request.
#' @param MaxResults The maximum number of results to return per each request.
#'
#' @keywords internal
#'
#' @rdname pinpointsmsvoicev2_describe_registration_section_definitions
pinpointsmsvoicev2_describe_registration_section_definitions <- function(RegistrationType, SectionPaths = NULL, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "DescribeRegistrationSectionDefinitions",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults", result_key = "RegistrationSectionDefinitions")
  )
  input <- .pinpointsmsvoicev2$describe_registration_section_definitions_input(RegistrationType = RegistrationType, SectionPaths = SectionPaths, NextToken = NextToken, MaxResults = MaxResults)
  output <- .pinpointsmsvoicev2$describe_registration_section_definitions_output()
  config <- get_config()
  svc <- .pinpointsmsvoicev2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpointsmsvoicev2$operations$describe_registration_section_definitions <- pinpointsmsvoicev2_describe_registration_section_definitions

#' Retrieves the specified registration type definitions
#'
#' @description
#' Retrieves the specified registration type definitions. You can use DescribeRegistrationTypeDefinitions to view the requirements for creating, filling out, and submitting each registration type.
#'
#' See [https://www.paws-r-sdk.com/docs/pinpointsmsvoicev2_describe_registration_type_definitions/](https://www.paws-r-sdk.com/docs/pinpointsmsvoicev2_describe_registration_type_definitions/) for full documentation.
#'
#' @param RegistrationTypes The type of registration form. The list of **RegistrationTypes** can be
#' found using the
#' [`describe_registration_type_definitions`][pinpointsmsvoicev2_describe_registration_type_definitions]
#' action.
#' @param Filters An array of RegistrationFilter objects to filter the results.
#' @param NextToken The token to be used for the next set of paginated results. You don't
#' need to supply a value for this field in the initial request.
#' @param MaxResults The maximum number of results to return per each request.
#'
#' @keywords internal
#'
#' @rdname pinpointsmsvoicev2_describe_registration_type_definitions
pinpointsmsvoicev2_describe_registration_type_definitions <- function(RegistrationTypes = NULL, Filters = NULL, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "DescribeRegistrationTypeDefinitions",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults", result_key = "RegistrationTypeDefinitions")
  )
  input <- .pinpointsmsvoicev2$describe_registration_type_definitions_input(RegistrationTypes = RegistrationTypes, Filters = Filters, NextToken = NextToken, MaxResults = MaxResults)
  output <- .pinpointsmsvoicev2$describe_registration_type_definitions_output()
  config <- get_config()
  svc <- .pinpointsmsvoicev2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpointsmsvoicev2$operations$describe_registration_type_definitions <- pinpointsmsvoicev2_describe_registration_type_definitions

#' Retrieves the specified registration version
#'
#' @description
#' Retrieves the specified registration version.
#'
#' See [https://www.paws-r-sdk.com/docs/pinpointsmsvoicev2_describe_registration_versions/](https://www.paws-r-sdk.com/docs/pinpointsmsvoicev2_describe_registration_versions/) for full documentation.
#'
#' @param RegistrationId &#91;required&#93; The unique identifier for the registration.
#' @param VersionNumbers An array of registration version numbers.
#' @param Filters An array of RegistrationVersionFilter objects to filter the results.
#' @param NextToken The token to be used for the next set of paginated results. You don't
#' need to supply a value for this field in the initial request.
#' @param MaxResults The maximum number of results to return per each request.
#'
#' @keywords internal
#'
#' @rdname pinpointsmsvoicev2_describe_registration_versions
pinpointsmsvoicev2_describe_registration_versions <- function(RegistrationId, VersionNumbers = NULL, Filters = NULL, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "DescribeRegistrationVersions",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults", result_key = "RegistrationVersions")
  )
  input <- .pinpointsmsvoicev2$describe_registration_versions_input(RegistrationId = RegistrationId, VersionNumbers = VersionNumbers, Filters = Filters, NextToken = NextToken, MaxResults = MaxResults)
  output <- .pinpointsmsvoicev2$describe_registration_versions_output()
  config <- get_config()
  svc <- .pinpointsmsvoicev2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpointsmsvoicev2$operations$describe_registration_versions <- pinpointsmsvoicev2_describe_registration_versions

#' Retrieves the specified registrations
#'
#' @description
#' Retrieves the specified registrations.
#'
#' See [https://www.paws-r-sdk.com/docs/pinpointsmsvoicev2_describe_registrations/](https://www.paws-r-sdk.com/docs/pinpointsmsvoicev2_describe_registrations/) for full documentation.
#'
#' @param RegistrationIds An array of unique identifiers for each registration.
#' @param Filters An array of RegistrationFilter objects to filter the results.
#' @param NextToken The token to be used for the next set of paginated results. You don't
#' need to supply a value for this field in the initial request.
#' @param MaxResults The maximum number of results to return per each request.
#'
#' @keywords internal
#'
#' @rdname pinpointsmsvoicev2_describe_registrations
pinpointsmsvoicev2_describe_registrations <- function(RegistrationIds = NULL, Filters = NULL, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "DescribeRegistrations",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults", result_key = "Registrations")
  )
  input <- .pinpointsmsvoicev2$describe_registrations_input(RegistrationIds = RegistrationIds, Filters = Filters, NextToken = NextToken, MaxResults = MaxResults)
  output <- .pinpointsmsvoicev2$describe_registrations_output()
  config <- get_config()
  svc <- .pinpointsmsvoicev2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpointsmsvoicev2$operations$describe_registrations <- pinpointsmsvoicev2_describe_registrations

#' Describes the specified SenderIds or all SenderIds associated with your
#' Amazon Web Services account
#'
#' @description
#' Describes the specified SenderIds or all SenderIds associated with your Amazon Web Services account.
#'
#' See [https://www.paws-r-sdk.com/docs/pinpointsmsvoicev2_describe_sender_ids/](https://www.paws-r-sdk.com/docs/pinpointsmsvoicev2_describe_sender_ids/) for full documentation.
#'
#' @param SenderIds An array of SenderIdAndCountry objects to search for.
#' @param Filters An array of SenderIdFilter objects to filter the results.
#' @param NextToken The token to be used for the next set of paginated results. You don't
#' need to supply a value for this field in the initial request.
#' @param MaxResults The maximum number of results to return per each request.
#'
#' @keywords internal
#'
#' @rdname pinpointsmsvoicev2_describe_sender_ids
pinpointsmsvoicev2_describe_sender_ids <- function(SenderIds = NULL, Filters = NULL, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "DescribeSenderIds",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults", result_key = "SenderIds")
  )
  input <- .pinpointsmsvoicev2$describe_sender_ids_input(SenderIds = SenderIds, Filters = Filters, NextToken = NextToken, MaxResults = MaxResults)
  output <- .pinpointsmsvoicev2$describe_sender_ids_output()
  config <- get_config()
  svc <- .pinpointsmsvoicev2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpointsmsvoicev2$operations$describe_sender_ids <- pinpointsmsvoicev2_describe_sender_ids

#' Describes the current monthly spend limits for sending voice and text
#' messages
#'
#' @description
#' Describes the current monthly spend limits for sending voice and text messages.
#'
#' See [https://www.paws-r-sdk.com/docs/pinpointsmsvoicev2_describe_spend_limits/](https://www.paws-r-sdk.com/docs/pinpointsmsvoicev2_describe_spend_limits/) for full documentation.
#'
#' @param NextToken The token to be used for the next set of paginated results. You don't
#' need to supply a value for this field in the initial request.
#' @param MaxResults The maximum number of results to return per each request.
#'
#' @keywords internal
#'
#' @rdname pinpointsmsvoicev2_describe_spend_limits
pinpointsmsvoicev2_describe_spend_limits <- function(NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "DescribeSpendLimits",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults", result_key = "SpendLimits")
  )
  input <- .pinpointsmsvoicev2$describe_spend_limits_input(NextToken = NextToken, MaxResults = MaxResults)
  output <- .pinpointsmsvoicev2$describe_spend_limits_output()
  config <- get_config()
  svc <- .pinpointsmsvoicev2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpointsmsvoicev2$operations$describe_spend_limits <- pinpointsmsvoicev2_describe_spend_limits

#' Retrieves the specified verified destiona numbers
#'
#' @description
#' Retrieves the specified verified destiona numbers.
#'
#' See [https://www.paws-r-sdk.com/docs/pinpointsmsvoicev2_describe_verified_destination_numbers/](https://www.paws-r-sdk.com/docs/pinpointsmsvoicev2_describe_verified_destination_numbers/) for full documentation.
#'
#' @param VerifiedDestinationNumberIds An array of VerifiedDestinationNumberid to retreive.
#' @param DestinationPhoneNumbers An array of verified destination phone number, in E.164 format.
#' @param Filters An array of VerifiedDestinationNumberFilter objects to filter the
#' results.
#' @param NextToken The token to be used for the next set of paginated results. You don't
#' need to supply a value for this field in the initial request.
#' @param MaxResults The maximum number of results to return per each request.
#'
#' @keywords internal
#'
#' @rdname pinpointsmsvoicev2_describe_verified_destination_numbers
pinpointsmsvoicev2_describe_verified_destination_numbers <- function(VerifiedDestinationNumberIds = NULL, DestinationPhoneNumbers = NULL, Filters = NULL, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "DescribeVerifiedDestinationNumbers",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults", result_key = "VerifiedDestinationNumbers")
  )
  input <- .pinpointsmsvoicev2$describe_verified_destination_numbers_input(VerifiedDestinationNumberIds = VerifiedDestinationNumberIds, DestinationPhoneNumbers = DestinationPhoneNumbers, Filters = Filters, NextToken = NextToken, MaxResults = MaxResults)
  output <- .pinpointsmsvoicev2$describe_verified_destination_numbers_output()
  config <- get_config()
  svc <- .pinpointsmsvoicev2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpointsmsvoicev2$operations$describe_verified_destination_numbers <- pinpointsmsvoicev2_describe_verified_destination_numbers

#' Removes the specified origination identity from an existing pool
#'
#' @description
#' Removes the specified origination identity from an existing pool.
#'
#' See [https://www.paws-r-sdk.com/docs/pinpointsmsvoicev2_disassociate_origination_identity/](https://www.paws-r-sdk.com/docs/pinpointsmsvoicev2_disassociate_origination_identity/) for full documentation.
#'
#' @param PoolId &#91;required&#93; The unique identifier for the pool to disassociate with the origination
#' identity. This value can be either the PoolId or PoolArn.
#' @param OriginationIdentity &#91;required&#93; The origination identity to use such as a PhoneNumberId, PhoneNumberArn,
#' SenderId or SenderIdArn. You can use
#' [`describe_phone_numbers`][pinpointsmsvoicev2_describe_phone_numbers]
#' find the values for PhoneNumberId and PhoneNumberArn, or use
#' [`describe_sender_ids`][pinpointsmsvoicev2_describe_sender_ids] to get
#' the values for SenderId and SenderIdArn.
#' @param IsoCountryCode &#91;required&#93; The two-character code, in ISO 3166-1 alpha-2 format, for the country or
#' region.
#' @param ClientToken Unique, case-sensitive identifier you provide to ensure the idempotency
#' of the request. If you don't specify a client token, a randomly
#' generated token is used for the request to ensure idempotency.
#'
#' @keywords internal
#'
#' @rdname pinpointsmsvoicev2_disassociate_origination_identity
pinpointsmsvoicev2_disassociate_origination_identity <- function(PoolId, OriginationIdentity, IsoCountryCode, ClientToken = NULL) {
  op <- new_operation(
    name = "DisassociateOriginationIdentity",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .pinpointsmsvoicev2$disassociate_origination_identity_input(PoolId = PoolId, OriginationIdentity = OriginationIdentity, IsoCountryCode = IsoCountryCode, ClientToken = ClientToken)
  output <- .pinpointsmsvoicev2$disassociate_origination_identity_output()
  config <- get_config()
  svc <- .pinpointsmsvoicev2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpointsmsvoicev2$operations$disassociate_origination_identity <- pinpointsmsvoicev2_disassociate_origination_identity

#' Disassociate a protect configuration from a configuration set
#'
#' @description
#' Disassociate a protect configuration from a configuration set.
#'
#' See [https://www.paws-r-sdk.com/docs/pinpointsmsvoicev2_disassociate_protect_configuration/](https://www.paws-r-sdk.com/docs/pinpointsmsvoicev2_disassociate_protect_configuration/) for full documentation.
#'
#' @param ProtectConfigurationId &#91;required&#93; The unique identifier for the protect configuration.
#' @param ConfigurationSetName &#91;required&#93; The name of the ConfigurationSet.
#'
#' @keywords internal
#'
#' @rdname pinpointsmsvoicev2_disassociate_protect_configuration
pinpointsmsvoicev2_disassociate_protect_configuration <- function(ProtectConfigurationId, ConfigurationSetName) {
  op <- new_operation(
    name = "DisassociateProtectConfiguration",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .pinpointsmsvoicev2$disassociate_protect_configuration_input(ProtectConfigurationId = ProtectConfigurationId, ConfigurationSetName = ConfigurationSetName)
  output <- .pinpointsmsvoicev2$disassociate_protect_configuration_output()
  config <- get_config()
  svc <- .pinpointsmsvoicev2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpointsmsvoicev2$operations$disassociate_protect_configuration <- pinpointsmsvoicev2_disassociate_protect_configuration

#' Discard the current version of the registration
#'
#' @description
#' Discard the current version of the registration.
#'
#' See [https://www.paws-r-sdk.com/docs/pinpointsmsvoicev2_discard_registration_version/](https://www.paws-r-sdk.com/docs/pinpointsmsvoicev2_discard_registration_version/) for full documentation.
#'
#' @param RegistrationId &#91;required&#93; The unique identifier for the registration.
#'
#' @keywords internal
#'
#' @rdname pinpointsmsvoicev2_discard_registration_version
pinpointsmsvoicev2_discard_registration_version <- function(RegistrationId) {
  op <- new_operation(
    name = "DiscardRegistrationVersion",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .pinpointsmsvoicev2$discard_registration_version_input(RegistrationId = RegistrationId)
  output <- .pinpointsmsvoicev2$discard_registration_version_output()
  config <- get_config()
  svc <- .pinpointsmsvoicev2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpointsmsvoicev2$operations$discard_registration_version <- pinpointsmsvoicev2_discard_registration_version

#' Retrieve the CountryRuleSet for the specified NumberCapability from a
#' protect configuration
#'
#' @description
#' Retrieve the CountryRuleSet for the specified NumberCapability from a protect configuration.
#'
#' See [https://www.paws-r-sdk.com/docs/pinpointsmsvoicev2_get_protect_configuration_country_rule_set/](https://www.paws-r-sdk.com/docs/pinpointsmsvoicev2_get_protect_configuration_country_rule_set/) for full documentation.
#'
#' @param ProtectConfigurationId &#91;required&#93; The unique identifier for the protect configuration.
#' @param NumberCapability &#91;required&#93; The capability type to return the CountryRuleSet for. Valid values are
#' `SMS`, `VOICE`, or `MMS`.
#'
#' @keywords internal
#'
#' @rdname pinpointsmsvoicev2_get_prote_confi_count_rule_set
pinpointsmsvoicev2_get_protect_configuration_country_rule_set <- function(ProtectConfigurationId, NumberCapability) {
  op <- new_operation(
    name = "GetProtectConfigurationCountryRuleSet",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .pinpointsmsvoicev2$get_protect_configuration_country_rule_set_input(ProtectConfigurationId = ProtectConfigurationId, NumberCapability = NumberCapability)
  output <- .pinpointsmsvoicev2$get_protect_configuration_country_rule_set_output()
  config <- get_config()
  svc <- .pinpointsmsvoicev2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpointsmsvoicev2$operations$get_protect_configuration_country_rule_set <- pinpointsmsvoicev2_get_protect_configuration_country_rule_set

#' Lists all associated origination identities in your pool
#'
#' @description
#' Lists all associated origination identities in your pool.
#'
#' See [https://www.paws-r-sdk.com/docs/pinpointsmsvoicev2_list_pool_origination_identities/](https://www.paws-r-sdk.com/docs/pinpointsmsvoicev2_list_pool_origination_identities/) for full documentation.
#'
#' @param PoolId &#91;required&#93; The unique identifier for the pool. This value can be either the PoolId
#' or PoolArn.
#' @param Filters An array of PoolOriginationIdentitiesFilter objects to filter the
#' results..
#' @param NextToken The token to be used for the next set of paginated results. You don't
#' need to supply a value for this field in the initial request.
#' @param MaxResults The maximum number of results to return per each request.
#'
#' @keywords internal
#'
#' @rdname pinpointsmsvoicev2_list_pool_origination_identities
pinpointsmsvoicev2_list_pool_origination_identities <- function(PoolId, Filters = NULL, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListPoolOriginationIdentities",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults", result_key = "OriginationIdentities")
  )
  input <- .pinpointsmsvoicev2$list_pool_origination_identities_input(PoolId = PoolId, Filters = Filters, NextToken = NextToken, MaxResults = MaxResults)
  output <- .pinpointsmsvoicev2$list_pool_origination_identities_output()
  config <- get_config()
  svc <- .pinpointsmsvoicev2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpointsmsvoicev2$operations$list_pool_origination_identities <- pinpointsmsvoicev2_list_pool_origination_identities

#' Retreive all of the origination identies that are associated with a
#' registration
#'
#' @description
#' Retreive all of the origination identies that are associated with a registration.
#'
#' See [https://www.paws-r-sdk.com/docs/pinpointsmsvoicev2_list_registration_associations/](https://www.paws-r-sdk.com/docs/pinpointsmsvoicev2_list_registration_associations/) for full documentation.
#'
#' @param RegistrationId &#91;required&#93; The unique identifier for the registration.
#' @param Filters An array of RegistrationAssociationFilter to apply to the results that
#' are returned.
#' @param NextToken The token to be used for the next set of paginated results. You don't
#' need to supply a value for this field in the initial request.
#' @param MaxResults The maximum number of results to return per each request.
#'
#' @keywords internal
#'
#' @rdname pinpointsmsvoicev2_list_registration_associations
pinpointsmsvoicev2_list_registration_associations <- function(RegistrationId, Filters = NULL, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListRegistrationAssociations",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults", result_key = "RegistrationAssociations")
  )
  input <- .pinpointsmsvoicev2$list_registration_associations_input(RegistrationId = RegistrationId, Filters = Filters, NextToken = NextToken, MaxResults = MaxResults)
  output <- .pinpointsmsvoicev2$list_registration_associations_output()
  config <- get_config()
  svc <- .pinpointsmsvoicev2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpointsmsvoicev2$operations$list_registration_associations <- pinpointsmsvoicev2_list_registration_associations

#' List all tags associated with a resource
#'
#' @description
#' List all tags associated with a resource.
#'
#' See [https://www.paws-r-sdk.com/docs/pinpointsmsvoicev2_list_tags_for_resource/](https://www.paws-r-sdk.com/docs/pinpointsmsvoicev2_list_tags_for_resource/) for full documentation.
#'
#' @param ResourceArn &#91;required&#93; The Amazon Resource Name (ARN) of the resource to query for.
#'
#' @keywords internal
#'
#' @rdname pinpointsmsvoicev2_list_tags_for_resource
pinpointsmsvoicev2_list_tags_for_resource <- function(ResourceArn) {
  op <- new_operation(
    name = "ListTagsForResource",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .pinpointsmsvoicev2$list_tags_for_resource_input(ResourceArn = ResourceArn)
  output <- .pinpointsmsvoicev2$list_tags_for_resource_output()
  config <- get_config()
  svc <- .pinpointsmsvoicev2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpointsmsvoicev2$operations$list_tags_for_resource <- pinpointsmsvoicev2_list_tags_for_resource

#' Creates or updates a keyword configuration on an origination phone
#' number or pool
#'
#' @description
#' Creates or updates a keyword configuration on an origination phone number or pool.
#'
#' See [https://www.paws-r-sdk.com/docs/pinpointsmsvoicev2_put_keyword/](https://www.paws-r-sdk.com/docs/pinpointsmsvoicev2_put_keyword/) for full documentation.
#'
#' @param OriginationIdentity &#91;required&#93; The origination identity to use such as a PhoneNumberId, PhoneNumberArn,
#' SenderId or SenderIdArn. You can use
#' [`describe_phone_numbers`][pinpointsmsvoicev2_describe_phone_numbers]
#' get the values for PhoneNumberId and PhoneNumberArn while
#' [`describe_sender_ids`][pinpointsmsvoicev2_describe_sender_ids] can be
#' used to get the values for SenderId and SenderIdArn.
#' @param Keyword &#91;required&#93; The new keyword to add.
#' @param KeywordMessage &#91;required&#93; The message associated with the keyword.
#' @param KeywordAction The action to perform for the new keyword when it is received.
#' 
#' -   AUTOMATIC_RESPONSE: A message is sent to the recipient.
#' 
#' -   OPT_OUT: Keeps the recipient from receiving future messages.
#' 
#' -   OPT_IN: The recipient wants to receive future messages.
#'
#' @keywords internal
#'
#' @rdname pinpointsmsvoicev2_put_keyword
pinpointsmsvoicev2_put_keyword <- function(OriginationIdentity, Keyword, KeywordMessage, KeywordAction = NULL) {
  op <- new_operation(
    name = "PutKeyword",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .pinpointsmsvoicev2$put_keyword_input(OriginationIdentity = OriginationIdentity, Keyword = Keyword, KeywordMessage = KeywordMessage, KeywordAction = KeywordAction)
  output <- .pinpointsmsvoicev2$put_keyword_output()
  config <- get_config()
  svc <- .pinpointsmsvoicev2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpointsmsvoicev2$operations$put_keyword <- pinpointsmsvoicev2_put_keyword

#' Creates an opted out destination phone number in the opt-out list
#'
#' @description
#' Creates an opted out destination phone number in the opt-out list.
#'
#' See [https://www.paws-r-sdk.com/docs/pinpointsmsvoicev2_put_opted_out_number/](https://www.paws-r-sdk.com/docs/pinpointsmsvoicev2_put_opted_out_number/) for full documentation.
#'
#' @param OptOutListName &#91;required&#93; The OptOutListName or OptOutListArn to add the phone number to.
#' @param OptedOutNumber &#91;required&#93; The phone number to add to the OptOutList in E.164 format.
#'
#' @keywords internal
#'
#' @rdname pinpointsmsvoicev2_put_opted_out_number
pinpointsmsvoicev2_put_opted_out_number <- function(OptOutListName, OptedOutNumber) {
  op <- new_operation(
    name = "PutOptedOutNumber",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .pinpointsmsvoicev2$put_opted_out_number_input(OptOutListName = OptOutListName, OptedOutNumber = OptedOutNumber)
  output <- .pinpointsmsvoicev2$put_opted_out_number_output()
  config <- get_config()
  svc <- .pinpointsmsvoicev2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpointsmsvoicev2$operations$put_opted_out_number <- pinpointsmsvoicev2_put_opted_out_number

#' Creates or updates a field value for a registration
#'
#' @description
#' Creates or updates a field value for a registration.
#'
#' See [https://www.paws-r-sdk.com/docs/pinpointsmsvoicev2_put_registration_field_value/](https://www.paws-r-sdk.com/docs/pinpointsmsvoicev2_put_registration_field_value/) for full documentation.
#'
#' @param RegistrationId &#91;required&#93; The unique identifier for the registration.
#' @param FieldPath &#91;required&#93; The path to the registration form field. You can use
#' [`describe_registration_field_definitions`][pinpointsmsvoicev2_describe_registration_field_definitions]
#' for a list of **FieldPaths**.
#' @param SelectChoices An array of values for the form field.
#' @param TextValue The text data for a free form field.
#' @param RegistrationAttachmentId The unique identifier for the registration attachment.
#'
#' @keywords internal
#'
#' @rdname pinpointsmsvoicev2_put_registration_field_value
pinpointsmsvoicev2_put_registration_field_value <- function(RegistrationId, FieldPath, SelectChoices = NULL, TextValue = NULL, RegistrationAttachmentId = NULL) {
  op <- new_operation(
    name = "PutRegistrationFieldValue",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .pinpointsmsvoicev2$put_registration_field_value_input(RegistrationId = RegistrationId, FieldPath = FieldPath, SelectChoices = SelectChoices, TextValue = TextValue, RegistrationAttachmentId = RegistrationAttachmentId)
  output <- .pinpointsmsvoicev2$put_registration_field_value_output()
  config <- get_config()
  svc <- .pinpointsmsvoicev2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpointsmsvoicev2$operations$put_registration_field_value <- pinpointsmsvoicev2_put_registration_field_value

#' Releases an existing origination phone number in your account
#'
#' @description
#' Releases an existing origination phone number in your account. Once released, a phone number is no longer available for sending messages.
#'
#' See [https://www.paws-r-sdk.com/docs/pinpointsmsvoicev2_release_phone_number/](https://www.paws-r-sdk.com/docs/pinpointsmsvoicev2_release_phone_number/) for full documentation.
#'
#' @param PhoneNumberId &#91;required&#93; The PhoneNumberId or PhoneNumberArn of the phone number to release. You
#' can use
#' [`describe_phone_numbers`][pinpointsmsvoicev2_describe_phone_numbers] to
#' get the values for PhoneNumberId and PhoneNumberArn.
#'
#' @keywords internal
#'
#' @rdname pinpointsmsvoicev2_release_phone_number
pinpointsmsvoicev2_release_phone_number <- function(PhoneNumberId) {
  op <- new_operation(
    name = "ReleasePhoneNumber",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .pinpointsmsvoicev2$release_phone_number_input(PhoneNumberId = PhoneNumberId)
  output <- .pinpointsmsvoicev2$release_phone_number_output()
  config <- get_config()
  svc <- .pinpointsmsvoicev2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpointsmsvoicev2$operations$release_phone_number <- pinpointsmsvoicev2_release_phone_number

#' Releases an existing sender ID in your account
#'
#' @description
#' Releases an existing sender ID in your account.
#'
#' See [https://www.paws-r-sdk.com/docs/pinpointsmsvoicev2_release_sender_id/](https://www.paws-r-sdk.com/docs/pinpointsmsvoicev2_release_sender_id/) for full documentation.
#'
#' @param SenderId &#91;required&#93; The sender ID to release.
#' @param IsoCountryCode &#91;required&#93; The two-character code, in ISO 3166-1 alpha-2 format, for the country or
#' region.
#'
#' @keywords internal
#'
#' @rdname pinpointsmsvoicev2_release_sender_id
pinpointsmsvoicev2_release_sender_id <- function(SenderId, IsoCountryCode) {
  op <- new_operation(
    name = "ReleaseSenderId",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .pinpointsmsvoicev2$release_sender_id_input(SenderId = SenderId, IsoCountryCode = IsoCountryCode)
  output <- .pinpointsmsvoicev2$release_sender_id_output()
  config <- get_config()
  svc <- .pinpointsmsvoicev2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpointsmsvoicev2$operations$release_sender_id <- pinpointsmsvoicev2_release_sender_id

#' Request an origination phone number for use in your account
#'
#' @description
#' Request an origination phone number for use in your account. For more information on phone number request see [Request a phone number](https://docs.aws.amazon.com/sms-voice/latest/userguide/phone-numbers-request.html) in the *AWS End User Messaging SMS User Guide*.
#'
#' See [https://www.paws-r-sdk.com/docs/pinpointsmsvoicev2_request_phone_number/](https://www.paws-r-sdk.com/docs/pinpointsmsvoicev2_request_phone_number/) for full documentation.
#'
#' @param IsoCountryCode &#91;required&#93; The two-character code, in ISO 3166-1 alpha-2 format, for the country or
#' region.
#' @param MessageType &#91;required&#93; The type of message. Valid values are TRANSACTIONAL for messages that
#' are critical or time-sensitive and PROMOTIONAL for messages that aren't
#' critical or time-sensitive.
#' @param NumberCapabilities &#91;required&#93; Indicates if the phone number will be used for text messages, voice
#' messages, or both.
#' @param NumberType &#91;required&#93; The type of phone number to request.
#' @param OptOutListName The name of the OptOutList to associate with the phone number. You can
#' use the OptOutListName or OptOutListArn.
#' @param PoolId The pool to associated with the phone number. You can use the PoolId or
#' PoolArn.
#' @param RegistrationId Use this field to attach your phone number for an external registration
#' process.
#' @param DeletionProtectionEnabled By default this is set to false. When set to true the phone number can't
#' be deleted.
#' @param Tags An array of tags (key and value pairs) associate with the requested
#' phone number.
#' @param ClientToken Unique, case-sensitive identifier that you provide to ensure the
#' idempotency of the request. If you don't specify a client token, a
#' randomly generated token is used for the request to ensure idempotency.
#'
#' @keywords internal
#'
#' @rdname pinpointsmsvoicev2_request_phone_number
pinpointsmsvoicev2_request_phone_number <- function(IsoCountryCode, MessageType, NumberCapabilities, NumberType, OptOutListName = NULL, PoolId = NULL, RegistrationId = NULL, DeletionProtectionEnabled = NULL, Tags = NULL, ClientToken = NULL) {
  op <- new_operation(
    name = "RequestPhoneNumber",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .pinpointsmsvoicev2$request_phone_number_input(IsoCountryCode = IsoCountryCode, MessageType = MessageType, NumberCapabilities = NumberCapabilities, NumberType = NumberType, OptOutListName = OptOutListName, PoolId = PoolId, RegistrationId = RegistrationId, DeletionProtectionEnabled = DeletionProtectionEnabled, Tags = Tags, ClientToken = ClientToken)
  output <- .pinpointsmsvoicev2$request_phone_number_output()
  config <- get_config()
  svc <- .pinpointsmsvoicev2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpointsmsvoicev2$operations$request_phone_number <- pinpointsmsvoicev2_request_phone_number

#' Request a new sender ID that doesn't require registration
#'
#' @description
#' Request a new sender ID that doesn't require registration.
#'
#' See [https://www.paws-r-sdk.com/docs/pinpointsmsvoicev2_request_sender_id/](https://www.paws-r-sdk.com/docs/pinpointsmsvoicev2_request_sender_id/) for full documentation.
#'
#' @param SenderId &#91;required&#93; The sender ID string to request.
#' @param IsoCountryCode &#91;required&#93; The two-character code, in ISO 3166-1 alpha-2 format, for the country or
#' region.
#' @param MessageTypes The type of message. Valid values are TRANSACTIONAL for messages that
#' are critical or time-sensitive and PROMOTIONAL for messages that aren't
#' critical or time-sensitive.
#' @param DeletionProtectionEnabled By default this is set to false. When set to true the sender ID can't be
#' deleted.
#' @param Tags An array of tags (key and value pairs) to associate with the sender ID.
#' @param ClientToken Unique, case-sensitive identifier that you provide to ensure the
#' idempotency of the request. If you don't specify a client token, a
#' randomly generated token is used for the request to ensure idempotency.
#'
#' @keywords internal
#'
#' @rdname pinpointsmsvoicev2_request_sender_id
pinpointsmsvoicev2_request_sender_id <- function(SenderId, IsoCountryCode, MessageTypes = NULL, DeletionProtectionEnabled = NULL, Tags = NULL, ClientToken = NULL) {
  op <- new_operation(
    name = "RequestSenderId",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .pinpointsmsvoicev2$request_sender_id_input(SenderId = SenderId, IsoCountryCode = IsoCountryCode, MessageTypes = MessageTypes, DeletionProtectionEnabled = DeletionProtectionEnabled, Tags = Tags, ClientToken = ClientToken)
  output <- .pinpointsmsvoicev2$request_sender_id_output()
  config <- get_config()
  svc <- .pinpointsmsvoicev2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpointsmsvoicev2$operations$request_sender_id <- pinpointsmsvoicev2_request_sender_id

#' Before you can send test messages to a verified destination phone number
#' you need to opt-in the verified destination phone number
#'
#' @description
#' Before you can send test messages to a verified destination phone number you need to opt-in the verified destination phone number. Creates a new text message with a verification code and send it to a verified destination phone number. Once you have the verification code use [`verify_destination_number`][pinpointsmsvoicev2_verify_destination_number] to opt-in the verified destination phone number to receive messages.
#'
#' See [https://www.paws-r-sdk.com/docs/pinpointsmsvoicev2_send_destination_number_verification_code/](https://www.paws-r-sdk.com/docs/pinpointsmsvoicev2_send_destination_number_verification_code/) for full documentation.
#'
#' @param VerifiedDestinationNumberId &#91;required&#93; The unique identifier for the verified destination phone number.
#' @param VerificationChannel &#91;required&#93; Choose to send the verification code as an SMS or voice message.
#' @param LanguageCode Choose the language to use for the message.
#' @param OriginationIdentity The origination identity of the message. This can be either the
#' PhoneNumber, PhoneNumberId, PhoneNumberArn, SenderId, SenderIdArn,
#' PoolId, or PoolArn.
#' @param ConfigurationSetName The name of the configuration set to use. This can be either the
#' ConfigurationSetName or ConfigurationSetArn.
#' @param Context You can specify custom data in this field. If you do, that data is
#' logged to the event destination.
#' @param DestinationCountryParameters This field is used for any country-specific registration requirements.
#' Currently, this setting is only used when you send messages to
#' recipients in India using a sender ID. For more information see [Special
#' requirements for sending SMS messages to recipients in
#' India](https://docs.aws.amazon.com/sms-voice/latest/userguide/registrations-sms-senderid-india.html).
#'
#' @keywords internal
#'
#' @rdname pinpointsmsvoicev2_send_destination_number_verification_code
pinpointsmsvoicev2_send_destination_number_verification_code <- function(VerifiedDestinationNumberId, VerificationChannel, LanguageCode = NULL, OriginationIdentity = NULL, ConfigurationSetName = NULL, Context = NULL, DestinationCountryParameters = NULL) {
  op <- new_operation(
    name = "SendDestinationNumberVerificationCode",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .pinpointsmsvoicev2$send_destination_number_verification_code_input(VerifiedDestinationNumberId = VerifiedDestinationNumberId, VerificationChannel = VerificationChannel, LanguageCode = LanguageCode, OriginationIdentity = OriginationIdentity, ConfigurationSetName = ConfigurationSetName, Context = Context, DestinationCountryParameters = DestinationCountryParameters)
  output <- .pinpointsmsvoicev2$send_destination_number_verification_code_output()
  config <- get_config()
  svc <- .pinpointsmsvoicev2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpointsmsvoicev2$operations$send_destination_number_verification_code <- pinpointsmsvoicev2_send_destination_number_verification_code

#' Creates a new multimedia message (MMS) and sends it to a recipient's
#' phone number
#'
#' @description
#' Creates a new multimedia message (MMS) and sends it to a recipient's phone number.
#'
#' See [https://www.paws-r-sdk.com/docs/pinpointsmsvoicev2_send_media_message/](https://www.paws-r-sdk.com/docs/pinpointsmsvoicev2_send_media_message/) for full documentation.
#'
#' @param DestinationPhoneNumber &#91;required&#93; The destination phone number in E.164 format.
#' @param OriginationIdentity &#91;required&#93; The origination identity of the message. This can be either the
#' PhoneNumber, PhoneNumberId, PhoneNumberArn, SenderId, SenderIdArn,
#' PoolId, or PoolArn.
#' @param MessageBody The text body of the message.
#' @param MediaUrls An array of URLs to each media file to send.
#' 
#' The media files have to be stored in a publicly available S3 bucket.
#' Supported media file formats are listed in [MMS file types, size and
#' character
#' limits](https://docs.aws.amazon.com/sms-voice/latest/userguide/mms-limitations-character.html).
#' For more information on creating an S3 bucket and managing objects, see
#' [Creating a
#' bucket](https://docs.aws.amazon.com/AmazonS3/latest/userguide/create-bucket-overview.html)
#' and [Uploading
#' objects](https://docs.aws.amazon.com/AmazonS3/latest/userguide/upload-objects.html)
#' in the S3 user guide.
#' @param ConfigurationSetName The name of the configuration set to use. This can be either the
#' ConfigurationSetName or ConfigurationSetArn.
#' @param MaxPrice The maximum amount that you want to spend, in US dollars, per each MMS
#' message.
#' @param TimeToLive How long the text message is valid for. By default this is 72 hours.
#' @param Context You can specify custom data in this field. If you do, that data is
#' logged to the event destination.
#' @param DryRun When set to true, the message is checked and validated, but isn't sent
#' to the end recipient.
#' @param ProtectConfigurationId The unique identifier of the protect configuration to use.
#'
#' @keywords internal
#'
#' @rdname pinpointsmsvoicev2_send_media_message
pinpointsmsvoicev2_send_media_message <- function(DestinationPhoneNumber, OriginationIdentity, MessageBody = NULL, MediaUrls = NULL, ConfigurationSetName = NULL, MaxPrice = NULL, TimeToLive = NULL, Context = NULL, DryRun = NULL, ProtectConfigurationId = NULL) {
  op <- new_operation(
    name = "SendMediaMessage",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .pinpointsmsvoicev2$send_media_message_input(DestinationPhoneNumber = DestinationPhoneNumber, OriginationIdentity = OriginationIdentity, MessageBody = MessageBody, MediaUrls = MediaUrls, ConfigurationSetName = ConfigurationSetName, MaxPrice = MaxPrice, TimeToLive = TimeToLive, Context = Context, DryRun = DryRun, ProtectConfigurationId = ProtectConfigurationId)
  output <- .pinpointsmsvoicev2$send_media_message_output()
  config <- get_config()
  svc <- .pinpointsmsvoicev2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpointsmsvoicev2$operations$send_media_message <- pinpointsmsvoicev2_send_media_message

#' Creates a new text message and sends it to a recipient's phone number
#'
#' @description
#' Creates a new text message and sends it to a recipient's phone number. SendTextMessage only sends an SMS message to one recipient each time it is invoked.
#'
#' See [https://www.paws-r-sdk.com/docs/pinpointsmsvoicev2_send_text_message/](https://www.paws-r-sdk.com/docs/pinpointsmsvoicev2_send_text_message/) for full documentation.
#'
#' @param DestinationPhoneNumber &#91;required&#93; The destination phone number in E.164 format.
#' @param OriginationIdentity The origination identity of the message. This can be either the
#' PhoneNumber, PhoneNumberId, PhoneNumberArn, SenderId, SenderIdArn,
#' PoolId, or PoolArn.
#' @param MessageBody The body of the text message.
#' @param MessageType The type of message. Valid values are for messages that are critical or
#' time-sensitive and PROMOTIONAL for messages that aren't critical or
#' time-sensitive.
#' @param Keyword When you register a short code in the US, you must specify a program
#' name. If you don’t have a US short code, omit this attribute.
#' @param ConfigurationSetName The name of the configuration set to use. This can be either the
#' ConfigurationSetName or ConfigurationSetArn.
#' @param MaxPrice The maximum amount that you want to spend, in US dollars, per each text
#' message. If the calculated amount to send the text message is greater
#' than `MaxPrice`, the message is not sent and an error is returned.
#' @param TimeToLive How long the text message is valid for, in seconds. By default this is
#' 72 hours. If the messages isn't handed off before the TTL expires we
#' stop attempting to hand off the message and return `TTL_EXPIRED` event.
#' @param Context You can specify custom data in this field. If you do, that data is
#' logged to the event destination.
#' @param DestinationCountryParameters This field is used for any country-specific registration requirements.
#' Currently, this setting is only used when you send messages to
#' recipients in India using a sender ID. For more information see [Special
#' requirements for sending SMS messages to recipients in
#' India](https://docs.aws.amazon.com/sms-voice/latest/userguide/registrations-sms-senderid-india.html).
#' 
#' -   `IN_ENTITY_ID` The entity ID or Principal Entity (PE) ID that you
#'     received after completing the sender ID registration process.
#' 
#' -   `IN_TEMPLATE_ID` The template ID that you received after completing
#'     the sender ID registration process.
#' 
#'     Make sure that the Template ID that you specify matches your message
#'     template exactly. If your message doesn't match the template that
#'     you provided during the registration process, the mobile carriers
#'     might reject your message.
#' @param DryRun When set to true, the message is checked and validated, but isn't sent
#' to the end recipient. You are not charged for using `DryRun`.
#' 
#' The Message Parts per Second (MPS) limit when using `DryRun` is five. If
#' your origination identity has a lower MPS limit then the lower MPS limit
#' is used. For more information about MPS limits, see [Message Parts per
#' Second (MPS)
#' limits](https://docs.aws.amazon.com/sms-voice/latest/userguide/sms-limitations-mps.html)
#' in the *AWS End User Messaging SMS User Guide*..
#' @param ProtectConfigurationId The unique identifier for the protect configuration.
#'
#' @keywords internal
#'
#' @rdname pinpointsmsvoicev2_send_text_message
pinpointsmsvoicev2_send_text_message <- function(DestinationPhoneNumber, OriginationIdentity = NULL, MessageBody = NULL, MessageType = NULL, Keyword = NULL, ConfigurationSetName = NULL, MaxPrice = NULL, TimeToLive = NULL, Context = NULL, DestinationCountryParameters = NULL, DryRun = NULL, ProtectConfigurationId = NULL) {
  op <- new_operation(
    name = "SendTextMessage",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .pinpointsmsvoicev2$send_text_message_input(DestinationPhoneNumber = DestinationPhoneNumber, OriginationIdentity = OriginationIdentity, MessageBody = MessageBody, MessageType = MessageType, Keyword = Keyword, ConfigurationSetName = ConfigurationSetName, MaxPrice = MaxPrice, TimeToLive = TimeToLive, Context = Context, DestinationCountryParameters = DestinationCountryParameters, DryRun = DryRun, ProtectConfigurationId = ProtectConfigurationId)
  output <- .pinpointsmsvoicev2$send_text_message_output()
  config <- get_config()
  svc <- .pinpointsmsvoicev2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpointsmsvoicev2$operations$send_text_message <- pinpointsmsvoicev2_send_text_message

#' Allows you to send a request that sends a voice message
#'
#' @description
#' Allows you to send a request that sends a voice message. This operation uses [Amazon Polly](https://aws.amazon.com/polly/) to convert a text script into a voice message.
#'
#' See [https://www.paws-r-sdk.com/docs/pinpointsmsvoicev2_send_voice_message/](https://www.paws-r-sdk.com/docs/pinpointsmsvoicev2_send_voice_message/) for full documentation.
#'
#' @param DestinationPhoneNumber &#91;required&#93; The destination phone number in E.164 format.
#' @param OriginationIdentity &#91;required&#93; The origination identity to use for the voice call. This can be the
#' PhoneNumber, PhoneNumberId, PhoneNumberArn, PoolId, or PoolArn.
#' @param MessageBody The text to convert to a voice message.
#' @param MessageBodyTextType Specifies if the MessageBody field contains text or [speech synthesis
#' markup language
#' (SSML)](https://docs.aws.amazon.com/polly/latest/dg/what-is.html).
#' 
#' -   TEXT: This is the default value. When used the maximum character
#'     limit is 3000.
#' 
#' -   SSML: When used the maximum character limit is 6000 including SSML
#'     tagging.
#' @param VoiceId The voice for the [Amazon
#' Polly](https://docs.aws.amazon.com/polly/latest/dg/what-is.html) service
#' to use. By default this is set to "MATTHEW".
#' @param ConfigurationSetName The name of the configuration set to use. This can be either the
#' ConfigurationSetName or ConfigurationSetArn.
#' @param MaxPricePerMinute The maximum amount to spend per voice message, in US dollars.
#' @param TimeToLive How long the voice message is valid for. By default this is 72 hours.
#' @param Context You can specify custom data in this field. If you do, that data is
#' logged to the event destination.
#' @param DryRun When set to true, the message is checked and validated, but isn't sent
#' to the end recipient.
#' @param ProtectConfigurationId The unique identifier for the protect configuration.
#'
#' @keywords internal
#'
#' @rdname pinpointsmsvoicev2_send_voice_message
pinpointsmsvoicev2_send_voice_message <- function(DestinationPhoneNumber, OriginationIdentity, MessageBody = NULL, MessageBodyTextType = NULL, VoiceId = NULL, ConfigurationSetName = NULL, MaxPricePerMinute = NULL, TimeToLive = NULL, Context = NULL, DryRun = NULL, ProtectConfigurationId = NULL) {
  op <- new_operation(
    name = "SendVoiceMessage",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .pinpointsmsvoicev2$send_voice_message_input(DestinationPhoneNumber = DestinationPhoneNumber, OriginationIdentity = OriginationIdentity, MessageBody = MessageBody, MessageBodyTextType = MessageBodyTextType, VoiceId = VoiceId, ConfigurationSetName = ConfigurationSetName, MaxPricePerMinute = MaxPricePerMinute, TimeToLive = TimeToLive, Context = Context, DryRun = DryRun, ProtectConfigurationId = ProtectConfigurationId)
  output <- .pinpointsmsvoicev2$send_voice_message_output()
  config <- get_config()
  svc <- .pinpointsmsvoicev2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpointsmsvoicev2$operations$send_voice_message <- pinpointsmsvoicev2_send_voice_message

#' Set a protect configuration as your account default
#'
#' @description
#' Set a protect configuration as your account default. You can only have one account default protect configuration at a time. The current account default protect configuration is replaced with the provided protect configuration.
#'
#' See [https://www.paws-r-sdk.com/docs/pinpointsmsvoicev2_set_account_default_protect_configuration/](https://www.paws-r-sdk.com/docs/pinpointsmsvoicev2_set_account_default_protect_configuration/) for full documentation.
#'
#' @param ProtectConfigurationId &#91;required&#93; The unique identifier for the protect configuration.
#'
#' @keywords internal
#'
#' @rdname pinpointsmsvoicev2_set_account_default_protect_configuration
pinpointsmsvoicev2_set_account_default_protect_configuration <- function(ProtectConfigurationId) {
  op <- new_operation(
    name = "SetAccountDefaultProtectConfiguration",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .pinpointsmsvoicev2$set_account_default_protect_configuration_input(ProtectConfigurationId = ProtectConfigurationId)
  output <- .pinpointsmsvoicev2$set_account_default_protect_configuration_output()
  config <- get_config()
  svc <- .pinpointsmsvoicev2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpointsmsvoicev2$operations$set_account_default_protect_configuration <- pinpointsmsvoicev2_set_account_default_protect_configuration

#' Sets the default message type on a configuration set
#'
#' @description
#' Sets the default message type on a configuration set.
#'
#' See [https://www.paws-r-sdk.com/docs/pinpointsmsvoicev2_set_default_message_type/](https://www.paws-r-sdk.com/docs/pinpointsmsvoicev2_set_default_message_type/) for full documentation.
#'
#' @param ConfigurationSetName &#91;required&#93; The configuration set to update with a new default message type. This
#' field can be the ConsigurationSetName or ConfigurationSetArn.
#' @param MessageType &#91;required&#93; The type of message. Valid values are TRANSACTIONAL for messages that
#' are critical or time-sensitive and PROMOTIONAL for messages that aren't
#' critical or time-sensitive.
#'
#' @keywords internal
#'
#' @rdname pinpointsmsvoicev2_set_default_message_type
pinpointsmsvoicev2_set_default_message_type <- function(ConfigurationSetName, MessageType) {
  op <- new_operation(
    name = "SetDefaultMessageType",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .pinpointsmsvoicev2$set_default_message_type_input(ConfigurationSetName = ConfigurationSetName, MessageType = MessageType)
  output <- .pinpointsmsvoicev2$set_default_message_type_output()
  config <- get_config()
  svc <- .pinpointsmsvoicev2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpointsmsvoicev2$operations$set_default_message_type <- pinpointsmsvoicev2_set_default_message_type

#' Sets default sender ID on a configuration set
#'
#' @description
#' Sets default sender ID on a configuration set.
#'
#' See [https://www.paws-r-sdk.com/docs/pinpointsmsvoicev2_set_default_sender_id/](https://www.paws-r-sdk.com/docs/pinpointsmsvoicev2_set_default_sender_id/) for full documentation.
#'
#' @param ConfigurationSetName &#91;required&#93; The configuration set to updated with a new default SenderId. This field
#' can be the ConsigurationSetName or ConfigurationSetArn.
#' @param SenderId &#91;required&#93; The current sender ID for the configuration set. When sending a text
#' message to a destination country which supports SenderIds, the default
#' sender ID on the configuration set specified on
#' [`send_text_message`][pinpointsmsvoicev2_send_text_message] will be used
#' if no dedicated origination phone numbers or registered SenderIds are
#' available in your account, instead of a generic sender ID, such as
#' 'NOTICE'.
#'
#' @keywords internal
#'
#' @rdname pinpointsmsvoicev2_set_default_sender_id
pinpointsmsvoicev2_set_default_sender_id <- function(ConfigurationSetName, SenderId) {
  op <- new_operation(
    name = "SetDefaultSenderId",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .pinpointsmsvoicev2$set_default_sender_id_input(ConfigurationSetName = ConfigurationSetName, SenderId = SenderId)
  output <- .pinpointsmsvoicev2$set_default_sender_id_output()
  config <- get_config()
  svc <- .pinpointsmsvoicev2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpointsmsvoicev2$operations$set_default_sender_id <- pinpointsmsvoicev2_set_default_sender_id

#' Sets an account level monthly spend limit override for sending MMS
#' messages
#'
#' @description
#' Sets an account level monthly spend limit override for sending MMS messages. The requested spend limit must be less than or equal to the `MaxLimit`, which is set by Amazon Web Services.
#'
#' See [https://www.paws-r-sdk.com/docs/pinpointsmsvoicev2_set_media_message_spend_limit_override/](https://www.paws-r-sdk.com/docs/pinpointsmsvoicev2_set_media_message_spend_limit_override/) for full documentation.
#'
#' @param MonthlyLimit &#91;required&#93; The new monthly limit to enforce on text messages.
#'
#' @keywords internal
#'
#' @rdname pinpointsmsvoicev2_set_media_message_spend_limit_override
pinpointsmsvoicev2_set_media_message_spend_limit_override <- function(MonthlyLimit) {
  op <- new_operation(
    name = "SetMediaMessageSpendLimitOverride",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .pinpointsmsvoicev2$set_media_message_spend_limit_override_input(MonthlyLimit = MonthlyLimit)
  output <- .pinpointsmsvoicev2$set_media_message_spend_limit_override_output()
  config <- get_config()
  svc <- .pinpointsmsvoicev2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpointsmsvoicev2$operations$set_media_message_spend_limit_override <- pinpointsmsvoicev2_set_media_message_spend_limit_override

#' Sets an account level monthly spend limit override for sending text
#' messages
#'
#' @description
#' Sets an account level monthly spend limit override for sending text messages. The requested spend limit must be less than or equal to the `MaxLimit`, which is set by Amazon Web Services.
#'
#' See [https://www.paws-r-sdk.com/docs/pinpointsmsvoicev2_set_text_message_spend_limit_override/](https://www.paws-r-sdk.com/docs/pinpointsmsvoicev2_set_text_message_spend_limit_override/) for full documentation.
#'
#' @param MonthlyLimit &#91;required&#93; The new monthly limit to enforce on text messages.
#'
#' @keywords internal
#'
#' @rdname pinpointsmsvoicev2_set_text_message_spend_limit_override
pinpointsmsvoicev2_set_text_message_spend_limit_override <- function(MonthlyLimit) {
  op <- new_operation(
    name = "SetTextMessageSpendLimitOverride",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .pinpointsmsvoicev2$set_text_message_spend_limit_override_input(MonthlyLimit = MonthlyLimit)
  output <- .pinpointsmsvoicev2$set_text_message_spend_limit_override_output()
  config <- get_config()
  svc <- .pinpointsmsvoicev2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpointsmsvoicev2$operations$set_text_message_spend_limit_override <- pinpointsmsvoicev2_set_text_message_spend_limit_override

#' Sets an account level monthly spend limit override for sending voice
#' messages
#'
#' @description
#' Sets an account level monthly spend limit override for sending voice messages. The requested spend limit must be less than or equal to the `MaxLimit`, which is set by Amazon Web Services.
#'
#' See [https://www.paws-r-sdk.com/docs/pinpointsmsvoicev2_set_voice_message_spend_limit_override/](https://www.paws-r-sdk.com/docs/pinpointsmsvoicev2_set_voice_message_spend_limit_override/) for full documentation.
#'
#' @param MonthlyLimit &#91;required&#93; The new monthly limit to enforce on voice messages.
#'
#' @keywords internal
#'
#' @rdname pinpointsmsvoicev2_set_voice_message_spend_limit_override
pinpointsmsvoicev2_set_voice_message_spend_limit_override <- function(MonthlyLimit) {
  op <- new_operation(
    name = "SetVoiceMessageSpendLimitOverride",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .pinpointsmsvoicev2$set_voice_message_spend_limit_override_input(MonthlyLimit = MonthlyLimit)
  output <- .pinpointsmsvoicev2$set_voice_message_spend_limit_override_output()
  config <- get_config()
  svc <- .pinpointsmsvoicev2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpointsmsvoicev2$operations$set_voice_message_spend_limit_override <- pinpointsmsvoicev2_set_voice_message_spend_limit_override

#' Submit the specified registration for review and approval
#'
#' @description
#' Submit the specified registration for review and approval.
#'
#' See [https://www.paws-r-sdk.com/docs/pinpointsmsvoicev2_submit_registration_version/](https://www.paws-r-sdk.com/docs/pinpointsmsvoicev2_submit_registration_version/) for full documentation.
#'
#' @param RegistrationId &#91;required&#93; The unique identifier for the registration.
#'
#' @keywords internal
#'
#' @rdname pinpointsmsvoicev2_submit_registration_version
pinpointsmsvoicev2_submit_registration_version <- function(RegistrationId) {
  op <- new_operation(
    name = "SubmitRegistrationVersion",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .pinpointsmsvoicev2$submit_registration_version_input(RegistrationId = RegistrationId)
  output <- .pinpointsmsvoicev2$submit_registration_version_output()
  config <- get_config()
  svc <- .pinpointsmsvoicev2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpointsmsvoicev2$operations$submit_registration_version <- pinpointsmsvoicev2_submit_registration_version

#' Adds or overwrites only the specified tags for the specified resource
#'
#' @description
#' Adds or overwrites only the specified tags for the specified resource. When you specify an existing tag key, the value is overwritten with the new value. Each resource can have a maximum of 50 tags. Each tag consists of a key and an optional value. Tag keys must be unique per resource. For more information about tags, see [Tags](https://docs.aws.amazon.com/sms-voice/latest/userguide/phone-numbers-tags.html) in the *AWS End User Messaging SMS User Guide*.
#'
#' See [https://www.paws-r-sdk.com/docs/pinpointsmsvoicev2_tag_resource/](https://www.paws-r-sdk.com/docs/pinpointsmsvoicev2_tag_resource/) for full documentation.
#'
#' @param ResourceArn &#91;required&#93; The Amazon Resource Name (ARN) of the resource.
#' @param Tags &#91;required&#93; An array of key and value pair tags that are associated with the
#' resource.
#'
#' @keywords internal
#'
#' @rdname pinpointsmsvoicev2_tag_resource
pinpointsmsvoicev2_tag_resource <- function(ResourceArn, Tags) {
  op <- new_operation(
    name = "TagResource",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .pinpointsmsvoicev2$tag_resource_input(ResourceArn = ResourceArn, Tags = Tags)
  output <- .pinpointsmsvoicev2$tag_resource_output()
  config <- get_config()
  svc <- .pinpointsmsvoicev2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpointsmsvoicev2$operations$tag_resource <- pinpointsmsvoicev2_tag_resource

#' Removes the association of the specified tags from a resource
#'
#' @description
#' Removes the association of the specified tags from a resource. For more information on tags see [Tags](https://docs.aws.amazon.com/sms-voice/latest/userguide/phone-numbers-tags.html) in the *AWS End User Messaging SMS User Guide*.
#'
#' See [https://www.paws-r-sdk.com/docs/pinpointsmsvoicev2_untag_resource/](https://www.paws-r-sdk.com/docs/pinpointsmsvoicev2_untag_resource/) for full documentation.
#'
#' @param ResourceArn &#91;required&#93; The Amazon Resource Name (ARN) of the resource.
#' @param TagKeys &#91;required&#93; An array of tag key values to unassociate with the resource.
#'
#' @keywords internal
#'
#' @rdname pinpointsmsvoicev2_untag_resource
pinpointsmsvoicev2_untag_resource <- function(ResourceArn, TagKeys) {
  op <- new_operation(
    name = "UntagResource",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .pinpointsmsvoicev2$untag_resource_input(ResourceArn = ResourceArn, TagKeys = TagKeys)
  output <- .pinpointsmsvoicev2$untag_resource_output()
  config <- get_config()
  svc <- .pinpointsmsvoicev2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpointsmsvoicev2$operations$untag_resource <- pinpointsmsvoicev2_untag_resource

#' Updates an existing event destination in a configuration set
#'
#' @description
#' Updates an existing event destination in a configuration set. You can update the IAM role ARN for CloudWatch Logs and Firehose. You can also enable or disable the event destination.
#'
#' See [https://www.paws-r-sdk.com/docs/pinpointsmsvoicev2_update_event_destination/](https://www.paws-r-sdk.com/docs/pinpointsmsvoicev2_update_event_destination/) for full documentation.
#'
#' @param ConfigurationSetName &#91;required&#93; The configuration set to update with the new event destination. Valid
#' values for this can be the ConfigurationSetName or ConfigurationSetArn.
#' @param EventDestinationName &#91;required&#93; The name to use for the event destination.
#' @param Enabled When set to true logging is enabled.
#' @param MatchingEventTypes An array of event types that determine which events to log.
#' 
#' The `TEXT_SENT` event type is not supported.
#' @param CloudWatchLogsDestination An object that contains information about an event destination that
#' sends data to CloudWatch Logs.
#' @param KinesisFirehoseDestination An object that contains information about an event destination for
#' logging to Firehose.
#' @param SnsDestination An object that contains information about an event destination that
#' sends data to Amazon SNS.
#'
#' @keywords internal
#'
#' @rdname pinpointsmsvoicev2_update_event_destination
pinpointsmsvoicev2_update_event_destination <- function(ConfigurationSetName, EventDestinationName, Enabled = NULL, MatchingEventTypes = NULL, CloudWatchLogsDestination = NULL, KinesisFirehoseDestination = NULL, SnsDestination = NULL) {
  op <- new_operation(
    name = "UpdateEventDestination",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .pinpointsmsvoicev2$update_event_destination_input(ConfigurationSetName = ConfigurationSetName, EventDestinationName = EventDestinationName, Enabled = Enabled, MatchingEventTypes = MatchingEventTypes, CloudWatchLogsDestination = CloudWatchLogsDestination, KinesisFirehoseDestination = KinesisFirehoseDestination, SnsDestination = SnsDestination)
  output <- .pinpointsmsvoicev2$update_event_destination_output()
  config <- get_config()
  svc <- .pinpointsmsvoicev2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpointsmsvoicev2$operations$update_event_destination <- pinpointsmsvoicev2_update_event_destination

#' Updates the configuration of an existing origination phone number
#'
#' @description
#' Updates the configuration of an existing origination phone number. You can update the opt-out list, enable or disable two-way messaging, change the TwoWayChannelArn, enable or disable self-managed opt-outs, and enable or disable deletion protection.
#'
#' See [https://www.paws-r-sdk.com/docs/pinpointsmsvoicev2_update_phone_number/](https://www.paws-r-sdk.com/docs/pinpointsmsvoicev2_update_phone_number/) for full documentation.
#'
#' @param PhoneNumberId &#91;required&#93; The unique identifier of the phone number. Valid values for this field
#' can be either the PhoneNumberId or PhoneNumberArn.
#' @param TwoWayEnabled By default this is set to false. When set to true you can receive
#' incoming text messages from your end recipients.
#' @param TwoWayChannelArn The Amazon Resource Name (ARN) of the two way channel.
#' @param TwoWayChannelRole An optional IAM Role Arn for a service to assume, to be able to post
#' inbound SMS messages.
#' @param SelfManagedOptOutsEnabled By default this is set to false. When an end recipient sends a message
#' that begins with HELP or STOP to one of your dedicated numbers, AWS End
#' User Messaging SMS and Voice automatically replies with a customizable
#' message and adds the end recipient to the OptOutList. When set to true
#' you're responsible for responding to HELP and STOP requests. You're also
#' responsible for tracking and honoring opt-out requests.
#' @param OptOutListName The OptOutList to add the phone number to. Valid values for this field
#' can be either the OutOutListName or OutOutListArn.
#' @param DeletionProtectionEnabled By default this is set to false. When set to true the phone number can't
#' be deleted.
#'
#' @keywords internal
#'
#' @rdname pinpointsmsvoicev2_update_phone_number
pinpointsmsvoicev2_update_phone_number <- function(PhoneNumberId, TwoWayEnabled = NULL, TwoWayChannelArn = NULL, TwoWayChannelRole = NULL, SelfManagedOptOutsEnabled = NULL, OptOutListName = NULL, DeletionProtectionEnabled = NULL) {
  op <- new_operation(
    name = "UpdatePhoneNumber",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .pinpointsmsvoicev2$update_phone_number_input(PhoneNumberId = PhoneNumberId, TwoWayEnabled = TwoWayEnabled, TwoWayChannelArn = TwoWayChannelArn, TwoWayChannelRole = TwoWayChannelRole, SelfManagedOptOutsEnabled = SelfManagedOptOutsEnabled, OptOutListName = OptOutListName, DeletionProtectionEnabled = DeletionProtectionEnabled)
  output <- .pinpointsmsvoicev2$update_phone_number_output()
  config <- get_config()
  svc <- .pinpointsmsvoicev2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpointsmsvoicev2$operations$update_phone_number <- pinpointsmsvoicev2_update_phone_number

#' Updates the configuration of an existing pool
#'
#' @description
#' Updates the configuration of an existing pool. You can update the opt-out list, enable or disable two-way messaging, change the `TwoWayChannelArn`, enable or disable self-managed opt-outs, enable or disable deletion protection, and enable or disable shared routes.
#'
#' See [https://www.paws-r-sdk.com/docs/pinpointsmsvoicev2_update_pool/](https://www.paws-r-sdk.com/docs/pinpointsmsvoicev2_update_pool/) for full documentation.
#'
#' @param PoolId &#91;required&#93; The unique identifier of the pool to update. Valid values are either the
#' PoolId or PoolArn.
#' @param TwoWayEnabled By default this is set to false. When set to true you can receive
#' incoming text messages from your end recipients.
#' @param TwoWayChannelArn The Amazon Resource Name (ARN) of the two way channel.
#' @param TwoWayChannelRole An optional IAM Role Arn for a service to assume, to be able to post
#' inbound SMS messages.
#' @param SelfManagedOptOutsEnabled By default this is set to false. When an end recipient sends a message
#' that begins with HELP or STOP to one of your dedicated numbers, AWS End
#' User Messaging SMS and Voice automatically replies with a customizable
#' message and adds the end recipient to the OptOutList. When set to true
#' you're responsible for responding to HELP and STOP requests. You're also
#' responsible for tracking and honoring opt-out requests.
#' @param OptOutListName The OptOutList to associate with the pool. Valid values are either
#' OptOutListName or OptOutListArn.
#' @param SharedRoutesEnabled Indicates whether shared routes are enabled for the pool.
#' @param DeletionProtectionEnabled When set to true the pool can't be deleted.
#'
#' @keywords internal
#'
#' @rdname pinpointsmsvoicev2_update_pool
pinpointsmsvoicev2_update_pool <- function(PoolId, TwoWayEnabled = NULL, TwoWayChannelArn = NULL, TwoWayChannelRole = NULL, SelfManagedOptOutsEnabled = NULL, OptOutListName = NULL, SharedRoutesEnabled = NULL, DeletionProtectionEnabled = NULL) {
  op <- new_operation(
    name = "UpdatePool",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .pinpointsmsvoicev2$update_pool_input(PoolId = PoolId, TwoWayEnabled = TwoWayEnabled, TwoWayChannelArn = TwoWayChannelArn, TwoWayChannelRole = TwoWayChannelRole, SelfManagedOptOutsEnabled = SelfManagedOptOutsEnabled, OptOutListName = OptOutListName, SharedRoutesEnabled = SharedRoutesEnabled, DeletionProtectionEnabled = DeletionProtectionEnabled)
  output <- .pinpointsmsvoicev2$update_pool_output()
  config <- get_config()
  svc <- .pinpointsmsvoicev2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpointsmsvoicev2$operations$update_pool <- pinpointsmsvoicev2_update_pool

#' Update the setting for an existing protect configuration
#'
#' @description
#' Update the setting for an existing protect configuration.
#'
#' See [https://www.paws-r-sdk.com/docs/pinpointsmsvoicev2_update_protect_configuration/](https://www.paws-r-sdk.com/docs/pinpointsmsvoicev2_update_protect_configuration/) for full documentation.
#'
#' @param ProtectConfigurationId &#91;required&#93; The unique identifier for the protect configuration.
#' @param DeletionProtectionEnabled When set to true deletion protection is enabled. By default this is set
#' to false.
#'
#' @keywords internal
#'
#' @rdname pinpointsmsvoicev2_update_protect_configuration
pinpointsmsvoicev2_update_protect_configuration <- function(ProtectConfigurationId, DeletionProtectionEnabled = NULL) {
  op <- new_operation(
    name = "UpdateProtectConfiguration",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .pinpointsmsvoicev2$update_protect_configuration_input(ProtectConfigurationId = ProtectConfigurationId, DeletionProtectionEnabled = DeletionProtectionEnabled)
  output <- .pinpointsmsvoicev2$update_protect_configuration_output()
  config <- get_config()
  svc <- .pinpointsmsvoicev2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpointsmsvoicev2$operations$update_protect_configuration <- pinpointsmsvoicev2_update_protect_configuration

#' Update a country rule set to ALLOW or BLOCK messages to be sent to the
#' specified destination counties
#'
#' @description
#' Update a country rule set to `ALLOW` or `BLOCK` messages to be sent to the specified destination counties. You can update one or multiple countries at a time. The updates are only applied to the specified NumberCapability type.
#'
#' See [https://www.paws-r-sdk.com/docs/pinpointsmsvoicev2_update_protect_configuration_country_rule_set/](https://www.paws-r-sdk.com/docs/pinpointsmsvoicev2_update_protect_configuration_country_rule_set/) for full documentation.
#'
#' @param ProtectConfigurationId &#91;required&#93; The unique identifier for the protect configuration.
#' @param NumberCapability &#91;required&#93; The number capability to apply the CountryRuleSetUpdates updates to.
#' @param CountryRuleSetUpdates &#91;required&#93; A map of ProtectConfigurationCountryRuleSetInformation objects that
#' contain the details for the requested NumberCapability. The Key is the
#' two-letter ISO country code. For a list of supported ISO country codes,
#' see [Supported countries and regions (SMS
#' channel)](https://docs.aws.amazon.com/sms-voice/latest/userguide/phone-numbers-sms-by-country.html)
#' in the AWS End User Messaging SMS User Guide.
#'
#' @keywords internal
#'
#' @rdname pinpointsmsvoicev2_updat_prote_confi_count_rule_set
pinpointsmsvoicev2_update_protect_configuration_country_rule_set <- function(ProtectConfigurationId, NumberCapability, CountryRuleSetUpdates) {
  op <- new_operation(
    name = "UpdateProtectConfigurationCountryRuleSet",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .pinpointsmsvoicev2$update_protect_configuration_country_rule_set_input(ProtectConfigurationId = ProtectConfigurationId, NumberCapability = NumberCapability, CountryRuleSetUpdates = CountryRuleSetUpdates)
  output <- .pinpointsmsvoicev2$update_protect_configuration_country_rule_set_output()
  config <- get_config()
  svc <- .pinpointsmsvoicev2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpointsmsvoicev2$operations$update_protect_configuration_country_rule_set <- pinpointsmsvoicev2_update_protect_configuration_country_rule_set

#' Updates the configuration of an existing sender ID
#'
#' @description
#' Updates the configuration of an existing sender ID.
#'
#' See [https://www.paws-r-sdk.com/docs/pinpointsmsvoicev2_update_sender_id/](https://www.paws-r-sdk.com/docs/pinpointsmsvoicev2_update_sender_id/) for full documentation.
#'
#' @param SenderId &#91;required&#93; The sender ID to update.
#' @param IsoCountryCode &#91;required&#93; The two-character code, in ISO 3166-1 alpha-2 format, for the country or
#' region.
#' @param DeletionProtectionEnabled By default this is set to false. When set to true the sender ID can't be
#' deleted.
#'
#' @keywords internal
#'
#' @rdname pinpointsmsvoicev2_update_sender_id
pinpointsmsvoicev2_update_sender_id <- function(SenderId, IsoCountryCode, DeletionProtectionEnabled = NULL) {
  op <- new_operation(
    name = "UpdateSenderId",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .pinpointsmsvoicev2$update_sender_id_input(SenderId = SenderId, IsoCountryCode = IsoCountryCode, DeletionProtectionEnabled = DeletionProtectionEnabled)
  output <- .pinpointsmsvoicev2$update_sender_id_output()
  config <- get_config()
  svc <- .pinpointsmsvoicev2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpointsmsvoicev2$operations$update_sender_id <- pinpointsmsvoicev2_update_sender_id

#' Use the verification code that was received by the verified destination
#' phone number to opt-in the verified destination phone number to receive
#' more messages
#'
#' @description
#' Use the verification code that was received by the verified destination phone number to opt-in the verified destination phone number to receive more messages.
#'
#' See [https://www.paws-r-sdk.com/docs/pinpointsmsvoicev2_verify_destination_number/](https://www.paws-r-sdk.com/docs/pinpointsmsvoicev2_verify_destination_number/) for full documentation.
#'
#' @param VerifiedDestinationNumberId &#91;required&#93; The unique identifier for the verififed destination phone number.
#' @param VerificationCode &#91;required&#93; The verification code that was received by the verified destination
#' phone number.
#'
#' @keywords internal
#'
#' @rdname pinpointsmsvoicev2_verify_destination_number
pinpointsmsvoicev2_verify_destination_number <- function(VerifiedDestinationNumberId, VerificationCode) {
  op <- new_operation(
    name = "VerifyDestinationNumber",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .pinpointsmsvoicev2$verify_destination_number_input(VerifiedDestinationNumberId = VerifiedDestinationNumberId, VerificationCode = VerificationCode)
  output <- .pinpointsmsvoicev2$verify_destination_number_output()
  config <- get_config()
  svc <- .pinpointsmsvoicev2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpointsmsvoicev2$operations$verify_destination_number <- pinpointsmsvoicev2_verify_destination_number
