% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/customerprofiles_operations.R
\name{customerprofiles_update_domain}
\alias{customerprofiles_update_domain}
\title{Updates the properties of a domain, including creating or selecting a
dead letter queue or an encryption key}
\usage{
customerprofiles_update_domain(
  DomainName,
  DefaultExpirationDays = NULL,
  DefaultEncryptionKey = NULL,
  DeadLetterQueueUrl = NULL,
  Matching = NULL,
  Tags = NULL
)
}
\arguments{
\item{DomainName}{[required] The unique name of the domain.}

\item{DefaultExpirationDays}{The default number of days until the data within the domain expires.}

\item{DefaultEncryptionKey}{The default encryption key, which is an AWS managed key, is used when no
specific type of encryption key is specified. It is used to encrypt all
data before it is placed in permanent or semi-permanent storage. If
specified as an empty string, it will clear any existing value.}

\item{DeadLetterQueueUrl}{The URL of the SQS dead letter queue, which is used for reporting errors
associated with ingesting data from third party applications. If
specified as an empty string, it will clear any existing value. You must
set up a policy on the DeadLetterQueue for the SendMessage operation to
enable Amazon Connect Customer Profiles to send messages to the
DeadLetterQueue.}

\item{Matching}{The process of matching duplicate profiles. If \code{Matching} = \code{true},
Amazon Connect Customer Profiles starts a weekly batch process called
Identity Resolution Job. If you do not specify a date and time for
Identity Resolution Job to run, by default it runs every Saturday at
12AM UTC to detect duplicate profiles in your domains.

After the Identity Resolution Job completes, use the
\code{\link[=customerprofiles_get_matches]{get_matches}} API to return and review
the results. Or, if you have configured \code{ExportingConfig} in the
\code{MatchingRequest}, you can download the results from S3.}

\item{Tags}{The tags used to organize, track, or control access for this resource.}
}
\description{
Updates the properties of a domain, including creating or selecting a dead letter queue or an encryption key.

See \url{https://paws-r.github.io/docs/customerprofiles/update_domain.html} for full documentation.
}
\keyword{internal}
