% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/connect_operations.R
\name{connect_update_user_identity_info}
\alias{connect_update_user_identity_info}
\title{Updates the identity information for the specified user in a
UserIdentityInfo object, including email, first name, and last name}
\usage{
connect_update_user_identity_info(IdentityInfo, UserId, InstanceId)
}
\arguments{
\item{IdentityInfo}{[required] A \code{UserIdentityInfo} object.}

\item{UserId}{[required] The identifier for the user account to update identity information for.}

\item{InstanceId}{[required] The identifier for your Amazon Connect instance. To find the ID of your
instance, open the AWS console and select Amazon Connect. Select the
alias of the instance in the Instance alias column. The instance ID is
displayed in the Overview section of your instance settings. For
example, the instance ID is the set of characters at the end of the
instance ARN, after instance/, such as
10a4c4eb-f57e-4d4c-b602-bf39176ced07.}
}
\description{
Updates the identity information for the specified user in a
\code{UserIdentityInfo} object, including email, first name, and last name.
}
\section{Request syntax}{
\preformatted{svc$update_user_identity_info(
  IdentityInfo = list(
    FirstName = "string",
    LastName = "string",
    Email = "string"
  ),
  UserId = "string",
  InstanceId = "string"
)
}
}

\keyword{internal}
