% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/connect_operations.R
\name{connect_list_routing_profile_queues}
\alias{connect_list_routing_profile_queues}
\title{List the queues associated with a routing profile}
\usage{
connect_list_routing_profile_queues(InstanceId, RoutingProfileId,
  NextToken, MaxResults)
}
\arguments{
\item{InstanceId}{[required] The identifier of the Amazon Connect instance.}

\item{RoutingProfileId}{[required] The identifier of the routing profile.}

\item{NextToken}{The token for the next set of results. Use the value returned in the
previous response in the next request to retrieve the next set of
results.}

\item{MaxResults}{The maximimum number of results to return per page.}
}
\value{
A list with the following syntax:\preformatted{list(
  NextToken = "string",
  RoutingProfileQueueConfigSummaryList = list(
    list(
      QueueId = "string",
      QueueArn = "string",
      QueueName = "string",
      Priority = 123,
      Delay = 123,
      Channel = "VOICE"|"CHAT"|"TASK"
    )
  )
)
}
}
\description{
List the queues associated with a routing profile.
}
\section{Request syntax}{
\preformatted{svc$list_routing_profile_queues(
  InstanceId = "string",
  RoutingProfileId = "string",
  NextToken = "string",
  MaxResults = 123
)
}
}

\keyword{internal}
