% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ecr_operations.R
\name{ecr_batch_get_image}
\alias{ecr_batch_get_image}
\title{Gets detailed information for an image}
\usage{
ecr_batch_get_image(
  registryId = NULL,
  repositoryName,
  imageIds,
  acceptedMediaTypes = NULL
)
}
\arguments{
\item{registryId}{The Amazon Web Services account ID associated with the registry that
contains the images to describe. If you do not specify a registry, the
default registry is assumed.}

\item{repositoryName}{[required] The repository that contains the images to describe.}

\item{imageIds}{[required] A list of image ID references that correspond to images to describe. The
format of the \code{imageIds} reference is \code{imageTag=tag} or
\code{imageDigest=digest}.}

\item{acceptedMediaTypes}{The accepted media types for the request.

Valid values: \code{application/vnd.docker.distribution.manifest.v1+json} |
\code{application/vnd.docker.distribution.manifest.v2+json} |
\code{application/vnd.oci.image.manifest.v1+json}}
}
\description{
Gets detailed information for an image. Images are specified with either an \code{imageTag} or \code{imageDigest}.

See \url{https://www.paws-r-sdk.com/docs/ecr_batch_get_image/} for full documentation.
}
\keyword{internal}
