% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_create_ipam_external_resource_verification_token}
\alias{ec2_create_ipam_external_resource_verification_token}
\title{Create a verification token}
\usage{
ec2_create_ipam_external_resource_verification_token(
  DryRun = NULL,
  IpamId,
  TagSpecifications = NULL,
  ClientToken = NULL
)
}
\arguments{
\item{DryRun}{A check for whether you have the required permissions for the action
without actually making the request and provides an error response. If
you have the required permissions, the error response is
\code{DryRunOperation}. Otherwise, it is \code{UnauthorizedOperation}.}

\item{IpamId}{[required] The ID of the IPAM that will create the token.}

\item{TagSpecifications}{Token tags.}

\item{ClientToken}{A unique, case-sensitive identifier that you provide to ensure the
idempotency of the request. For more information, see \href{https://docs.aws.amazon.com/ec2/latest/devguide/ec2-api-idempotency.html}{Ensuring idempotency}.}
}
\description{
Create a verification token. A verification token is an Amazon Web Services-generated random value that you can use to prove ownership of an external resource. For example, you can use a verification token to validate that you control a public IP address range when you bring an IP address range to Amazon Web Services (BYOIP).

See \url{https://www.paws-r-sdk.com/docs/ec2_create_ipam_external_resource_verification_token/} for full documentation.
}
\keyword{internal}
