% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_modify_verified_access_instance_logging_configuration}
\alias{ec2_modify_verified_access_instance_logging_configuration}
\title{Modifies the logging configuration for the specified Amazon Web Services
Verified Access instance}
\usage{
ec2_modify_verified_access_instance_logging_configuration(
  VerifiedAccessInstanceId,
  AccessLogs,
  DryRun = NULL,
  ClientToken = NULL
)
}
\arguments{
\item{VerifiedAccessInstanceId}{[required] The ID of the Verified Access instance.}

\item{AccessLogs}{[required] The configuration options for Verified Access instances.}

\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}

\item{ClientToken}{A unique, case-sensitive token that you provide to ensure idempotency of
your modification request. For more information, see \href{https://docs.aws.amazon.com/ec2/latest/devguide/ec2-api-idempotency.html}{Ensuring idempotency}.}
}
\description{
Modifies the logging configuration for the specified Amazon Web Services Verified Access instance.

See \url{https://www.paws-r-sdk.com/docs/ec2_modify_verified_access_instance_logging_configuration/} for full documentation.
}
\keyword{internal}
