% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/imagebuilder_operations.R
\name{imagebuilder_update_lifecycle_policy}
\alias{imagebuilder_update_lifecycle_policy}
\title{Update the specified lifecycle policy}
\usage{
imagebuilder_update_lifecycle_policy(
  lifecyclePolicyArn,
  description = NULL,
  status = NULL,
  executionRole,
  resourceType,
  policyDetails,
  resourceSelection,
  clientToken
)
}
\arguments{
\item{lifecyclePolicyArn}{[required] The Amazon Resource Name (ARN) of the lifecycle policy resource.}

\item{description}{Optional description for the lifecycle policy.}

\item{status}{Indicates whether the lifecycle policy resource is enabled.}

\item{executionRole}{[required] The name or Amazon Resource Name (ARN) of the IAM role that Image
Builder uses to update the lifecycle policy.}

\item{resourceType}{[required] The type of image resource that the lifecycle policy applies to.}

\item{policyDetails}{[required] The configuration details for a lifecycle policy resource.}

\item{resourceSelection}{[required] Selection criteria for resources that the lifecycle policy applies to.}

\item{clientToken}{[required] Unique, case-sensitive identifier you provide to ensure idempotency of
the request. For more information, see \href{https://docs.aws.amazon.com/ec2/latest/devguide/ec2-api-idempotency.html}{Ensuring idempotency}
in the \emph{Amazon EC2 API Reference}.}
}
\description{
Update the specified lifecycle policy.

See \url{https://www.paws-r-sdk.com/docs/imagebuilder_update_lifecycle_policy/} for full documentation.
}
\keyword{internal}
