% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_create_default_subnet}
\alias{ec2_create_default_subnet}
\title{Creates a default subnet with a size /20 IPv4 CIDR block in the
specified Availability Zone in your default VPC}
\usage{
ec2_create_default_subnet(AvailabilityZone, DryRun = NULL, Ipv6Native = NULL)
}
\arguments{
\item{AvailabilityZone}{[required] The Availability Zone in which to create the default subnet.}

\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}

\item{Ipv6Native}{Indicates whether to create an IPv6 only subnet. If you already have a
default subnet for this Availability Zone, you must delete it before you
can create an IPv6 only subnet.}
}
\description{
Creates a default subnet with a size \verb{/20} IPv4 CIDR block in the specified Availability Zone in your default VPC. You can have only one default subnet per Availability Zone. For more information, see \href{https://docs.aws.amazon.com/vpc/latest/userguide/default-vpc.html#create-default-subnet}{Create a default subnet} in the \emph{Amazon VPC User Guide}.

See \url{https://www.paws-r-sdk.com/docs/ec2_create_default_subnet/} for full documentation.
}
\keyword{internal}
