% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_allocate_ipam_pool_cidr}
\alias{ec2_allocate_ipam_pool_cidr}
\title{Allocate a CIDR from an IPAM pool}
\usage{
ec2_allocate_ipam_pool_cidr(
  DryRun = NULL,
  IpamPoolId,
  Cidr = NULL,
  NetmaskLength = NULL,
  ClientToken = NULL,
  Description = NULL,
  PreviewNextCidr = NULL,
  DisallowedCidrs = NULL
)
}
\arguments{
\item{DryRun}{A check for whether you have the required permissions for the action
without actually making the request and provides an error response. If
you have the required permissions, the error response is
\code{DryRunOperation}. Otherwise, it is \code{UnauthorizedOperation}.}

\item{IpamPoolId}{[required] The ID of the IPAM pool from which you would like to allocate a CIDR.}

\item{Cidr}{The CIDR you would like to allocate from the IPAM pool. Note the
following:
\itemize{
\item If there is no DefaultNetmaskLength allocation rule set on the pool,
you must specify either the NetmaskLength or the CIDR.
\item If the DefaultNetmaskLength allocation rule is set on the pool, you
can specify either the NetmaskLength or the CIDR and the
DefaultNetmaskLength allocation rule will be ignored.
}

Possible values: Any available IPv4 or IPv6 CIDR.}

\item{NetmaskLength}{The netmask length of the CIDR you would like to allocate from the IPAM
pool. Note the following:
\itemize{
\item If there is no DefaultNetmaskLength allocation rule set on the pool,
you must specify either the NetmaskLength or the CIDR.
\item If the DefaultNetmaskLength allocation rule is set on the pool, you
can specify either the NetmaskLength or the CIDR and the
DefaultNetmaskLength allocation rule will be ignored.
}

Possible netmask lengths for IPv4 addresses are 0 - 32. Possible netmask
lengths for IPv6 addresses are 0 - 128.}

\item{ClientToken}{A unique, case-sensitive identifier that you provide to ensure the
idempotency of the request. For more information, see \href{https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html}{Ensuring Idempotency}.}

\item{Description}{A description for the allocation.}

\item{PreviewNextCidr}{A preview of the next available CIDR in a pool.}

\item{DisallowedCidrs}{Exclude a particular CIDR range from being returned by the pool.
Disallowed CIDRs are only allowed if using netmask length for
allocation.}
}
\description{
Allocate a CIDR from an IPAM pool. The Region you use should be the IPAM pool locale. The locale is the Amazon Web Services Region where this IPAM pool is available for allocations.

See \url{https://www.paws-r-sdk.com/docs/ec2_allocate_ipam_pool_cidr/} for full documentation.
}
\keyword{internal}
