% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/emrcontainers_operations.R
\name{emrcontainers_create_managed_endpoint}
\alias{emrcontainers_create_managed_endpoint}
\title{Creates a managed endpoint}
\usage{
emrcontainers_create_managed_endpoint(
  name,
  virtualClusterId,
  type,
  releaseLabel,
  executionRoleArn,
  certificateArn = NULL,
  configurationOverrides = NULL,
  clientToken,
  tags = NULL
)
}
\arguments{
\item{name}{[required] The name of the managed endpoint.}

\item{virtualClusterId}{[required] The ID of the virtual cluster for which a managed endpoint is created.}

\item{type}{[required] The type of the managed endpoint.}

\item{releaseLabel}{[required] The Amazon EMR release version.}

\item{executionRoleArn}{[required] The ARN of the execution role.}

\item{certificateArn}{The certificate ARN provided by users for the managed endpoint. This
field is under deprecation and will be removed in future releases.}

\item{configurationOverrides}{The configuration settings that will be used to override existing
configurations.}

\item{clientToken}{[required] The client idempotency token for this create call.}

\item{tags}{The tags of the managed endpoint.}
}
\description{
Creates a managed endpoint. A managed endpoint is a gateway that connects Amazon EMR Studio to Amazon EMR on EKS so that Amazon EMR Studio can communicate with your virtual cluster.

See \url{https://www.paws-r-sdk.com/docs/emrcontainers_create_managed_endpoint/} for full documentation.
}
\keyword{internal}
